package nameserver;

/*
* This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
* You may use this code for reference for modding the DangerZone game program,
* and are perfectly welcome to cut'n'paste portions for your mod as well.
* DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
* DO NOT REDISTRIBUTE THIS CODE. 
* 
 *

* 
* WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
* This code is NOT suitable for use in anything other than this particular game. 
* NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
* TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
* You should have made backups. It's your own fault for not making them.
* 
* NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
* Regardless of what you may think, the reality is, that the moment you 
* connected your computer to the Internet, Uncle Sam, among many others, hacked it.
* DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
* Or your phone...
* 
*/

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.FloatBuffer;
import java.security.CodeSource;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import static org.lwjgl.glfw.GLFW.*;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import static org.lwjgl.opengl.GL11.*;

import slick.Audio;
import slick.AudioLoader;
import slick.ColorSlick;
import slick.Inputs;
import slick.Matrix4f;
import slick.ResourceLoader;
import slick.SoundStore;
import slick.Texture;
import slick.TextureLoader;
import slick.TrueTypeFont;
import slick.Vector3f;

public class NameServerCode {
	public  String version_string = "1.0";
	public  String windowTitle = "DangerZone NameServer";
	public  Font awtfont = null;
	public  TrueTypeFont font = null;
	private  Texture logotexture = null;
	public int screen_width = 1000;
	public int screen_height = 600;

	private  Texture pic1 = null;
	private  Texture pic2 = null;
	private  Texture pic3 = null;
	private  Texture pic4 = null;
	private  Texture pic5 = null;
	public  boolean quit = false;
	public  boolean quitfile = false;
	public  List<ButtonHandler> buttons;
	public  boolean escaped = false;
	public  boolean entered = false;
	public  Properties prop = new Properties();
	public  int picnum = 0;
	public  int picnum_counter = 0;
	public  int current_screen = 0;
	public  Audio popsound;
	public  NServer nserver = null;
	public  int server_port = 18669;
	public  Lock proplock = new ReentrantLock();
	public  boolean usegui = true;
	public  boolean printit = false;

	   /**
     * The handle of the window.
     */
    private  long window;
    public Inputs input;
    GLFWFramebufferSizeCallback fbCallback;
    public boolean windowed = true;
    private long monitor = 0;

	@SuppressWarnings("rawtypes")
	private static final Class[] parameters = new Class[] {URL.class};
	
	
	public void startGUI(){
		
	   input = new Inputs(1000, 600);
	       
	   //Initialize GLFW.
        GLFW.glfwInit();      
        
        glfwDefaultWindowHints();
        glfwWindowHint(GLFW_RESIZABLE, GLFW_TRUE);
        glfwWindowHint(GLFW_VISIBLE, GLFW_FALSE);
        
        //Get the primary monitor.
        monitor = glfwGetPrimaryMonitor();
        //Retrieve the desktop resolution
        GLFWVidMode vidMode = glfwGetVideoMode(monitor);
        if (!windowed) {
            input.setScreenWidthHeight(vidMode.width(), vidMode.width());
        }
               
        //Create the window with the specified title.
        window = glfwCreateWindow(input.getScreenWidth(), input.getScreenHeight(), "DangerZone NameServer :: LWJGL3", 0, 0);       
        //GLWF.setWindowTitle(window, "Stupid Title");
        if(window == 0) {
            throw new RuntimeException("Failed to create window");
        }
                
        GLFW.glfwSetKeyCallback(window, input.getKeyboardCallback());
        GLFW.glfwSetCursorPosCallback(window, input.getMouseMoveCallback());
        GLFW.glfwSetMouseButtonCallback(window, input.getMouseButtonsCallback());
        GLFW.glfwSetFramebufferSizeCallback(window, input.getFrameSizeCallback());
        GLFW.glfwSetScrollCallback(window, input.getScrollCallback());
        
        if(windowed)glfwSetWindowPos(window, (vidMode.width()-input.getScreenWidth())/2, (vidMode.height()-input.getScreenHeight())/2);

        //glfwSetInputMode(window, GLFW_CURSOR, GLFW_CURSOR_DISABLED);
		glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_NORMAL);
        glfwMakeContextCurrent(window);
        glfwSwapInterval(0);
        glfwShowWindow(window);

              
        GL.createCapabilities();
        glClearColor(0.97f, 0.97f, 0.97f, 1.0f);
        glfwWindowHint(GLFW_VISIBLE, GLFW_TRUE);
         

		try {
			SoundStore.get().init();
			//initGL();
		} catch (Exception e1) {
			System.out.printf("Something went horribly wrong with initialization!\n");
			e1.printStackTrace();
			System.exit(1);
		}

		System.out.printf("Finished init\n");
		
	}
	
	public void stopGUI(){
		GLFW.glfwDestroyWindow(window);
		GLFW.glfwTerminate();
		input.destroy();
	}
	
	
	/**
	 * @param args
	 * @throws IOException 
	 */
	public void main(String[] args) throws InterruptedException, IOException {
			
		String curdir = System.getProperty("user.dir");	
		File libfile = new File(curdir + "/DangerZone_lib/native");
		File stopfile = new File(curdir + "/stop.txt");
		if(libfile.exists())System.setProperty("org.lwjgl.librarypath", curdir + "/DangerZone_lib/native");
		
		CodeSource codeSource = NameServerCode.class.getProtectionDomain().getCodeSource();
		try {
			File myfile = new File(codeSource.getLocation().toURI().getPath());
			//System.out.printf("Adding self as: %s\n",  myfile.getAbsolutePath());
			addFile(myfile); //add self to path so it will search here for resources!
		} catch (URISyntaxException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		if(args.length > 1){
			int arglen = args.length;
			int i;
			for(i=0;i<arglen;i++){
				//System.out.printf("arg %d = :%s\n", i, args[i]);
				if(args[i].contains("nogui")){
					usegui = false;
				}
				if(args[i].contains("print")){
					printit = true;
				}
			}
		}
		
		if(usegui){
			startGUI();

			awtfont = new Font("Times New Roman", Font.PLAIN, 36);
			font = new TrueTypeFont(awtfont, false);

			try {
				logotexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/logo.png"));

				pic1 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic1.png"));
				pic2 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic2.png"));
				pic3 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic3.png"));
				pic4 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic4.png"));
				pic5 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("nsres/menus/pic5.png"));
			} catch (IOException e) {
				e.printStackTrace();
			}

			try {
				//System.out.printf("load sound file %s\n", s.filepath);
				popsound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("nsres/sounds/pop.wav"));
			} catch (Exception e) {
				popsound = null;
			}
		}
		
	

		readConfig();
		picnum = 0;
		picnum_counter = 0;
		
		//float heightAboveGround = 1.80f;
		float heightAboveGround = 0f;
        Vector3f dir = new Vector3f();
        Vector3f right = new Vector3f();
        Matrix4f mat = new Matrix4f();
        FloatBuffer fb = BufferUtils.createFloatBuffer(16);
        Vector3f pos = new Vector3f(0, heightAboveGround, 0);
        float rotX = 0.0f;
        float rotY = 0.0f;
        dir.x = 1;
        right.z = 1;
		
		if(usegui){
			
	
			   
			
	        glMatrixMode(GL_PROJECTION);
	        glLoadMatrixf(mat.setPerspective((float) Math.toRadians(45), (float) input.getScreenWidth() / (float) input.getScreenHeight(), 1f, 100.0f, false).get(fb));
	        glMatrixMode(GL_MODELVIEW);
	        mat.identity().rotateX(rotX).rotateY(rotY);
	        glLoadMatrixf(mat.get(fb));
	        glViewport(0, 0, input.getScreenWidth(), input.getScreenHeight());
	        glClear(GL_COLOR_BUFFER_BIT);          
	        GL11.glTranslatef(pos.x, pos.y, pos.z);;
			GL11.glDisable(GL11.GL_DEPTH_TEST);
			GL11.glMatrixMode(GL11.GL_PROJECTION);
			GL11.glLoadIdentity();   		
			GL11.glOrtho(0,input.getScreenWidth(),0,input.getScreenHeight(),-30,30);//puts 0,0 (x,y) at lower left of screen!
			GL11.glMatrixMode(GL11.GL_MODELVIEW);
			GL11.glLoadIdentity();
			GL11.glEnable(GL11.GL_TEXTURE_2D);
			GL11.glEnable(GL11.GL_BLEND);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
			GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!
			showLogo();

			textAt(25, input.getScreenHeight()-50, "NameServer Version " + version_string);
			glfwSwapBuffers(window);
		}
		
		nserver = new NServer();
		Thread st = new Thread(nserver);	//Fire up the actual SERVER side
		st.start();	
		
		Thread.sleep(1000);
		
		picnum = 1;
		while(!quit && !quitfile){
						
			if(stopfile.exists()){
				stopfile.delete();
				quitfile = true;
			}
			
			//switch pics every 5 seconds
			picnum_counter++;
			if(picnum_counter > 300){
				picnum_counter = 0;
				picnum++;
				if(picnum > 5){
					picnum = 1;
					writeConfig(); //Write this out periodically!
				}
			}
			
			if(usegui){
				
	            //Need to do this every time because of RESIZE!!!		
	            glMatrixMode(GL_PROJECTION);
	            glLoadMatrixf(mat.setPerspective((float) Math.toRadians(45), (float) input.getScreenWidth() / (float) input.getScreenHeight(), 1f, 100.0f, false).get(fb));
	            glMatrixMode(GL_MODELVIEW);
	            mat.identity().rotateX(rotX).rotateY(rotY);
	            glLoadMatrixf(mat.get(fb));
	            glViewport(0, 0, input.getScreenWidth(), input.getScreenHeight());
	            glClear(GL_COLOR_BUFFER_BIT);          
	            GL11.glTranslatef(pos.x, pos.y, pos.z);;
	    		GL11.glDisable(GL11.GL_DEPTH_TEST);
	    		GL11.glMatrixMode(GL11.GL_PROJECTION);
	    		GL11.glLoadIdentity();   		
	    		GL11.glOrtho(0,input.getScreenWidth(),0,input.getScreenHeight(),-30,30);//puts 0,0 (x,y) at lower left of screen!
	    		GL11.glMatrixMode(GL11.GL_MODELVIEW);
	    		GL11.glLoadIdentity();
	    		GL11.glEnable(GL11.GL_TEXTURE_2D);
	    		GL11.glEnable(GL11.GL_BLEND);
	    		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
	    		GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!

				showLogo();

				if(current_screen == 0){
					doHomeScreen();
				}

				glfwSwapBuffers(window);
			}
			
			Thread.sleep(100);
			
			if(usegui){
				quit = GLFW.glfwWindowShouldClose(window);
				if(input.isKeyDown(GLFW_KEY_ESCAPE))quit = true;
				if(quit)break; //can be set other places as well, so check again...
			}
			
			//have to do this for sounds!
			if(usegui) {
				SoundStore.get().poll(0);	
				glfwPollEvents();
			}
		}
			
		if(usegui){
			picnum = 0;
			showLogo();
			textAt(10,10,"Bye!");
			glfwSwapBuffers(window);
		}
		
		Thread.sleep(1000);
		writeConfig();
		Thread.sleep(100);
		
		//clean up and exit!
		if(usegui)stopGUI();
		System.exit(0);
	}
	
	private  void showLogo(){
		float x, y;

		GL11.glPushMatrix(); //save position
		GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	
		GL11.glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_DEPTH_BUFFER_BIT); // Clear The Screen And The Depth Buffer
		GL11.glLoadIdentity(); // Reset The View						
		GL11.glColor3f(1.0f, 1.0f, 1.0f);
		if(picnum == 0)logotexture.bind();
		if(picnum == 1)pic1.bind();
		if(picnum == 2)pic2.bind();
		if(picnum == 3)pic3.bind();
		if(picnum == 4)pic4.bind();
		if(picnum == 5)pic5.bind();
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_LINEAR);
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_LINEAR);	
		x = 210;
		y = 200;
		if(picnum > 0){
			x = 480;
			y = 280;
		}
		GL11.glTranslatef(input.getScreenWidth()/2, input.getScreenHeight()/2, -5);	
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(1,0);
		GL11.glVertex3f(x, y, 0.0f); // Top Right Of The Quad (Front)
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(-x, y, 0.0f); // Top Left Of The Quad (Front)
		GL11.glTexCoord2f(0,1);
		GL11.glVertex3f(-x, -y, 0.0f); // Bottom Left Of The Quad (Front)
		GL11.glTexCoord2f(1,1);
		GL11.glVertex3f(x, -y, 0.0f); // Bottom Right Of The Quad (Front)
		GL11.glEnd(); // Done Drawing The Quad		
		GL11.glPopMatrix();  //restore position
		
	}
	
	public  void textAt( float xpos, float ypos, String text){
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos+font.getHeight(), 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		font.drawString(0, 0, text, ColorSlick.white);	
		GL11.glPopMatrix();  //restore position
	}
	
	//convenience box...
	public  void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize){
		float w = t.getWidth();
		float h = t.getHeight();
		t.bind();
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos, 0f); 
		GL11.glScalef(xsize/t.getWidth(), ysize/t.getHeight(), 1f);
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(w,0);
		GL11.glVertex3f(1, 1, 0); // Top Right
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(0, 1, 0); // Top Left
		GL11.glTexCoord2f(0,h);
		GL11.glVertex3f(0, 0, 0); // Bottom left
		GL11.glTexCoord2f(w,h);
		GL11.glVertex3f(1, 0, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glPopMatrix();
	}
	
	public  class ButtonHandler {
		Texture t;
		int x;
		int y;
		int xsize;
		int ysize;
		String s;
		int which;
		
		public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b){
			x = xpos;
			y = ypos;
			xsize = bxsize;
			ysize = bysize;
			t = tx;
			s = ot;
			which = b;
		}
		
		
		public void leftclickhandler(){	
			popsound.playAsSoundEffect(1.0f,  1.0f, false);
			if(which == 1){		//default no args, single player	

			}

		}
		
		public void rightclickhandler(){			
		}
		
		public void draw(){			
			if(t != null){
				GL11.glColor3f(1,1,1);
				drawRectangleWithTexture(t, x, y, xsize, ysize);
			}
			if(s != null && !s.equals("")){
				textAt(x+6, y, s);
				GL11.glColor3f(1,1,1); //because text messes this up!
			}			
		}
	}
	

	
	private  void readConfig(){
		InputStream input = null;
		
		proplock.lock();
		//defaults for when the file doesn't exist!
		
		try {	 
			input = new FileInputStream("NameServer.properties");
	 
			// load a properties file
			prop.load(input);

		} catch (IOException ex) {
			//ex.printStackTrace();
		}
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				//e.printStackTrace();
			}
		}
/*		
		try {	 
			input = new FileInputStream("Merge.NameServer.properties");
	 
			// load a properties file
			Properties prop2 = new Properties();
			prop2.load(input);
			Enumeration<?> e = prop2.propertyNames();
			while(e.hasMoreElements()){
				String key = (String)e.nextElement();
				String val = prop2.getProperty(key);
				if(!prop.containsKey(key)){
					prop.setProperty(key, val);
					System.out.printf("Merged in: %s,  %s\n", key, val);
				}
			}

		} catch (IOException ex) {
			//ex.printStackTrace();
		}
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				//e.printStackTrace();
			}
		}
	*/	
		proplock.unlock();
	}
	
	
	private  void writeConfig(){
		OutputStream output = null;
	 
		proplock.lock();
		try {	 
			output = new FileOutputStream("NameServer.properties");	 
			prop.store(output, null);
	 
		} catch (IOException io) {
			io.printStackTrace();
		}
		if (output != null) {
			try {
				output.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		proplock.unlock();
	}
	
	public  String getpwdfor(String username){
		String pwd = null;
		String tstring = username.toLowerCase();
		proplock.lock();
		
		pwd = prop.getProperty(tstring);		
		
		proplock.unlock();
		return pwd;
	}
	
	public  void setpwdfor(String username, String pwd, String ias){
		String tstring = username.toLowerCase();
		proplock.lock();
		
		prop.setProperty(tstring, pwd);	
		prop.setProperty(tstring + "_ipaddress", ias);
		
		proplock.unlock();
	}
	
	
	public  void doHomeScreen(){

		int sz;
		proplock.lock();
		sz = prop.size();
		proplock.unlock();
		textAt(25, screen_height-55, "Hi!");
		textAt(25, screen_width-95, String.format("Registered Names: %d", sz/2));
		
		if (input.isKeyDown(GLFW_KEY_ESCAPE))quit = true;
		if (input.isKeyDown(GLFW_KEY_X))quit = true;
		if (input.isKeyDown(GLFW_KEY_Q))quit = true;


	}
	
	
	public  int getPropertyInt(Properties prop, String propname, int min, int max, int dflt){
		String s;
		int retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Integer.parseInt(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public  long getPropertyLong(Properties prop, String propname, long min, long max, long dflt){
		String s;
		long retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Long.parseLong(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public  float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt){
		String s;
		float retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Float.parseFloat(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public  double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt){
		String s;
		double retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Double.parseDouble(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public  boolean getPropertyBoolean(Properties prop, String propname, boolean dflt){
		String s;
		boolean retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Boolean.parseBoolean(s);
		}
		return retval;
	}
	
	public  String getPropertyString(Properties prop, String propname, String dflt){
		String s;
		String retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = s;
		}
		return retval;
	}
	
    public  void addFile(File f) throws IOException {
        addURL(f.toURI().toURL());
    }

    /**
     * Adds the content pointed by the URL to the classpath.
     * @param u the URL pointing to the content to be added
     * @throws IOException
     */
    public  void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<?> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke(sysloader,new Object[]{ u }); 
        } catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }        
    }

}
