package nameserver;


import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;

import java.io.IOException;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import java.net.InetAddress;
import java.net.Socket;





public class NSServerThread implements Runnable {
	
	Socket sock;
	int fatal_error = 0;
	ObjectInputStream objectInput = null;;
	ObjectOutputStream objectOutput = null;
	BufferedOutputStream bufobjectOutput = null;
	BufferedInputStream bufobjectInput = null;
	
	NSServerThread(Socket insock){
		sock = insock;
	}
	
	public void run()  {
		
		int packettype = 0;
		int result = 0;
		String username;
		String userpwd;
		String dbpasswd;
		
		//System.out.printf("nsthread listening!\n");
		
		try {
			sock.setSoTimeout(5000); //five seconds is more than enough. Then fail and give up!
			bufobjectInput = new BufferedInputStream(sock.getInputStream());
			objectInput = new ObjectInputStream(bufobjectInput);	
			bufobjectOutput = new BufferedOutputStream(sock.getOutputStream());
			objectOutput = new ObjectOutputStream(bufobjectOutput);
			packettype = objectInput.readInt();
			//System.out.printf("thread got packettype %d\n", packettype);
			if(packettype != -1){
				objectInput.close();
				bufobjectInput.close();
				objectOutput.close();
				bufobjectOutput.close();
				sock.close();
				return;
			}

			objectOutput.writeInt(packettype);
			objectOutput.flush();
		} catch (IOException e) {
			//System.out.printf("NSServerThread client connection failed...\n");
			fatal_error = 1;
		}
		
		try {

			while(!NameServer.nsc.quit && fatal_error == 0){

				//System.out.printf("Waiting for an int...\n");

				packettype = objectInput.readInt();
				//System.out.printf("Got packettype %d\n",  packettype);

				//-------------------------------------------------------------------------------------
				if(packettype == 0){ //Verify username and password - 0 = BAD, non-zero = good
					username = (String) objectInput.readObject();
					userpwd = (String) objectInput.readObject();
					if(username == null || userpwd == null)break;
					if(username.length() < 4)break;
					if(username.length() > 16)break;
					if(userpwd.length() != 32)break;
					dbpasswd = NameServer.nsc.getpwdfor(username);
					result = 0;
					if(dbpasswd != null && userpwd.equals(dbpasswd))result = 1; //TODO FIXME - get bling bits!
					if(NameServer.nsc.printit)System.out.printf("Verify: %s,  result %d\n", username, result);
					Thread.sleep(250); //so they can't just hammer the DB...
					objectOutput.writeInt(result);
					objectOutput.flush();
					break; //done!
				}
				//-------------------------------------------------------------------------------------
				if(packettype == 1){ //check username - 0 = unused, non-zero = already taken
					username = (String) objectInput.readObject();
					if(username == null)break;
					if(username.length() < 4)break;
					if(username.length() > 16)break;
					dbpasswd = NameServer.nsc.getpwdfor(username);
					result = 0;
					if(dbpasswd != null)result = 1; //IT IS USED!!!!!!
					if(NameServer.nsc.printit)System.out.printf("Check: %s,  result %d\n", username, result);
					Thread.sleep(250);//so they can't just hammer the DB...
					objectOutput.writeInt(result);
					objectOutput.flush();
					break; //done!
				}
				//-------------------------------------------------------------------------------------
				//TODO FIXME Yes, small chance for a collision here. Should fix it some day...
				if(packettype == 2){ //Register username and password - 0 = BAD, non-zero = good
					username = (String) objectInput.readObject();
					userpwd = (String) objectInput.readObject();
					InetAddress ia = sock.getInetAddress();
					String ias = ia.getHostAddress();
					//System.out.printf("ias = %s\n", ias);
					if(username == null || userpwd == null)break;
					if(username.length() < 4)break;
					if(username.length() > 16)break;
					if(userpwd.length() != 32)break;
					if(isBadName(username))break;
					dbpasswd = NameServer.nsc.getpwdfor(username);
					if(dbpasswd != null){
						result = 0; //TOO LATE! IT IS USED ALREADY!!!!!!
					}else{
						NameServer.nsc.setpwdfor(username, userpwd, ias);
						result = 1;
					}
					if(NameServer.nsc.printit)System.out.printf("Register: %s,  result %d\n", username, result);
					Thread.sleep(250);//so they can't just hammer the DB...
					objectOutput.writeInt(result);
					objectOutput.flush();
					break; //done!
				}
				//-------------------------------------------------------------------------------------
				//TODO FIXME Yes, small chance for a collision here. Should fix it some day...
				if(packettype == 3){ //Change password - 0 = BAD, non-zero = good
					username = (String) objectInput.readObject();
					userpwd = (String) objectInput.readObject();
					String newpasswd = (String) objectInput.readObject();
					InetAddress ia = sock.getInetAddress();
					String ias = ia.getHostAddress();
					if(username == null || userpwd == null)break;
					if(username.length() < 4)break;
					if(username.length() > 16)break;
					if(userpwd.length() != 32)break;
					if(newpasswd.length() != 32)break;
					result = 0;
					dbpasswd = NameServer.nsc.getpwdfor(username);
					if(dbpasswd != null){						
						if(dbpasswd.equals(userpwd)){
							NameServer.nsc.setpwdfor(username, newpasswd, ias);
							result = 1;
						}
					}
					if(NameServer.nsc.printit)System.out.printf("Change password: %s,  result %d\n", username, result);
					Thread.sleep(250);//so they can't just hammer the DB...
					objectOutput.writeInt(result);
					objectOutput.flush();
					break; //done!
				}
				if(packettype == 4){ //Graceful shutdown!
					username = (String) objectInput.readObject();
					userpwd = (String) objectInput.readObject();
					if(username == null || userpwd == null)break;
					if(username.length() < 4)break;
					if(username.length() > 16)break;
					if(userpwd.length() != 32)break;
					dbpasswd = NameServer.nsc.getpwdfor(username);
					result = 0;
					if(dbpasswd != null && userpwd.equals(dbpasswd))result = 1;
					Thread.sleep(250); //so they can't just hammer the DB...
					objectOutput.writeInt(result);
					objectOutput.flush();
					Thread.sleep(250); //so they can't just hammer the DB...
					if(NameServer.nsc.printit)System.out.printf("Remote Shutdown: %s,  result %d\n", username, result);
					if(username.toLowerCase().equals("theycallmedanger") && result != 0){
						NameServer.nsc.quit = true;
					}
					break; //done!
				}
								
			}
		
		} catch (IOException e1) {
			//	System.out.printf("ServerThread barfed on read. Did client exit?\n");
			fatal_error = 1;
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			if(bufobjectInput != null)bufobjectInput.close();
			if(bufobjectOutput != null)bufobjectOutput.close();
			if(objectInput != null)objectInput.close();
			if(objectOutput != null)objectOutput.close();
			sock.close();
		} catch (IOException e) {

		}
		
		//let the chunker know we are leaving!
		fatal_error = 1;
		
	}
	
	public boolean isBadName(String in){
		String check = in.toLowerCase();
		
		if(check.equals("player"))return true;
		if(check.equals("null"))return true;
		if(check.contains(" "))return true;
		
		return false;
	}
	
}