package launcher;
/*
* This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
* You may use this code for reference for modding the DangerZone game program,
* and are perfectly welcome to cut'n'paste portions for your mod as well.
* DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
* DO NOT REDISTRIBUTE THIS CODE. 
* 
* 
* WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
* This code is NOT suitable for use in anything other than this particular game. 
* NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
* TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
* You should have made backups. It's your own fault for not making them.
* 
* NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
* Regardless of what you may think, the reality is, that the moment you 
* connected your computer to the Internet, Uncle Sam, among many others, hacked it.
* DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
* Or your phone...
* 
*/


import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.FloatBuffer;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;



import static org.lwjgl.glfw.GLFW.*;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

import launcher.LauncherCode;
import launcher.Runnit;

import static org.lwjgl.opengl.GL11.*;

import slick.Audio;
import slick.AudioLoader;
import slick.ColorSlick;
import slick.Inputs;
import slick.Matrix4f;
import slick.ResourceLoader;
import slick.SoundStore;
import slick.Texture;
import slick.TextureLoader;
import slick.TrueTypeFont;
import slick.Vector3f;
import slick.Inputs.KeyEvent;
import slick.Inputs.MouseEvent;


public class LauncherCode {
	public String version_string = "2.8-VR";
	public int screen_width = 1000;
	public int screen_height = 600;
	public String windowTitle = "DangerZone Launcher";
	public java.awt.Font awtfont = null;
	public TrueTypeFont font = null;
	public java.awt.Font smallawtfont = null;
	public TrueTypeFont smallfont = null;
	private Texture logotexture = null;
	private Texture buttontexture = null;
	private Texture runbuttontexture = null;
	private Texture checktexture = null;
	private Texture unchecktexture = null;
	private Texture textinputtexture = null;
	private Texture pics[];
	public boolean quit = false;
	public List<ButtonHandler> buttons;
	public boolean escaped = false;
	public boolean entered = false;
	public Properties prop = new Properties();
	public int picnum = 0;
	public int picnum_counter = 0;
	public int errstringcounter = 0;
	//public int client_max_g = 2;
	//public int single_max_g = 2;
	//public int server_max_g = 2;
	
	//defaults for when the file doesn't exist!
	public  String server_address = "127.0.0.1";
	public  int server_port = 18668;
	public  String nsserver_address = "127.0.0.1";
	public  int nsserver_port = 18669;
	public  String server_port_string = "";
	public  String worldname = "my_world";
	public  String playername ="Player";
	public  String playerpassword ="";
	//public  boolean keepitsqueakyclean = false;
	//public  String alt_texture_path = "";
	public  int current_screen = 0;
	public  Iterator<ButtonHandler> bb;
	public  Audio popsound;
	public  boolean playernameinput = false;
	public  boolean serveraddressinput = false;
	public  boolean newworldinput = false;
	public  boolean serverportinput = false;
	public  boolean passwordinput = false;
	public  int worldliststart = 0;
	public  int numworld = 0;
	public  boolean displaydeleteconfirm = false;
	public  boolean dodelete = false;
	public  String newworldname = "New World";
	public  String crypted_password = null;
	public  String errstring = null;
	@SuppressWarnings("rawtypes")
	private  final Class[] parameters = new Class[] {URL.class};
	public  String playerstatestring = "unknown";
	public  volatile boolean do_validate = false;
	public  NSValidator Vserverthread = null;
	public  volatile boolean name_registered_already = false;
	public  volatile boolean do_register = false;
	
	public  boolean world_loaded = false;
	public  String worldfile = "";
	public  boolean generatecaves = true;
	public  boolean playnicely = false;
	public  boolean require_valid_passwords = true;
	public  long worldseed = 0;
	public  boolean keep_inventory_on_death = false;
	
	public  int timetimer = 0;
	public  String todinputstring = "";
	public  boolean todinput = false;
	
	public  int max_players_on_server = 0;
	public  String maxpinputstring = "";
	public  boolean maxpinput = false;
	
	public  int default_privs = 0;
	public  String privsinputstring = "";
	public  boolean privsinput = false;
	
	public  int login_state = 0;
	//0 = unknown
	//1 = logged in
	//2 = name/pwd fail
	
	public boolean multiplayer_enable = false;
	public boolean nameserver_enable = false;
	public boolean multiple_login_enable = false;

    

	

    /**
     * The handle of the window.
     */
    private  long window;
    public Inputs input;
    GLFWFramebufferSizeCallback fbCallback;
    private long monitor = 0;

	
	public void startGUI(){
		
	   input = new Inputs(1000, 600);
	       
	   //Initialize GLFW.
        GLFW.glfwInit();      
        
        glfwDefaultWindowHints();
        glfwWindowHint(GLFW_RESIZABLE, GLFW_FALSE);
        glfwWindowHint(GLFW_VISIBLE, GLFW_TRUE);
        
        //Get the primary monitor.
        monitor = glfwGetPrimaryMonitor();
        //Retrieve the desktop resolution
        GLFWVidMode vidMode = glfwGetVideoMode(monitor);
        //if (!windowed) {
        //    input.setScreenWidthHeight(vidMode.width(), vidMode.width());
        //}
               
        //Create the window with the specified title.
        window = glfwCreateWindow(input.getScreenWidth(), input.getScreenHeight(), "DangerZone Launcher :: DZVR 2.7", 0, 0);       
        //GLWF.setWindowTitle(window, "Stupid Title");
        if(window == 0) {
            throw new RuntimeException("Failed to create window");
        }
                
        GLFW.glfwSetKeyCallback(window, input.getKeyboardCallback());
        GLFW.glfwSetCursorPosCallback(window, input.getMouseMoveCallback());
        GLFW.glfwSetMouseButtonCallback(window, input.getMouseButtonsCallback());
        GLFW.glfwSetFramebufferSizeCallback(window, input.getFrameSizeCallback());
        GLFW.glfwSetScrollCallback(window, input.getScrollCallback());
        
        glfwSetWindowPos(window, (vidMode.width()-input.getScreenWidth())/2, (vidMode.height()-input.getScreenHeight())/2);

        glfwSetInputMode(window, GLFW_CURSOR, GLFW_CURSOR_DISABLED);
        glfwMakeContextCurrent(window);
        glfwSwapInterval(0);
        glfwShowWindow(window);

              
        GL.createCapabilities();
        glClearColor(0.97f, 0.97f, 0.97f, 1.0f);
        glfwWindowHint(GLFW_VISIBLE, GLFW_TRUE);
         

		try {
			SoundStore.get().init();
			//initGL();
		} catch (Exception e1) {
			System.out.printf("Something went horribly wrong with initialization!\n");
			e1.printStackTrace();
			System.exit(1);
		}

		//System.out.printf("Finished init\n");
		
	}
	
	public void stopGUI(){
		GLFW.glfwDestroyWindow(window);
		GLFW.glfwTerminate();
		input.destroy();
	}
	
	
	/**
	 * @param args
	 * @throws IOException 
	 */
	public void launcher_main(String[] args) throws InterruptedException, IOException {
			
		Random rand = new Random();		
		rand.setSeed(System.currentTimeMillis());
		
		//because some places use commas in numbers, and of course java hoses them up!
		if(Locale.getDefault() != Locale.US) {
		    Locale.setDefault(Locale.US);
		}
		
		String curdir = System.getProperty("user.dir");	
		File libfile = new File(curdir + "/DangerZone_lib/native");
		if(libfile.exists())System.setProperty("org.lwjgl.librarypath", curdir + "/DangerZone_lib/native");
		
		CodeSource codeSource = LauncherCode.class.getProtectionDomain().getCodeSource();
		try {
			File myfile = new File(codeSource.getLocation().toURI().getPath());
			//System.out.printf("Adding self as: %s\n",  myfile.getAbsolutePath());
			addFile(myfile); //add self to path so it will search here for resources!
		} catch (URISyntaxException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
				
		startGUI();
		
		awtfont = new java.awt.Font("Times New Roman", java.awt.Font.PLAIN, 36);
		font = new TrueTypeFont(awtfont, false);
		smallawtfont = new java.awt.Font("Times New Roman", java.awt.Font.PLAIN, 24);
		smallfont = new TrueTypeFont(smallawtfont, false);

		try {
			logotexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/logo.png"));
			buttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/button.png"));
			runbuttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/runbutton.png"));
			checktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/check.png"));
			unchecktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/uncheck.png"));
			textinputtexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/textinput.png"));
			
			pics = new Texture[17];
			
			for(int i=0;i<17;i++){
				pics[i] = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(String.format("launchres/menus/pic%d.png", i+1)));
			}
					
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		try {
			//System.out.printf("load sound file %s\n", s.filepath);
			popsound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("launchres/sounds/pop.wav"));
		} catch (Exception e) {
			popsound = null;
		}
		
		
	
		//System.out.printf("doing readConfig()\n");
		readConfig();
		picnum = 0;
		picnum_counter = 0;
		//System.out.printf("doing showLogo()\n");
		
		//float heightAboveGround = 1.80f;
		float heightAboveGround = 0f;
        Vector3f dir = new Vector3f();
        Vector3f right = new Vector3f();
        Matrix4f mat = new Matrix4f();
        FloatBuffer fb = BufferUtils.createFloatBuffer(16);
        Vector3f pos = new Vector3f(0, heightAboveGround, 0);
        float rotX = 0.0f;
        float rotY = 0.0f;
        //float movementSpeed = 2.666f;
        dir.x = 1;
        right.z = 1;
		   
        
		//GLU.gluPerspective(45f, ((float) screen_width / (float) screen_height), 1.0f, 100);
		
        glMatrixMode(GL_PROJECTION);
        glLoadMatrixf(mat.setPerspective((float) Math.toRadians(45), (float) input.getScreenWidth() / (float) input.getScreenHeight(), 1f, 100.0f, false).get(fb));
        glMatrixMode(GL_MODELVIEW);
        mat.identity().rotateX(rotX).rotateY(rotY);
        glLoadMatrixf(mat.get(fb));
        glViewport(0, 0, input.getScreenWidth(), input.getScreenHeight());
        glClear(GL_COLOR_BUFFER_BIT);          
        GL11.glTranslatef(pos.x, pos.y, pos.z);;
		GL11.glDisable(GL11.GL_DEPTH_TEST);
		GL11.glMatrixMode(GL11.GL_PROJECTION);
		GL11.glLoadIdentity();   		
		GL11.glOrtho(0,input.getScreenWidth(),0,input.getScreenHeight(),-30,30);//puts 0,0 (x,y) at lower left of screen!
		GL11.glMatrixMode(GL11.GL_MODELVIEW);
		GL11.glLoadIdentity();
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!
	

		showLogo();
		glfwSwapBuffers(window);
		
		textAt(25, screen_height-50, "Hi " + playername + "!");
		textAt(675, screen_height-50, "Launcher Ver " + version_string);
		
		
		do_validate = true;

		if(multiplayer_enable) {
			if(nameserver_enable) {
				Vserverthread = new NSValidator();
				Thread st = new Thread(Vserverthread);	//Fire up a validation thread!
				st.start();	
			}
		}
		
		Thread.sleep(1000);
		
		picnum = rand.nextInt(17)+1;
		


		glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_NORMAL);

        //long lastTime = System.nanoTime();

		//System.out.printf("doing main loop!\n");
		while(!quit){
			
			//System.out.printf("loop!\n");
			
			/*
			long thisTime = System.nanoTime();
            float diff = (float) ((thisTime - lastTime) / 1E9);
            lastTime = thisTime;
            float move = diff * movementSpeed;

            if (input.isKeyDown(GLFW_KEY_LEFT_SHIFT))
                move *= 2.0f;
            if (input.isKeyDown(GLFW_KEY_LEFT_CONTROL))
                move *= 0.5f;
            
            dir.y = 0.0f; // <- restrict movement on XZ plane


            if (input.isKeyDown(GLFW_KEY_W)) pos.x += move;
                
            if (input.isKeyDown(GLFW_KEY_S)) pos.x -= move;
                
            if (input.isKeyDown(GLFW_KEY_A)) pos.z += move;
                
            if (input.isKeyDown(GLFW_KEY_D)) pos.z -= move;
                
            rotX = (float) input.getMousey();
            rotY = (float) input.getMousex();
            rotX = (float) Math.toRadians(rotX);
            rotY = -(float) Math.toRadians(rotY);
            */
         
            //Need to do this every time because of RESIZE!!!		
            glMatrixMode(GL_PROJECTION);
            glLoadMatrixf(mat.setPerspective((float) Math.toRadians(45), (float) input.getScreenWidth() / (float) input.getScreenHeight(), 1f, 100.0f, false).get(fb));
            glMatrixMode(GL_MODELVIEW);
            mat.identity().rotateX(rotX).rotateY(rotY);
            glLoadMatrixf(mat.get(fb));
            glViewport(0, 0, input.getScreenWidth(), input.getScreenHeight());
            glClear(GL_COLOR_BUFFER_BIT);          
            GL11.glTranslatef(pos.x, pos.y, pos.z);;
    		GL11.glDisable(GL11.GL_DEPTH_TEST);
    		GL11.glMatrixMode(GL11.GL_PROJECTION);
    		GL11.glLoadIdentity();   		
    		GL11.glOrtho(0,input.getScreenWidth(),0,input.getScreenHeight(),-30,30);//puts 0,0 (x,y) at lower left of screen!
    		GL11.glMatrixMode(GL11.GL_MODELVIEW);
    		GL11.glLoadIdentity();
    		GL11.glEnable(GL11.GL_TEXTURE_2D);
    		GL11.glEnable(GL11.GL_BLEND);
    		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
    		GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!

            
            //renderGrid();

			if(errstring != null && errstringcounter == 0){
				errstringcounter = 100;
			}			
			if(errstringcounter > 0){
				errstringcounter--;
				if(errstringcounter == 0)errstring = null;
			}
			
			//switch pics every 5 seconds
			picnum_counter++;
			if(picnum_counter > 250){
				picnum_counter = 0;
				picnum = rand.nextInt(17)+1;
			}
		
			
			showLogo();
						
			if(current_screen == 0){
				doHomeScreen();
			}
			if(current_screen == 1){
				doMultiPlayerScreen();
			}		
			if(current_screen == 2){
				doOptionsScreen();
			}
			if(current_screen == 3){
				doSinglePlayerScreen();
			}
			if(current_screen == 4){
				doMusicScreen();
			}
			if(current_screen == 5){
				doWorldEditScreen();
			}
			if(current_screen == 6) {
				doRegisterConfirm();
			}
						
			glfwSwapBuffers(window);
			Thread.sleep(20); //SLOW! WE DO NOT NEED FAST HERE!!!			
				
			quit = GLFW.glfwWindowShouldClose(window);
			if(input.isKeyDown(GLFW_KEY_ESCAPE))quit = true;
			if(quit)break; //can be set other places as well, so check again...
			
			//have to do this for sounds!
			SoundStore.get().poll(0);	
			glfwPollEvents();
			
		}
			
		glfwSetInputMode(window, GLFW_CURSOR, GLFW_CURSOR_DISABLED);
		picnum = 0;
		showLogo();
		textAt(10,10,"Bye!");
		glfwSwapBuffers(window);
		
		writeConfig();
		Thread.sleep(1000);
		
		//clean up and exit!
		SoundStore.get().clear();
		stopGUI();
		System.exit(0);
	}
	
    int dl = -1;
    int gridSize = 40;
    float ceiling = 3.0f;
    
    void renderGrid() {
        if (dl == -1) {
            dl = glGenLists(1);
            glNewList(dl, GL_COMPILE);
            glBegin(GL_LINES);
            glColor3f(0.2f, 0.2f, 0.2f);
            for (int i = -gridSize; i <= gridSize; i++) {
                glVertex3f(-gridSize, 0.0f, i);
                glVertex3f(gridSize, 0.0f, i);
                glVertex3f(i, 0.0f, -gridSize);
                glVertex3f(i, 0.0f, gridSize);
            }
            glColor3f(0.5f, 0.5f, 0.5f);
            for (int i = -gridSize; i <= gridSize; i++) {
                glVertex3f(-gridSize, ceiling, i);
                glVertex3f(gridSize, ceiling, i);
                glVertex3f(i, ceiling, -gridSize);
                glVertex3f(i, ceiling, gridSize);
            }
            glEnd();
            glEndList();
        }
        glCallList(dl);
    }


	
	private  void showLogo(){
		float x, y;
		
		GL11.glPushMatrix(); //save position
		GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	
		GL11.glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_DEPTH_BUFFER_BIT); // Clear The Screen And The Depth Buffer
		
		//GL11.glLoadIdentity(); // Reset The View						
		GL11.glColor3f(1.0f, 1.0f, 1.0f);
		
		if(picnum == 0){
			logotexture.bind();
		}else{
			pics[picnum-1].bind();
		}
		
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_LINEAR);
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_LINEAR);	
		x = 210;
		y = 200;
		if(picnum > 0){
			x = 480;
			y = 280;
		}
		
		GL11.glTranslatef(input.getScreenWidth()/2, input.getScreenHeight()/2, -5);	
		
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(1,0);
		GL11.glVertex3f(x, y, 0.0f); // Top Right Of The Quad (Front)
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(-x, y, 0.0f); // Top Left Of The Quad (Front)
		GL11.glTexCoord2f(0,1);
		GL11.glVertex3f(-x, -y, 0.0f); // Bottom Left Of The Quad (Front)
		GL11.glTexCoord2f(1,1);
		GL11.glVertex3f(x, -y, 0.0f); // Bottom Right Of The Quad (Front)
		GL11.glEnd(); // Done Drawing The Quad	
		
		GL11.glPopMatrix();  //restore position
		
	}
	
	public  void textAt( float xpos, float ypos, String text){
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos+font.getHeight(), 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		font.drawString(0, 0, text, ColorSlick.white);	
		GL11.glPopMatrix();  //restore position
	}
	
	public  void smalltextAt( float xpos, float ypos, String text){
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos+smallfont.getHeight(), 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		smallfont.drawString(0, 0, text, ColorSlick.white);	
		GL11.glPopMatrix();  //restore position
	}
	
	public  void errtextAt( float xpos, float ypos, String text){
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos+font.getHeight(), 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		font.drawString(0, 0, text, ColorSlick.red);	
		GL11.glPopMatrix();  //restore position
	}
	
	//convenience box...
	public  void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize){
		float w = t.getWidth();
		float h = t.getHeight();
		t.bind();
		GL11.glPushMatrix(); //save position
		GL11.glTranslatef(xpos, ypos, 0f); 
		GL11.glScalef(xsize/t.getWidth(), ysize/t.getHeight(), 1f);
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(w,0);
		GL11.glVertex3f(1, 1, 0); // Top Right
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(0, 1, 0); // Top Left
		GL11.glTexCoord2f(0,h);
		GL11.glVertex3f(0, 0, 0); // Bottom left
		GL11.glTexCoord2f(w,h);
		GL11.glVertex3f(1, 0, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glPopMatrix();
	}
	
	public class ButtonHandler {
		Texture t;
		int x;
		int y;
		int xsize;
		int ysize;
		String s;
		int which;
		float transp;
		
		public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b){
			x = xpos;
			y = ypos;
			xsize = bxsize;
			ysize = bysize;
			t = tx;
			s = ot;
			which = b;
			transp = 1f;
		}
		
		public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b, float tr){
			x = xpos;
			y = ypos;
			xsize = bxsize;
			ysize = bysize;
			t = tx;
			s = ot;
			which = b;
			transp = tr;
		}
		
		
		public void leftclickhandler(){	
			//System.out.printf("leftclickhandler which = %d\n",  which);
			popsound.playAsSoundEffect(1.0f,  1.0f, false);
			if(which == 1){		//default no args, single player	
				String curdir = System.getProperty("user.dir");	
				List<String> cmdarray = new ArrayList<String>();
				try {
					cmdarray.add(Runnit.getJreExecutable().toString());
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					return;
				}
				
				writeConfig();
				
				//cmdarray.add("-Xmx1500m");
				//cmdarray.add("-XX:MaxDirectMemorySize=2g");
				String where = curdir + "/GameRunner.jar";
				cmdarray.add("-jar");
				cmdarray.add(where);
				cmdarray.add("singleplayer");
				cmdarray.add("-singleplayer");
				cmdarray.add("--singleplayer");
				
				//fire it up and wait for it here.
				try {
					Runnit.launch("singleplayer", cmdarray);
				} catch (IOException | InterruptedException e) {
					e.printStackTrace();
				}
				//readConfig();	
				stopGUI();
				System.exit(0);
			}
			if(which == 2){
				//System.out.printf("Clicked Multi-Player!\n");
				current_screen = 1;
			}
			if(which == 3){
				current_screen = 2;
			}
			if(which == 4){
				if(current_screen == 5){ //world edit
					current_screen = 3;  //to world selection
					world_loaded = false;
					todinput = false;
					privsinput = false;
					maxpinput = false;
				}else if(current_screen == 6) {
					current_screen = 2;
				}else{
					current_screen = 0;
				}
				playernameinput = false;
				serveraddressinput = false;
				serverportinput = false;
				displaydeleteconfirm = false;
				newworldinput = false;
				passwordinput = false;
			}
			if(which == 5){
				current_screen = 3;
			}
			//if(which == 6){
			//	if(keepitsqueakyclean){
			//		keepitsqueakyclean = false;
			//	}else{
			//		keepitsqueakyclean = true;
			//	}
			//}
			if(which == 7){
				playernameinput = true;
				passwordinput = false;
			}
			if(which == 8){
				serveraddressinput = true;
				serverportinput = false;
			}
			if(which == 9){
				serverportinput = true;
				serveraddressinput = false;
			}
			
			if(which == 10){		//start server	
				String curdir = System.getProperty("user.dir");	
				List<String> cmdarray = new ArrayList<String>();
				try {
					cmdarray.add(Runnit.getJreExecutable().toString());
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					return;
				}
				
				writeConfig();
				
				//cmdarray.add("-Xmx2g");
				//cmdarray.add("-XX:MaxDirectMemorySize=1g");
				String where = curdir + "/GameRunner.jar";
				cmdarray.add("-jar");
				cmdarray.add(where);
				cmdarray.add("server");
				cmdarray.add("-server");
				cmdarray.add("--server");
				
				//fire it up and wait for it here.
				try {
					Runnit.launch("server", cmdarray);
				} catch (IOException | InterruptedException e) {
					e.printStackTrace();
					return;
				}	
				//readConfig();
				stopGUI();
				System.exit(0);
			}
			if(which == 11){			//start client
				String curdir = System.getProperty("user.dir");	
				List<String> cmdarray = new ArrayList<String>();
				try {
					cmdarray.add(Runnit.getJreExecutable().toString());
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					return;
				}
				
				writeConfig();
				
				//cmdarray.add("-Xmx1500m");
				//cmdarray.add("-XX:MaxDirectMemorySize=2g");
				String where = curdir + "/GameRunner.jar";
				cmdarray.add("-jar");
				cmdarray.add(where);
				cmdarray.add("client");
				cmdarray.add("-client");
				cmdarray.add("--client");
				
				//fire it up and wait for it here.
				try {
					Runnit.launch("client", cmdarray);
				} catch (IOException | InterruptedException e) {
					e.printStackTrace();
					return;
				}
				//readConfig();
				stopGUI();
				System.exit(0);
			}
			if(which == 12){
				worldliststart++;
				if(worldliststart >= numworld){
					worldliststart = numworld-1;
				}
				if(worldliststart < 0)worldliststart = 0;
			}
			if(which == 13){
				worldliststart--;
				if(worldliststart < 0)worldliststart = 0;
			}
			if(which == 14){
				newworldinput = false;
				if(newworldname != null && newworldname != "" && ! newworldname.contains("..")){
					String curdir = System.getProperty("user.dir");
					boolean files = new File(curdir + "/worlds/" + newworldname).mkdirs();
					if(files){
						newworldname = "New World";
					}
				}	
			}
			if(which == 15){
				displaydeleteconfirm = true;
			}
			if(which == 16){
				displaydeleteconfirm = false;				
				if(worldname != null && worldname != "" && ! worldname.contains("..")){
					String curdir = System.getProperty("user.dir");
					removedir(curdir + "/worlds/"+ worldname);				
				}				
			}
			if(which == 17){
				displaydeleteconfirm = false;
			}
			if(which == 18){
				newworldinput = true;
			}
			if(which == 19){
				passwordinput = true;
				playernameinput = false;
			}
			if(which == 20){
				
				if(playerpassword.length() >= 4 && playerpassword.length() <= 16){
					if(playername.length() >= 4 && playername.length() <= 16){
						crypted_password = "";
						doCryptPassword();
						playerpassword = "";
					}
				}
				passwordinput = false;
				playernameinput = false;
				do_validate = true;
			}
			if(which == 21){
				
				if(playerpassword.length() >= 4 && playerpassword.length() <= 16){
					if(playername.length() >= 4 && playername.length() <= 16){
						crypted_password = "";
						doCryptPassword();
					}
				}
				passwordinput = false;
				playernameinput = false;
				do_validate = false;
				current_screen = 6;
			}
			if(which == 22){
				current_screen = 4;
			}
			if(which == 23){
				current_screen = 5;
			}

			if(which == 24){
				generatecaves = !generatecaves;
			}
			if(which == 25){
				playnicely = !playnicely;
			}
			if(which == 26){
				require_valid_passwords = !require_valid_passwords;
			}
			if(which == 27){
				todinput = true;
				privsinput = false;
				maxpinput = false;
			}
			if(which == 28){
				privsinput = true;
				todinput = false;
				maxpinput = false;
			}
			if(which == 29){
				maxpinput = true;
				todinput = false;
				privsinput = false;
			}
			
			if(which == 30){
				saveWorld(worldfile);
			}
			
			if(which == 31){
				keep_inventory_on_death = !keep_inventory_on_death;
			}
			
			if(which == 32){
				do_register = true;
				current_screen = 2; //back to login screen!
				playerpassword = "";
			}
			
			if(which == 33){
				do_register = false;
				current_screen = 2; //back to login screen!
			}
			
		}
		
		public void rightclickhandler(){			
		}
		
		public void draw(){			
			if(t != null){
				GL11.glColor4f(1,1,1, transp);
				drawRectangleWithTexture(t, x, y, xsize, ysize);
			}
			if(s != null && !s.equals("")){
				textAt(x+6, y, s);
				GL11.glColor4f(1,1,1,1); //because text messes this up!
			}			
		}
	}
	
	public String getTextChar(){
		int currk;
		boolean caps = false;
		escaped = false;
		entered = false;
		
		if(input.isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)||input.isKeyDown(GLFW.GLFW_KEY_RIGHT_SHIFT)){
			caps = true;
		}
		
		while (input.hasNextKey()) {
			KeyEvent ke = input.nextKey();
			
			//System.out.printf("Key!\n");
			if (ke.key == GLFW.GLFW_KEY_ESCAPE && input.isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
				escaped = true;
			}
			if (ke.key == GLFW.GLFW_KEY_ENTER && input.isKeyDown(GLFW.GLFW_KEY_ENTER)){
				entered = true;
			}
			currk = ke.key;
			if(!input.isKeyDown(currk))continue;
			
			switch(currk){
			
			case GLFW.GLFW_KEY_DELETE:
				return "delete";
			case GLFW.GLFW_KEY_BACKSPACE:
				return "delete";
				
			case GLFW.GLFW_KEY_0:
				if(caps)return ")";
				return "0";
			case GLFW.GLFW_KEY_1:
				if(caps)return "!";
				return "1";
			case GLFW.GLFW_KEY_2:
				if(caps)return "@";
				return "2";
			case GLFW.GLFW_KEY_3:
				if(caps)return "#";
				return "3";
			case GLFW.GLFW_KEY_4:
				if(caps)return "$";
				return "4";
			case GLFW.GLFW_KEY_5:
				if(caps)return "%";
				return "5";
			case GLFW.GLFW_KEY_6:
				if(caps)return "^";
				return "6";
			case GLFW.GLFW_KEY_7:
				if(caps)return "&";
				return "7";
			case GLFW.GLFW_KEY_8:
				if(caps)return "*";
				return "8";
			case GLFW.GLFW_KEY_9:
				if(caps)return "(";
				return "9";
			case GLFW.GLFW_KEY_A:
				if(caps)return "A";
				return "a";
			case GLFW.GLFW_KEY_B:
				if(caps)return "B";
				return "b";
			case GLFW.GLFW_KEY_C:
				if(caps)return "C";
				return "c";
			case GLFW.GLFW_KEY_D:
				if(caps)return "D";
				return "d";
			case GLFW.GLFW_KEY_E:
				if(caps)return "E";
				return "e";
			case GLFW.GLFW_KEY_F:
				if(caps)return "F";
				return "f";
			case GLFW.GLFW_KEY_G:
				if(caps)return "G";
				return "g";
			case GLFW.GLFW_KEY_H:
				if(caps)return "H";
				return "h";
			case GLFW.GLFW_KEY_I:
				if(caps)return "I";
				return "i";
			case GLFW.GLFW_KEY_J:
				if(caps)return "J";
				return "j";
			case GLFW.GLFW_KEY_K:
				if(caps)return "K";
				return "k";
			case GLFW.GLFW_KEY_L:
				if(caps)return "L";
				return "l";
			case GLFW.GLFW_KEY_M:
				if(caps)return "M";
				return "m";
			case GLFW.GLFW_KEY_N:
				if(caps)return "N";
				return "n";
			case GLFW.GLFW_KEY_O:
				if(caps)return "O";
				return "o";
			case GLFW.GLFW_KEY_P:
				if(caps)return "P";
				return "p";
			case GLFW.GLFW_KEY_Q:
				if(caps)return "Q";
				return "q";
			case GLFW.GLFW_KEY_R:
				if(caps)return "R";
				return "r";
			case GLFW.GLFW_KEY_S:
				if(caps)return "S";
				return "s";
			case GLFW.GLFW_KEY_T:
				if(caps)return "T";
				return "t";
			case GLFW.GLFW_KEY_U:
				if(caps)return "U";
				return "u";
			case GLFW.GLFW_KEY_V:
				if(caps)return "V";
				return "v";
			case GLFW.GLFW_KEY_W:
				if(caps)return "W";
				return "w";
			case GLFW.GLFW_KEY_X:
				if(caps)return "X";
				return "x";
			case GLFW.GLFW_KEY_Y:
				if(caps)return "Y";
				return "y";
			case GLFW.GLFW_KEY_Z:
				if(caps)return "Z";
				return "z";				
				
			case GLFW.GLFW_KEY_PERIOD:
				if(caps)return ">";
				return ".";
			case GLFW.GLFW_KEY_COMMA:
				if(caps)return "<";
				return ",";
			case GLFW.GLFW_KEY_SLASH:
				if(caps)return "?";
				return "/";				
			case GLFW.GLFW_KEY_SEMICOLON:
				if(caps)return ":";
				return ";";
			case GLFW.GLFW_KEY_APOSTROPHE:
				if(caps)return "\"";
				return "'";				
			case GLFW.GLFW_KEY_SPACE:
			case GLFW.GLFW_KEY_TAB:				
				return " ";				
			case GLFW.GLFW_KEY_BACKSLASH:
				if(caps)return "|";
				return "\\";
			case GLFW.GLFW_KEY_LEFT_BRACKET:
				if(caps)return "{";
				return "[";
			case GLFW.GLFW_KEY_RIGHT_BRACKET:
				if(caps)return "}";
				return "]";				
			case GLFW.GLFW_KEY_MINUS:
				if(caps)return "_";
				return "-";
			case GLFW.GLFW_KEY_EQUAL:
				if(caps)return "+";
				return "=";
				
			default:
				
			}
		}
		return null;
	}
	
	public String getNumericChar(){
		int currk;
		escaped = false;
		entered = false;
		
		
		while (input.hasNextKey()) {
			KeyEvent ke = input.nextKey();
			
			//System.out.printf("Key!\n");
			if (ke.key == GLFW.GLFW_KEY_ESCAPE && input.isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
				escaped = true;
			}
			if (ke.key == GLFW.GLFW_KEY_ENTER && input.isKeyDown(GLFW.GLFW_KEY_ENTER)){
				entered = true;
			}
			currk = ke.key;
			if(!input.isKeyDown(currk))continue;
			
			switch(currk){
			
			case GLFW.GLFW_KEY_DELETE:
				return "delete";
			case GLFW.GLFW_KEY_BACKSPACE:
				return "delete";
				
			case GLFW.GLFW_KEY_0:
				return "0";
			case GLFW.GLFW_KEY_1:
				return "1";
			case GLFW.GLFW_KEY_2:
				return "2";
			case GLFW.GLFW_KEY_3:
				return "3";
			case GLFW.GLFW_KEY_4:
				return "4";
			case GLFW.GLFW_KEY_5:
				return "5";
			case GLFW.GLFW_KEY_6:
				return "6";
			case GLFW.GLFW_KEY_7:
				return "7";
			case GLFW.GLFW_KEY_8:
				return "8";
			case GLFW.GLFW_KEY_9:
				return "9";
				
			default:
				
			}
		}
		return null;
	}
	
	private void readConfig(){
		InputStream input = null;
		
		//defaults for when the file doesn't exist!
		server_address = "127.0.0.1";
		server_port = 18668;
		nsserver_address = "127.0.0.1";
		nsserver_port = 18669;
		worldname = "my_world";
		playername ="Player";
		//keepitsqueakyclean = true;
		//alt_texture_path = "";
		crypted_password = "";
		playerpassword = "";
		name_registered_already = false;
		multiplayer_enable = false;
		nameserver_enable = false;
		multiple_login_enable = false;
		
		try {	 
			input = new FileInputStream("DangerZone.properties");
	 
			// load a properties file
			prop.load(input);
	 
			server_address = getPropertyString(prop, "ServerAddress", "127.0.0.1"); //
			server_port = getPropertyInt(prop, "ServerPort", 0, Integer.MAX_VALUE, 18668); //min, max, default
			nsserver_address = getPropertyString(prop, "NameServerAddress", "127.0.0.1"); //
			nsserver_port = getPropertyInt(prop, "NameServerPort", 0, Integer.MAX_VALUE, 18669); //min, max, default
			worldname = getPropertyString(prop, "WorldName", "my_world"); 
			playername = getPropertyString(prop, "Playername", "Player");		
			//keepitsqueakyclean = getPropertyBoolean(prop, "RunFinalization", true);
			//alt_texture_path = getPropertyString(prop, "AltTextureDir", "");
			crypted_password = getPropertyString(prop, "CryptedPassword", "");
			//playerpassword = getPropertyString(prop, "Password", "");
			name_registered_already = getPropertyBoolean(prop, "Registered", false);
			//client_max_g = getPropertyInt(prop, "ClientMaxG", 1, 16, 2); //min, max, default
			//single_max_g = getPropertyInt(prop, "SingleMaxG", 1, 16, 2); //min, max, default
			//server_max_g = getPropertyInt(prop, "ServerMaxG", 1, 16, 2); //min, max, default
			multiplayer_enable = getPropertyBoolean(prop, "MultiPlayerEnable", false);
			nameserver_enable = getPropertyBoolean(prop, "NameServerEnable", false);
			multiple_login_enable = getPropertyBoolean(prop, "MultiLogin", false);



		} catch (IOException ex) {
			//ex.printStackTrace();
		}
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				//e.printStackTrace();
			}
		}		
	}
	
	
	private void writeConfig(){
		OutputStream output = null;
	 
		try {	 
			output = new FileOutputStream("DangerZone.properties");	 
			// set the properties value
			
			prop.setProperty("ServerAddress", server_address);
			prop.setProperty("ServerPort", String.format("%d", server_port));
			prop.setProperty("NameServerAddress", nsserver_address);
			prop.setProperty("NameServerPort", String.format("%d", nsserver_port));
			prop.setProperty("WorldName", worldname);
			prop.setProperty("Playername", playername);
			//prop.setProperty("RunFinalization", String.format("%s", keepitsqueakyclean?"true":"false"));
			//prop.setProperty("AltTextureDir", alt_texture_path);
			prop.setProperty("CryptedPassword", crypted_password);
			//prop.setProperty("Password", playerpassword);
			if(multiple_login_enable)name_registered_already = false;
			prop.setProperty("Registered", name_registered_already?"true":"false");
			prop.setProperty("MultiPlayerEnable", multiplayer_enable?"true":"false");
			prop.setProperty("NameServerEnable", nameserver_enable?"true":"false");
			prop.setProperty("MultiLogin", multiple_login_enable?"true":"false");
			
			//prop.setProperty("ClientMaxG", String.format("%d", client_max_g));
			//prop.setProperty("SingleMaxG", String.format("%d", single_max_g));
			//prop.setProperty("ServerMaxG", String.format("%d", server_max_g));
	 
			// save properties to project root folder
			prop.store(output, null);
	 
		} catch (IOException io) {
			io.printStackTrace();
		}
		if (output != null) {
			try {
				output.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}		
	}
	
	
	public void doHomeScreen(){

		textAt(25, screen_height-55, "Hi " + playername + "!");
		buttons = new ArrayList<ButtonHandler>();
		buttons.add(new ButtonHandler(25, screen_height-155, 105, 45, runbuttontexture, "PLAY", 1));
		textAt(150,screen_height-155, ": " + worldname);
		if(multiplayer_enable) {
			if(nameserver_enable) {
				String plst = String.format("Login Status: %s", playerstatestring);
				textAt(25, screen_height-95, plst);
			}
		}
		if(multiplayer_enable) {
			buttons.add(new ButtonHandler(25, 150, 215, 45, buttontexture, "Multi-Player", 2));
			//textAt(300,150, ": " + server_address + ":" + String.format("%d", server_port));
		}
		buttons.add(new ButtonHandler(25, 200, 275, 45, buttontexture, "World Selection", 5));
		
		if(multiplayer_enable) {
			if(nameserver_enable) {
				buttons.add(new ButtonHandler(25, 250, 485, 45, buttontexture, "Login and Name Registration", 3));
			}else {
				buttons.add(new ButtonHandler(25, 250, 200, 45, buttontexture, "Edit Name", 3));
			}
		}
		
		buttons.add(new ButtonHandler(input.getScreenWidth() - 250, 50, 215, 45, buttontexture, "Music Credits", 22));
		
		if(login_state == 0){
			do_validate = true;
		}


		//Draw buttons!
		bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}

		while (input.hasNextKey()) {	
			KeyEvent ke = input.nextKey();
			//System.out.printf("Key!\n");
			if (ke.key == GLFW.GLFW_KEY_ESCAPE && input.isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
				if(ke.isdown){
					quit = true;
					break;
				}
			}
			if (ke.key == GLFW.GLFW_KEY_X && input.isKeyDown(GLFW.GLFW_KEY_X)){
				if(ke.isdown){
					quit = true;
					break;
				}
			}
			if (ke.key == GLFW.GLFW_KEY_Q && input.isKeyDown(GLFW.GLFW_KEY_Q)){
				if(ke.isdown){
					quit = true;
					break;
				}
			}
		}	
		
		//System.out.printf("Homescreen mouse checks\n");

		//Check for mouse events!
		int clickx, clicky;
		ButtonHandler mb, fb;
		while(input.mnext()){
			MouseEvent me = input.nextButton();
			if(me != null) {
				clickx = (int)me.x;
				clicky = (int)me.y;		
				if(me.isdown){ //clicked!
					//System.out.printf("Mouseclick = %d at %d, %d\n", me.button, clickx, clicky);
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(me.button == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(me.button == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}
	}
	
	public void doMusicScreen(){
		buttons = new ArrayList<ButtonHandler>();		
		buttons.add(new ButtonHandler(25, screen_height-55, 125, 45, buttontexture, "Back", 4));
		
		
		textAt(25, screen_height-150, "Music Credits:");		
		

		smalltextAt(100, screen_height-250, "https://machinimasound.com");	
		smalltextAt(100, screen_height-300, "Licensed under Creative Commons Attribution 4.0 International");	
		smalltextAt(100, screen_height-350, "(http://creativecommons.org/licenses/by/4.0/)");	
		smalltextAt(100, screen_height-400, "Authors: Machinimasound, Jens Kiilstofte, Per Kiilstofte, Aaron Spencer");	


		//Draw buttons!
		bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}
				
		int clickx, clicky;
		ButtonHandler mb, fb;
		while(input.mnext()){
			MouseEvent me = input.nextButton();
			if(me != null) {
				clickx = (int)me.x;
				clicky = (int)me.y;		
				if(me.isdown){ //clicked!
					//System.out.printf("Mouseclick = %d at %d, %d\n", me.button, clickx, clicky);
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(me.button == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(me.button == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}

	}
	
	public void doRegisterConfirm(){
		buttons = new ArrayList<ButtonHandler>();		
		buttons.add(new ButtonHandler(25, screen_height-55, 125, 45, buttontexture, "Back", 4));
		
		if(errstring != null)errtextAt(25, screen_height-555, errstring);	
		
		textAt(25, screen_height-155, "Player Name:");	
		textAt(225, screen_height-155, playername);
		//buttons.add(new ButtonHandler(225, screen_height-155, 325, 45, textinputtexture, playername, 7, playernameinput?1f:0.25f));	
		
		textAt(25, screen_height-205, "Password:");	
		textAt(225, screen_height-205, playerpassword);	
		//buttons.add(new ButtonHandler(225, screen_height-205, 325, 45, textinputtexture, playerpassword, 19, passwordinput?1f:0.25f));	
		
		errstring = null;
		if(playerpassword.length() < 4){
			errstring = "Password must be > 3 characters";
		}
		if(playerpassword.length() > 16){
			errstring = "Password must be < 17 characters";
		}
		if(playername.length() < 4){
			errstring = "Name must be > 3 characters";
		}
		if(playername.length() > 16){
			errstring = "Name must be < 17 characters";
		}
		if(playername.toLowerCase().startsWith("player")) {
			errstring = "Name cannot start with \"Player\"";
		}
		if(errstring != null) {
			current_screen = 2; //back to login screen!
			return;
		}
		
		textAt(25, screen_height-255, "Register this name and password?");	
		
		buttons.add(new ButtonHandler(225, screen_height-305, 85, 45, buttontexture, "YES", 32, 1f));	
		buttons.add(new ButtonHandler(325, screen_height-305, 65, 45, buttontexture, "NO", 33, 1f));	
		
		//Draw buttons!
		bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}
		
		int clickx, clicky;
		ButtonHandler mb, fb;
		while(input.mnext()){
			MouseEvent me = input.nextButton();
			if(me != null) {
				clickx = (int)me.x;
				clicky = (int)me.y;		
				if(me.isdown){ //clicked!
					//System.out.printf("Mouseclick = %d at %d, %d\n", me.button, clickx, clicky);
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(me.button == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(me.button == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}


	}
	
	public void doOptionsScreen(){
		
		buttons = new ArrayList<ButtonHandler>();		
		buttons.add(new ButtonHandler(25, screen_height-55, 125, 45, buttontexture, "Back", 4));

		if(errstring != null)errtextAt(25, screen_height-555, errstring);	

		textAt(25, screen_height-155, "Player Name:");		
		buttons.add(new ButtonHandler(225, screen_height-155, 325, 45, textinputtexture, playername, 7, playernameinput?1f:0.25f));	

		if(nameserver_enable) {
			textAt(25, screen_height-205, "Password:");		
			buttons.add(new ButtonHandler(225, screen_height-205, 325, 45, textinputtexture, playerpassword, 19, passwordinput?1f:0.25f));	

			if(!name_registered_already) {			
				buttons.add(new ButtonHandler(25, screen_height-405, 475, 45, runbuttontexture, "Register New Name/Password", 21));
			}
			textAt(25, screen_height-255, "Login State:");	
			if(playerstatestring != null)textAt(225, screen_height-255, playerstatestring);	

			buttons.add(new ButtonHandler(25, screen_height-355, 250, 45, runbuttontexture, "Login", 20));
		}


		//Draw buttons!
		bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}
				
		String s = getTextChar();	
		if(playernameinput){
			if(entered){
				playernameinput = false;
			}
			if(escaped){
				playernameinput = false;
			}
			if(s != null){
				if(!s.equals("delete")){
					//add a new char
					if(!s.equals(" ")){
						if(playername.length() < 16){
							playername += s;
						}
					}
				}else{
					//delete the last char
					if(playername.length() > 0){
						String newstring = new String();
						for(int i=0;i<playername.length()-1;i++){
							newstring += playername.charAt(i);
						}
						playername = newstring;
					}
				}
			}
		}
		
		
		errstring = null;
		if(nameserver_enable) {
			if(passwordinput){
				if(entered){
					passwordinput = false;				
					if(name_registered_already){
						do_validate = true;
					}else{
						current_screen = 6;
					}
				}
				if(escaped){
					passwordinput = false;
				}
				if(s != null){
					if(!s.equals("delete")){
						//add a new char
						if(playerpassword.length() < 16){
							playerpassword += s;
						}
					}else{
						//delete the last char
						if(playerpassword.length() > 0){
							String newstring = new String();
							for(int i=0;i<playerpassword.length()-1;i++){
								newstring += playerpassword.charAt(i);
							}
							playerpassword = newstring;
						}
					}
				}
			}

			if(login_state != 1){
				if(playerpassword.length() < 4){
					errstring = "Password must be > 3 characters";
				}
				if(playerpassword.length() > 16){
					errstring = "Password must be < 17 characters";
				}
				if(playername.length() < 4){
					errstring = "Name must be > 3 characters";
				}
				if(playername.length() > 16){
					errstring = "Name must be < 17 characters";
				}
				if(playername.toLowerCase().startsWith("player")) {
					errstring = "Name cannot start with \"Player\"";
				}

				current_screen = 2; //stay here!
			}
		}
		
		int clickx, clicky;
		ButtonHandler mb, fb;
		while(input.mnext()){
			MouseEvent me = input.nextButton();
			if(me != null) {
				clickx = (int)me.x;
				clicky = (int)me.y;		
				if(me.isdown){ //clicked!
					//System.out.printf("Mouseclick = %d at %d, %d\n", me.button, clickx, clicky);
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(me.button == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(me.button == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}
	}
	
	public void doMultiPlayerScreen(){
		
		buttons = new ArrayList<ButtonHandler>();		
		buttons.add(new ButtonHandler(25, screen_height-55, 125, 45, buttontexture, "Back", 4));
		
		
		textAt(25, screen_height-155, "Server Address:");		
		buttons.add(new ButtonHandler(325, screen_height-155, 325, 45, textinputtexture, server_address, 8, serveraddressinput?1f:0.25f));
		
		textAt(25, screen_height-205, "Server Port:");	
		server_port_string = String.format("%d", server_port);
		buttons.add(new ButtonHandler(325, screen_height-205, 325, 45, textinputtexture, server_port_string, 9, serverportinput?1f:0.25f));			
	
		buttons.add(new ButtonHandler(25, screen_height-305, 325, 45, runbuttontexture, "START A SERVER", 10));
		buttons.add(new ButtonHandler(25, screen_height-255, 400, 45, runbuttontexture, "CONNECT TO SERVER", 11));
		
		//Draw buttons!
		bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}
				
		String s = getTextChar();	
		if(serveraddressinput){
			if(entered){
				serveraddressinput = false;
				if(server_address.length() <= 0)server_address = "127.0.0.1";
			}
			if(escaped){
				serveraddressinput = false;
			}
			if(s != null){
				if(!s.equals("delete")){
					//add a new char
					if(server_address.length() < 24){
						server_address += s;
					}
				}else{
					//delete the last char
					if(server_address.length() > 0){
						String newstring = new String();
						for(int i=0;i<server_address.length()-1;i++){
							newstring += server_address.charAt(i);
						}
						server_address = newstring;
					}
				}
			}
		}
		
		if(serverportinput){
			if(entered){
				serverportinput = false;
				if(server_port_string.length() <= 0)server_port_string = "18668";
			}
			if(escaped){
				serverportinput = false;
			}
			if(s != null){
				if(!s.equals("delete")){
					//add a new char
					if(server_port_string.length() < 6){
						server_port_string += s;
					}
				}else{
					//delete the last char
					if(server_port_string.length() > 0){
						String newstring = new String();
						for(int i=0;i<server_port_string.length()-1;i++){
							newstring += server_port_string.charAt(i);
						}
						server_port_string = newstring;
					}
				}
			}
			if(server_port_string.length() > 0)server_port = Integer.parseInt(server_port_string);
		}
		
		

		int clickx, clicky;
		ButtonHandler mb, fb;
		while(input.mnext()){
			MouseEvent me = input.nextButton();
			if(me != null) {
				clickx = (int)me.x;
				clicky = (int)me.y;		
				if(me.isdown){ //clicked!
					//System.out.printf("Mouseclick = %d at %d, %d\n", me.button, clickx, clicky);
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(me.button == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(me.button == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}
	}
	
	public void removedir(String dir){
				
		File[] files = new File(dir).listFiles();		
		for (File file : files) {
			if (file.isDirectory()) {
				removedir(dir + "/" + file.getName());		
			}else{
				file.delete();
				//System.out.printf("remove file %s\n", file.getName());
			}
		}
		File curdir = new File(dir);
		curdir.delete();
		//System.out.printf("remove file %s\n", curdir.getName());
	}
	
	public void doSinglePlayerScreen(){
		
		String curdir = System.getProperty("user.dir");
		File[] files = new File(curdir + "/worlds").listFiles();
		String currworldname = "";
		int newnumworld = 0;
		
		for (File file : files) {
			if (file.isDirectory()) {
				if(worldliststart == newnumworld){ //current selection
					currworldname = file.getName();
				}
				newnumworld++;				
			}			
		}
		if(worldliststart >= newnumworld){
			worldliststart = 0;
		}
		numworld = newnumworld;
		
		buttons = new ArrayList<ButtonHandler>();		
		buttons.add(new ButtonHandler(25, screen_height-55, 125, 45, buttontexture, "Back", 4));
		
		textAt(25, screen_height-155, "World:");
		textAt(175, screen_height-155, currworldname);
		if(currworldname != ""){
			worldname = currworldname;
		}
		
		buttons.add(new ButtonHandler(175, screen_height-205, 100, 45, buttontexture, "Next", 12));
		buttons.add(new ButtonHandler(300, screen_height-205, 100, 45, buttontexture, "Prev", 13));
		buttons.add(new ButtonHandler(425, screen_height-205, 150, 45, buttontexture, "Edit", 23));
		buttons.add(new ButtonHandler(625, screen_height-205, 150, 45, buttontexture, "Delete", 15));
		
		
		buttons.add(new ButtonHandler(25, screen_height-305, 150, 45, buttontexture, "Create", 14));
		buttons.add(new ButtonHandler(225, screen_height-305, 325, 45, textinputtexture, newworldname, 18, newworldinput?1f:0.25f));
		
				
		if(displaydeleteconfirm){
			textAt(200, screen_height-375, "Delete: " + worldname);
			textAt(200, screen_height-425, "Are you sure?");
			buttons.add(new ButtonHandler(425, screen_height-425, 45, 45, checktexture, "", 16));
			buttons.add(new ButtonHandler(475, screen_height-425, 45, 45, unchecktexture, "", 17));
		}
			

		//Draw buttons!
		bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}
		
		String s = getTextChar();	
		if(newworldinput){
			if(entered){
				newworldinput = false;
				if(newworldname.length() <= 0)newworldname = "New World";
			}
			if(escaped){
				newworldinput = false;
			}
			if(s != null){
				if(!s.equals("delete")){
					//add a new char
					if(newworldname.length() < 24){
						newworldname += s;
					}
				}else{
					//delete the last char
					if(newworldname.length() > 0){
						String newstring = new String();
						for(int i=0;i<newworldname.length()-1;i++){
							newstring += newworldname.charAt(i);
						}
						newworldname = newstring;
					}
				}
			}
		}
		

		int clickx, clicky;
		ButtonHandler mb, fb;
		while(input.mnext()){
			MouseEvent me = input.nextButton();
			if(me != null) {
				clickx = (int)me.x;
				clicky = (int)me.y;		
				if(me.isdown){ //clicked!
					//System.out.printf("Mouseclick = %d at %d, %d\n", me.button, clickx, clicky);
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(me.button == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(me.button == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}
	}
	
	public void doWorldEditScreen(){
		
		String curdir = System.getProperty("user.dir");
		worldfile = curdir + "/worlds/" + worldname + "/world.dat";
		
		buttons = new ArrayList<ButtonHandler>();		
		buttons.add(new ButtonHandler(25, screen_height-55, 125, 45, buttontexture, "Back", 4));
		
		textAt(25, screen_height-155, "World:");
		textAt(175, screen_height-155, worldname);
		
		if(!world_loaded){
			loadWorld(worldfile);
		}
		
		textAt(50, screen_height-205, "Cave Generation:");
		buttons.add(new ButtonHandler(425, screen_height-205, 45, 45, generatecaves?checktexture:unchecktexture, "", 24));
		
		textAt(50, screen_height-255, "Play Nicely:");
		buttons.add(new ButtonHandler(425, screen_height-255, 45, 45, playnicely?checktexture:unchecktexture, "", 25));
		
		textAt(50, screen_height-305, "Keep Inventory:");
		buttons.add(new ButtonHandler(425, screen_height-305, 45, 45, keep_inventory_on_death?checktexture:unchecktexture, "", 31));
		
		//textAt(50, screen_height-305, "Require Passwords:");
		//buttons.add(new ButtonHandler(425, screen_height-305, 45, 45, require_valid_passwords?checktexture:unchecktexture, "", 26));
		
		textAt(50, screen_height-355, "Time of Day:");
		buttons.add(new ButtonHandler(425, screen_height-355, 100, 45, textinputtexture, todinputstring, 27, todinput?1f:0.25f));
		
		//textAt(50, screen_height-405, "Default Privs:");
		//buttons.add(new ButtonHandler(425, screen_height-405, 100, 45, privsinput?textinputtexture:null, privsinputstring, 28));
		
		//textAt(50, screen_height-455, "Max Players:");
		//buttons.add(new ButtonHandler(425, screen_height-455, 100, 45, maxpinput?textinputtexture:null, maxpinputstring, 29));
		
				
		buttons.add(new ButtonHandler(50, screen_height-515, 125, 45, buttontexture, "SAVE", 30));
		
		
		String s = getNumericChar();	
		if(todinput){
			if(entered){
				todinput = false;
				if(todinputstring.length() <= 0)todinputstring = "0";
			}
			if(escaped){
				todinput = false;
			}
			if(s != null){
				if(!s.equals("delete")){
					//add a new char
					if(todinputstring.length() < 4){
						todinputstring += s;
					}
				}else{
					//delete the last char
					if(todinputstring.length() > 0){
						String newstring = new String();
						for(int i=0;i<todinputstring.length()-1;i++){
							newstring += todinputstring.charAt(i);
						}
						todinputstring = newstring;
					}
				}
			}
			if(todinputstring.length() > 0)timetimer = Integer.parseInt(todinputstring);
		}
		
		/*
		if(privsinput){
			if(entered){
				privsinput = false;
				if(privsinputstring.length() <= 0)privsinputstring = "0";
			}
			if(escaped){
				privsinput = false;
			}
			if(s != null){
				if(!s.equals("delete")){
					//add a new char
					if(privsinputstring.length() < 4){
						privsinputstring += s;
					}
				}else{
					//delete the last char
					if(privsinputstring.length() > 0){
						String newstring = new String();
						for(int i=0;i<privsinputstring.length()-1;i++){
							newstring += privsinputstring.charAt(i);
						}
						privsinputstring = newstring;
					}
				}
			}
			if(privsinputstring.length() > 0)default_privs = Integer.parseInt(privsinputstring);
		}
		
		if(maxpinput){
			if(entered){
				maxpinput = false;
				if(maxpinputstring.length() <= 0)maxpinputstring = "0";
				
			}
			if(escaped){
				maxpinput = false;
			}
			if(s != null){
				if(!s.equals("delete")){
					//add a new char
					if(maxpinputstring.length() < 4){
						maxpinputstring += s;
					}
				}else{
					//delete the last char
					if(maxpinputstring.length() > 0){
						String newstring = new String();
						for(int i=0;i<maxpinputstring.length()-1;i++){
							newstring += maxpinputstring.charAt(i);
						}
						maxpinputstring = newstring;
					}
				}
			}
			if(maxpinputstring.length() > 0)max_players_on_server = Integer.parseInt(maxpinputstring);
		}
		*/
			

		//Draw buttons!
		bb = buttons.iterator();
		while(bb.hasNext()){
			bb.next().draw();
		}
		
		

		int clickx, clicky;
		ButtonHandler mb, fb;
		while(input.mnext()){
			MouseEvent me = input.nextButton();
			if(me != null) {
				clickx = (int)me.x;
				clicky = (int)me.y;		
				if(me.isdown){ //clicked!
					//System.out.printf("Mouseclick = %d at %d, %d\n", me.button, clickx, clicky);
					//Find which "button" they clicked on
					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(clickx >= mb.x && clickx <= mb.x+mb.xsize){
							if(clicky >= mb.y && clicky <= mb.y+mb.ysize){
								fb = mb;
								break;
							}
						}
					}
					// 0 = left, 1 = right, 2 = middle
					if(me.button == 0){
						if(fb != null)fb.leftclickhandler();
					}
					if(me.button == 1){
						if(fb != null)fb.rightclickhandler();
					}
				}
			}
		}
	}
	
	public int getPropertyInt(Properties prop, String propname, int min, int max, int dflt){
		String s;
		int retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Integer.parseInt(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public long getPropertyLong(Properties prop, String propname, long min, long max, long dflt){
		String s;
		long retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Long.parseLong(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt){
		String s;
		float retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Float.parseFloat(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt){
		String s;
		double retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Double.parseDouble(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}
	
	public boolean getPropertyBoolean(Properties prop, String propname, boolean dflt){
		String s;
		boolean retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Boolean.parseBoolean(s);
		}
		return retval;
	}
	
	public String getPropertyString(Properties prop, String propname, String dflt){
		String s;
		String retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = s;
		}
		return retval;
	}
	
    public void addFile(File f) throws IOException {
        addURL(f.toURI().toURL());
    }

    /**
     * Adds the content pointed by the URL to the classpath.
     * @param u the URL pointing to the content to be added
     * @throws IOException
     */
    public void addURL(URL u) throws IOException {
    	// Fix?
    	//URL path[] = { ... };
    	//ClassLoader parent = ClassLoader.getPlatformClassLoader();
    	//URLClassLoader loader = new URLClassLoader(path, parent);
    	//
    	//or
    	/*
        ModuleFinder finder = ModuleFinder.of(dir1, dir2, dir3);

        ModuleLayer parent = ModuleLayer.boot();

        Configuration cf = parent.configuration().resolve(finder, ModuleFinder.of(), Set.of("myapp"));

        ClassLoader scl = ClassLoader.getSystemClassLoader();

        ModuleLayer layer = parent.defineModulesWithOneLoader(cf, scl);

        Class<?> c = layer.findLoader("myapp").loadClass("app.Main");
        */
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<?> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke(sysloader,new Object[]{ u }); 
        } catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }        
    }
    
    public void doCryptPassword(){
    	//playername
    	//playerpassword
    	//crypted_password
    	//32
    	int namelen = playername.length();
    	int passlen = playerpassword.length();
    	String dzstring = "DangerZone is the best!";
    	int dzstlen = dzstring.length();
    	String hashbackstring = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    	int hashbacklen = hashbackstring.length();
    	int nameint[] = new int[32];
    	int passint[] = new int[32];
    	int dzstint[] = new int[32];
    	int cryptint[] = new int[32];
    	byte asbytes[];
    	int i, j;
    	
    	if(namelen < 4 || passlen < 4){
    		errstring = "password encryption failure";
    		return;
    	}
    	
    	//convert to something we can work with!!!
    	String tstring = playername.toLowerCase();
    	asbytes = tstring.getBytes();
    	for(i=0;i<32;i++){
    		nameint[i] = (int)asbytes[i%namelen];
    	}
    	asbytes = playerpassword.getBytes();
    	for(i=0;i<32;i++){
    		passint[i] = (int)asbytes[i%passlen];
    	}
    	asbytes = dzstring.getBytes();
    	for(i=0;i<32;i++){
    		dzstint[i] = (int)asbytes[i%dzstlen];
    	}
    	
    	//now we can shuffle around and make it a one-way crypyt
    	for(i=0;i<32;i++){
    		cryptint[i] = nameint[i]*passint[31-i];
    		cryptint[i] /= 8; //make sure we lose some information
    		cryptint[i] *= dzstint[i];
    		cryptint[i] /= 4; //make sure we lose some information
    		cryptint[i] += nameint[i]^passint[i]^dzstint[i];
    	}
    	//do the random shuffle!
    	for(i=0;i<32;i++){
    		cryptint[i] &= 0xfff;
    		j = cryptint[i];
    		cryptint[i] = cryptint[cryptint[i]%32];
    		cryptint[cryptint[i]%32] = j;
    	}
    	//good enough. Now make back into ascii-ish...
    	crypted_password = "";
    	for(i=0;i<32;i++){
    		crypted_password += hashbackstring.charAt(cryptint[i]%hashbacklen);    		
    	}
    	
    	//let's see if it turns out arbitrary enough!
    	//System.out.printf("Resulting crypt = %s\n", crypted_password);
    	
    }
    
	public void loadWorld(String worldname){
		InputStream input = null;
		Properties worldprop = new Properties();
				
		generatecaves = true;
		playnicely = false;
		keep_inventory_on_death = false;
		require_valid_passwords = true;
		default_privs = 0; //
		max_players_on_server = 10;
		timetimer = 0;
		worldseed = System.currentTimeMillis();
		 
		try {	 
			input = new FileInputStream(worldname);	 
			// load a properties file
			worldprop.load(input);
			
			timetimer = getPropertyInt(worldprop, "TimeOfDay", 0, Integer.MAX_VALUE, 0); //min, max, default
			generatecaves = getPropertyBoolean(worldprop, "CaveGeneration", true);
			playnicely = getPropertyBoolean(worldprop, "PlayNicely", false);
			keep_inventory_on_death = getPropertyBoolean(worldprop, "KeepInventory", false);
			require_valid_passwords = getPropertyBoolean(worldprop, "RequireValidPassword", true);
			default_privs = getPropertyInt(worldprop, "DefaultPrivs", Integer.MIN_VALUE, Integer.MAX_VALUE, 0); //min, max, default
			max_players_on_server = getPropertyInt(worldprop, "MaxPlayers", 2, 255, 10); //min, max, default
			worldseed = getPropertyLong(worldprop, "WorldSeed", Long.MIN_VALUE, Long.MAX_VALUE, worldseed); //min, max, default

		} catch (IOException ex) {
			//ex.printStackTrace();
			//doesn't exist yet!
		}
		todinputstring = String.format("%d", timetimer);
		privsinputstring = String.format("%d", default_privs);
		maxpinputstring = String.format("%d", max_players_on_server);
		
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				//e.printStackTrace();
			}
		}
		world_loaded = true;
		
	}
	
	public void saveWorld(String worldname){
		Properties worldprop = new Properties();
		OutputStream output = null;
		File f = new File(worldname);		
		f.getParentFile().mkdirs();	
		
		
		
		try {	
					
			worldprop.setProperty("TimeOfDay", String.format("%d", timetimer));
			worldprop.setProperty("CaveGeneration", String.format("%s", generatecaves?"true":"false"));
			worldprop.setProperty("PlayNicely", String.format("%s", playnicely?"true":"false"));
			worldprop.setProperty("KeepInventory", String.format("%s", keep_inventory_on_death?"true":"false"));
			worldprop.setProperty("RequireValidPassword", String.format("%s", require_valid_passwords?"true":"false"));
			worldprop.setProperty("DefaultPrivs", String.format("%d", default_privs));
			worldprop.setProperty("MaxPlayers", String.format("%d", max_players_on_server));
			worldprop.setProperty("WorldSeed", String.format("%d", worldseed));
			
			output = new FileOutputStream(worldname);	 
			// save properties
			worldprop.store(output, null);			
	 
		} catch (IOException io) {
			io.printStackTrace();
		}
		if (output != null) {
			try {
				output.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}		
	}
	

}
