package gamerunner;

/*
* This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
* You may use this code for reference for modding the DangerZone game program,
* and are perfectly welcome to cut'n'paste portions for your mod as well.
* DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
* DO NOT REDISTRIBUTE THIS CODE. 
* 
* 
* WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
* This code is NOT suitable for use in anything other than this particular game. 
* NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
* TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
* You should have made backups. It's your own fault for not making them.
* 
* NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
* Regardless of what you may think, the reality is, that the moment you 
* connected your computer to the Internet, Uncle Sam, among many others, hacked it.
* DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
* Or your phone...
* 
*/

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class Runnit {

    public static boolean isWindows() {
    	String os = System.getProperty("os.name");
    	if (os == null) {
    		throw new IllegalStateException("os.name");
    	}
    	os = os.toLowerCase();
    	return os.startsWith("windows");
    }

    public static File getJreExecutable() throws FileNotFoundException {
    	File exe;
    	
    	//try hardcoded local java first!
    	exe = new File("./java/", "bin/java.exe");
    	if (exe.isFile()) {
    		return exe;
    	}
    	
    	//if that didn't work, try the hard way...
    	
    	String jreDirectory = System.getProperty("java.home");
    	if (jreDirectory == null) {
    		//throw new IllegalStateException("java.home");
    		jreDirectory = "./java/";
    	}
    	
    	String version = System.getProperty("java.version");
        if(!version.startsWith("1.8")) {
        	throw new IllegalStateException("java.version");
        }
        
    	
    	if (isWindows()) {
    		exe = new File(jreDirectory, "bin/java.exe");
    	} else {
    		exe = new File(jreDirectory, "bin/java");
    	}
    	if (!exe.isFile()) {
    		throw new FileNotFoundException(exe.toString());
    	}
    	return exe;
    }

    public static int launch(String which, List<String> cmdarray, int maxlines) throws IOException, InterruptedException {
    	byte[] buffer = new byte[1024];

    	ProcessBuilder processBuilder = new ProcessBuilder(cmdarray);
    	processBuilder.redirectErrorStream(true);
    	Process process = processBuilder.start();
    	InputStream in = process.getInputStream();
    	
		GregorianCalendar gcalendar = new GregorianCalendar();
		int nowmonth, nowday, nowhour, nowminute, nowyear;
		nowmonth = gcalendar.get(Calendar.MONTH);
		nowday = gcalendar.get(Calendar.DATE);
		nowhour = gcalendar.get(Calendar.HOUR_OF_DAY);
		nowminute = gcalendar.get(Calendar.MINUTE);
		nowyear = gcalendar.get(Calendar.YEAR);
		String st = "";
		if(which.equals("server"))st = String.format("_%4d%2d%2d_%2d%2d", nowyear, nowmonth, nowday, nowhour, nowminute);	
		//System.out.printf("string = %s\n", st);
    	String filepath = "logs/" + which + st + ".log";
    	//System.out.printf("filepath = %s\n", filepath);
    	File f = new File(filepath);		
		FileOutputStream os = null;
		BufferedOutputStream bos = null;
		f.getParentFile().mkdirs();	
		int linelimit = 0;
		
		
		
		//Let's spit the output to a log file...
		os = new FileOutputStream(filepath);
		bos = new BufferedOutputStream(os, 10000);
		
    	while (true) {
    		int r = in.read(buffer);
    		if (r <= 0) {
    			break;
    		}
    		if(linelimit > maxlines)continue; //put a throttle on the size of the file!!!!
    		
    		bos.write(buffer, 0, r);
    		linelimit++;
    	}
    	bos.close();
    	os.close();
    	return process.waitFor();
    }

}