package gamerunner;

/*
* This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
* You may use this code for reference for modding the DangerZone game program,
* and are perfectly welcome to cut'n'paste portions for your mod as well.
* DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
* DO NOT REDISTRIBUTE THIS CODE. 
* 
* 
* WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
* This code is NOT suitable for use in anything other than this particular game. 
* NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
* TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
* You should have made backups. It's your own fault for not making them.
* 
* NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
* Regardless of what you may think, the reality is, that the moment you 
* connected your computer to the Internet, Uncle Sam, among many others, hacked it.
* DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
* Or your phone...
* 
*/




//import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
//import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;



public class GameRunner {
	
	public static int client_max_g = 3;
	public static int single_max_g = 4;
	public static int server_max_g = 2;
	
	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws InterruptedException, IOException {
		String curdir = System.getProperty("user.dir");		
		List<String> cmdarray = new ArrayList<String>();
		//boolean bits64mode = (System.getProperty("os.arch").indexOf("64") != -1);
		
		
		Thread.sleep(1500); //give launcher time to exit and clean up
		
		/*
		String filepath = "perms.dat";
		File f = null;
		BufferedWriter writer = null;
		//slam out a new perms file so we know it has not been overwritten!
		f = new File(filepath);		
		writer = new BufferedWriter(new FileWriter(f));
        writer.write("grant {\n");
        writer.write("    permission java.io.FilePermission \"${user.dir}\", \"read,write,execute\";\n");
        writer.write("};\n");
        writer.write("grant {\n");
        writer.write("    permission java.io.FilePermission \"${user.dir}/*\", \"read,write,execute,delete\";\n");
        writer.write("};\n");
        writer.write("grant codebase \"file:DangerZone.jar\" {\n");
        writer.write("    permission java.io.FilePermission \"<<ALL FILES>>\", \"read,write,execute,delete\";\n");
        writer.write("};\n");
        writer.flush();
        writer.close();
		*/
		
		readConfig();
		
		if(args.length > 1){
			int arglen = args.length;
			int i;
			for(i=0;i<arglen;i++){
				//System.out.printf("arg %d = :%s\n", i, args[i]);
				if(args[i].contains("client")){
					try {
						cmdarray.add(Runnit.getJreExecutable().toString());
					} catch (FileNotFoundException e) {
						break;
					}
					
					//cmdarray.add("-Djava.security.manager");
					//String foo = "-Djava.security.policy=" + curdir + "/perms.dat";
					//cmdarray.add(foo);
					//if(!bits64mode){
					//	//cmdarray.add("-Xnoclassgc"); //TODO - does this crash the launcher??????????
					//	cmdarray.add("-Xmx750m");
					//	cmdarray.add("-XX:MaxDirectMemorySize=1g");
					//}else{
						//cmdarray.add("-Xnoclassgc"); //TODO - does this crash the launcher??????????
						//cmdarray.add("-Xmx2g");
						cmdarray.add(String.format("-Xmx%dg", client_max_g));
						//cmdarray.add("-XX:MaxDirectMemorySize=2g");
					//}
					String where = curdir + "/DangerZone.jar";
					cmdarray.add("-jar");
					cmdarray.add(where);
					cmdarray.add("client");
					cmdarray.add("-client");
					cmdarray.add("--client");
					
					//fire it up and wait for it here.
					try {
						Runnit.launch("client", cmdarray, 1000);
					} catch (IOException | InterruptedException e) {
						break;
					}
					break;
				}
				if(args[i].contains("server")){
					try {
						cmdarray.add(Runnit.getJreExecutable().toString());
					} catch (FileNotFoundException e) {
						break;
					}
					//cmdarray.add("-Djava.security.manager");
					//String foo = "-Djava.security.policy=" + curdir + "/perms.dat";
					//cmdarray.add(foo);
					//if(!bits64mode){
					//	cmdarray.add("-Xmx1g");
					//	cmdarray.add("-XX:MaxDirectMemorySize=500m");
					//}else{
						//cmdarray.add("-Xmx2g");
						cmdarray.add(String.format("-Xmx%dg", server_max_g));
						//cmdarray.add("-XX:MaxDirectMemorySize=1500m");
					//}
					String where = curdir + "/DangerZone.jar";
					cmdarray.add("-jar");
					cmdarray.add(where);
					cmdarray.add("server");
					cmdarray.add("-server");
					cmdarray.add("--server");
					
					//fire it up and wait for it here.
					try {
						Runnit.launch("server", cmdarray, 100000);
					} catch (IOException | InterruptedException e) {
						break;
					}	
					break;
				}
				if(args[i].contains("singleplayer")){
					try {
						cmdarray.add(Runnit.getJreExecutable().toString());
					} catch (FileNotFoundException e) {
						break;
					}
					//cmdarray.add("-Djava.security.manager");
					//String foo = "-Djava.security.policy=" + curdir + "/perms.dat";
					//cmdarray.add(foo);
					//if(!bits64mode){
					//	//cmdarray.add("-Xnoclassgc"); //TODO - does this crash the launcher??????????
					//	cmdarray.add("-Xmx1g");
					//	cmdarray.add("-XX:MaxDirectMemorySize=1g");
					//}else{
						//cmdarray.add("-Xmx2g");
						//cmdarray.add("-Xnoclassgc"); //TODO - does this crash the launcher??????????
						cmdarray.add(String.format("-Xmx%dg", single_max_g));
						//cmdarray.add("-XX:MaxDirectMemorySize=2g");
					//}
					String where = curdir + "/DangerZone.jar";
					cmdarray.add("-jar");
					cmdarray.add(where);
					
					//fire it up and wait for it here.
					try {
						Runnit.launch("singleplayer", cmdarray, 1000);
					} catch (IOException | InterruptedException e) {
						break;
					}
					break;
				}
			}
	
		}

		System.exit(0);
	}
	
	private static void readConfig(){
		//InputStream input = null;
		//Properties prop = new Properties();
		
		//try {	 
		//	input = new FileInputStream("DangerZone.properties");
	 
			// load a properties file
		//	prop.load(input);
	 
			//client_max_g = getPropertyInt(prop, "ClientMaxG", 1, 16, 2); //min, max, default
			//single_max_g = getPropertyInt(prop, "SingleMaxG", 1, 16, 2); //min, max, default
			//server_max_g = getPropertyInt(prop, "ServerMaxG", 1, 16, 2); //min, max, default
		server_max_g = 2;
		client_max_g = 3;
		single_max_g = 4;

		//} catch (IOException ex) {
			//ex.printStackTrace();
		//}
		//if (input != null) {
		//	try {
		//		input.close();
		//	} catch (IOException e) {
		//		//e.printStackTrace();
		//	}
		//}		
	}
	
	public static int getPropertyInt(Properties prop, String propname, int min, int max, int dflt){
		String s;
		int retval = dflt;
		// get the property value and print it out
		s = prop.getProperty(propname);
		if(s != null){
			retval = Integer.parseInt(s);
			if(retval < min)retval = min;
			if(retval > max)retval = max;
		}
		return retval;
	}

}
