package demomodcode;

import slick.Texture;

import dangerzone.DangerZone;
import dangerzone.entities.Entity;
import dangerzone.items.ItemArmor;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelRenderer;
import dangerzone.rendering.TextureMapper;


public class Beanie extends ItemArmor {
	
	public static ModelBeanie mhm = null;
	
	public Beanie(String n, String txt, float protvalue, int durability, int type) {
		super(n, txt, null, null, protvalue, durability, type);
		armortexturepath = "demores/items/"+ "BeanieTexture.png"; //same moose texture!
		burntime = 5;
		if(mhm == null)mhm = new ModelBeanie();
	}
	
	public Texture getArmorTexture(int id){
		if(armortexture == null){
			armortexture = TextureMapper.getTexture(armortexturepath);
		}
		return armortexture;
	}
	
	public Texture getArmorTexture2(int id){
		return null;
	}
	
	//uses a slightly modified moose head model.
	public void drawHelmet(Entity ent, ModelRenderer head, float deathfactor){
		
		DangerZone.wr.loadtexture(getArmorTexture(0));
		
		

		mhm.beaniebase.rotateAngleX = mhm.beanieaxel.rotateAngleX = mhm.beanieprop.rotateAngleX = head.rotateAngleX;
		mhm.beaniebase.rotateAngleY = mhm.beanieaxel.rotateAngleY = mhm.beanieprop.rotateAngleY = head.rotateAngleY;
		mhm.beaniebase.rotateAngleZ = mhm.beanieaxel.rotateAngleZ = mhm.beanieprop.rotateAngleZ = head.rotateAngleZ;
		
		mhm.beanieprop.rotateAngleY = (float) Math.toRadians((ent.lifetimeticker*15)%360);
		
		mhm.beaniebase.render(1);
		mhm.beanieaxel.render(1);
		
		MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();
		
		MatrixStack.translate( 0, 24f, 0);	//push the whole thing up 
		MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();
		MatrixStack.translate( 0, -24f, 0);	//undo Techne offset so it rotates correctly in x			
		MatrixStack.rotate((float)Math.toDegrees(mhm.beanieprop.rotateAngleZ), 0, 0, 1);
		MatrixStack.rotate(-(float)Math.toDegrees(mhm.beanieprop.rotateAngleX), 1, 0, 0);
		MatrixStack.sendCurrentStack();
		
		mhm.beanieprop.rotateAngleX = 0;
		mhm.beanieprop.rotateAngleZ = 0;
		mhm.beanieprop.render(1);	
		
		MatrixStack.popMatrix();			
		MatrixStack.popMatrix();
	}
}
	



