/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.resource.PackagerResource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SignJarParams
extends CommonParams {
    final List<PackagerResource> resources = new ArrayList<PackagerResource>();
    File keyStore;
    String alias;
    String storePass;
    String keyPass;
    String storeType = "jks";
    Boolean verbose = false;

    @Override
    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public void setKeyStore(File keyStore) {
        this.keyStore = keyStore;
    }

    public void setStorePass(String storePass) {
        this.storePass = storePass;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    @Override
    public void addResource(File baseDir, String path) {
        this.resources.add(new PackagerResource(baseDir, path));
    }

    @Override
    public void addResource(File baseDir, File file) {
        this.resources.add(new PackagerResource(baseDir, file));
    }

    @Override
    public void validate() throws PackagerException {
        if (this.keyStore == null) {
            throw new PackagerException("ERR_InvalidStoreFile", "null keystore");
        }
        if (!this.keyStore.isFile()) {
            throw new PackagerException("ERR_InvalidStoreFile", this.keyStore.getAbsolutePath());
        }
        if (this.alias == null || this.storePass == null) {
            throw new PackagerException("ERR_MissingArgument", "alias or storePass");
        }
        if (this.storeType == null) {
            this.storeType = "jks";
        }
        if (this.outdir != null) {
            this.outdir.mkdirs();
        }
    }
}

