/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinAppBundler;
import com.oracle.tools.packager.windows.WinResources;
import com.oracle.tools.packager.windows.WinServiceBundler;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WinExeBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinExeBundler.class.getName());
    public static final BundlerParamInfo<WinAppBundler> APP_BUNDLER = new WindowsBundlerParam<WinAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "win.app.bundler", WinAppBundler.class, params -> new WinAppBundler(), null);
    public static final BundlerParamInfo<WinServiceBundler> SERVICE_BUNDLER = new WindowsBundlerParam<WinServiceBundler>(I18N.getString("param.service-bundler.name"), I18N.getString("param.service-bundler.description"), "win.service.bundler", WinServiceBundler.class, params -> new WinServiceBundler(), null);
    public static final BundlerParamInfo<File> CONFIG_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> {
        File imagesRoot = new File((File)WindowsBundlerParam.BUILD_ROOT.fetchFrom((Map<String, ? super Object>)params), "windows");
        imagesRoot.mkdirs();
        return imagesRoot;
    }, (s, p) -> null);
    public static final StandardBundlerParam<Boolean> EXE_SYSTEM_WIDE = new StandardBundlerParam<Boolean>(I18N.getString("param.system-wide.name"), I18N.getString("param.system-wide.description"), "win.exe.systemWide", Boolean.class, params -> params.containsKey(WindowsBundlerParam.SYSTEM_WIDE.getID()) ? (Boolean)WindowsBundlerParam.SYSTEM_WIDE.fetchFrom((Map<String, ? super Object>)params) : Boolean.valueOf(false), (s, p) -> s == null || "null".equalsIgnoreCase((String)s) ? null : Boolean.valueOf(s));
    public static final BundlerParamInfo<File> EXE_IMAGE_DIR = new WindowsBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "win.exe.imageDir", File.class, params -> {
        File imagesRoot = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)params);
        if (!imagesRoot.exists()) {
            imagesRoot.mkdirs();
        }
        return new File(imagesRoot, "win-exe.image");
    }, (s, p) -> null);
    private static final String DEFAULT_EXE_PROJECT_TEMPLATE = "template.iss";
    private static final String TOOL_INNO_SETUP_COMPILER = "iscc.exe";
    public static final BundlerParamInfo<String> TOOL_INNO_SETUP_COMPILER_EXECUTABLE = new WindowsBundlerParam<String>(I18N.getString("param.iscc-path.name"), I18N.getString("param.iscc-path.description"), "win.exe.iscc.exe", String.class, params -> {
        for (String dirString : (System.getenv("PATH") + ";C:\\Program Files (x86)\\Inno Setup 5;C:\\Program Files\\Inno Setup 5").split(";")) {
            File f = new File(dirString.replace("\"", ""), TOOL_INNO_SETUP_COMPILER);
            if (!f.isFile()) continue;
            return f.toString();
        }
        return null;
    }, null);
    private static final String DEFAULT_INNO_SETUP_ICON = "icon_inno_setup.bmp";

    public WinExeBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "exe";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(WinAppBundler.getAppBundleParameters());
        results.addAll(WinExeBundler.getExeBundleParameters());
        return results;
    }

    public static Collection<BundlerParamInfo<?>> getExeBundleParameters() {
        return Arrays.asList(WindowsBundlerParam.DESCRIPTION, WindowsBundlerParam.COPYRIGHT, WindowsBundlerParam.LICENSE_FILE, WindowsBundlerParam.MENU_GROUP, WindowsBundlerParam.MENU_HINT, WindowsBundlerParam.SHORTCUT_HINT, WindowsBundlerParam.SYSTEM_WIDE, WindowsBundlerParam.TITLE, WindowsBundlerParam.VENDOR, WindowsBundlerParam.INSTALLDIR_CHOOSER);
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.bundle(params, outputParentDir);
    }

    private static double findToolVersion(String toolName) {
        try {
            if (toolName == null || "".equals(toolName)) {
                return 0.0;
            }
            ProcessBuilder pb = new ProcessBuilder(toolName, "/?");
            VersionExtractor ve = new VersionExtractor();
            IOUtils.exec(pb, Log.isDebug(), true, ve);
            double version = ve.getVersion();
            Log.verbose(MessageFormat.format(I18N.getString("message.tool-version"), toolName, version));
            return version;
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                e.printStackTrace();
            }
            return 0.0;
        }
    }

    @Override
    public boolean validate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        try {
            double minVersion;
            double innoVersion;
            if (p == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(p).validate(p);
            for (BundlerParamInfo bundlerParamInfo : Arrays.asList(WindowsBundlerParam.APP_NAME, WindowsBundlerParam.COPYRIGHT, WindowsBundlerParam.DESCRIPTION, WindowsBundlerParam.MENU_GROUP, WindowsBundlerParam.TITLE, WindowsBundlerParam.VENDOR, WindowsBundlerParam.VERSION)) {
                String v = (String)bundlerParamInfo.fetchFrom(p);
                if (!(v.contains("\n") | v.contains("\r"))) continue;
                throw new ConfigException("Parmeter '" + bundlerParamInfo.getID() + "' cannot contain a newline.", "Change the value of '" + bundlerParamInfo.getID() + " so that it does not contain any newlines");
            }
            if (((String)WindowsBundlerParam.COPYRIGHT.fetchFrom(p)).length() > 100) {
                throw new ConfigException(I18N.getString("error.copyright-is-too-long"), I18N.getString("error.copyright-is-too-long.advice"));
            }
            if (p.containsKey(WindowsBundlerParam.LICENSE_FILE.getID())) {
                List appResourcesList = (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(p);
                for (String license : (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(p)) {
                    boolean found = false;
                    for (RelativeFileSet appResources : appResourcesList) {
                        found = found || appResources.contains(license);
                    }
                    if (found) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), license));
                }
            }
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(p)).booleanValue()) {
                SERVICE_BUNDLER.fetchFrom(p).validate(p);
            }
            if ((innoVersion = WinExeBundler.findToolVersion(TOOL_INNO_SETUP_COMPILER_EXECUTABLE.fetchFrom(p))) < (minVersion = 5.0)) {
                Log.info(MessageFormat.format(I18N.getString("message.tool-wrong-version"), TOOL_INNO_SETUP_COMPILER, innoVersion, minVersion));
                throw new ConfigException(I18N.getString("error.iscc-not-found"), I18N.getString("error.iscc-not-found.advice"));
            }
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    private boolean prepareProto(Map<String, ? super Object> params) throws IOException {
        File imageDir = EXE_IMAGE_DIR.fetchFrom(params);
        File appOutputDir = APP_BUNDLER.fetchFrom(params).doBundle(params, imageDir, true);
        if (appOutputDir == null) {
            return false;
        }
        List licenseFiles = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(params);
        if (licenseFiles != null) {
            block0: for (RelativeFileSet rfs : (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(params)) {
                for (String s : licenseFiles) {
                    if (!rfs.contains(s)) continue;
                    File lfile = new File(rfs.getBaseDirectory(), s);
                    IOUtils.copyFile(lfile, new File(imageDir, lfile.getName()));
                    break block0;
                }
            }
        }
        for (Map fileAssociation : (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(params)) {
            File icon = (File)WindowsBundlerParam.FA_ICON.fetchFrom(fileAssociation);
            if (icon == null || !icon.exists()) continue;
            IOUtils.copyFile(icon, new File(appOutputDir, icon.getName()));
        }
        return (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params) == false || (appOutputDir = SERVICE_BUNDLER.fetchFrom(params).doBundle(params, appOutputDir, true)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> p, File outputDirectory) {
        File imageDir;
        block34: {
            if (!outputDirectory.isDirectory() && !outputDirectory.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outputDirectory.getAbsolutePath()));
            }
            if (!outputDirectory.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outputDirectory.getAbsolutePath()));
            }
            String iscc = TOOL_INNO_SETUP_COMPILER_EXECUTABLE.fetchFrom(p);
            if (iscc == null || !new File(iscc).isFile()) {
                Log.info(I18N.getString("error.iscc-not-found"));
                Log.info(MessageFormat.format(I18N.getString("message.iscc-file-string"), iscc));
                return null;
            }
            imageDir = EXE_IMAGE_DIR.fetchFrom(p);
            imageDir.mkdirs();
            boolean menuShortcut = (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(p);
            boolean desktopShortcut = (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(p);
            if (!menuShortcut && !desktopShortcut) {
                Log.verbose(I18N.getString("message.one-shortcut-required"));
                p.put(WindowsBundlerParam.MENU_HINT.getID(), (Object)true);
            }
            if (!this.prepareProto(p) || !this.prepareProjectConfig(p)) break block34;
            File configScript = this.getConfig_Script(p);
            if (configScript.exists()) {
                Log.info(MessageFormat.format(I18N.getString("message.running-wsh-script"), configScript.getAbsolutePath()));
                IOUtils.run("wscript", configScript, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
            }
            File file = this.buildEXE(p, outputDirectory);
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    this.saveConfigFiles(p);
                }
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            return file;
        }
        File configScript = null;
        try {
            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                this.saveConfigFiles(p);
            }
            if (imageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(imageDir);
            } else if (imageDir != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return configScript;
        catch (IOException ex) {
            File file;
            try {
                ex.printStackTrace();
                file = null;
            }
            catch (Throwable throwable) {
                try {
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                        this.saveConfigFiles(p);
                    }
                    if (imageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(imageDir);
                    } else if (imageDir != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException ex2) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    this.saveConfigFiles(p);
                }
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex3) {
                return null;
            }
            return file;
        }
    }

    private File getConfig_Script(Map<String, ? super Object> params) {
        return new File(EXE_IMAGE_DIR.fetchFrom(params), (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "-post-image.wsf");
    }

    protected void saveConfigFiles(Map<String, ? super Object> params) {
        try {
            File configRoot = CONFIG_ROOT.fetchFrom(params);
            if (this.getConfig_ExeProjectFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_ExeProjectFile(params), new File(configRoot, this.getConfig_ExeProjectFile(params).getName()));
            }
            if (this.getConfig_Script(params).exists()) {
                IOUtils.copyFile(this.getConfig_Script(params), new File(configRoot, this.getConfig_Script(params).getName()));
            }
            if (this.getConfig_SmallInnoSetupIcon(params).exists()) {
                IOUtils.copyFile(this.getConfig_SmallInnoSetupIcon(params), new File(configRoot, this.getConfig_SmallInnoSetupIcon(params).getName()));
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), configRoot.getAbsolutePath()));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String getAppIdentifier(Map<String, ? super Object> params) {
        String nm = (String)WindowsBundlerParam.IDENTIFIER.fetchFrom(params);
        if (nm.length() > 126) {
            nm = nm.substring(0, 126);
        }
        return nm;
    }

    private String getLicenseFile(Map<String, ? super Object> params) {
        List licenseFiles = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(params);
        if (licenseFiles == null || licenseFiles.isEmpty()) {
            return "";
        }
        return (String)licenseFiles.get(0);
    }

    void validateValueAndPut(Map<String, String> data, String key, BundlerParamInfo<String> param, Map<String, ? super Object> params) throws IOException {
        String value = param.fetchFrom(params);
        if (value.contains("\r") || value.contains("\n")) {
            throw new IOException("Configuration Parameter " + param.getID() + " cannot contain multiple lines of text");
        }
        data.put(key, this.innosetupEscape(value));
    }

    private String innosetupEscape(String value) {
        if (value.contains("\"") || !value.trim().equals(value)) {
            value = "\"" + value.replace("\"", "\"\"") + "\"";
        }
        return value;
    }

    boolean prepareMainProjectFile(Map<String, ? super Object> params) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("PRODUCT_APP_IDENTIFIER", this.innosetupEscape(this.getAppIdentifier(params)));
        this.validateValueAndPut(data, "APPLICATION_NAME", WindowsBundlerParam.APP_NAME, params);
        this.validateValueAndPut(data, "APPLICATION_VENDOR", WindowsBundlerParam.VENDOR, params);
        this.validateValueAndPut(data, "APPLICATION_VERSION", WindowsBundlerParam.VERSION, params);
        this.validateValueAndPut(data, "INSTALLER_FILE_NAME", WindowsBundlerParam.INSTALLER_FILE_NAME, params);
        data.put("APPLICATION_LAUNCHER_FILENAME", this.innosetupEscape(WinAppBundler.getLauncherName(params)));
        data.put("APPLICATION_DESKTOP_SHORTCUT", (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(params) != false ? "returnTrue" : "returnFalse");
        data.put("APPLICATION_MENU_SHORTCUT", (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(params) != false ? "returnTrue" : "returnFalse");
        this.validateValueAndPut(data, "APPLICATION_GROUP", WindowsBundlerParam.MENU_GROUP, params);
        this.validateValueAndPut(data, "APPLICATION_COMMENTS", WindowsBundlerParam.TITLE, params);
        this.validateValueAndPut(data, "APPLICATION_COPYRIGHT", WindowsBundlerParam.COPYRIGHT, params);
        data.put("APPLICATION_LICENSE_FILE", this.innosetupEscape(this.getLicenseFile(params)));
        data.put("DISABLE_DIR_PAGE", WindowsBundlerParam.INSTALLDIR_CHOOSER.fetchFrom(params) != false ? "No" : "Yes");
        Boolean isSystemWide = (Boolean)EXE_SYSTEM_WIDE.fetchFrom(params);
        if (isSystemWide.booleanValue()) {
            data.put("APPLICATION_INSTALL_ROOT", "{pf}");
            data.put("APPLICATION_INSTALL_PRIVILEGE", "admin");
        } else {
            data.put("APPLICATION_INSTALL_ROOT", "{localappdata}");
            data.put("APPLICATION_INSTALL_PRIVILEGE", "lowest");
        }
        if (((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(params)).booleanValue()) {
            data.put("ARCHITECTURE_BIT_MODE", "x64");
        } else {
            data.put("ARCHITECTURE_BIT_MODE", "");
        }
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
            data.put("RUN_FILENAME", this.innosetupEscape(WinServiceBundler.getAppSvcName(params)));
        } else {
            this.validateValueAndPut(data, "RUN_FILENAME", WindowsBundlerParam.APP_NAME, params);
        }
        this.validateValueAndPut(data, "APPLICATION_DESCRIPTION", WindowsBundlerParam.DESCRIPTION, params);
        data.put("APPLICATION_SERVICE", (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params) != false ? "returnTrue" : "returnFalse");
        data.put("APPLICATION_NOT_SERVICE", (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params) != false ? "returnFalse" : "returnTrue");
        data.put("APPLICATION_APP_CDS_INSTALL", (Boolean)WindowsBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(params) != false && (Boolean)WindowsBundlerParam.ENABLE_APP_CDS.fetchFrom(params) != false && ("install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params)) || "auto+install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params))) ? "returnTrue" : "returnFalse");
        data.put("START_ON_INSTALL", (Boolean)WindowsBundlerParam.START_ON_INSTALL.fetchFrom(params) != false ? "-startOnInstall" : "");
        data.put("STOP_ON_UNINSTALL", (Boolean)WindowsBundlerParam.STOP_ON_UNINSTALL.fetchFrom(params) != false ? "-stopOnUninstall" : "");
        data.put("RUN_AT_STARTUP", (Boolean)WindowsBundlerParam.RUN_AT_STARTUP.fetchFrom(params) != false ? "-runAtStartup" : "");
        StringBuilder secondaryLaunchersCfg = new StringBuilder();
        for (Map launcher : (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(params)) {
            String application_name = (String)WindowsBundlerParam.APP_NAME.fetchFrom(launcher);
            if (((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(launcher)).booleanValue()) {
                secondaryLaunchersCfg.append("Name: \"{group}\\");
                secondaryLaunchersCfg.append(application_name);
                secondaryLaunchersCfg.append("\"; Filename: \"{app}\\");
                secondaryLaunchersCfg.append(application_name);
                secondaryLaunchersCfg.append(".exe\"; IconFilename: \"{app}\\");
                secondaryLaunchersCfg.append(application_name);
                secondaryLaunchersCfg.append(".ico\"\r\n");
            }
            if (!((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(launcher)).booleanValue()) continue;
            secondaryLaunchersCfg.append("Name: \"{commondesktop}\\");
            secondaryLaunchersCfg.append(application_name);
            secondaryLaunchersCfg.append("\"; Filename: \"{app}\\");
            secondaryLaunchersCfg.append(application_name);
            secondaryLaunchersCfg.append(".exe\";  IconFilename: \"{app}\\");
            secondaryLaunchersCfg.append(application_name);
            secondaryLaunchersCfg.append(".ico\"\r\n");
        }
        data.put("SECONDARY_LAUNCHERS", secondaryLaunchersCfg.toString());
        StringBuilder registryEntries = new StringBuilder();
        String regName = WindowsBundlerParam.APP_REGISTRY_NAME.fetchFrom(params);
        List fetchFrom = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(params);
        for (int i = 0; i < fetchFrom.size(); ++i) {
            Map fileAssociation = (Map)fetchFrom.get(i);
            String description = (String)WindowsBundlerParam.FA_DESCRIPTION.fetchFrom(fileAssociation);
            File icon = (File)WindowsBundlerParam.FA_ICON.fetchFrom(fileAssociation);
            List extensions = (List)WindowsBundlerParam.FA_EXTENSIONS.fetchFrom(fileAssociation);
            String entryName = regName + "File";
            if (i > 0) {
                entryName = entryName + "." + i;
            }
            if (extensions == null) {
                Log.info(I18N.getString("message.creating-association-with-null-extension"));
            } else {
                for (String ext : extensions) {
                    if (isSystemWide.booleanValue()) {
                        registryEntries.append("Root: HKCR; Subkey: \".").append(ext).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(entryName).append("\"; Flags: uninsdeletevalue\r\n");
                        continue;
                    }
                    registryEntries.append("Root: HKCU; Subkey: \"Software\\Classes\\.").append(ext).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(entryName).append("\"; Flags: uninsdeletevalue\r\n");
                }
            }
            if (extensions != null && !extensions.isEmpty()) {
                String ext = (String)extensions.get(0);
                List mimeTypes = (List)WindowsBundlerParam.FA_CONTENT_TYPE.fetchFrom(fileAssociation);
                for (String mime : mimeTypes) {
                    if (isSystemWide.booleanValue()) {
                        registryEntries.append("Root: HKCR; Subkey: \"Mime\\Database\\Content Type\\").append(mime).append("\"; ValueType: string; ValueName: \"Extension\"; ValueData: \".").append(ext).append("\"; Flags: uninsdeletevalue\r\n");
                        continue;
                    }
                    registryEntries.append("Root: HKCU; Subkey: \"Software\\Classes\\Mime\\Database\\Content Type\\").append(mime).append("\"; ValueType: string; ValueName: \"Extension\"; ValueData: \".").append(ext).append("\"; Flags: uninsdeletevalue\r\n");
                }
            }
            if (isSystemWide.booleanValue()) {
                registryEntries.append("Root: HKCR; Subkey: \"").append(entryName).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(description).append("\"; Flags: uninsdeletekey\r\n");
            } else {
                registryEntries.append("Root: HKCU; Subkey: \"Software\\Classes\\").append(entryName).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(description).append("\"; Flags: uninsdeletekey\r\n");
            }
            if (icon != null && icon.exists()) {
                if (isSystemWide.booleanValue()) {
                    registryEntries.append("Root: HKCR; Subkey: \"").append(entryName).append("\\DefaultIcon\"; ValueType: string; ValueName: \"\"; ValueData: \"{app}\\").append(icon.getName()).append("\"\r\n");
                } else {
                    registryEntries.append("Root: HKCU; Subkey: \"Software\\Classes\\").append(entryName).append("\\DefaultIcon\"; ValueType: string; ValueName: \"\"; ValueData: \"{app}\\").append(icon.getName()).append("\"\r\n");
                }
            }
            if (isSystemWide.booleanValue()) {
                registryEntries.append("Root: HKCR; Subkey: \"").append(entryName).append("\\shell\\open\\command\"; ValueType: string; ValueName: \"\"; ValueData: \"\"\"{app}\\").append((String)WindowsBundlerParam.APP_NAME.fetchFrom(params)).append("\"\" \"\"%1\"\"\"\r\n");
                continue;
            }
            registryEntries.append("Root: HKCU; Subkey: \"Software\\Classes\\").append(entryName).append("\\shell\\open\\command\"; ValueType: string; ValueName: \"\"; ValueData: \"\"\"{app}\\").append((String)WindowsBundlerParam.APP_NAME.fetchFrom(params)).append("\"\" \"\"%1\"\"\"\r\n");
        }
        if (registryEntries.length() > 0) {
            data.put("FILE_ASSOCIATIONS", "ChangesAssociations=yes\r\n\r\n[Registry]\r\n" + registryEntries.toString());
        } else {
            data.put("FILE_ASSOCIATIONS", "");
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_ExeProjectFile(params)));
        String content = this.preprocessTextResource("package/windows/" + this.getConfig_ExeProjectFile(params).getName(), I18N.getString("resource.inno-setup-project-file"), DEFAULT_EXE_PROJECT_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        return true;
    }

    private boolean prepareProjectConfig(Map<String, ? super Object> params) throws IOException {
        this.prepareMainProjectFile(params);
        File iconTarget = this.getConfig_SmallInnoSetupIcon(params);
        this.fetchResource("package/windows/" + iconTarget.getName(), I18N.getString("resource.setup-icon"), DEFAULT_INNO_SETUP_ICON, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        this.fetchResource("package/windows/" + this.getConfig_Script(params).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        return true;
    }

    private File getConfig_SmallInnoSetupIcon(Map<String, ? super Object> params) {
        return new File(EXE_IMAGE_DIR.fetchFrom(params), (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + "-setup-icon.bmp");
    }

    private File getConfig_ExeProjectFile(Map<String, ? super Object> params) {
        return new File(EXE_IMAGE_DIR.fetchFrom(params), (String)WindowsBundlerParam.APP_NAME.fetchFrom(params) + ".iss");
    }

    private File buildEXE(Map<String, ? super Object> params, File outdir) throws IOException {
        Log.verbose(MessageFormat.format(I18N.getString("message.outputting-to-location"), outdir.getAbsolutePath()));
        outdir.mkdirs();
        ProcessBuilder pb = new ProcessBuilder(TOOL_INNO_SETUP_COMPILER_EXECUTABLE.fetchFrom(params), "/o" + outdir.getAbsolutePath(), this.getConfig_ExeProjectFile(params).getAbsolutePath());
        pb = pb.directory(EXE_IMAGE_DIR.fetchFrom(params));
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
        Log.info(MessageFormat.format(I18N.getString("message.output-location"), outdir.getAbsolutePath()));
        File result = null;
        long lastModified = 0L;
        File[] list = outdir.listFiles();
        if (list != null) {
            for (File f : list) {
                if (!f.getName().endsWith(".exe") || f.lastModified() <= lastModified) continue;
                result = f;
                lastModified = f.lastModified();
            }
        }
        return result;
    }

    static class VersionExtractor
    extends PrintStream {
        double version = 0.0;

        public VersionExtractor() {
            super(new ByteArrayOutputStream());
        }

        double getVersion() {
            if (this.version == 0.0) {
                String content = new String(((ByteArrayOutputStream)this.out).toByteArray());
                Pattern pattern = Pattern.compile("Inno Setup (\\d+.?\\d*)");
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    String v = matcher.group(1);
                    this.version = new Double(v);
                }
            }
            return this.version;
        }
    }
}

