/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;

public class MacAppStoreBundler
extends MacBaseInstallerBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacAppStoreBundler.class.getName());
    private static final String TEMPLATE_BUNDLE_ICON_HIDPI = "GenericAppHiDPI.icns";
    private static final String DEFAULT_ENTITLEMENTS = "MacAppStore.entitlements";
    private static final String DEFAULT_INHERIT_ENTITLEMENTS = "MacAppStore_Inherit.entitlements";
    public static final BundlerParamInfo<String> MAC_APP_STORE_APP_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-app.name"), I18N.getString("param.signing-key-app.description"), "mac.signing-key-app", String.class, params -> MacBaseInstallerBundler.findKey("3rd Party Mac Developer Application: " + (String)SIGNING_KEY_USER.fetchFrom((Map<String, ? super Object>)params), (String)SIGNING_KEYCHAIN.fetchFrom((Map<String, ? super Object>)params), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)params)), (s, p) -> s);
    public static final BundlerParamInfo<String> MAC_APP_STORE_PKG_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-pkg.name"), I18N.getString("param.signing-key-pkg.description"), "mac.signing-key-pkg", String.class, params -> MacBaseInstallerBundler.findKey("3rd Party Mac Developer Installer: " + (String)SIGNING_KEY_USER.fetchFrom((Map<String, ? super Object>)params), (String)SIGNING_KEYCHAIN.fetchFrom((Map<String, ? super Object>)params), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)params)), (s, p) -> s);
    public static final StandardBundlerParam<File> MAC_APP_STORE_ENTITLEMENTS = new StandardBundlerParam<File>(I18N.getString("param.mac-app-store-entitlements.name"), I18N.getString("param.mac-app-store-entitlements.description"), "mac.app-store-entitlements", File.class, params -> null, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<String> INSTALLER_SUFFIX = new StandardBundlerParam<String>(I18N.getString("param.installer-suffix.name"), I18N.getString("param.installer-suffix.description"), "mac.app-store.installerName.suffix", String.class, params -> "-MacAppStore", (s, p) -> s);

    public MacAppStoreBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> p, File outdir) {
        Log.info(MessageFormat.format(I18N.getString("message.building-bundle"), StandardBundlerParam.APP_NAME.fetchFrom(p)));
        if (!outdir.isDirectory() && !outdir.mkdirs()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outdir.getAbsolutePath()));
        }
        if (!outdir.canWrite()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outdir.getAbsolutePath()));
        }
        p.put(MacAppBundler.DEFAULT_ICNS_ICON.getID(), TEMPLATE_BUNDLE_ICON_HIDPI);
        p.put(MacAppBundler.MAC_RULES.getID(), (Object)MacAppStoreBundler.createMacAppStoreRuntimeRules(p));
        File appImageDir = (File)this.APP_IMAGE_BUILD_ROOT.fetchFrom(p);
        appImageDir.mkdirs();
        p.put(MacAppBundler.DEVELOPER_ID_APP_SIGNING_KEY.getID(), null);
        File appLocation = this.prepareAppBundle(p);
        this.prepareEntitlements(p);
        String signingIdentity = MAC_APP_STORE_APP_SIGNING_KEY.fetchFrom(p);
        String identifierPrefix = MacAppBundler.BUNDLE_ID_SIGNING_PREFIX.fetchFrom(p);
        String entitlementsFile = this.getConfig_Entitlements(p).toString();
        String inheritEntitlements = this.getConfig_Inherit_Entitlements(p).toString();
        MacAppStoreBundler.signAppBundle(p, appLocation, signingIdentity, identifierPrefix, entitlementsFile, inheritEntitlements);
        File finalPKG = new File(outdir, (String)INSTALLER_NAME.fetchFrom(p) + INSTALLER_SUFFIX.fetchFrom(p) + ".pkg");
        outdir.mkdirs();
        ArrayList<String> buildOptions = new ArrayList<String>();
        buildOptions.add("productbuild");
        buildOptions.add("--component");
        buildOptions.add(appLocation.toString());
        buildOptions.add("/Applications");
        buildOptions.add("--sign");
        buildOptions.add(MAC_APP_STORE_PKG_SIGNING_KEY.fetchFrom(p));
        buildOptions.add("--product");
        buildOptions.add(appLocation + "/Contents/Info.plist");
        String keychainName = (String)SIGNING_KEYCHAIN.fetchFrom(p);
        if (keychainName != null && !keychainName.isEmpty()) {
            buildOptions.add("--keychain");
            buildOptions.add(keychainName);
        }
        buildOptions.add(finalPKG.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(buildOptions);
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        File file = finalPKG;
        try {
            if (appImageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(appImageDir);
            } else if (appImageDir != null) {
                Log.info(MessageFormat.format(I18N.getString("mesasge.intermediate-bundle-location"), appImageDir.getAbsolutePath()));
            }
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                this.cleanupConfigFiles(p);
            } else {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(p)).getAbsolutePath()));
            }
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return file;
        catch (Exception ex) {
            File file2;
            try {
                Log.info("App Store Ready Bundle failed : " + ex.getMessage());
                ex.printStackTrace();
                Log.debug(ex);
                file2 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (appImageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(appImageDir);
                    } else if (appImageDir != null) {
                        Log.info(MessageFormat.format(I18N.getString("mesasge.intermediate-bundle-location"), appImageDir.getAbsolutePath()));
                    }
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                        this.cleanupConfigFiles(p);
                    } else {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(p)).getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException ex2) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (appImageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(appImageDir);
                } else if (appImageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("mesasge.intermediate-bundle-location"), appImageDir.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    this.cleanupConfigFiles(p);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(p)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex3) {
                return null;
            }
            return file2;
        }
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> params) {
        if (this.getConfig_Entitlements(params) != null) {
            this.getConfig_Entitlements(params).delete();
        }
        if (this.getConfig_Inherit_Entitlements(params) != null) {
            this.getConfig_Inherit_Entitlements(params).delete();
        }
        if (MAC_APP_IMAGE.fetchFrom(params) == null) {
            ((MacAppBundler)APP_BUNDLER.fetchFrom(params)).cleanupConfigFiles(params);
        }
    }

    private File getConfig_Entitlements(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".entitlements");
    }

    private File getConfig_Inherit_Entitlements(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "_Inherit.entitlements");
    }

    private void prepareEntitlements(Map<String, ? super Object> params) throws IOException {
        File entitlements = (File)MAC_APP_STORE_ENTITLEMENTS.fetchFrom(params);
        if (entitlements == null || !entitlements.exists()) {
            this.fetchResource(this.getEntitlementsFileName(params), I18N.getString("resource.mac-app-store-entitlements"), DEFAULT_ENTITLEMENTS, this.getConfig_Entitlements(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        } else {
            this.fetchResource(this.getEntitlementsFileName(params), I18N.getString("resource.mac-app-store-entitlements"), entitlements, this.getConfig_Entitlements(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        }
        this.fetchResource(this.getInheritEntitlementsFileName(params), I18N.getString("resource.mac-app-store-inherit-entitlements"), DEFAULT_INHERIT_ENTITLEMENTS, this.getConfig_Inherit_Entitlements(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
    }

    private String getEntitlementsFileName(Map<String, ? super Object> params) {
        return MacAppBundler.MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".entitlements";
    }

    private String getInheritEntitlementsFileName(Map<String, ? super Object> params) {
        return MacAppBundler.MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "_Inherit.entitlements";
    }

    public static JreUtils.Rule[] createMacAppStoreRuntimeRules(Map<String, ? super Object> params) {
        int updateVersion;
        int majorVersion;
        Object o;
        ArrayList<JreUtils.Rule> rules = new ArrayList<JreUtils.Rule>();
        rules.addAll(Arrays.asList(MacAppBundler.createMacRuntimeRules(params)));
        File baseDir = params.containsKey(MacAppBundler.MAC_RUNTIME.getID()) ? ((o = params.get(MacAppBundler.MAC_RUNTIME.getID())) instanceof RelativeFileSet ? ((RelativeFileSet)o).getBaseDirectory() : new File(o.toString())) : new File(System.getProperty("java.home"));
        try {
            String path = baseDir.getCanonicalPath();
            if (path.endsWith("/Contents/Home/jre")) {
                baseDir = baseDir.getParentFile().getParentFile().getParentFile();
            } else if (path.endsWith("/Contents/Home")) {
                baseDir = baseDir.getParentFile().getParentFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!baseDir.exists()) {
            throw new RuntimeException(I18N.getString("error.non-existent-runtime"), new ConfigException(I18N.getString("error.non-existent-runtime"), I18N.getString("error.non-existent-runtime.advice")));
        }
        try {
            majorVersion = Integer.parseInt(params.get(".runtime.version.major").toString());
            updateVersion = Integer.parseInt(params.get(".runtime.version.update").toString());
        }
        catch (Exception e) {
            majorVersion = 8;
            updateVersion = 60;
        }
        if (majorVersion == 8 && updateVersion >= 40) {
            rules.add(JreUtils.Rule.suffixNeg("/lib/libjfxmedia_qtkit.dylib"));
        } else {
            rules.add(JreUtils.Rule.suffixNeg("/lib/libjfxmedia.dylib"));
        }
        if (majorVersion == 8 && 60 <= updateVersion && updateVersion < 152) {
            rules.add(JreUtils.Rule.suffixNeg("/lib/libjfxwebkit.dylib"));
        }
        return rules.toArray(new JreUtils.Rule[rules.size()]);
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "mac.appStore";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(MacAppBundler.getAppBundleParameters());
        results.addAll(this.getMacAppStoreBundleParameters());
        return results;
    }

    public Collection<BundlerParamInfo<?>> getMacAppStoreBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(MacAppBundler.getAppBundleParameters());
        results.remove(MacAppBundler.DEVELOPER_ID_APP_SIGNING_KEY);
        results.addAll(Arrays.asList(INSTALLER_SUFFIX, MAC_APP_STORE_APP_SIGNING_KEY, MAC_APP_STORE_ENTITLEMENTS, MAC_APP_STORE_PKG_SIGNING_KEY, SIGNING_KEYCHAIN));
        return results;
    }

    @Override
    public boolean validate(Map<String, ? super Object> params) throws UnsupportedPlatformException, ConfigException {
        try {
            if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
                throw new UnsupportedPlatformException();
            }
            if (params == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            if (params.containsKey(MacAppBundler.MAC_RUNTIME.getID()) && params.get(MacAppBundler.MAC_RUNTIME.getID()) == null) {
                throw new ConfigException(I18N.getString("error.no-system-runtime"), I18N.getString("error.no-system-runtime.advice"));
            }
            params.put(MacAppBundler.MAC_RULES.getID(), (Object)MacAppStoreBundler.createMacAppStoreRuntimeRules(params));
            this.validateAppImageAndBundeler(params);
            if (!Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(params)).orElse(Boolean.TRUE).booleanValue()) {
                throw new ConfigException(I18N.getString("error.must-sign-app-store"), I18N.getString("error.must-sign-app-store.advice"));
            }
            if (MAC_APP_STORE_APP_SIGNING_KEY.fetchFrom(params) == null) {
                throw new ConfigException(I18N.getString("error.no-app-signing-key"), I18N.getString("error.no-app-signing-key.advice"));
            }
            if (MAC_APP_STORE_PKG_SIGNING_KEY.fetchFrom(params) == null) {
                throw new ConfigException(I18N.getString("error.no-pkg-signing-key"), I18N.getString("error.no-pkg-signing-key.advice"));
            }
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.bundle(params, outputParentDir);
    }
}

