/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.FormatterAccessor;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.util.StringConverter;

public class TextFormatter<V> {
    private final StringConverter<V> valueConverter;
    private final UnaryOperator<Change> filter;
    private Consumer<TextFormatter<?>> textUpdater;
    public static final StringConverter<String> IDENTITY_STRING_CONVERTER = new StringConverter<String>(){

        @Override
        public String toString(String object) {
            return object == null ? "" : object;
        }

        @Override
        public String fromString(String string) {
            return string;
        }
    };
    private final ObjectProperty<V> value = new ObjectPropertyBase<V>(){

        @Override
        public Object getBean() {
            return TextFormatter.this;
        }

        @Override
        public String getName() {
            return "value";
        }

        @Override
        protected void invalidated() {
            if (TextFormatter.this.valueConverter == null && this.get() != null) {
                if (this.isBound()) {
                    this.unbind();
                }
                throw new IllegalStateException("Value changes are not supported when valueConverter is not set");
            }
            TextFormatter.this.updateText();
        }
    };

    public TextFormatter(@NamedArg(value="filter") UnaryOperator<Change> filter) {
        this(null, null, filter);
    }

    public TextFormatter(@NamedArg(value="valueConverter") StringConverter<V> valueConverter, @NamedArg(value="defaultValue") V defaultValue, @NamedArg(value="filter") UnaryOperator<Change> filter) {
        this.filter = filter;
        this.valueConverter = valueConverter;
        this.setValue(defaultValue);
    }

    public TextFormatter(@NamedArg(value="valueConverter") StringConverter<V> valueConverter, @NamedArg(value="defaultValue") V defaultValue) {
        this(valueConverter, defaultValue, null);
    }

    public TextFormatter(@NamedArg(value="valueConverter") StringConverter<V> valueConverter) {
        this(valueConverter, null, null);
    }

    public final StringConverter<V> getValueConverter() {
        return this.valueConverter;
    }

    public final UnaryOperator<Change> getFilter() {
        return this.filter;
    }

    public final ObjectProperty<V> valueProperty() {
        return this.value;
    }

    public final void setValue(V value) {
        if (this.valueConverter == null && value != null) {
            throw new IllegalStateException("Value changes are not supported when valueConverter is not set");
        }
        this.value.set(value);
    }

    public final V getValue() {
        return (V)this.value.get();
    }

    private void updateText() {
        if (this.textUpdater != null) {
            this.textUpdater.accept(this);
        }
    }

    void bindToControl(Consumer<TextFormatter<?>> updater) {
        if (this.textUpdater != null) {
            throw new IllegalStateException("Formatter is already used in other control");
        }
        this.textUpdater = updater;
    }

    void unbindFromControl() {
        this.textUpdater = null;
    }

    void updateValue(String text) {
        if (!this.value.isBound()) {
            try {
                V v = this.valueConverter.fromString(text);
                this.setValue(v);
            }
            catch (Exception e) {
                this.updateText();
            }
        }
    }

    public static final class Change
    implements Cloneable {
        private final FormatterAccessor accessor;
        private Control control;
        int start;
        int end;
        String text;
        int anchor;
        int caret;

        Change(Control control, FormatterAccessor accessor, int anchor, int caret) {
            this(control, accessor, caret, caret, "", anchor, caret);
        }

        Change(Control control, FormatterAccessor accessor, int start, int end, String text) {
            this(control, accessor, start, end, text, start + text.length(), start + text.length());
        }

        Change(Control control, FormatterAccessor accessor, int start, int end, String text, int anchor, int caret) {
            this.control = control;
            this.accessor = accessor;
            this.start = start;
            this.end = end;
            this.text = text;
            this.anchor = anchor;
            this.caret = caret;
        }

        public final Control getControl() {
            return this.control;
        }

        public final int getRangeStart() {
            return this.start;
        }

        public final int getRangeEnd() {
            return this.end;
        }

        public final void setRange(int start, int end) {
            int length = this.accessor.getTextLength();
            if (start < 0 || start > length || end < 0 || end > length) {
                throw new IndexOutOfBoundsException();
            }
            this.start = start;
            this.end = end;
        }

        public final int getCaretPosition() {
            return this.caret;
        }

        public final int getAnchor() {
            return this.anchor;
        }

        public final int getControlCaretPosition() {
            return this.accessor.getCaret();
        }

        public final int getControlAnchor() {
            return this.accessor.getAnchor();
        }

        public final void selectRange(int newAnchor, int newCaretPosition) {
            if (newAnchor < 0 || newAnchor > this.accessor.getTextLength() - (this.end - this.start) + this.text.length() || newCaretPosition < 0 || newCaretPosition > this.accessor.getTextLength() - (this.end - this.start) + this.text.length()) {
                throw new IndexOutOfBoundsException();
            }
            this.anchor = newAnchor;
            this.caret = newCaretPosition;
        }

        public final IndexRange getSelection() {
            return IndexRange.normalize(this.anchor, this.caret);
        }

        public final void setAnchor(int newAnchor) {
            if (newAnchor < 0 || newAnchor > this.accessor.getTextLength() - (this.end - this.start) + this.text.length()) {
                throw new IndexOutOfBoundsException();
            }
            this.anchor = newAnchor;
        }

        public final void setCaretPosition(int newCaretPosition) {
            if (newCaretPosition < 0 || newCaretPosition > this.accessor.getTextLength() - (this.end - this.start) + this.text.length()) {
                throw new IndexOutOfBoundsException();
            }
            this.caret = newCaretPosition;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.text = value;
        }

        public final String getControlText() {
            return this.accessor.getText(0, this.accessor.getTextLength());
        }

        public final String getControlNewText() {
            return this.accessor.getText(0, this.start) + this.text + this.accessor.getText(this.end, this.accessor.getTextLength());
        }

        public final boolean isAdded() {
            return !this.text.isEmpty();
        }

        public final boolean isDeleted() {
            return this.start != this.end;
        }

        public final boolean isReplaced() {
            return this.isAdded() && this.isDeleted();
        }

        public final boolean isContentChange() {
            return this.isAdded() || this.isDeleted();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TextInputControl.Change [");
            if (this.isReplaced()) {
                builder.append(" replaced \"").append(this.accessor.getText(this.start, this.end)).append("\" with \"").append(this.text).append("\" at (").append(this.start).append(", ").append(this.end).append(")");
            } else if (this.isDeleted()) {
                builder.append(" deleted \"").append(this.accessor.getText(this.start, this.end)).append("\" at (").append(this.start).append(", ").append(this.end).append(")");
            } else if (this.isAdded()) {
                builder.append(" added \"").append(this.text).append("\" at ").append(this.start);
            }
            if (this.isAdded() || this.isDeleted()) {
                builder.append("; ");
            } else {
                builder.append(" ");
            }
            builder.append("new selection (anchor, caret): [").append(this.anchor).append(", ").append(this.caret).append("]");
            builder.append(" ]");
            return builder.toString();
        }

        public Change clone() {
            try {
                return (Change)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

