/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.NumberExpressionBase;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class LongExpression
extends NumberExpressionBase
implements ObservableLongValue {
    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public Long getValue() {
        return this.get();
    }

    public static LongExpression longExpression(final ObservableLongValue value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof LongExpression ? (LongExpression)value : new LongBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected long computeValue() {
                return value.get();
            }

            @Override
            public ObservableList<ObservableLongValue> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public static <T extends Number> LongExpression longExpression(final ObservableValue<T> value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof LongExpression ? (LongExpression)value : new LongBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected long computeValue() {
                Number val = (Number)value.getValue();
                return val == null ? 0L : val.longValue();
            }

            @Override
            public ObservableList<ObservableValue<T>> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    @Override
    public LongBinding negate() {
        return (LongBinding)Bindings.negate(this);
    }

    @Override
    public DoubleBinding add(double other) {
        return Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding add(float other) {
        return (FloatBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding add(long other) {
        return (LongBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding add(int other) {
        return (LongBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(double other) {
        return Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding subtract(float other) {
        return (FloatBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding subtract(long other) {
        return (LongBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding subtract(int other) {
        return (LongBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(double other) {
        return Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding multiply(float other) {
        return (FloatBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding multiply(long other) {
        return (LongBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding multiply(int other) {
        return (LongBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(double other) {
        return Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding divide(float other) {
        return (FloatBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding divide(long other) {
        return (LongBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public LongBinding divide(int other) {
        return (LongBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    public ObjectExpression<Long> asObject() {
        return new ObjectBinding<Long>(){
            {
                this.bind(LongExpression.this);
            }

            @Override
            public void dispose() {
                this.unbind(LongExpression.this);
            }

            @Override
            protected Long computeValue() {
                return LongExpression.this.getValue();
            }
        };
    }
}

