/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import javafx.animation.Transition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.util.Duration;

public final class FadeTransition
extends Transition {
    private static final double EPSILON = 1.0E-12;
    private double start;
    private double delta;
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private Node cachedNode;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis(400.0);
    private DoubleProperty fromValue;
    private static final double DEFAULT_FROM_VALUE = Double.NaN;
    private DoubleProperty toValue;
    private static final double DEFAULT_TO_VALUE = Double.NaN;
    private DoubleProperty byValue;
    private static final double DEFAULT_BY_VALUE = 0.0;

    public final void setNode(Node value) {
        if (this.node != null || value != null) {
            this.nodeProperty().set(value);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    public final void setDuration(Duration value) {
        if (this.duration != null || !DEFAULT_DURATION.equals(value)) {
            this.durationProperty().set(value);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                @Override
                public void invalidated() {
                    try {
                        FadeTransition.this.setCycleDuration(FadeTransition.this.getDuration());
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(FadeTransition.this.getCycleDuration());
                        throw e;
                    }
                }

                @Override
                public Object getBean() {
                    return FadeTransition.this;
                }

                @Override
                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public final void setFromValue(double value) {
        if (this.fromValue != null || !Double.isNaN(value)) {
            this.fromValueProperty().set(value);
        }
    }

    public final double getFromValue() {
        return this.fromValue == null ? Double.NaN : this.fromValue.get();
    }

    public final DoubleProperty fromValueProperty() {
        if (this.fromValue == null) {
            this.fromValue = new SimpleDoubleProperty(this, "fromValue", Double.NaN);
        }
        return this.fromValue;
    }

    public final void setToValue(double value) {
        if (this.toValue != null || !Double.isNaN(value)) {
            this.toValueProperty().set(value);
        }
    }

    public final double getToValue() {
        return this.toValue == null ? Double.NaN : this.toValue.get();
    }

    public final DoubleProperty toValueProperty() {
        if (this.toValue == null) {
            this.toValue = new SimpleDoubleProperty(this, "toValue", Double.NaN);
        }
        return this.toValue;
    }

    public final void setByValue(double value) {
        if (this.byValue != null || Math.abs(value - 0.0) > 1.0E-12) {
            this.byValueProperty().set(value);
        }
    }

    public final double getByValue() {
        return this.byValue == null ? 0.0 : this.byValue.get();
    }

    public final DoubleProperty byValueProperty() {
        if (this.byValue == null) {
            this.byValue = new SimpleDoubleProperty(this, "byValue", 0.0);
        }
        return this.byValue;
    }

    public FadeTransition(Duration duration, Node node) {
        this.setDuration(duration);
        this.setNode(node);
        this.setCycleDuration(duration);
    }

    public FadeTransition(Duration duration) {
        this(duration, null);
    }

    public FadeTransition() {
        this(DEFAULT_DURATION, null);
    }

    @Override
    protected void interpolate(double frac) {
        double newOpacity = Math.max(0.0, Math.min(this.start + frac * this.delta, 1.0));
        this.cachedNode.setOpacity(newOpacity);
    }

    private Node getTargetNode() {
        Node node = this.getNode();
        return node != null ? node : this.getParentTargetNode();
    }

    @Override
    boolean impl_startable(boolean forceSync) {
        return super.impl_startable(forceSync) && (this.getTargetNode() != null || !forceSync && this.cachedNode != null);
    }

    @Override
    void impl_sync(boolean forceSync) {
        super.impl_sync(forceSync);
        if (forceSync || this.cachedNode == null) {
            this.cachedNode = this.getTargetNode();
            double _fromValue = this.getFromValue();
            double _toValue = this.getToValue();
            this.start = !Double.isNaN(_fromValue) ? Math.max(0.0, Math.min(_fromValue, 1.0)) : this.cachedNode.getOpacity();
            double d = this.delta = !Double.isNaN(_toValue) ? _toValue - this.start : this.getByValue();
            if (this.start + this.delta > 1.0) {
                this.delta = 1.0 - this.start;
            } else if (this.start + this.delta < 0.0) {
                this.delta = -this.start;
            }
        }
    }
}

