/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.light.Light;

public class DistantLight
extends Light {
    private float azimuth;
    private float elevation;

    public DistantLight() {
        this(0.0f, 0.0f, Color4f.WHITE);
    }

    public DistantLight(float azimuth, float elevation, Color4f color) {
        super(Light.Type.DISTANT, color);
        this.azimuth = azimuth;
        this.elevation = elevation;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(float azimuth) {
        this.azimuth = azimuth;
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float elevation) {
        this.elevation = elevation;
    }

    @Override
    public float[] getNormalizedLightPosition() {
        float z;
        float y;
        double a = Math.toRadians(this.azimuth);
        double e = Math.toRadians(this.elevation);
        float x = (float)(Math.cos(a) * Math.cos(e));
        float len = (float)Math.sqrt(x * x + (y = (float)(Math.sin(a) * Math.cos(e))) * y + (z = (float)Math.sin(e)) * z);
        if (len == 0.0f) {
            len = 1.0f;
        }
        float[] pos = new float[]{x / len, y / len, z / len};
        return pos;
    }
}

