/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DGraphics;
import com.sun.prism.d3d.D3DRenderTarget;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.d3d.D3DTexture;
import com.sun.prism.d3d.D3DTextureData;
import com.sun.prism.d3d.D3DTextureResource;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class D3DRTTexture
extends D3DTexture
implements D3DRenderTarget,
RTTexture,
ReadbackRenderTarget {
    private boolean opaque = false;

    D3DRTTexture(D3DContext context, Texture.WrapMode wrapMode, long pResource, int physicalWidth, int physicalHeight, int contentWidth, int contentHeight) {
        super(context, PixelFormat.INT_ARGB_PRE, wrapMode, pResource, physicalWidth, physicalHeight, contentWidth, contentHeight, true);
    }

    D3DRTTexture(D3DContext context, Texture.WrapMode wrapMode, long pResource, int physicalWidth, int physicalHeight, int contentX, int contentY, int contentWidth, int contentHeight, int samples) {
        super(context, PixelFormat.INT_ARGB_PRE, wrapMode, pResource, physicalWidth, physicalHeight, contentX, contentY, contentWidth, contentHeight, true, samples, false);
    }

    @Override
    public Texture getBackBuffer() {
        return this;
    }

    @Override
    public long getResourceHandle() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getResource();
    }

    @Override
    public Graphics createGraphics() {
        return D3DGraphics.create(this, this.getContext());
    }

    @Override
    public int[] getPixels() {
        return null;
    }

    @Override
    public boolean readPixels(Buffer pixels, int x, int y, int width, int height) {
        if (x != this.getContentX() || y != this.getContentY() || width != this.getContentWidth() || height != this.getContentHeight()) {
            throw new IllegalArgumentException("reading subtexture not yet supported!");
        }
        return this.readPixels(pixels);
    }

    @Override
    public boolean readPixels(Buffer pixels) {
        this.getContext().flushVertexBuffer();
        long ctx = this.getContext().getContextHandle();
        int res = 0;
        if (pixels instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)pixels;
            byte[] arr = buf.hasArray() ? buf.array() : null;
            long length = buf.capacity();
            res = D3DResourceFactory.nReadPixelsB(ctx, this.getNativeSourceHandle(), length, pixels, arr, this.getContentWidth(), this.getContentHeight());
        } else if (pixels instanceof IntBuffer) {
            IntBuffer buf = (IntBuffer)pixels;
            int[] arr = buf.hasArray() ? buf.array() : null;
            long length = buf.capacity() * 4;
            res = D3DResourceFactory.nReadPixelsI(ctx, this.getNativeSourceHandle(), length, pixels, arr, this.getContentWidth(), this.getContentHeight());
        } else {
            throw new IllegalArgumentException("Buffer of this type is not supported: " + pixels);
        }
        return this.getContext().validatePresent(res);
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.getContext().getAssociatedScreen();
    }

    @Override
    public void update(Image img) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image img, int dstx, int dsty) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image img, int dstx, int dsty, int w, int h) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image img, int dstx, int dsty, int w, int h, boolean skipFlush) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer pixels, PixelFormat format, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan, boolean skipFlush) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.opaque = isOpaque;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public boolean isVolatile() {
        return this.getContext().isRTTVolatile();
    }

    @Override
    public boolean isMSAA() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getSamples() != 0;
    }
}

