/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.jmx;

import com.sun.javafx.util.Logging;

public abstract class MXExtension {
    private static final String EXTENSION_CLASS_NAME = System.getProperty("javafx.debug.jmx.class", "com.oracle.javafx.jmx.MXExtensionImpl");

    public abstract void intialize() throws Exception;

    public static void initializeIfAvailable() {
        try {
            ClassLoader loader = MXExtension.class.getClassLoader();
            Class<?> mxExtensionClass = Class.forName(EXTENSION_CLASS_NAME, false, loader);
            if (!MXExtension.class.isAssignableFrom(mxExtensionClass)) {
                throw new IllegalArgumentException("Unrecognized MXExtension class: " + EXTENSION_CLASS_NAME);
            }
            MXExtension mxExtension = (MXExtension)mxExtensionClass.newInstance();
            mxExtension.intialize();
        }
        catch (Exception e) {
            Logging.getJavaFXLogger().info("Failed to initialize management extension", e);
        }
    }
}

