/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismMetrics;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.text.GlyphList;
import java.util.HashMap;
import java.util.Map;

public abstract class PrismFontStrike<T extends PrismFontFile>
implements FontStrike {
    private DisposerRecord disposer;
    private T fontResource;
    private Map<Integer, Glyph> glyphMap = new HashMap<Integer, Glyph>();
    private PrismMetrics metrics;
    protected boolean drawShapes = false;
    private float size;
    private BaseTransform transform;
    private int aaMode;
    private FontStrikeDesc desc;
    private int hash;

    protected PrismFontStrike(T fontResource, float size, BaseTransform tx, int aaMode, FontStrikeDesc desc) {
        this.fontResource = fontResource;
        this.size = size;
        this.desc = desc;
        PrismFontFactory factory = PrismFontFactory.getFontFactory();
        boolean lcdEnabled = factory.isLCDTextSupported();
        this.aaMode = lcdEnabled ? aaMode : 0;
        this.transform = tx.isTranslateOrIdentity() ? BaseTransform.IDENTITY_TRANSFORM : new Affine2D(tx.getMxx(), tx.getMyx(), tx.getMxy(), tx.getMyy(), 0.0, 0.0);
    }

    DisposerRecord getDisposer() {
        if (this.disposer == null) {
            this.disposer = this.createDisposer(this.desc);
        }
        return this.disposer;
    }

    protected abstract DisposerRecord createDisposer(FontStrikeDesc var1);

    @Override
    public synchronized void clearDesc() {
        ((PrismFontFile)this.fontResource).getStrikeMap().remove(this.desc);
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public Metrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = ((PrismFontFile)this.fontResource).getFontMetrics(this.size);
        }
        return this.metrics;
    }

    public T getFontResource() {
        return this.fontResource;
    }

    @Override
    public boolean drawAsShapes() {
        return this.drawShapes;
    }

    @Override
    public int getAAMode() {
        return this.aaMode;
    }

    @Override
    public BaseTransform getTransform() {
        return this.transform;
    }

    @Override
    public int getQuantizedPosition(Point2D point) {
        point.x = this.aaMode == 0 ? (float)Math.round(point.x) : (float)Math.round(3.0 * (double)point.x) / 3.0f;
        point.y = Math.round(point.y);
        return 0;
    }

    @Override
    public float getCharAdvance(char ch) {
        int glyphCode = ((PrismFontFile)this.fontResource).getGlyphMapper().charToGlyph((int)ch);
        return ((PrismFontFile)this.fontResource).getAdvance(glyphCode, this.size);
    }

    @Override
    public Glyph getGlyph(char ch) {
        int glyphCode = ((PrismFontFile)this.fontResource).getGlyphMapper().charToGlyph((int)ch);
        return this.getGlyph(glyphCode);
    }

    protected abstract Glyph createGlyph(int var1);

    @Override
    public Glyph getGlyph(int glyphCode) {
        Glyph glyph = this.glyphMap.get(glyphCode);
        if (glyph == null) {
            glyph = this.createGlyph(glyphCode);
            this.glyphMap.put(glyphCode, glyph);
        }
        return glyph;
    }

    protected abstract Path2D createGlyphOutline(int var1);

    @Override
    public Shape getOutline(GlyphList gl, BaseTransform transform) {
        Path2D result = new Path2D();
        this.getOutline(gl, transform, result);
        return result;
    }

    void getOutline(GlyphList gl, BaseTransform transform, Path2D p) {
        p.reset();
        if (gl == null) {
            return;
        }
        if (transform == null) {
            transform = BaseTransform.IDENTITY_TRANSFORM;
        }
        Affine2D t = new Affine2D();
        for (int i = 0; i < gl.getGlyphCount(); ++i) {
            Path2D gp;
            int glyphCode = gl.getGlyphCode(i);
            if (glyphCode == 65535 || (gp = this.createGlyphOutline(glyphCode)) == null) continue;
            t.setTransform(transform);
            t.translate(gl.getPosX(i), gl.getPosY(i));
            p.append(((Shape)gp).getPathIterator(t), false);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrismFontStrike)) {
            return false;
        }
        PrismFontStrike other = (PrismFontStrike)obj;
        return this.size == other.size && this.transform.getMxx() == other.transform.getMxx() && this.transform.getMxy() == other.transform.getMxy() && this.transform.getMyx() == other.transform.getMyx() && this.transform.getMyy() == other.transform.getMyy() && ((PrismFontFile)this.fontResource).equals(other.fontResource);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = Float.floatToIntBits(this.size) + Float.floatToIntBits((float)this.transform.getMxx()) + Float.floatToIntBits((float)this.transform.getMyx()) + Float.floatToIntBits((float)this.transform.getMxy()) + Float.floatToIntBits((float)this.transform.getMyy());
        this.hash = 71 * this.hash + ((PrismFontFile)this.fontResource).hashCode();
        return this.hash;
    }

    public String toString() {
        return "FontStrike: " + super.toString() + " font resource = " + this.fontResource + " size = " + this.size + " matrix = " + this.transform;
    }
}

