/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrPosef")
public class OVRPosef
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIENTATION;
    public static final int POSITION;

    public OVRPosef(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRPosef.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrQuatf")
    public OVRQuatf Orientation() {
        return OVRPosef.nOrientation(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f Position() {
        return OVRPosef.nPosition(this.address());
    }

    public OVRPosef Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
        OVRPosef.nOrientation(this.address(), value);
        return this;
    }

    public OVRPosef Orientation(Consumer<OVRQuatf> consumer) {
        consumer.accept(this.Orientation());
        return this;
    }

    public OVRPosef Position(@NativeType(value="ovrVector3f") OVRVector3f value) {
        OVRPosef.nPosition(this.address(), value);
        return this;
    }

    public OVRPosef Position(Consumer<OVRVector3f> consumer) {
        consumer.accept(this.Position());
        return this;
    }

    public OVRPosef set(OVRQuatf Orientation, OVRVector3f Position) {
        this.Orientation(Orientation);
        this.Position(Position);
        return this;
    }

    public OVRPosef set(OVRPosef src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRPosef malloc() {
        return (OVRPosef)OVRPosef.wrap(OVRPosef.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRPosef calloc() {
        return (OVRPosef)OVRPosef.wrap(OVRPosef.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRPosef create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRPosef)OVRPosef.wrap(OVRPosef.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRPosef create(long address) {
        return (OVRPosef)OVRPosef.wrap(OVRPosef.class, (long)address);
    }

    @Nullable
    public static OVRPosef createSafe(long address) {
        return address == 0L ? null : (OVRPosef)OVRPosef.wrap(OVRPosef.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRPosef.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRPosef.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRPosef.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRPosef.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRPosef.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRPosef.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRPosef.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRPosef mallocStack() {
        return OVRPosef.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRPosef callocStack() {
        return OVRPosef.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRPosef mallocStack(MemoryStack stack) {
        return OVRPosef.malloc(stack);
    }

    @Deprecated
    public static OVRPosef callocStack(MemoryStack stack) {
        return OVRPosef.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRPosef.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRPosef.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRPosef.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRPosef.calloc(capacity, stack);
    }

    public static OVRPosef malloc(MemoryStack stack) {
        return (OVRPosef)OVRPosef.wrap(OVRPosef.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRPosef calloc(MemoryStack stack) {
        return (OVRPosef)OVRPosef.wrap(OVRPosef.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRPosef.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRPosef.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static OVRQuatf nOrientation(long struct) {
        return OVRQuatf.create(struct + (long)ORIENTATION);
    }

    public static OVRVector3f nPosition(long struct) {
        return OVRVector3f.create(struct + (long)POSITION);
    }

    public static void nOrientation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ORIENTATION), (long)OVRQuatf.SIZEOF);
    }

    public static void nPosition(long struct, OVRVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSITION), (long)OVRVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRPosef.__struct((Struct.Member[])new Struct.Member[]{OVRPosef.__member((int)OVRQuatf.SIZEOF, (int)OVRQuatf.ALIGNOF), OVRPosef.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIENTATION = layout.offsetof(0);
        POSITION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRPosef, Buffer>
    implements NativeResource {
        private static final OVRPosef ELEMENT_FACTORY = OVRPosef.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRPosef getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrQuatf")
        public OVRQuatf Orientation() {
            return OVRPosef.nOrientation(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f Position() {
            return OVRPosef.nPosition(this.address());
        }

        public Buffer Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
            OVRPosef.nOrientation(this.address(), value);
            return this;
        }

        public Buffer Orientation(Consumer<OVRQuatf> consumer) {
            consumer.accept(this.Orientation());
            return this;
        }

        public Buffer Position(@NativeType(value="ovrVector3f") OVRVector3f value) {
            OVRPosef.nPosition(this.address(), value);
            return this;
        }

        public Buffer Position(Consumer<OVRVector3f> consumer) {
            consumer.accept(this.Position());
            return this;
        }
    }
}

