package dangerzone.threads;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.ServerHooker;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Flag;
import dangerzone.world.Swarm;


public class ServerEntityUpdateLoop  implements Runnable   {
	

	//public  List<ListInt> entity_list; 	// a list of little things that index into
	public  List<Integer> entity_list; 
	public  List<Integer> entity_free_list; 	// a list of little things that index into
	public volatile Entity entities[];           // an array of big things that we don't want Java to copy!
	public  Lock entity_list_lock = new ReentrantLock();
	public long upticker = 1;
	public int active_entities;

	public void run()  {
		long lasttime = System.currentTimeMillis();
		long currtime, tlong;
		long loop_interval = DangerZone.serverentityupdaterate; //millisecs
		float deltaT;
		int inext = 0;
		Entity ent;
		int j;
		int ent_counter;
		//boolean doprint = false;
		
		entity_list_lock.lock();
		entities = new Entity[DangerZone.max_entities];
		entity_list = new ArrayList<Integer>();
		entity_free_list = new ArrayList<Integer>();
		//make a free list
		for(j=1;j<DangerZone.max_entities;j++){ //zero is not valid!
			entity_free_list.add(j);
		}
		entity_list_lock.unlock();
		
		while(true){
			if(DangerZone.gameover != 0)break;
			
			currtime = System.currentTimeMillis();
			tlong = currtime - lasttime;
			tlong = loop_interval - tlong;
			if(tlong < 0)tlong = 0;
			if(tlong > loop_interval)tlong = loop_interval;
			if(tlong > 0){
				try {
					//System.out.printf("tlong = %d\n",  (int)tlong);
					Thread.sleep(tlong);
				} catch (InterruptedException ex) {
					// TODO Auto-generated catch block
					ex.printStackTrace();
					System.exit(1);
				}
				currtime = System.currentTimeMillis();
			}
			tlong = currtime - lasttime;
			lasttime = currtime;
			deltaT = tlong;
			//System.out.printf("DeltaT = %f\n", deltaT/100f);
			if(deltaT < 100)deltaT = 100;
			if(deltaT > 500)deltaT = 500;
			deltaT = deltaT / loop_interval; //Scale!
			
			if(DangerZone.gameover != 0)break; //this is the important one!
			
			if(DangerZone.start_client){
				int tmp = DangerZone.renderdistance; //chunks
				tmp += 4;
				if(tmp > 24)tmp = 24;
				DangerZone.entityupdatedist = tmp * 16; //blocks
			}
			
			inext = 0;
			ent_counter = 0;
			
			if(DangerZone.f12_on){
				DangerZone.server.flushAll(); //flush out any stray updates!
				continue; //PAUSED
			}
			
			//Oh yeah... swarm time! I hope...
			Swarm.doSpawnSwarm();
			
			ServerHooker.entity_loop_start(deltaT);
			
			for(int i=0;i<DangerZone.server.max_players;i++){
				if(DangerZone.server.players[i] != null){
					if(DangerZone.server.players[i].p != null){
						ServerHooker.player_entity_loop_start(DangerZone.server.players[i].p);
					}
				}
			}
			
			
			for(inext = 0;inext < DangerZone.max_entities;inext++){
			
				ent = entities[inext];
				if(ent != null){
					if(ent.deadflag){
						//if(ent.uniquename.equals("OreSpawn:EasterBunny")) {
						//	System.out.printf("Dead Easter Bunny at %d, %d\n", (int)ent.posx, (int)ent.posz);
						//}
						removeEntityByID(inext);
						DangerZone.server.sendEntityRemoveToAll(inext);
						continue;
					}
				}
				
				//Inactive Entities are marked for removal from the list by the CHUNK save logic.
				if(ent != null){
					//if(DangerZone.start_client && doprint)System.out.printf("Entity %s,  dist %f\n", ent.uniquename, ent.getHorizontalDistanceFromEntity(DangerZone.player));
					if(DangerZone.server.isPlayerCloseInDimension(ent)){
						if(ent.access_lock.tryLock()) { //lock for saving to chunk in a coherent state
							ServerHooker.entity_action(ent, deltaT);
							ent.doEntityAction(deltaT);
							ent.doEntityCollisions(deltaT);
							ent.update(deltaT);
							ent_counter++;
							ent.access_lock.unlock();
						}
						
					}else{
						if(!DangerZone.server_chunk_cache.DecoratedChunkExists(ent.dimension, (int)ent.posx, 100, (int)ent.posz)){
							//System.out.printf("stray entity needs saving: %s @ %f, %f\n", ent.uniquename, ent.posx, ent.posz);
							//let the chunkwriter READ the chunk... the cleaner thread will eventually save it along with the entity...
							//if(ent.uniquename.equals("OreSpawn:EasterBunny")) {
							//	System.out.printf("Orphaned Easter Bunny at %d, %d\n", (int)ent.posx, (int)ent.posz);
							//}
							DangerZone.chunkwriter.addEntity(inext);
						}
					}
					if(ent instanceof Player){
						ent.stray_entity_ticker++; //player timeout in case server thread doesn't detect disconnect
						if(ent.stray_entity_ticker > 300){ //30 seconds is more than enough!
							Player plyr = (Player)ent;
							plyr.server_thread.fatal_error = 1;
							plyr.deadflag = true;
							removeEntityByID(inext);
							DangerZone.server.removeMe(plyr.server_thread);
							DangerZone.server.sendEntityRemoveToAllExcept(plyr, inext);
						}
					}
				}

			}
			active_entities = ent_counter;
			DangerZone.server.flushAll(); //flush out any stray updates!
			upticker++;
		}
		
		//System.out.printf("ServerEntityUpdateLoop flushing orphaned entities.\n");
		for(inext = 0;inext < DangerZone.max_entities;inext++){			
			ent = entities[inext];
			if(ent != null){
				if(!ent.deadflag){
					if(!DangerZone.server_chunk_cache.DecoratedChunkExists(ent.dimension, (int)ent.posx, 100, (int)ent.posz)){
						//System.out.printf("stray entity needs saving: %s @ %f, %f\n", ent.uniquename, ent.posx, ent.posz);
						//let the chunkwriter READ the chunk... the cleaner thread will eventually save it along with the entity...
						//if(ent.uniquename.equals("OreSpawn:EasterBunny")) {
						//	System.out.printf("Shutdown found Orphaned Easter Bunny at %d, %d\n", (int)ent.posx, (int)ent.posz);
						//}
						DangerZone.chunkwriter.addEntity(inext);
					}
				}
			}
		}
		
		//all the entities should now be safe.
		System.out.printf("ServerEntityUpdateLoop exit.\n");
	}
	
	private int find_entity_slot(){
		int retval = -1;
		if(DangerZone.graphics_mode < 0 && entity_free_list.size() < (DangerZone.max_entities/2))return retval; //Throttled!
		if(entity_free_list.size() > 0){
			retval = entity_free_list.get(0);
			entity_free_list.remove(0);			
/*			
			Iterator<Integer> ii = entity_free_list.iterator();
			int st;
			while(ii.hasNext()) {
				st = ii.next();
				if(st == retval) {
					System.out.printf("FATAL! $d is on list more than once!\n", st);
				}
			}
*/						
		}
		return retval;
	}
	
	public int addEntity(Entity e){
		int i;
		entity_list_lock.lock(); 
		i = find_entity_slot();
		if(i <= 0){
			e.entityID = -1;
			entity_list_lock.unlock();
			return -1;
		}		
		e.entityID = i;
		entities[i] = e;
		entity_list.add(i);			
		entity_list_lock.unlock();
		return i;
	}
	
	
	public List<Integer> getEntitiesInChunk(int dim, int cx, int cz){
		entity_list_lock.lock();
		List<Integer> retlist = null;
		Iterator<Integer> ii = entity_list.iterator();
		int st;
		
		while(ii.hasNext()){
			st = ii.next();
			if(entities[st] != null && entities[st].dimension == dim && ((int)entities[st].posx)>>4 == cx && ((int)entities[st].posz)>>4 == cz){
				if(retlist == null) {
					retlist = new ArrayList<Integer>();
				}
				retlist.add(st);
			}
		}		
		entity_list_lock.unlock();

		return retlist;
	}
	
	public boolean areEntitiesInChunk(int dim, int cx, int cz){
		entity_list_lock.lock();
		Iterator<Integer> ii = entity_list.iterator();
		int st;
		while(ii.hasNext()){
			st = ii.next();
			if(entities[st] != null && entities[st].dimension == dim && ((int)entities[st].posx)>>4 == cx && ((int)entities[st].posz)>>4 == cz){
				entity_list_lock.unlock();
				return true;
			}
		}		
		entity_list_lock.unlock();
		return false;
	}
	
	public Entity findEntityByID(int eid){
		if(eid <= 0)return null;
		if(eid >= DangerZone.max_entities)return null;
		return entities[eid];
	}
	
	public Entity findPlayerByName(String playername){
		if(playername == null)return null;
		Entity ent = null;
		entity_list_lock.lock();
		Iterator<Integer> ii = entity_list.iterator();
		int st;
		while(ii.hasNext()){
			st = ii.next();
			if(entities[st] != null && entities[st] instanceof Player){
				Player p = (Player)entities[st];
				if(p.myname.toLowerCase().equals(playername.toLowerCase())){
					ent = entities[st];
					break;
				}
			}
		}		
		entity_list_lock.unlock();
		return ent;
	}
	
	public void removeEntityByID(int eid){
		entity_list_lock.lock();
		Iterator<Integer> ii = entity_list.iterator();
		int st;
		while(ii.hasNext()){
			st = ii.next();
			if(st == eid) {
				if(entities[st] != null){
					//entities[st].entityID = -1; no can't do this! is used to send notifications!
					if(!entities[st].deadflag && !entities[st].has_been_saved) {
						System.out.printf("Ent %d : %s is not saved yet, not removing\n", st, entities[st].uniquename);
						DangerZone.chunkwriter.addEntity(st); //add back to the list!
						break;
					}
					entities[st] = null;
					entity_free_list.add(st);
				}
				ii.remove();
				break;
			}
		}		
		entity_list_lock.unlock();
	}
	
	//Finds EntityLiving entities within range
	public List<Entity> findEntitiesInRange(float range, int dim, double x, double y, double z){
		entity_list_lock.lock();
		List<Entity> retlist = new ArrayList<Entity>();
		Iterator<Integer> ii = entity_list.iterator();
		int st;
		double dx, dy, dz;
		while(ii.hasNext()){
			st = ii.next();
			if(entities[st] != null && entities[st].dimension == dim){
				dx = x - entities[st].posx;
				dy = y - entities[st].posy;
				dz = z - entities[st].posz;
				dx = Math.sqrt((dx*dx)+(dy*dy)+(dz*dz));
				//Flags attract all hostiles in dimension.
				if((dx < range && entities[st] instanceof EntityLiving)||(entities[st] instanceof Flag)){
					retlist.add(entities[st]);
				}
			}
		}		
		entity_list_lock.unlock();

		return retlist;
	}
	
	//Finds EntityLiving entities within range
		public List<Integer> findEntitiesInRangei(float range, int dim, double x, double y, double z){
			entity_list_lock.lock();
			List<Integer> retlist = new ArrayList<Integer>();
			Iterator<Integer> ii = entity_list.iterator();
			int st;
			double dx, dy, dz;
			while(ii.hasNext()){
				st = ii.next();
				if(entities[st] != null && entities[st].dimension == dim){
					dx = x - entities[st].posx;
					dy = y - entities[st].posy;
					dz = z - entities[st].posz;
					dx = Math.sqrt((dx*dx)+(dy*dy)+(dz*dz));
					//Flags attract all hostiles in dimension.
					if((dx < range && entities[st] instanceof EntityLiving)||(entities[st] instanceof Flag)){
						retlist.add(st);
					}
				}
			}		
			entity_list_lock.unlock();

			return retlist;
		}
	
	//Finds ALL kinds of entities in range
	public List<Entity> findALLEntitiesInRange(float range, int dim, double x, double y, double z){
		entity_list_lock.lock();
		List<Entity> retlist = new ArrayList<Entity>();
		Iterator<Integer> ii = entity_list.iterator();
		int st;
		double dx, dy, dz;
		while(ii.hasNext()){
			st = ii.next();
			if(entities[st] != null && entities[st].dimension == dim){
				dx = x - entities[st].posx;
				dy = y - entities[st].posy;
				dz = z - entities[st].posz;
				dx = Math.sqrt((dx*dx)+(dy*dy)+(dz*dz));
				if(dx < range){
					retlist.add(entities[st]);
				}
			}
		}		
		entity_list_lock.unlock();

		return retlist;
	}

}
