package dangerzone.threads;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import dangerzone.Coords;
import dangerzone.DangerZone;
import dangerzone.blocks.Blocks;
import dangerzone.world.Chunk;
import dangerzone.world.World;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

//TODO FIXME - run on server to have proper light maps there too! (spawning at night near torches, etc)

public class LightingThread implements Runnable {
	public int tickmax = 14;
	public List<Coords> requested_list; //Don't blast server with same request over and over and over again!
	public Lock requested_list_lock = new ReentrantLock();
	int me;
	
	public LightingThread(int whichami){
		requested_list = new ArrayList<Coords>();
		me = whichami;
	}

	public void run() {
		int i, j;
		long sleeper;
		int currentdimension;
		boolean restart = false;
		int ix, iz;
		double px;
		double pz;	
		int pd;
		
		//Let things settle down a little first...
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		Thread thisthread = Thread.currentThread();
		thisthread.setPriority(Thread.MIN_PRIORITY);
		
		currentdimension = DangerZone.player.dimension;

		while(DangerZone.gameover == 0){
			tickmax = DangerZone.renderdistance;
			
			while(me != 0 && DangerZone.graphics_mode < 3) { //not in ultra mode				
				if(DangerZone.graphics_mode == 2 && me < 2)break; //Great mode gets two threads
				try {
					Thread.sleep(1000); //give it a rest! :)
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
			while(DangerZone.graphics_mode < 0) { //no lighting
				try {
					Thread.sleep(1000); //give it a rest! :)
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			
			//this and cleaner thread loop through in reverse to hopefully de-sync with everything else.
			for(i=tickmax;i>=-tickmax && DangerZone.gameover == 0 && !restart;i--){
				for(j=tickmax;j>=-tickmax && DangerZone.gameover == 0 && !restart;j--){ 
					px = DangerZone.player.posx;
					pz = DangerZone.player.posz;	
					pd = DangerZone.player.dimension;

					if(DangerZone.graphics_mode == 3) {
						ix = (i*16)+(int)px;					
						iz = (j*16)+(int)pz;					
						if((((ix>>4)+(iz>>4))%4) != me)continue; //split 4 ways
					}
					if(DangerZone.graphics_mode == 2) {
						ix = (i*16)+(int)px;					
						iz = (j*16)+(int)pz;					
						if((((ix>>4)+(iz>>4))&0x01) != me)continue; //split 2 ways
					}
					 
					if((int)Math.sqrt((i*i)+(j*j))>tickmax)continue; //Too far
										
					if(!DangerZone.f12_on)tickChunk(DangerZone.world, i, j, px, pz, pd);
					if(currentdimension != DangerZone.player.dimension){
						currentdimension = DangerZone.player.dimension;
						restart = true;
					}
					
					try {
						sleeper = 4;
						sleeper += ((24 - tickmax))/2;
						if(DangerZone.wr.fps < 40)sleeper += 16;
						if(DangerZone.wr.fps < 20)sleeper += 16;
						if(DangerZone.showcase || (DangerZone.graphics_mode < 2))sleeper += 32;
						if(!DangerZone.showcase && DangerZone.graphics_mode == 3)sleeper = 1;
						Thread.sleep(sleeper); //give it a rest! :)
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					if(DangerZone.gameover != 0)return;
					//process the request list!
					Coords cl = null;
					
					while(true){
						requested_list_lock.lock();		
						Iterator<Coords> ii = requested_list.iterator();
						cl = null;
						if(ii.hasNext()){
							cl = (Coords)ii.next();						
							//Remove it!
							ii.remove();
						}
						requested_list_lock.unlock();
						if(cl != null){
							updateLightMaps(DangerZone.world, cl.lv, cl.d, cl.x, cl.y, cl.z);
							Thread.yield();
						}else{
							break;
						}
					}
				}
			}
			
			//try {
			//	Thread.sleep(2); //give it a rest! :)
			//} catch (InterruptedException e) {
			//	e.printStackTrace();
			//}
			if(DangerZone.gameover != 0)return;
			
			if(restart){
				restart = false;
				//Let things settle down a little first...
				//clean up the list while we wait
				requested_list_lock.lock();		
				Iterator<Coords> ii = requested_list.iterator();
				while(ii.hasNext()){					
					//Remove it!
					ii.remove();
				}				
				requested_list_lock.unlock();
				try {
					Thread.sleep(2000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	
	public void tickChunk(World w, int xrel, int zrel, double px, double pz, int pd){
		int i, j, k, m, bid;
		short leveldata[] = null;
		float lightmap[] = null;
		float currentlight;
		short drawn[] = null;
		int iup, idown;
		//boolean active = false;
		
		if(!w.chunkcache.DecoratedChunkExists(pd, (xrel<<4)+(int)px, 0, (zrel<<4)+(int)pz))return;
		
		Chunk c = w.chunkcache.getDecoratedChunk(pd, (xrel<<4)+(int)px, 0, (zrel<<4)+(int)pz);
		if(c == null)return;
		drawn = c.drawn;
		if(drawn == null)return;

		//System.out.printf("Tick chunk at %d,  %d\n", c.chunkX, c.chunkZ);
		//Dimmer pass
		for(j=0;j<256;j++){	
			lightmap = w.chunkcache.getDecoratedChunkLightmap(pd, (c.chunkX<<4), j, (c.chunkZ<<4));			
			if(lightmap != null){
				for(i=0;i<16;i++){
					for(k=0;k<16;k++){
						m = (i*16)+k;
						lightmap[m] *= 0.95f;	
					}
				}
				//We no longer bother attempting to clear and free zero'd lightmaps.
				//It just isn't that much extra space. 
				//They will get freed when the chunks gets flushed out of cache.
				//Caused problems when lighting threads crossed chunks and got nulled maps unexpectedly.
				//Don't want to slow it all to a crawl by locking every access.
			}
		}
		
		//Now we go do updates for lighted blocks
		for(j=0;j<256;j++){	
			/*
			 * Quick check to see if anything was drawn around here.
			 * No sense making maps for ores that no one is anywhere near!
			 */
			iup = j+1;
			if(iup > 255)iup = 255;
			idown = j-1;
			if(idown < 0)idown = 0;
			if(drawn != null && drawn[j] == 0 && drawn[iup] == 0 && drawn[idown] == 0){
				continue;
			}
			
			//update for new/existing lights
			leveldata = c.blockdata[j];			
			if(leveldata == null){
				continue; //no sense trying if no data!
			}
			for(i=0;i<16;i++){
				for(k=0;k<16;k++){
					bid = leveldata[i*16+k];
					if(bid != 0){
						//currentlight = Blocks.getLightLevel(bid, w, p.dimension, (c.chunkX<<4)+i, j, (c.chunkZ<<4)+k);
						currentlight = Blocks.BlockArray[bid].brightness;
						if(currentlight != 0.0f){
							//crap... have to update lighting around this thing...
							updateLightMaps(w, currentlight, pd, (c.chunkX<<4)+i, j, (c.chunkZ<<4)+k);
						}
					}
				}
			}
		}
	}
	
	public void updateLightMaps(World w, float lv, int d, int x, int y, int z){
		int updist = 11;
		float cval;
		float cdist;
		int i, j, k;
		float prev;
		float newv = 0;
		
		if(DangerZone.renderdistance <= 20)updist = 10;
		if(DangerZone.renderdistance <= 16)updist = 9;
		if(DangerZone.renderdistance <= 12)updist = 8;
		if(DangerZone.renderdistance < 10)updist = 7;
	
		//These loops can cross chunks!
		for(i=-updist;i<=updist;i++){
			for(k=-updist;k<=updist;k++){
				for(j=-updist;j<=updist;j++){ //up/down in middle so we stay in same chunk for a while longer
					if(y+j<0 || y+j>255)continue;
					cdist = (float) Math.sqrt((i*i)+(j*j)+(k*k));
					//cdist is now scaling factor... linear...				
					if(cdist < updist){
						cval = lv*(updist-cdist)/updist;
						prev = getLightMapValue(w, d, x+i, y+j, z+k);						
						if(prev>=0&&cval>0){
							newv = prev;
							if(cval > newv)newv = cval;
						}else if(prev<=0&&cval<0){
							newv = prev;
							if(cval < newv)newv = cval;
						}else{
							newv = prev + (cval*cval)*Math.signum(cval);
						}

						w.chunkcache.setDecoratedChunkLightValue(d, x+i, y+j, z+k, newv);
					}
				}
			}
		}		
	}
	
	public float getLightMapValue(World w, int d, int x, int y, int z){
		return w.chunkcache.getDecoratedChunkLightmapVal(d, x, y, z);
	}
	
	public void addRequest(int d, int x, int y, int z, float val){
		if(requested_list == null)return; //hasn't been started yet!
		if(DangerZone.graphics_mode < 0)return; //no lighting!
		
		requested_list_lock.lock();	
		
		if(requested_list.size() > 500){ //There is no reason for more! Let whatever it is (usually fire) retry...
			requested_list_lock.unlock();
			return;
		}
		
		Iterator<Coords> i = requested_list.iterator();
		while(i.hasNext()){
			Coords c = (Coords)i.next();
			if(c.d != d)continue;
			if(c.x != x)continue;
			if(c.z != z)continue;
			if(c.y != y)continue;
			if(c.lv != val)continue;
			//Have already requested this
			requested_list_lock.unlock();
			return; //it's already on the list!
		}
		Coords newc = new Coords();
		newc.d = d; newc.x = x; newc.y = y; newc.z = z; newc.lv = val;
		requested_list.add(newc);
		requested_list_lock.unlock();
	}
		
	
}