package dangerzone.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import dangerzone.DangerZone;
import dangerzone.entities.EntityLiving;
import dangerzone.particles.Particle;
import dangerzone.rendering.WorldRendererUtils;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


public class DisplaySorterThread implements Runnable {
	public List<Integer> LDrawMe = null;
	public Lock LDrawMelock = new ReentrantLock();
	public List<Particle> LDrawMeP = null;
	public Lock LDrawMePlock = new ReentrantLock();

	public DisplaySorterThread(){
		LDrawMe = new ArrayList<Integer>(); //so it is not null!
		LDrawMeP = new ArrayList<Particle>(); //so it is not null!
	}

	public void run()  {
		//Let startup happen
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {

		}
		
		/*
		 * Offload sorting through entities and particles from the main thread.
		 * Still has to copy a list, but at least it is a shortened list and it doesn't have
		 * to sort through it a thousand times. (in VR mode)
		 */
		//the only reason we need to do this "reasonably" fast is so new entities (like arrows!) show up without a delay.
		while(DangerZone.gameover == 0) {
			try {
				int isleep = (1000/DangerZone.wr.fps) - 1;
				if(isleep < 7)isleep = 7;
				if(isleep > 50)isleep = 50;
				Thread.sleep(isleep);
			} catch (InterruptedException e) {

			}

			//Entities
			LDrawMelock.lock();
			LDrawMe.clear();
			if(DangerZone.isVR || DangerZone.graphics_mode < 0) {
				WorldRendererUtils.findClosest(LDrawMe, DangerZone.vr_max_entity, DangerZone.renderdistance*8,
						(EntityLiving)DangerZone.wr.ViewFromEntity, DangerZone.wr.ref_yaw+DangerZone.wr.f5yaw, DangerZone.wr.ref_dim, DangerZone.wr.ref_posx, DangerZone.wr.ref_posy, DangerZone.wr.ref_posz);
			}else {
				WorldRendererUtils.findClosest(LDrawMe, -1, DangerZone.renderdistance*16, 
						(EntityLiving)DangerZone.wr.ViewFromEntity, DangerZone.wr.ref_yaw+DangerZone.wr.f5yaw, DangerZone.wr.ref_dim, DangerZone.wr.ref_posx, DangerZone.wr.ref_posy, DangerZone.wr.ref_posz);
			}
			LDrawMelock.unlock();

			//Particles
			LDrawMePlock.lock();
			LDrawMeP.clear();
			if(DangerZone.isVR || DangerZone.graphics_mode < 0) {
				WorldRendererUtils.findClosestP(LDrawMeP, DangerZone.vr_max_particle, DangerZone.renderdistance*8, //severely throttled because VR lags so bad
						(EntityLiving)DangerZone.wr.ViewFromEntity, DangerZone.wr.ref_yaw+DangerZone.wr.f5yaw, DangerZone.wr.ref_dim, DangerZone.wr.ref_posx, DangerZone.wr.ref_posy, DangerZone.wr.ref_posz);
			}else {
				WorldRendererUtils.findClosestP(LDrawMeP, -1, DangerZone.renderdistance*16, 
						(EntityLiving)DangerZone.wr.ViewFromEntity, DangerZone.wr.ref_yaw+DangerZone.wr.f5yaw, DangerZone.wr.ref_dim, DangerZone.wr.ref_posx, DangerZone.wr.ref_posy, DangerZone.wr.ref_posz);
			}
			LDrawMePlock.unlock();
			

		}

	}	



}
