package dangerzone.rendering;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;


public class VBOBuffer {
	
	public volatile ByteBuffer vbodata = null;
	public volatile int vcount = 0;
	public volatile int drawvcount = 0;
	public volatile int vmax = 0;
	public volatile int drawvmax = 0;
	//public volatile boolean isfar = true;
	private int stride = 0;
	private int textureoff = 0;
	private int coloroff = 0;
	private volatile int glvboID = 0;
	private volatile int glvaoID = 0;
	public int textureindex = 0;
	public volatile long VBOid = 0; //internal id, not Opengl!
	public boolean isTranslucent = false;
	public int xoff;
	public int zoff;
	public long lastusedframe;
	public volatile int vbostate = 0; //0 = sizing, 1 = draw, 2 = newdata, 3 = freed

	
	
	public VBOBuffer(){		

		stride = 3*4; //xyz coord size (floats!)
		textureoff = stride;
		stride += 2*4; //texture coord size
		coloroff = stride;
		stride += 3*4; //rgb (brightness floats!)	
		
		vmax = 0;
		drawvmax = 0;
		vbostate = 0;
		glvboID = 0;
		glvaoID = 0;
		vbodata = null;
		isTranslucent = false; //Translucent VBOs get drawn AFTER ones with only solids
		xoff = zoff = 0;
		lastusedframe = 0;
	}
	
	public void addVertexInfoToVBO(float vx, float vy, float vz,
						float tx, float ty,
						float br, float bg, float bb){
		
		if(vbostate == 0){
			vcount++;
			return;
		}
		if(vbostate != 1){
			return; //do nothing.
		}

		
		//just in case we need to grow even more!
		if(vcount >= vmax){
			//System.out.printf("resize at vcount %d pos %d exp %d\n", vcount, vbodata.position(), stride*vcount);
			ByteBuffer tmpvbodata = BufferUtils.createByteBuffer(((vmax+512)*stride)+1024); 
			if(tmpvbodata == null)return;
			vmax += 512; //make it bigger!
			DangerZone.wr.VBOmemorysize += 512*stride; //bytes
			if(vbodata != null) {
				vbodata.position(0);
				vbodata.limit(vbodata.capacity());
			}
			tmpvbodata.position(0);
			tmpvbodata.limit(tmpvbodata.capacity());
			if(vbodata != null)tmpvbodata.put(vbodata); //memcpy-ish
			vbodata = tmpvbodata; //because java doesn't have a realloc that can usually just extend the current buffer....
			//System.out.printf("vmax extended to %d\n", vmax);
			vbodata.limit(vbodata.capacity()); //set actual size of data
			vbodata.position(vcount*stride); 
		}
		

		//if(vx < -8 || vx > 248)System.out.printf("bad vx = %f\n", vx);
		//if(vy < -8 || vy > 4088)System.out.printf("bad vy = %f\n", vy);
		//if(vz < -8 || vz > 248)System.out.printf("bad vz = %f\n", vz);
		vbodata.putFloat( vx);
		vbodata.putFloat( vy);
		vbodata.putFloat( vz);
		//if(tx < 0 || tx > 1)System.out.printf("bad tx = \n", tx);
		//if(ty < 0 || ty > 1)System.out.printf("bad ty = \n", ty);
		vbodata.putFloat(tx);
		vbodata.putFloat(ty);
		//if(br < 0 || br > 1)System.out.printf("bad br = \n", br);
		//if(bg < 0 || bg > 1)System.out.printf("bad bg = \n", bg);
		//if(bb < 0 || bb > 1)System.out.printf("bad bb = \n", bb);
		vbodata.putFloat(br);
		vbodata.putFloat(bg);
		vbodata.putFloat(bb);
		vcount++;
	}
	
	/*
	 * Draw the specified buffer.
	 * Tells GPU to draw the VBO data we sent previously.
	 */
	public void draw()
	{
		if(vbostate == 0)return;
		if(vbostate == 3)return;
		if(vbodata == null)return;

		if(vbostate == 2){		//new data!!!			
			if(vcount == 0){
				drawvcount = 0; //it is empty, for now at least...
				vbostate = 1;
				return;			
			}
			
			if(glvaoID == 0 || glvboID == 0){
				//create a new vao and vbo, just don't put any data in it yet.
				glvaoID = GL30.glGenVertexArrays();
				glvboID = GL15.glGenBuffers();				
				GL30.glBindVertexArray(glvaoID);
				GL20.glEnableVertexAttribArray(0);
				GL20.glEnableVertexAttribArray(1);
				GL20.glEnableVertexAttribArray(2);				
				GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, glvboID);
				//if(isfar){
					GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
				//}else{
					//GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_DYNAMIC_DRAW);
				//}
				GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
				GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
				GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
				GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
				GL30.glBindVertexArray(0);
				GL20.glDisableVertexAttribArray(2);
				GL20.glDisableVertexAttribArray(1);
				GL20.glDisableVertexAttribArray(0);		
			}

			
			drawvcount = vcount;
			drawvmax = vmax;

			GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, glvboID);								
			vbodata.position(0);
			vbodata.limit(drawvcount*stride); //drawvcount*stride
			//if(isfar){
				GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
				//GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STREAM_DRAW);
			//}else{
				//GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_DYNAMIC_DRAW);
			//}
			GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0); //un-attach it

			vbodata.limit(vbodata.capacity());
			vbostate = 1;

		}

		if(vbostate != 1)return;
		if(drawvcount == 0)return;


		if(isTranslucent){
			GL11.glEnable(GL11.GL_BLEND);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);	
		}
		
		MatrixStack.sendFinalStack();

		//GL20.glEnableVertexAttribArray(0);
		//GL20.glEnableVertexAttribArray(1);
		//GL20.glEnableVertexAttribArray(2);	

		GL30.glBindVertexArray(glvaoID);

		GL11.glDrawArrays(GL11.GL_QUADS, 0, drawvcount);

		GL30.glBindVertexArray(0);

		//GL20.glDisableVertexAttribArray(2);
		//GL20.glDisableVertexAttribArray(1);
		//GL20.glDisableVertexAttribArray(0);		

		if(isTranslucent)GL11.glDisable(GL11.GL_BLEND);

	}
	
	public boolean finishDraw(){
		

		if(vbostate == 3)return false;
		
		if(vbostate == 0){  //sizing pass, change to draw and do it again!
			//first time through a non-sizing pass. Time to get real!
			//System.out.printf("buffer setup %d\n", vcount);
			vbodata = BufferUtils.createByteBuffer(((vcount+128)*stride)+1024); 
			if(vbodata == null)return false;
			vmax = vcount+128;
			vbodata.rewind();
			vbodata.limit(vbodata.capacity());
			vbodata.position(0);
			DangerZone.wr.VBOmemorysize += vmax*stride; //bytes
					
			vcount = 0;
			drawvcount = 0;
			drawvmax = 0;
			vbostate = 1;
			return true;
		}
		
		if(vbostate == 1){
			if(vmax > vcount+128){
				//buffers need to be resized down!
				int downsize = vmax-(vcount+128);
				downsize *= stride;
				//System.out.printf("Downsizing %d bytes\n", downsize);	
				ByteBuffer tmpvbodata = BufferUtils.createByteBuffer(((vcount+128)*stride)+1024); 
				if(tmpvbodata == null)return false;
				DangerZone.wr.VBOmemorysize -= downsize; //bytes
				vmax = vcount+128;			
				vbodata.position(0);
				vbodata.limit(vcount*stride);
				tmpvbodata.position(0);
				tmpvbodata.limit(tmpvbodata.capacity());
				tmpvbodata.put(vbodata); //memcpy-ish
				vbodata = tmpvbodata;
				vbodata.limit(vbodata.capacity()); 
				vbodata.position(vcount*stride); 
				drawvmax = 0;	
			}
			vbostate = 2;
		}

		return false;
	}
	
	public boolean reset(){
		//this vbo is being re-used.
		if(vbostate != 1){
			return false;
		}
		if(vbodata == null)return true;
		
		vbodata.position(0);          //rewind internal pointer to beginning
		vbodata.limit(vbodata.capacity()); //set size of data to max
		vcount = 0;
		
		return true; 
	}
	
	
	public void free(){
		if(vbostate == 3)return; //already free!
		GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
		GL30.glBindVertexArray(0);
		if(glvboID != 0)GL15.glDeleteBuffers(glvboID);
		glvboID = 0;
		if(glvaoID != 0)GL30.glDeleteVertexArrays(glvaoID);
		glvaoID = 0;
		if(vbodata != null)DangerZone.wr.VBOmemorysize -= vbodata.capacity(); //bytes
		drawvcount = 0;
		vbostate = 3; 
		vbodata = null;
	}
	

}
