package dangerzone.rendering;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

import dangerzone.DangerZone;

public class ShaderStuff {
	
	public void initShaders() {
		
		DangerZone.model_shader = shaderInit("ModelVertexShader.txt", "ModelFragmentShader.txt");
		if (DangerZone.model_shader == -1) {
			System.out.println("Failed to initialise model shader");
			System.exit(1);
		}
		
	}
	
	private String readFileAsString(String filename) throws Exception {
		StringBuilder source = new StringBuilder();

		FileInputStream in = new FileInputStream(filename);

		Exception exception = null;

		BufferedReader reader;
		try {
			reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));

			Exception innerExc = null;
			try {
				String line;
				while ((line = reader.readLine()) != null)
					source.append(line).append('\n');
			} catch (Exception exc) {
				exception = exc;
			} finally {
				try {
					reader.close();
				} catch (Exception exc) {
					if (innerExc == null)
						innerExc = exc;
					else
						exc.printStackTrace();
				}
			}

			if (innerExc != null)
				throw innerExc;
		} catch (Exception exc) {
			exception = exc;
		} finally {
			try {
				in.close();
			} catch (Exception exc) {
				if (exception == null)
					exception = exc;
				else
					exc.printStackTrace();
			}

			if (exception != null)
				throw exception;
		}

		return source.toString();
	}
	
	public void removeShaders() {
		//GL20.glDetachShader(m_main_program, vertex_shader);
		//GL20.glDetachShader(m_main_program, fragment_shader);
		//GL20.glDeleteShader(vertex_shader);
		//GL20.glDeleteShader(fragment_shader);
		//GL20.glDeleteProgram(DangerZone.default_shader);
		GL20.glDeleteProgram(DangerZone.model_shader);
		//DangerZone.current_shader = -1;
	}

	public int shaderInit(String vsn, String fsn) {

		String vertexShader;
		String fragmentShader;
		int errorCheckValue;
		String l_dir = "./";
		try {
			Path currentRelativePath = Paths.get("");
			String s = currentRelativePath.toAbsolutePath().toString();
			System.out.println("Current relative path is: " + s);
			vertexShader = readFileAsString(l_dir + vsn);
			fragmentShader = readFileAsString(l_dir + fsn);
		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}

		int program = GL20.glCreateProgram();
		errorCheckValue = GL11.glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.err.println("Failed to create shader program");
			return -1;
		}
		int vertex_shader = GL20.glCreateShader(GL20.GL_VERTEX_SHADER);
		errorCheckValue = GL11.glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.err.println("Failed to create vertex shader");
			return -1;
		}
		GL20.glShaderSource(vertex_shader, vertexShader);
		errorCheckValue =GL11. glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.err.println("Failed to load vertex shader string");
			return -1;
		}
		GL20.glCompileShader(vertex_shader);
		int isCompiled;
		isCompiled = GL20.glGetShaderi(vertex_shader, GL20.GL_COMPILE_STATUS);
		if (isCompiled == GL11.GL_FALSE) {
			String shaderLog = GL20.glGetShaderInfoLog(vertex_shader);
			System.err.println("Failed to compile vertex shader");
			System.err.println(shaderLog);
			return -1;
		}
		GL20.glAttachShader(program, vertex_shader);
		errorCheckValue = GL11.glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.err.println("Failed to attach vertex shader to program");
			return -1;
		}

		int fragment_shader = GL20.glCreateShader(GL20.GL_FRAGMENT_SHADER);
		errorCheckValue = GL11.glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.err.println("Failed to create fragment shader");
			return -1;
		}
		GL20.glShaderSource(fragment_shader, fragmentShader);
		errorCheckValue = GL11.glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.err.println("Failed to load fragment shader");
			return -1;
		}
		GL20.glCompileShader(fragment_shader);
		isCompiled = GL20.glGetShaderi(fragment_shader, GL20.GL_COMPILE_STATUS);
		if (isCompiled == GL11.GL_FALSE) {
			String shaderLog = GL20.glGetShaderInfoLog(fragment_shader);
			System.err.println("Failed to compile fragment shader");
			System.err.println(shaderLog);
			return -1;
		}
		GL20.glAttachShader(program, fragment_shader);
		errorCheckValue = GL11.glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.err.println("Failed to attach fragment shader to program");
			return -1;
		}	
		
		GL20.glLinkProgram(program);
		if (GL20.glGetProgrami(program, GL20.GL_LINK_STATUS) == GL11.GL_FALSE) {
			System.err.println("Failed to link program");
			System.err.println(GL20.glGetProgramInfoLog(program, GL20.glGetProgrami(program, GL20.GL_INFO_LOG_LENGTH)));
			return -1;
		}
		
		GL20.glValidateProgram(program);
		if (GL20.glGetProgrami(program, GL20.GL_VALIDATE_STATUS) == GL11.GL_FALSE) {
			System.err.println("Failed to validate program");
			System.err.println(GL20.glGetProgramInfoLog(program, GL20.glGetProgrami(program, GL20.GL_INFO_LOG_LENGTH)));
			return -1;
		}

		System.out.println("Created program Id " + program);
		
		//clean up!
		GL20.glDetachShader(program, vertex_shader);
		GL20.glDetachShader(program, fragment_shader);		
		GL20.glDeleteShader(vertex_shader);
		GL20.glDeleteShader(fragment_shader);

		return program;
	}


	
	

}
