package dangerzone.rendering;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.Arrays;

import org.lwjgl.openvr.HmdQuaternion;




//THESE ARE NOT THE DROIDS YOU ARE LOOKING FOR!!!!!

/*
 * No, really... go see MatrixStack.java. That is the one currently being used.
 * But something is wrong with the graphics (slow!) so I may try this one day instead.
 * I'm thinking the problem has to do with so many matrix transfers to the graphics card for
 * each little cube. Perhaps it is better to do most of the math in the CPU instead.
 * 
 * Some of this is used for Headset and Controllers, but not much else.
 */
public class Matrix4f {
	private final static int SIZE = 4;
	public float[] elements = new float[SIZE * SIZE];
	//public static boolean once = false;
	
	public static void identity(Matrix4f mat) {
		//Matrix4f result = new Matrix4f();
		
		//TODO - see if this worked
		//TODO - see if this worked
		//TODO - see if this worked
		//TODO - see if this worked
		
		for (int i = 0; i < SIZE*SIZE; i++) {
			//for (int j = 0; j < SIZE; j++) {
				//mat.set(i, j, 0);
				mat.elements[i] = 0;				
			//}
		}
		
		//mat.set(0, 0, 1);
		//mat.set(1, 1, 1);
		//mat.set(2, 2, 1);
		//mat.set(3, 3, 1);
		mat.elements[0] = 1;
		mat.elements[(SIZE) + 1] = 1;	
		mat.elements[(2 * SIZE) + 2] = 1;	
		mat.elements[(3 * SIZE) + 3] = 1;	
	}
	
	//These next three are CUMULATIVE
	public static void translate(Matrix4f mat, float x, float y, float z) {			
		mat.set(3, 0, mat.get(3,0)+x);
		mat.set(3, 1, mat.get(3,1)+y);
		mat.set(3, 2, mat.get(3,2)+z);		
	}
	
	public static void scale(Matrix4f mat, float x, float y, float z) {			
		mat.set(0, 0, mat.get(0,0)*x);
		mat.set(1, 1, mat.get(1,1)*y);
		mat.set(2, 2, mat.get(2,2)*z);		
	}
	

	public static void rotate(Matrix4f mat, float angle, float x, float y, float z) {
		Matrix4f presult = new Matrix4f();
		identity(presult);
		Matrix4f temp = new Matrix4f();
		
		float cos = (float) Math.cos(Math.toRadians(angle));
		float sin = (float) Math.sin(Math.toRadians(angle));
		float C = 1 - cos;
		
		
		presult.set(0, 0, cos + (x * x * C));
		presult.set(0, 1, (x * y * C) - (z * sin));
		presult.set(0, 2, (x * z * C) + (y * sin));
		presult.set(1, 0, (y * x * C) + (z * sin));
		presult.set(1, 1, cos + (y * y * C));
		presult.set(1, 2, (y * z * C) - (x * sin));
		presult.set(2, 0, (z * x * C) - (y * sin));
		presult.set(2, 1, (z * y * C) + (x * sin));
		presult.set(2, 2, cos + (z * z * C));
		
		for (int i = 0; i < SIZE; i++) {
			for (int j = 0; j < SIZE; j++) {
				temp.set(i, j, mat.get(i,  j));
			}
		}
		multiply(mat, temp, presult);
	}
	
	
	//These three just set the result
	private static Matrix4f translate(Vector3f translate) {
		Matrix4f result = new Matrix4f();
		Matrix4f.identity(result);
		
		result.set(3, 0, translate.getX());
		result.set(3, 1, translate.getY());
		result.set(3, 2, translate.getZ());
		
		return result;
	}
	
	private static Matrix4f rotate(float angle, Vector3f axis) {
		Matrix4f result = new Matrix4f();
		Matrix4f.identity(result);
		
		float cos = (float) Math.cos(Math.toRadians(angle));
		float sin = (float) Math.sin(Math.toRadians(angle));
		float C = 1 - cos;
		
		result.set(0, 0, cos + axis.getX() * axis.getX() * C);
		result.set(0, 1, axis.getX() * axis.getY() * C - axis.getZ() * sin);
		result.set(0, 2, axis.getX() * axis.getZ() * C + axis.getY() * sin);
		result.set(1, 0, axis.getY() * axis.getX() * C + axis.getZ() * sin);
		result.set(1, 1, cos + axis.getY() * axis.getY() * C);
		result.set(1, 2, axis.getY() * axis.getZ() * C - axis.getX() * sin);
		result.set(2, 0, axis.getZ() * axis.getX() * C - axis.getY() * sin);
		result.set(2, 1, axis.getZ() * axis.getY() * C + axis.getX() * sin);
		result.set(2, 2, cos + axis.getZ() * axis.getZ() * C);
		
		return result;
	}
	
	private static Matrix4f scale(Vector3f scalar) {
		Matrix4f result = new Matrix4f();
		Matrix4f.identity(result);
		
		result.set(0, 0, scalar.getX());
		result.set(1, 1, scalar.getY());
		result.set(2, 2, scalar.getZ());
		
		return result;
	}
	
	
	public static Matrix4f transform(Vector3f position, Vector3f rotation, Vector3f scale) {
		Matrix4f result = new Matrix4f();
		Matrix4f.identity(result);
		
		Matrix4f translationMatrix = Matrix4f.translate(position);
		Matrix4f rotXMatrix = Matrix4f.rotate(rotation.getX(), new Vector3f(1, 0, 0));
		Matrix4f rotYMatrix = Matrix4f.rotate(rotation.getY(), new Vector3f(0, 1, 0));
		Matrix4f rotZMatrix = Matrix4f.rotate(rotation.getZ(), new Vector3f(0, 0, 1));
		Matrix4f scaleMatrix = Matrix4f.scale(scale);
		
		Matrix4f rotationMatrix = Matrix4f.multiply(rotXMatrix, Matrix4f.multiply(rotYMatrix, rotZMatrix));
		
		result = Matrix4f.multiply(translationMatrix, Matrix4f.multiply(rotationMatrix, scaleMatrix));
		
		return result;
	}
	
	public static void projection(Matrix4f mat, float fov, float aspect, float near, float far) {
		
		float tanFOV = (float) Math.tan(Math.toRadians(fov / 2));
		float range = far - near;
		
		identity(mat);
		mat.set(0, 0, 1.0f / (aspect * tanFOV));
		mat.set(1, 1, 1.0f / tanFOV);
		mat.set(2, 2, -((far + near) / range));
		mat.set(2, 3, -1.0f);
		mat.set(3, 2, -((2f * far * near) / range));
		mat.set(3, 3, 0.0f);
		
		
		//if(!once) {
		//	System.out.printf("p %f, %f, %f, %f\n", mat.get(0,0), mat.get(0,1), mat.get(0,2), mat.get(0,3));
		//	System.out.printf("p %f, %f, %f, %f\n", mat.get(1,0), mat.get(1,1), mat.get(1,2), mat.get(1,3));
		//	System.out.printf("p %f, %f, %f, %f\n", mat.get(2,0), mat.get(2,1), mat.get(2,2), mat.get(2,3));
		//	System.out.printf("p %f, %f, %f, %f\n", mat.get(3,0), mat.get(3,1), mat.get(3,2), mat.get(3,3));
		//	once = true;
		//}

	}
	
	public static void ortho(Matrix4f mat, float left, float right, float top, float bottom, float near, float far) {
		
		identity(mat);
		mat.set(0, 0, 2.0f / (right-left));
		mat.set(1, 1, 2.0f / (top-bottom));
		mat.set(2, 2, -(2f / (far-near)));
		mat.set(3, 0,-((right+left)/(right-left)));
		mat.set(3, 1,-((top+bottom)/(top-bottom)));
		mat.set(3, 2,-((far+near)/(far-near)));
		mat.set(3, 3, 1.0f);

	}
	
	public static Matrix4f view(Vector3f position, Vector3f rotation) {
		Matrix4f result = new Matrix4f();
		Matrix4f.identity(result);
		
		Vector3f negative = new Vector3f(-position.getX(), -position.getY(), -position.getZ());
		Matrix4f translationMatrix = Matrix4f.translate(negative);
		Matrix4f rotXMatrix = Matrix4f.rotate(rotation.getX(), new Vector3f(1, 0, 0));
		Matrix4f rotYMatrix = Matrix4f.rotate(rotation.getY(), new Vector3f(0, 1, 0));
		Matrix4f rotZMatrix = Matrix4f.rotate(rotation.getZ(), new Vector3f(0, 0, 1));
		
		Matrix4f rotationMatrix = Matrix4f.multiply(rotYMatrix, Matrix4f.multiply(rotZMatrix, rotXMatrix));
		
		result = Matrix4f.multiply(translationMatrix, rotationMatrix);
		
		return result;
	}
	
	private static Matrix4f multiply(Matrix4f matrix, Matrix4f other) {
		Matrix4f result = new Matrix4f();
		Matrix4f.identity(result);
		
		for (int i = 0; i < SIZE; i++) {
			for (int j = 0; j < SIZE; j++) {
				result.set(i, j, matrix.get(i, 0) * other.get(0, j) +
								 matrix.get(i, 1) * other.get(1, j) +
								 matrix.get(i, 2) * other.get(2, j) +
								 matrix.get(i, 3) * other.get(3, j));
			}
		}
		
		return result;
	}
	
	public static void multiply(Matrix4f result, Matrix4f matrix, Matrix4f other) {
		
		
		for (int i = 0; i < SIZE; i++) {
			for (int j = 0; j < SIZE; j++) {
				result.set(i, j, (matrix.get(i, 0) * other.get(0, j)) +
								 (matrix.get(i, 1) * other.get(1, j)) +
								 (matrix.get(i, 2) * other.get(2, j)) +
								 (matrix.get(i, 3) * other.get(3, j)));
			}
		}
		
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(elements);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Matrix4f other = (Matrix4f) obj;
		if (!Arrays.equals(elements, other.elements))
			return false;
		return true;
	}

	public float get(int x, int y) {
		return elements[(y * SIZE) + x];
	}
	
	public void set(int x, int y, float value) {
		elements[(y * SIZE) + x] = value;
	}
	
	//private float[] getAll() {
	//	return elements;
	//}
	
    public void set(float m00, float m01, float m02, float m03,
            float m10, float m11, float m12, float m13,
            float m20, float m21, float m22, float m23,
            float m30, float m31, float m32, float m33) {
    	
        set(0,0, m00);
        set(1,0, m01);
        set(2,0, m02);
        set(3,0, m03);
        set(0,1, m10);
        set(1,1, m11);
        set(2,1, m12);
        set(3,1, m13);
        set(0,2, m20);
        set(2,2, m21);
        set(2,2, m22);
        set(3,2, m23);
        set(0,3, m30);
        set(1,3, m31);
        set(2,3, m32);
        set(3,3, m33);
        
        
    	//System.out.printf("%f, %f, %f, %f\n", get(0,0), get(0,1), get(0,2), get(0,3));
    	//System.out.printf("%f, %f, %f, %f\n", get(1,0), get(1,1), get(1,2), get(1,3));
    	//System.out.printf("%f, %f, %f, %f\n", get(2,0), get(2,1), get(2,2), get(2,3));
    	//System.out.printf("%f, %f, %f, %f\n", get(3,0), get(3,1), get(3,2), get(3,3));
    	
    }
    
	public static void quaternion_to_rotation(HmdQuaternion quat, Matrix4f mat) {
		double x = quat.x();
		double y = quat.y();
		double z = quat.z();
		double w = quat.w();		
	    double sqw = w*w;
	    double sqx = x*x;
	    double sqy = y*y;
	    double sqz = z*z;
	    
	    Matrix4f.identity(mat);

	    // invs (inverse square length) is only required if quaternion is not already normalised
	    double invs = 1 / (sqx + sqy + sqz + sqw) ;

	    mat.set(0, 0, (float)(( sqx - sqy - sqz + sqw)*invs)); // since sqw + sqx + sqy + sqz =1/invs*invs
	    mat.set(1, 1, (float)((-sqx + sqy - sqz + sqw)*invs));
	    mat.set(2, 2, (float)((-sqx - sqy + sqz + sqw)*invs));
	    
	    double tmp1 = x*y;
	    double tmp2 = z*w;
	    mat.set(0, 1, (float)(2.0 * (tmp1 + tmp2)*invs));
	    mat.set(1, 0, (float)(2.0 * (tmp1 - tmp2)*invs));
	    
	    tmp1 = x*z;
	    tmp2 = y*w;
	    mat.set(0, 2, (float)(2.0 * (tmp1 - tmp2)*invs));
	    mat.set(2, 0, (float)(2.0 * (tmp1 + tmp2)*invs));
	    tmp1 = y*z;
	    tmp2 = x*w;
	    mat.set(1, 2, (float)(2.0 * (tmp1 + tmp2)*invs));
	    mat.set(2, 1, (float)(2.0 * (tmp1 - tmp2)*invs));      
	    	    
	}

}