package dangerzone.rendering;



import java.io.DataInputStream;
import java.io.IOException;
import dangerzone.DangerZone;
import dangerzone.ReadMyFuckingFileYouAssholes;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

public class Fastmath {
	
	//because on-the-fly calculations of sin and cos are painful, and we don't need 10 digits of accuracy,
	//make a pre-calculated table that gives us roughly 3-4 digits! Much faster to just look it up!
	
	public static double sintable[] = null;
	public static double costable[] = null;
	public static volatile int nextval = 0;
	public static volatile int cntr = 0;
	public static int salt[] = null;
	public static int SALTLEN = 100000;
	public static volatile int saltindex = 0;
	
	public static void inittable(){
		double dval = 0;
		double dindex;
		int index;
		sintable = new double [10000];
		costable = new double [10000];
		
		for(index = 0; index < 10000; index++){
			dindex = index;
			dval = (Math.PI*2d)*(dindex/10000d);
			sintable[index] = Math.sin(dval);
			costable[index] = Math.cos(dval);
		}
		
	}
	
	public static double sin(double rads){
		double retval = 0;
		int index = 0;
		
		if(sintable == null)inittable();
		
		retval = rads % (Math.PI*2d);
		if(retval < 0)retval += (Math.PI*2d);
		retval = (retval * 10000d) / (Math.PI*2d);
		index = (int)retval;
		
		if(index < 0)index = 0;
		if(index > 9999)index = 9999;
		retval = sintable[index];
		return retval;
	}
	
	public static double cos(double rads){
		double retval = 0;
		int index = 0;
		
		if(costable == null)inittable();
		
		retval = rads % (Math.PI*2d);
		if(retval < 0)retval += (Math.PI*2d);
		retval = (retval * 10000d) / (Math.PI*2d);
		index = (int)retval;
		
		if(index < 0)index = 0;
		if(index > 9999)index = 9999;
		retval = costable[index];
		return retval;
	}
	
	//Fetch some randomish numbers to help with quick successive calls.
	public static void initrand() {

		DataInputStream dos = null;		
		salt = new int [SALTLEN]; //should be enough
		
		//Go ahead, just try to read a file in your jar file.
		ReadMyFuckingFileYouAssholes rmff = new ReadMyFuckingFileYouAssholes();
		java.io.InputStream in = rmff.readthisfuckingfile("res/sounds/thunder3.wav");
		dos = new DataInputStream(in);
		
		try {

			int skip = DangerZone.rand.nextInt(1000)+500; //make sure we skip past the header
			int skl, skr, skew, skewb;
			skip += (int)((int)System.currentTimeMillis()&0xff);
			while(skip > 0) {
				salt[0] = dos.readInt();
				skip--;
			}
			//now read some data into array
			skip = 0;
			skew = 0;
			while(skip < SALTLEN) {
				salt[skip] = dos.readInt();
				
				//rotate it a little maybe
				if(skew > 0) {
					for(int i=0;i<skew;i++) {
						skewb = salt[skip] & 0x80000000;
						salt[skip] >>= 1;
						if(skewb != 0)salt[skip] |= 0x80000000;
					}
				}
				
				skl = salt[skip]&0xffff;
				skr = (salt[skip]>>16)&0xffff;
				salt[skip] = skl^skr;
				//System.out.printf("rand data = 0x%x\n", salt[skip]);
				skip++;
				skew++;
				if(skew >= 16)skew = 0;
			}
			
			//and that should make some reasonable randomish data to start with.

		} catch (IOException e) {		
			System.out.printf("Fastmath.initrand() failure read\n");
			DangerZone.gameover = 1;
		}
				
		try {
			dos.close();
			in.close();
		} catch (IOException e) {
			System.out.printf("Fastmath.initrand() failure close\n");
			DangerZone.gameover = 1;
			return;	
		}
		
		cntr = (int)System.currentTimeMillis();
		
	}
	
	private static void update_nextval() {
		cntr++;
		//cntr &= 0xffff;
		if((cntr%10000) == 0) {
			cntr += (int)DangerZone.most_current_time;
			//cntr &= 0xffff;
			if(cntr < 0)cntr = -cntr;
		}
		nextval += cntr;
		//This index gets soooooo confused and goes negative and crashes
		//Try to make sure it doesn't
		int localint = saltindex; //force it positive just in case java gets confused (again!)
		if(localint < 0)localint = 0;
		if(localint >= SALTLEN)localint = 0;
		nextval += salt[(localint&0xfffff)%SALTLEN];
		saltindex++;
		if(saltindex < 0)saltindex = 0;
		if(saltindex >= SALTLEN)saltindex = 0;
		nextval &= 0xffff;
	}
	
	public static boolean nextBoolean() {
		update_nextval();
		return ((nextval&0x01) == 0x01);
	}
	
	public static int nextInt(int scale) {
		update_nextval();
		//System.out.printf("rand = 0x%x\n",  nextval%scale);
		return (nextval&0xffff)%scale;
	}
	
	public static float nextFloat() {
		//int tempval = nextInt(10000);
		//float retval = (float)tempval;
		return (float)(nextInt(10000))/10000.0f;
	}

}
