package dangerzone.particles;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;


public class ModelParticle extends ModelBase {
	
	private boolean compiled = false;
	private int list1, list2, list3, list4, list5;
	
	public ModelParticle()
	{
		if(!compiled && DangerZone.wr != null){
			int stride = 3*4; //xyz coord size (floats!)
			int textureoff = stride;
			stride += 2*4; //texture coord size
			int coloroff = stride;
			stride += 3*4; //rgb (brightness bytes!)	
			
			ByteBuffer vbodata = BufferUtils.createByteBuffer(4*stride); // size (1 side)  	
			int vbo_buffer;
			

			list1 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(list1);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 4, 4, 0,      0.5f,0          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, 4, 0,     0,0             , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, -4, 0,    0,0.5f          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 4, -4, 0,     0.5f,0.5f      , 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			

			list2 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(list2);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 4, 4, 0,      1,0          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, 4, 0,     0.5f,0             , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, -4, 0,    0.5f,0.5f          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 4, -4, 0,     1,0.5f      , 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			

			list3 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(list3);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 4, 4, 0,      0.5f,0.5f          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, 4, 0,     0,0.5f             , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, -4, 0,    0,1          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 4, -4, 0,     0.5f,1      , 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			
			

			list4 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(list4);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 4, 4, 0,      1,0.5f          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, 4, 0,     0.5f,0.5f             , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, -4, 0,    0.5f,1          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 4, -4, 0,     1,1      , 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();
			
			

			list5 = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(list5);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);					    	
	    	addVertexInfoToBuffer(vbodata, 4, 4, 0,      1,0          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, 4, 0,     0,0             , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -4, -4, 0,    0,1          , 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 4, -4, 0,     1,1      , 1f, 1f, 1f);   		    	
	    	vbodata.flip();
	    	vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
			vbodata.rewind();

			compiled = true;
		}		  
	}
	
    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }
	  
	public void renderParticle(Particle p)
	{
		
		
		//All the rotation and such has been done for us... just render!	
		//GL11.glEnable(GL11.GL_BLEND);
		//GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);  
		
		MatrixStack.sendFinalStack();
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);
		
		if(p.fullsize){
			GL30.glBindVertexArray(list5);				
			GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);						
			GL30.glBindVertexArray(0);
		}else{
			int which = p.getSubTexture();
			switch(which){
			case 0:
				GL30.glBindVertexArray(list1);				
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);						
				GL30.glBindVertexArray(0);
				break;
			case 1:
				GL30.glBindVertexArray(list2);				
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);						
				GL30.glBindVertexArray(0);
				break;
			case 2:
				GL30.glBindVertexArray(list3);				
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);						
				GL30.glBindVertexArray(0);
				break;
			case 3:
				GL30.glBindVertexArray(list4);				
				GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);						
				GL30.glBindVertexArray(0);
				break;
			default:
			}
		}
		
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);

		//GL11.glDisable(GL11.GL_BLEND);

	}

}
