package dangerzone.items;



import dangerzone.DangerZone;
import dangerzone.entities.Entity;
import dangerzone.gui.InventoryMenus;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * 
 */
public class ItemSword extends Item {

	public ItemSword(String n, String txt, int durability, int attack) {
		super(n, txt);
		maxuses = durability;
		maxstack = 1;
		attackstrength = attack;
		burntime = 15;
		menu = InventoryMenus.HARDWARE;
		
		itemreach = 1f;
		itemwidth = 0.25f;
		
		//VR adjustments
		xoff = 0.5f;
		yoff = -0.1f;
		zoff = -6.3f;
		pitch_off = 9.3f;
		yaw_off = 91.8f;
		roll_off = 144.0f;
	}

	/*
	 * add some buffs the first time something right-clicks this thing...
	 * 
	public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic){
		if(holder == null)return false;
		if(ic.attributes == null){ //if not already added...
			if(holder.world.isServer){
				//add some just for fun...
				ic.addAttribute(ItemAttribute.ACCURACY, 3);
				ic.addAttribute(ItemAttribute.DAMAGE, 3);
				ic.addAttribute(ItemAttribute.DURABILITY, 2);
				ic.addAttribute(ItemAttribute.REACH, 2);
				ic.addAttribute(ItemAttribute.SPAM, 5);
				holder.setVarInventoryChanged(ic); //finds this container and sets bit to update to clients!
			}
		}
		return false;
	}
	*/
	
	/*
	 * example for adding buffs when crafted (or from creative inventory) instead of on a right-click
	 * Much easier. No updating necessary as it will all get done later automagically...
	 * 
	public void onCrafted(Player p, InventoryContainer ic){
		//add some just for fun...
		ic.addAttribute(ItemAttribute.ACCURACY, 3);
		ic.addAttribute(ItemAttribute.DAMAGE, 3);
		ic.addAttribute(ItemAttribute.DURABILITY, 2);
		ic.addAttribute(ItemAttribute.REACH, 2);
		ic.addAttribute(ItemAttribute.SPAM, 5);
	}	  
	*/
	
    public void vr_hit_something(Entity e, int bid) {
    	//override and do something if you want! One or the other parameter should be valid.
    	if(bid != 0) {
    		DangerZone.hit_pulse(500);
    		return;
    	}
    	if(e != null) {
    		DangerZone.hit_pulse(2000);
    	}
    }
	

}
