package dangerzone.items;
import dangerzone.Player;
import dangerzone.ToDoList;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.gui.InventoryMenus;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class ItemSpawnEggMC2 extends Item {
	
	public String critter;
	
	public ItemSpawnEggMC2(String name, String tx, String tospawn){
		super(name, tx);
		critter = tospawn;
		maxstack = 16;
		menu = InventoryMenus.SPAWNEGG;
	}
		
	//Player right-clicked on this block with this item
	//called from client side.
	public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side){
		if(p != null){
			if(p.world.isServer){		
				Entity eb = p.world.createEntityByName(critter, dimension, ((double)x)+0.5f, ((double)y)+1.05f, ((double)z)+0.5f);
				if(eb != null){
					eb.init();
					eb.setVarInt(31, 17); //set it ready to hatch any second!
					p.world.spawnEntityInWorld(eb);
				}
				Utils.spawnParticles(p.world, "DangerZone:ParticleSparkle", 20, dimension, ((double)x)+0.5f, ((double)y)+1.05f, ((double)z)+0.5f, true);
				Utils.spawnParticles(p.world, "DangerZone:ParticleSmoke", 20, dimension, ((double)x)+0.5f, ((double)y)+1.05f, ((double)z)+0.5f, true);
				Utils.spawnParticles(p.world, "DangerZone:ParticleFire", 10, dimension, ((double)x)+0.5f, ((double)y)+1.05f, ((double)z)+0.5f, true);
				p.world.playSound("DangerZone:small_explosion4", dimension, ((double)x)+0.5f, ((double)y)+1.05f, ((double)z)+0.5f, 0.25f, 1.0f+((p.world.rand.nextFloat()-p.world.rand.nextFloat())*0.3f));
				ToDoList.onSpawned(p, eb);
			
			}
		}
		return true; //delete me, I'm done!
	}

}
