package dangerzone.items;

import slick.Texture;

import dangerzone.DamageTypes;
import dangerzone.DangerZone;
import dangerzone.GameModes;
import dangerzone.InventoryContainer;
import dangerzone.ItemAttribute;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityExtendedRangeDamage;
import dangerzone.gui.InventoryMenus;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;

public class ItemMagnum extends Item {
	
	Texture texturebig = null;
	ModelMagnum ma = null;
	
	//Example of a nice tame little peashooter.
	//Not too fast.
	//Not too accurate.
	//But then what did you expect for a 22?
	//Make your own!
	
	public ItemMagnum(String n, String txt, int att, int uses) {
		super(n, txt);
		this.maxstack = 1;
		this.maxuses = uses;
		this.attackstrength = att;
		menu = InventoryMenus.HARDWARE;
		hold_straight = true;
		do_shoot_clicks = true; //don't eat or hit!!! SHOOT!!!
		
		xoff = -2.8f+4.0f;
		yoff = -2.8f-7.2f;
		zoff = -0.4f-7.2f+3.2f;
		pitch_off = 9.4f+210.8f+7.6f;
		yaw_off = 91.2f+194.0f;
		roll_off = -54.8f+82f+6.2f;
	}
	
	public void renderMe(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay){
		
		if(texturebig == null){
			texturebig = TextureMapper.getTexture("res/items/Magnumtexture.png");
		}
		DangerZone.wr.loadtexture(texturebig);
		
		if(ma == null){
			ma = new ModelMagnum();
		}		
		
		//MatrixStack.translate((float)DangerZone.testx, (float)DangerZone.testy, (float)DangerZone.testz);
		//MatrixStack.rotate(DangerZone.testp, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
		//MatrixStack.rotate(DangerZone.testw, 0.0f, 1.0f, 0.0f);
		//MatrixStack.rotate(DangerZone.testr, 0.0f, 0.0f, 1.0f);
		
	   
	    MatrixStack.pushMatrix();
	    		
		MatrixStack.rotate(5.5f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
		MatrixStack.rotate(-75.1f, 0.0f, 1.0f, 0.0f);
		MatrixStack.rotate(149.7f, 0.0f, 0.0f, 1.0f);
		MatrixStack.translate(1.5f, 18.1f, -4.4f);
			    
	    MatrixStack.sendCurrentStack();
	    
		if(ma != null)ma.render(e, ic);
		
		MatrixStack.popMatrix();
		
	}
	
	public void renderMeHeld(WorldRenderer wr, Entity e, InventoryContainer ic, boolean isdisplay){
		if(e == null)return;

		float count = e.getRightButtonDownCount();
		if(count > getfullholdcount())count = getfullholdcount();
		float pct = count/getfullholdcount();
		int tweaked = 0;
		
		if(DangerZone.isVR)pct = 0;
		
		if(isdisplay && e.getRightButtonDownCount() != 0){	

			//this is for when just the right button is being held down!
		    MatrixStack.pushMatrix();
		    		
			//MatrixStack.rotate((pct*DangerZone.testp), 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
			//MatrixStack.rotate( (pct*DangerZone.testw), 0.0f, 1.0f, 0.0f);
			//MatrixStack.rotate( (pct*DangerZone.testr), 0.0f, 0.0f, 1.0f);
			//MatrixStack.translate((pct*(float)DangerZone.testx), (pct*(float)DangerZone.testy), (pct*(float)DangerZone.testz));
			
			MatrixStack.rotate((pct*(-6.3f)), 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
			MatrixStack.rotate( (pct*(11.5f+1.3f)), 0.0f, 1.0f, 0.0f);
			MatrixStack.rotate( (pct*(20.8f)), 0.0f, 0.0f, 1.0f);
			MatrixStack.translate((pct*2.4f), (pct*(8.2f+-5.7f)), (pct*-17.5f));				    
		    MatrixStack.sendCurrentStack();
		    
			tweaked = 1;
		}else {
			if(!isdisplay) {
				MatrixStack.pushMatrix();
				pct = 1;
				MatrixStack.rotate(-16.4f, 1.0f, 0.0f, 0.0f); // Rotate The Entity On X, Y & Z
				MatrixStack.rotate( 5.7f, 0.0f, 1.0f, 0.0f);
				MatrixStack.rotate( -64.9f, 0.0f, 0.0f, 1.0f);
				MatrixStack.translate(-7.3f, -4.2f, 1.1f);
			    MatrixStack.sendCurrentStack();
			    
				tweaked = 1;
			}
		}

		renderMe( wr,  e, ic, isdisplay);
		
		if(tweaked != 0)MatrixStack.popMatrix();


	}
	
	//this is a little single-shot pea-shooter! (but you can uncomment these others and try it!)
	//public boolean fullauto(Entity holder, InventoryContainer ic, int holdcount){
	//public boolean semiauto(Entity holder, InventoryContainer ic, int holdcount){
	public boolean singleshot(Entity holder, InventoryContainer ic, int holdcount){
		
		if(ic == null)return false;
		int spam = ic.getAttribute(ItemAttribute.SPAM);			//spell effect
		int acc = ic.getAttribute(ItemAttribute.ACCURACY);		//spell effect
		int dmg = ic.getAttribute(ItemAttribute.DAMAGE);		//spell effect
		int rch = ic.getAttribute(ItemAttribute.REACH);			//spell effect
		float held = holdcount+10*spam;
		
		if(holder.world.isServer){


			if(acc < 1)acc = 1;
			float acu = 1/acc;
			float dam = this.attackstrength + 2*dmg;
			float spd = 0.75f*rch;
			if(held > getfullholdcount())held = getfullholdcount();

			//System.out.printf("got to pistol item with %d and %f\n", holdcount, held);

			if(this.maxuses-ic.currentuses <= 1)return false; //EMPTY!!!
			if(held < getfullholdcount())return false; //Not ready!!!
			
			float mx, my, mz;
			TargetInfo ti = DangerZone.weapon_controller;
			
			EntityExtendedRangeDamage e = null;
			
			if(DangerZone.isVR && holder instanceof Player) {
				e = (EntityExtendedRangeDamage)holder.world.createEntityByName("DangerZone:ExtendedRangeDamage", 
						holder.dimension, 
						ti.real_posx, ti.real_posy+holder.getEyeHeight(), ti.real_posz);	
			}else {
				//create invisible entity because bullets are too small and fast to see.
				 e = (EntityExtendedRangeDamage)holder.world.createEntityByName("DangerZone:ExtendedRangeDamage", 
						holder.dimension, 
						holder.posx+(float)Math.sin(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
						holder.posy+(holder.getHeight()*9.25f/10f) - (float)Math.sin(Math.toRadians(holder.rotation_pitch_head))*(holder.getWidth()+1.5f),
						holder.posz+(float)Math.cos(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)));
			}


			if(e != null){				
				e.init();
				e.setDamageType(DamageTypes.PROJECTILE); 				//damagetype
				e.setRange(256); 										//absolute max range in blocks
				e.thrower = holder; 									//shooter!
				e.setAttackDamage(dam); 								//attackdamage (damage when hits entity)
				e.setItemDamage(1);										//can hit and destroy items!
				
				//we will use m* to set blast particle direction below!
				mx = (float)Math.sin(Math.toRadians(holder.rotation_yaw_head))*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
				my = -(float)Math.sin(Math.toRadians(holder.rotation_pitch_head-0.75f)); //just a smidge high (-0.75f)
				mz = (float)Math.cos(Math.toRadians(holder.rotation_yaw_head))*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head));
						
				
				float dx, dy, dz;
				dx = dy = dz = 0;
				if(DangerZone.isVR && holder instanceof Player) {
					
					ti.calc_50();					
					e.setDirectionAndVelocity( ti.dx_50,  ti.dy_50, ti.dz_50, 25.25f + spd, 0.01f * acu);

				}else {
					e.setDirectionAndVelocity( mx, my, mz, 25.25f + spd, 0.01f * acu);
				}
				
				holder.world.spawnEntityInWorld(e);

				holder.world.playSound("DangerZone:357cal_2", holder.dimension, holder.posx, holder.posy+holder.getHeight(), holder.posz, 1.55f, 1.0f+((holder.world.rand.nextFloat()-holder.world.rand.nextFloat())*0.2f));


				if(DangerZone.isVR && holder instanceof Player) {
					Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 20, holder.dimension, 
							ti.real_posx+(ti.dx_50/2), ti.real_posy+holder.getEyeHeight()+(ti.dy_50/2), ti.real_posz+(ti.dz_50/2),
							0, 0.25f*(holder.getWidth()+holder.getHeight())/4);
					
					Utils.spawnParticlesFromServerScaledWithDirection(holder.world, "DangerZone:ParticleBlast", 50, holder.dimension, 
							ti.real_posx+(ti.dx_50/2), ti.real_posy+holder.getEyeHeight()+(ti.dy_50/2), ti.real_posz+(ti.dz_50/2),
							dx, dy, dz, 0, 0.15f*(holder.getWidth()+holder.getHeight())/4, 1.25f, 0.50f);

					
				}else {
					if(!DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side) {
						Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 20, holder.dimension, 
								holder.posx+(float)Math.sin(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								holder.posy+(holder.getHeight()*9.25f/10f) - (float)Math.sin(Math.toRadians(holder.rotation_pitch_head))*(holder.getWidth()+0.35f),
								holder.posz+(float)Math.cos(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								0, 0.15f*(holder.getWidth()+holder.getHeight())/4);

						Utils.spawnParticlesFromServerScaledWithDirection(holder.world, "DangerZone:ParticleBlast", 50, holder.dimension, 
								holder.posx+(float)Math.sin(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								holder.posy+(holder.getHeight()*9.25f/10f) - (float)Math.sin(Math.toRadians(holder.rotation_pitch_head))*(holder.getWidth()+0.35f),
								holder.posz+(float)Math.cos(Math.toRadians(holder.rotation_yaw_head))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								mx, my, mz, 0, 0.15f*(holder.getWidth()+holder.getHeight())/4, 1.25f, 0.50f);
					}else {
						//particles on the side!
						Utils.spawnParticlesFromServerScaled(holder.world, "DangerZone:ParticleDust", 20, holder.dimension, 
								holder.posx+(float)Math.sin(Math.toRadians(holder.rotation_yaw_head-15))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								holder.posy+(holder.getHeight()*9.25f/10) - (float)Math.sin(Math.toRadians(holder.rotation_pitch_head))*(holder.getWidth()+0.35f),
								holder.posz+(float)Math.cos(Math.toRadians(holder.rotation_yaw_head-15))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								0, 0.15f*(holder.getWidth()+holder.getHeight())/4);

						Utils.spawnParticlesFromServerScaledWithDirection(holder.world, "DangerZone:ParticleBlast", 50, holder.dimension, 
								holder.posx+(float)Math.sin(Math.toRadians(holder.rotation_yaw_head-15))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								holder.posy+(holder.getHeight()*9.25f/10) - (float)Math.sin(Math.toRadians(holder.rotation_pitch_head))*(holder.getWidth()+0.35f),
								holder.posz+(float)Math.cos(Math.toRadians(holder.rotation_yaw_head-15))*(holder.getWidth()+0.35f)*(float)Math.cos(Math.toRadians(holder.rotation_pitch_head)),
								mx, my, mz, 0, 0.15f*(holder.getWidth()+holder.getHeight())/4, 1.25f, 0.50f);

					}
				}
				
				holder.addKnockback(e, 0.3f, 0.1f); // knockback!!!
			
			}else{
				return false;
			}

			if(holder instanceof Player){
				if(holder.getGameMode() != GameModes.SURVIVAL){
					return false; //Don't decrement arrows (below), and don't bother with uses either...
				}
			}
			return true; //inc currentuses...
		}else {
			if(this.maxuses-ic.currentuses <= 1)return false; //EMPTY!!!
			if(held < getfullholdcount())return false; //Not ready!!!
			DangerZone.hit_pulse(3000);
		}
		return false;

	}
	
	
	public float getfullholdcount(){
		//time to get ready
		//holdcount is roughly 100ths of a second
		return 20;
	}


}
