package dangerzone.gui;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.ArrayList;
import java.util.Iterator;

import org.lwjgl.opengl.GL11;

import slick.Texture;
import dangerzone.DangerZone;
import dangerzone.GameModes;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.Dimensions;




public class PlayerVRGUI extends GuiInterface {

	int show_edges = 0;
	
	private class MyButtonHandler extends ButtonHandler {
		
		
		MyButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int i){
			super(xpos, ypos, bxsize, bysize, tx, ot, i);
		}
		
		public void leftclickhandler(){
			DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
			DangerZone.click_pulse(100);
			if(buttonid == 0){
				ImAllDone();
			}
			
			if(buttonid == 1111){
				DangerZone.gameover = 1;
				ImAllDone();
			}
			//Function keys
			
			
			if(buttonid == 2){
				Utils.screenshot(DangerZone.screen_width, DangerZone.screen_height);
				DangerZone.messagestring = "Screenshot!";
				DangerZone.messagetimer = 60;
			}
			if(buttonid == 3){
				//show some stats
				if(DangerZone.f3_on){
					DangerZone.f3_on = false;
				}else{
					DangerZone.f3_on = true;
					DangerZone.f12_on = false;
				}
			}			
			if (buttonid == 4){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.statsgui);				
			}
			if (buttonid == 5){
				//show me!!!
				if(DangerZone.f5_front){
					DangerZone.f5_front = false;
					DangerZone.f5_back = true;
				}else{
					if(DangerZone.f5_back){
						DangerZone.f5_back = false;
					}else{
						DangerZone.f5_front = true;
					}
				}
			}
			if (buttonid == 6){
				if(DangerZone.player.getGameMode() != GameModes.SURVIVAL){
					if(DangerZone.view_ores){
						DangerZone.view_ores = false;
					}else{
						DangerZone.view_ores = true;
					}
				}
			}
			if (buttonid == 7){
					if(DangerZone.overlays_on){
						DangerZone.overlays_on = false;
					}else{
						DangerZone.overlays_on = true;
					}
			}

			if (buttonid == 11){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.todogui);
				
			}
			
			
			
			//regular keys
			if(buttonid == 13){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.escapegui);
			}
			if(buttonid == 14){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.inventorygui);
			}				
			if(buttonid == 15){
				//change gamemode
				if(DangerZone.player.getGameMode() == GameModes.SURVIVAL){
					DangerZone.player.server_connection.changeGameMode(GameModes.GHOST);
				}else if(DangerZone.player.getGameMode() == GameModes.GHOST){
					DangerZone.player.server_connection.changeGameMode(GameModes.CREATIVE);
				}else if(DangerZone.player.getGameMode() == GameModes.CREATIVE){
					DangerZone.player.server_connection.changeGameMode(GameModes.SURVIVAL);
				}else{
					DangerZone.player.server_connection.changeGameMode(GameModes.SURVIVAL);
				}
			}
			if(buttonid == 16){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.helpgui);
			}	
			if(buttonid == 17){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.chatgui);
			}	
			if(buttonid == 18){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.commandgui);
			}				
			if(buttonid == 19){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.entitygui);
			}
			if(buttonid == 20){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.dronegui);
			}
			if(buttonid == 21){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.statsgui);
			}
			if(buttonid == 22){
				ImAllDone();
				DangerZone.setActiveGui(DangerZone.todogui);
			}
			if(buttonid == 23){
				for(int i=0;i<Dimensions.dimensionsMAX;i++){
					int id = (DangerZone.player.dimension+i+1)%Dimensions.dimensionsMAX;
					if(Dimensions.DimensionArray[id] != null){
						if(!Dimensions.DimensionArray[id].special_hidden){
							//System.out.printf("requesting switch to %d:%s\n", id, Dimensions.DimensionArray[id].uniquename);
							Dimensions.DimensionArray[id].teleportToDimension(DangerZone.player, DangerZone.world, id, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
							break;
						}
					}
				}
			}
			if(buttonid == 24){
				for(int i=0;i<Dimensions.dimensionsMAX;i++){
					int id = (DangerZone.player.dimension-i-1)%Dimensions.dimensionsMAX;
					while(id<0)id += Dimensions.dimensionsMAX;
					if(Dimensions.DimensionArray[id] != null){
						if(!Dimensions.DimensionArray[id].special_hidden){
							//System.out.printf("requesting switch to %d:%s\n", id, Dimensions.DimensionArray[id].uniquename);
							Dimensions.DimensionArray[id].teleportToDimension(DangerZone.player, DangerZone.world, id, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
							break;
						}
					}
				}
			}
			if(buttonid == 25){
				Dimensions.DimensionArray[1].teleportToDimension(DangerZone.player, DangerZone.world, 1, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
			}
			
			if(buttonid == 26 || buttonid == 126){
				DangerZone.lr_eye_skew++;
				if(DangerZone.lr_eye_skew > 1000)DangerZone.lr_eye_skew = 1000;
				show_edges = 600;
			}
			if(buttonid == 27 || buttonid == 127){
				DangerZone.lr_eye_skew--;
				if(DangerZone.lr_eye_skew < -1000)DangerZone.lr_eye_skew = -1000;
				show_edges = 600;
			}
			if(buttonid == 28 || buttonid == 128){
				DangerZone.use_height++;
				if(DangerZone.use_height > 5000)DangerZone.use_height = 5000;
				show_edges = 600;
			}
			if(buttonid == 29 || buttonid == 129){
				DangerZone.use_height--;
				if(DangerZone.use_height < 500)DangerZone.use_height = 500;
				show_edges = 600;
			}
			if(buttonid == 30 || buttonid == 130){
				DangerZone.use_width++;
				if(DangerZone.use_width > 10000)DangerZone.use_width = 10000;
				show_edges = 600;
			}
			if(buttonid == 31 || buttonid == 131){
				DangerZone.use_width--;
				if(DangerZone.use_width < 1000)DangerZone.use_width = 1000;
				show_edges = 600;
			}
			if(buttonid == 32 || buttonid == 132){
				DangerZone.height_adjust++;
				if(DangerZone.height_adjust > 1000)DangerZone.height_adjust = 1000;
				show_edges = 600;
			}
			if(buttonid == 33 || buttonid == 133){
				DangerZone.height_adjust--;
				if(DangerZone.height_adjust < -1000)DangerZone.height_adjust = -1000;
				show_edges = 600;
			}

			if(buttonid == 37){
				DangerZone.ipd += 0.1f;
				if(DangerZone.ipd > 2)DangerZone.ipd = 2;
			}
			if(buttonid == 38){
				DangerZone.ipd -= 0.1f;
				if(DangerZone.ipd < 0.0f)DangerZone.ipd = 0.0f;
			}
			if(buttonid == 39 || buttonid == 139){
				DangerZone.vrha += 0.01f;
				if(DangerZone.vrha > 2)DangerZone.vrha = 2;
			}
			if(buttonid == 40 || buttonid == 140){
				DangerZone.vrha -= 0.01f;
				if(DangerZone.vrha < -2f)DangerZone.vrha = -2f;
			}
			if(buttonid == 43){
				DangerZone.refresh_rate = 60;
			}
			if(buttonid == 44){
				DangerZone.refresh_rate = 90;
			}
			if(buttonid == 45){
				DangerZone.refresh_rate = 120;
			}
			
			if(buttonid == 46){
				DangerZone.vr_max_entity += 10;
				if(DangerZone.vr_max_entity > 1500)DangerZone.vr_max_entity = 1500;
			}
			if(buttonid == 47){
				DangerZone.vr_max_entity -= 10;
				if(DangerZone.vr_max_entity < 10)DangerZone.vr_max_entity = 10;
			}
			
			if(buttonid == 48){
				DangerZone.vr_max_particle += 100;
				if(DangerZone.vr_max_particle > 10000)DangerZone.vr_max_particle = 10000;
			}
			if(buttonid == 49){
				DangerZone.vr_max_particle -= 100;
				if(DangerZone.vr_max_particle < 500)DangerZone.vr_max_particle = 500;
			}

			
		}
		
		public void rightclickhandler(){
			leftclickhandler();
		}
	}
	
	public PlayerVRGUI(){
		super();
		show_edges = 0;
	}
	
	/*
	 * Nice reasonably simple button event processing....
	 */
	public void process(int mode){
		Texture backtexture = null;
		Texture buttontexture = null;
		Texture exittexture = null;

		backtexture = TextureMapper.getTexture("res/menus/"+"back.png");
		buttontexture = TextureMapper.getTexture("res/menus/"+"button.png");
		exittexture = TextureMapper.getTexture("res/menus/"+"exit.png");


		std_setup(mode);
		GL11.glColor3f(1,1,1); //because text messes this up!
		
		
		if(show_edges > 0) {
			show_edges--;
			textAt(left_of_display + 200, top_of_display - 10, "---------- Top Top Top Top Top Top Top Top Top ----------");
			textAt(left_of_display + 200, bottom_of_display,          "---------- Bottom Bottom Bottom Bottom Bottom -----------");
			for(int i=0;i<1000;i+=50) {
				textAt(left_of_display, (top_of_display - 200) - i, "Left");
			}
		}
		

		//Build the button list... 
		buttons = new ArrayList<ButtonHandler>();
		buttons.add(new MyButtonHandler(middle - 150, starty - 150, 100, 100, backtexture, null, 0));
		buttons.add(new MyButtonHandler(middle + 50, starty - 150, 100, 100, exittexture, null, 1111));

		startx += 250;
		starty += 100; //pull the rest up.

		buttons.add(new MyButtonHandler(startx + 150, starty - 400, 75, 25, buttontexture, "F1", 1));
		buttons.add(new MyButtonHandler(startx + 250, starty - 400, 75, 25, buttontexture, "F2", 2));
		buttons.add(new MyButtonHandler(startx + 350, starty - 400, 75, 25, buttontexture, "F3", 3));
		buttons.add(new MyButtonHandler(startx + 450, starty - 400, 75, 25, buttontexture, "F4", 4));
		buttons.add(new MyButtonHandler(startx + 550, starty - 400, 75, 25, buttontexture, "F5", 5));
		buttons.add(new MyButtonHandler(startx + 650, starty - 400, 75, 25, buttontexture, "F6", 6));

		buttons.add(new MyButtonHandler(startx + 150, starty - 450, 75, 25, buttontexture, "F7", 7));
		buttons.add(new MyButtonHandler(startx + 250, starty - 450, 75, 25, buttontexture, "F8", 8));
		buttons.add(new MyButtonHandler(startx + 350, starty - 450, 75, 25, buttontexture, "F9", 9));
		buttons.add(new MyButtonHandler(startx + 450, starty - 450, 75, 25, buttontexture, "F10", 10));
		buttons.add(new MyButtonHandler(startx + 550, starty - 450, 75, 25, buttontexture, "F11", 11));
		buttons.add(new MyButtonHandler(startx + 650, starty - 450, 75, 25, buttontexture, "F12", 12));

		startx -= 150;
		buttons.add(new MyButtonHandler(startx + 200, starty - 550, 175, 25, buttontexture, "Entities", 19)); 
		buttons.add(new MyButtonHandler(startx + 200, starty - 600, 175, 25, buttontexture, "Drone", 20)); 
		buttons.add(new MyButtonHandler(startx + 200, starty - 650, 175, 25, buttontexture, "Stats", 21)); 
		buttons.add(new MyButtonHandler(startx + 200, starty - 700, 175, 25, buttontexture, "To Do", 22)); 
		buttons.add(new MyButtonHandler(startx + 200, starty - 750, 175, 25, buttontexture, "Dimension +", 23)); 
		buttons.add(new MyButtonHandler(startx + 200, starty - 800, 175, 25, buttontexture, "Dimension -", 24)); 
		buttons.add(new MyButtonHandler(startx + 200, starty - 850, 175, 25, buttontexture, "Dimension 0", 25)); 




		textAt(startx, starty - 900, "L/R Eye Skew:");
		textAt(startx + 520, starty - 900, String.format("LRS: %d", DangerZone.lr_eye_skew));
		buttons.add(new MyButtonHandler(startx + 200, starty - 900, 75, 25, buttontexture, "More", 26));
		buttons.add(new MyButtonHandler(startx + 300, starty - 900, 75, 25, buttontexture, "Less", 27));
		buttons.add(new MyButtonHandler(startx + 400, starty - 900, 50, 25, buttontexture, "<<", 127));
		buttons.add(new MyButtonHandler(startx + 450, starty - 900, 50, 25, buttontexture, ">>", 126));

		textAt(startx, starty - 950, "Usable Height:");
		textAt(startx + 520, starty - 950, String.format("UHT: %d", DangerZone.use_height));
		buttons.add(new MyButtonHandler(startx + 200, starty - 950, 75, 25, buttontexture, "More", 28));
		buttons.add(new MyButtonHandler(startx + 300, starty - 950, 75, 25, buttontexture, "Less", 29));
		buttons.add(new MyButtonHandler(startx + 400, starty - 950, 50, 25, buttontexture, "<<", 129));
		buttons.add(new MyButtonHandler(startx + 450, starty - 950, 50, 25, buttontexture, ">>", 128));

		textAt(startx, starty - 1000, "Usable Width:");
		textAt(startx + 520, starty - 1000, String.format("UWT: %d", DangerZone.use_width));
		buttons.add(new MyButtonHandler(startx + 200, starty - 1000, 75, 25, buttontexture, "More", 30));
		buttons.add(new MyButtonHandler(startx + 300, starty - 1000, 75, 25, buttontexture, "Less", 31));
		buttons.add(new MyButtonHandler(startx + 400, starty - 1000, 50, 25, buttontexture, "<<", 131));
		buttons.add(new MyButtonHandler(startx + 450, starty - 1000, 50, 25, buttontexture, ">>", 130));

		textAt(startx, starty - 1050, "Up/Down Adjust:");
		textAt(startx + 520, starty - 1050, String.format("UDA: %d", DangerZone.height_adjust));
		buttons.add(new MyButtonHandler(startx + 200, starty - 1050, 75, 25, buttontexture, "More", 32));
		buttons.add(new MyButtonHandler(startx + 300, starty - 1050, 75, 25, buttontexture, "Less", 33));
		buttons.add(new MyButtonHandler(startx + 400, starty - 1050, 50, 25, buttontexture, "<<", 133));
		buttons.add(new MyButtonHandler(startx + 450, starty - 1050, 50, 25, buttontexture, ">>", 132));
		
		textAt(startx, starty - 1100, "Max Entity:");
		textAt(startx + 460, starty - 1100, String.format("MXI: %d", DangerZone.vr_max_entity));
		buttons.add(new MyButtonHandler(startx + 200, starty - 1100, 75, 25, buttontexture, "More", 46));
		buttons.add(new MyButtonHandler(startx + 300, starty - 1100, 75, 25, buttontexture, "Less", 47));

		textAt(startx, starty - 1150, "Max Particle:");
		textAt(startx + 460, starty - 1150, String.format("MXP: %d", DangerZone.vr_max_particle));
		buttons.add(new MyButtonHandler(startx + 200, starty - 1150, 75, 25, buttontexture, "More", 48));
		buttons.add(new MyButtonHandler(startx + 300, starty - 1150, 75, 25, buttontexture, "Less", 49));



		buttons.add(new MyButtonHandler(middle, starty - 550, 175, 25, buttontexture, "Escape", 13));
		buttons.add(new MyButtonHandler(middle, starty - 600, 175, 25, buttontexture, "Inventory", 14)); 
		buttons.add(new MyButtonHandler(middle, starty - 650, 175, 25, buttontexture, "Game Mode", 15)); 
		String stringmode = ": Unknown";		
		if(DangerZone.player.getGameMode() == GameModes.SURVIVAL)stringmode = ": Survival";
		if(DangerZone.player.getGameMode() == GameModes.GHOST)stringmode = ": Ghost";
		if(DangerZone.player.getGameMode() == GameModes.CREATIVE)stringmode = ": Creative";		
		textAt( middle + 225, starty-650,  stringmode);

		buttons.add(new MyButtonHandler(middle, starty - 700, 175, 25, buttontexture, "Help", 16)); 
		buttons.add(new MyButtonHandler(middle, starty - 750, 175, 25, buttontexture, "Chat", 17)); 
		buttons.add(new MyButtonHandler(middle, starty - 800, 175, 25, buttontexture, "Command", 18)); 





		buttons.add(new MyButtonHandler(middle + 250, starty - 900, 75, 25, buttontexture, "More", 37));
		buttons.add(new MyButtonHandler(middle + 350, starty - 900, 75, 25, buttontexture, "Less", 38));

		buttons.add(new MyButtonHandler(middle + 250, starty - 950, 75, 25, buttontexture, "More", 39));
		buttons.add(new MyButtonHandler(middle + 350, starty - 950, 75, 25, buttontexture, "Less", 40));
		buttons.add(new MyButtonHandler(middle + 450, starty - 950, 50, 25, buttontexture, "<<", 140));
		buttons.add(new MyButtonHandler(middle + 500, starty - 950, 50, 25, buttontexture, ">>", 139));

		buttons.add(new MyButtonHandler(middle + 250, starty - 1000, 75, 25, buttontexture, "60", 43));
		buttons.add(new MyButtonHandler(middle + 350, starty - 1000, 75, 25, buttontexture, "90", 44));
		buttons.add(new MyButtonHandler(middle + 450, starty - 1000, 75, 25, buttontexture, "120", 45));

		textAt( middle + 50, starty - 900, "Pupil Distance:");
		textAt( middle + 460, starty - 900, String.format("IPD: %f", DangerZone.ipd));

		textAt( middle + 50, starty - 950, "Height Adjust:");
		textAt( middle + 550, starty - 950, String.format("VHA: %f :: %f", DangerZone.vrha, (float)DangerZone.lasty));

		textAt(middle +  50, starty - 1000, "Refresh Rate:");
		textAt(middle +  560, starty - 1000, String.format("RRT: %d", DangerZone.refresh_rate));				




		int high_button = std_draw(mode);
		
		if(mode == 1) {
			TargetInfo ti = DangerZone.vr_is_down();
			if(ti != null) {
				if( ti == DangerZone.pointer_controller){

					Iterator<ButtonHandler> bb = buttons.iterator();
					ButtonHandler fb = null;
					ButtonHandler mb = null;

					bb = buttons.iterator();
					fb = null;
					while(bb.hasNext()){
						mb = bb.next();
						if(high_button >= 100 && high_button <= 200){
							if(mb.buttonid == high_button) {
								fb = mb;
								break;
							}
						}
					}

					//did we find a ff fr button?
					if(fb != null)fb.leftclickhandler();
				}
			}
		}

		std_clicker(mode, high_button);

	}
	

}
