package dangerzone.gui;
import static org.lwjgl.openvr.VRSystem.VRSystem_GetControllerState;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import org.lwjgl.openvr.VRControllerState;

import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.GameModes;
import dangerzone.entities.Drone;
import dangerzone.entities.Entity;
import dangerzone.rendering.TextureMapper;
import slick.Texture;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class PlayerDroneGUI extends GuiInterface {
	
	private class MyButtonHandler extends ButtonHandler {
		
		
		MyButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int i){
			super(xpos, ypos, bxsize, bysize, tx, ot, i);
		}
		
		public void leftclickhandler(){
			DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
			DangerZone.click_pulse(100);
			if(buttonid <= 0){
				DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_ESCAPE, true);
				ImAllDone();
				return;
			}
						
			if(buttonid == 1){
				droneview = !droneview;
				if(!droneview)DangerZone.wr.ViewFromEntity = DangerZone.player;
				if(droneview)DangerZone.wr.ViewFromEntity = droneentity;
			}
			if(buttonid == 2){
				dronecontrol = !dronecontrol;
			}
					
			if (buttonid == 5){
				//show me!!!
				if(DangerZone.f5_front){
					DangerZone.f5_front = false;
					DangerZone.f5_back = true;
				}else{
					if(DangerZone.f5_back){
						DangerZone.f5_back = false;
					}else{
						DangerZone.f5_front = true;
					}
				}
			}


		}
		
		public void rightclickhandler(){
			leftclickhandler();
		}
	}
	

	Drone droneentity = null;
	int connection_tries = 300;
	boolean droneview = false;
	boolean dronecontrol = true;
	float accel;
	int gofasttimer, flytimer, gofly, gofast;
	
	public PlayerDroneGUI(){
		super();
		grab_mouse = true;
		droneview = false;
		accel = 0;
		gofasttimer = flytimer = gofast = gofly = 0;
	}
	
	
	
	/*
	 * Fly a drone!
	 * 
	 */
	public void process(int mode){
		Texture backtexture = null;
		Texture buttontexture = null;
		Texture exittexture = null;
		backtexture = TextureMapper.getTexture("res/menus/"+"back.png");
		buttontexture = TextureMapper.getTexture("res/menus/"+"button.png");
		exittexture = TextureMapper.getTexture("res/menus/"+"exit.png");
		
		std_setup(mode);
		
		if(droneview){
			textAt(startx+50, bottom_of_display+100, "DRONE VIEW");
		}else{
			textAt(startx+50, bottom_of_display+100, "PLAYER VIEW");
			if(dronecontrol){
				textAt(startx+50, bottom_of_display+60, "DRONE CONTROL");
			}else{
				textAt(startx+50, bottom_of_display+60, "PLAYER CONTROL");
			}
		}
		
		if(mode == 0) {
			smallTextAt(startx+50, bottom_of_display+160, "Arrow up/down - Claw up/down");
			smallTextAt(startx+50, bottom_of_display+190, "Arrow left/right - Claw open/close");
			smallTextAt(startx+50, bottom_of_display+220, "T - toggle Player/Drone View");
			smallTextAt(startx+50, bottom_of_display+250, "R - toggle Player/Drone Control");
		}else {
			//add some buttons for VR!
			buttons = new ArrayList<ButtonHandler>();
			buttons.add(new MyButtonHandler(middle - 150, starty - 200, 100, 100, backtexture, null, 0));
			buttons.add(new MyButtonHandler(middle - 150, starty - 300, 100, 100, exittexture, null, -1));
			buttons.add(new MyButtonHandler(startx + 150, starty - 400, 275, 25, buttontexture, "Player/Drone View", 1));
			buttons.add(new MyButtonHandler(startx + 150, starty - 450, 275, 25, buttontexture, "Player/Drone Control", 2));
			buttons.add(new MyButtonHandler(startx + 150, starty - 500, 75, 25, buttontexture, "F5", 5));
		}
		
		
		
		if(droneentity == null){
			textAt(startx+120, bottom_of_display+120, "Connecting....");
			connection_tries--;
			if(connection_tries <= 0){
				ImAllDone();
				return;
			}
			
			List<Entity> nearby_list = null;
			//Get a list of entities within reach of largest mob expected because we may hit their hitbox!
			nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(10, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz);
			if(nearby_list != null){
				if(!nearby_list.isEmpty()){
					Entity e = null;
					ListIterator<Entity> li;
					li = nearby_list.listIterator();
					while(li.hasNext()){
						e = (Entity)li.next();												
						if(e instanceof Drone){
							//DangerZone.wr.ViewFromEntity = e;
							droneentity = (Drone)e;
							break;
						}		
					}					
				}								
			}			
		}
		
		if(droneentity == null)return;
		if(droneentity.deadflag){
			ImAllDone();
			return;
		}
		
		GL11.glColor3f(1,1,1); //because text messes this up!
		int high_button = std_draw(mode);
		
		if(!DangerZone.isVR) {

			if(droneview){

				//drone is controlled through the player, so get inputs and set them (without actually moving the player!)

				while (DangerZone.K_next()) {	

					//toggle view!
					if (DangerZone.K_getEventKey() == GLFW.GLFW_KEY_T && DangerZone.K_isKeyDown(GLFW.GLFW_KEY_T)){
						droneview = false;
						DangerZone.wr.ViewFromEntity = DangerZone.player;
					}

					//Look at self, of course...
					if (DangerZone.K_getEventKey() == GLFW.GLFW_KEY_F5 && DangerZone.K_isKeyDown(GLFW.GLFW_KEY_F5)){
						//show me!!!
						if(DangerZone.f5_front){
							DangerZone.f5_front = false;
							DangerZone.f5_back = true;
						}else{
							if(DangerZone.f5_back){
								DangerZone.f5_back = false;
							}else{
								DangerZone.f5_front = true;
							}
						}
					}

					//forward all key events to the drone. It can figure out what to do with them...
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, DangerZone.K_getEventKey(), DangerZone.K_isKeyDown(DangerZone.K_getEventKey()));

				}

				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_SPACE)){
					DangerZone.player.setUp(true);
				}else{
					DangerZone.player.setUp(false);
				}
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)){
					DangerZone.player.setDown(true);
				}else{
					DangerZone.player.setDown(false);
				}
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_W)){
					DangerZone.player.setForward(true);
				}else{
					DangerZone.player.setForward(false);
				}
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_S)){
					DangerZone.player.setBackward(true);
				}else{
					DangerZone.player.setBackward(false);
				}
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_A)){
					DangerZone.player.setLeft(true);
				}else{
					DangerZone.player.setLeft(false);
				}
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_D)){
					DangerZone.player.setRight(true);
				}else{
					DangerZone.player.setRight(false);
				}

				//emergency exit!
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_ESCAPE, true);
					ImAllDone();
					return;
				}

				//adjust where looking with mouse...
				//makes player look around... kinda funny! :)
				float dx, dy;		
				while(DangerZone.M_next()){
					//System.out.printf("Mouse!\n");
					dx = DangerZone.M_getCurDX();
					dx *= 0.1f + (0.01f * (float)DangerZone.mouseSensitivity);
					dy = DangerZone.M_getCurDY();
					dy *= 0.1f + (0.01f * (float)DangerZone.mouseSensitivity);

					DangerZone.player.rotation_yaw_head += dx; //normal
					if(DangerZone.player.rotation_yaw_head < 0)DangerZone.player.rotation_yaw_head += 360;
					DangerZone.player.rotation_yaw_head = DangerZone.player.rotation_yaw_head%360;		
					DangerZone.player.rotation_pitch_head -= dy;
					DangerZone.player.rotation_pitch_head = DangerZone.player.rotation_pitch_head%360;

					if(DangerZone.player.rotation_pitch_head > 180){
						if(DangerZone.player.rotation_pitch_head < 270)DangerZone.player.rotation_pitch_head = 270;
					}else{
						if(DangerZone.player.rotation_pitch_head > 90)DangerZone.player.rotation_pitch_head = 90;
					}

					//send button clicks to entity!
					if(DangerZone.M_getEventButtonState()){	
						//System.out.printf("DOWN: %d\n", Mouse.getEventButton());
						if(DangerZone.M_getEventButton() >= 0)DangerZone.player.server_connection.sendMouseEventToEntity(droneentity.entityID, DangerZone.M_getEventButton(), true);
					}else{
						//Mouse button released!
						if(DangerZone.M_getEventButton() >= 0)DangerZone.player.server_connection.sendMouseEventToEntity(droneentity.entityID, DangerZone.M_getEventButton(), false);
					}

				}
			}else{

				//minimal player functionality while flying drone.
				//not sure I like the way I did this though...
				//
				accel -= 0.05f;
				if(accel < 0.1f)accel = 0.1f;
				if(flytimer > 0)flytimer--;
				if(gofasttimer > 0)gofasttimer--;

				while (DangerZone.K_next()) {	
					if (DangerZone.K_getEventKey() == GLFW.GLFW_KEY_W && DangerZone.K_isKeyDown(GLFW.GLFW_KEY_W)){
						if(gofasttimer != 0)gofast = 1;
						gofasttimer = 20;
					}

					if (DangerZone.K_getEventKey() == GLFW.GLFW_KEY_SPACE && DangerZone.K_isKeyDown(GLFW.GLFW_KEY_SPACE)){
						if(flytimer != 0)gofly = 1;
						flytimer = 20;
					}

					//Look at self, of course...
					if (DangerZone.K_getEventKey() == GLFW.GLFW_KEY_F5 && DangerZone.K_isKeyDown(GLFW.GLFW_KEY_F5)){
						//show me!!!
						if(DangerZone.f5_front){
							DangerZone.f5_front = false;
							DangerZone.f5_back = true;
						}else{
							if(DangerZone.f5_back){
								DangerZone.f5_back = false;
							}else{
								DangerZone.f5_front = true;
							}
						}
					}

					//toggle view!
					if (DangerZone.K_getEventKey() == GLFW.GLFW_KEY_T && DangerZone.K_isKeyDown(GLFW.GLFW_KEY_T)){
						droneview = true;
						DangerZone.wr.ViewFromEntity = droneentity;
					}
					//toggle control!
					if (DangerZone.K_getEventKey() == GLFW.GLFW_KEY_R && DangerZone.K_isKeyDown(GLFW.GLFW_KEY_R)){
						dronecontrol = !dronecontrol;
					}

					//forward all up/down key events to the drone. It can figure out what to do with them...
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, DangerZone.K_getEventKey(), DangerZone.K_isKeyDown(DangerZone.K_getEventKey()));

				}

				if(dronecontrol){
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_SPACE)){
						DangerZone.player.setUp(true);
					}else{
						DangerZone.player.setUp(false);
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)){
						DangerZone.player.setDown(true);
					}else{
						DangerZone.player.setDown(false);
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_W)){
						DangerZone.player.setForward(true);
					}else{
						DangerZone.player.setForward(false);
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_S)){
						DangerZone.player.setBackward(true);
					}else{
						DangerZone.player.setBackward(false);
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_A)){
						DangerZone.player.setLeft(true);
					}else{
						DangerZone.player.setLeft(false);
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_D)){
						DangerZone.player.setRight(true);
					}else{
						DangerZone.player.setRight(false);
					}
				}else{
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_SPACE)){
						if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.isFlying()){
							DangerZone.player.motiony += 0.055f*DangerZone.deltaT*accel;
							accel += 0.1f;
							if(accel > 1)accel = 1;
						}else{
							if(DangerZone.player.getOnGround() || DangerZone.player.getInLiquid()){
								DangerZone.player.jump();
							}
							if(gofly != 0)DangerZone.player.tryfly();
						}
					}else{
						gofly = 0;
					}

					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)){
						if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.isFlying()){
							DangerZone.player.motiony -= 0.055f*DangerZone.deltaT*accel;
							accel += 0.1f;
							if(accel > 1)accel = 1;
						}
					}

					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_W)){
						float speed = 0.042f*accel;
						if(DangerZone.player.getGameMode() != GameModes.GHOST && 
								(DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy+2, (int)DangerZone.player.posz) != 0
								|| DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy+3, (int)DangerZone.player.posz) != 0 ))speed *= 0.70f;
						accel += 0.2f;
						if(accel > 1)accel = 1;
						if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.isFlying()){
							speed *= 4.0f;
						}else{
							if(gofast != 0)speed *= 2.5f;
						}
						float effectspeed;
						effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
						if(effectspeed > 1){
							speed *= effectspeed;
						}
						effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
						if(effectspeed > 1){
							speed /= effectspeed;
						}
						DangerZone.player.motionx += speed*Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*DangerZone.deltaT;
						DangerZone.player.motionz += speed*Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*DangerZone.deltaT;
					}else{
						gofast = 0;
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_S)){
						float speed = 0.030f*accel;
						accel += 0.1f;
						if(accel > 1)accel = 1;
						if(DangerZone.player.getGameMode() == GameModes.GHOST)speed *= 2.5f;
						float effectspeed;
						effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
						if(effectspeed > 1){
							speed *= effectspeed;
						}
						effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
						if(effectspeed > 1){
							speed /= effectspeed;
						}
						DangerZone.player.motionx -= speed*Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*DangerZone.deltaT;
						DangerZone.player.motionz -= speed*Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head-90))*DangerZone.deltaT;
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_A)){
						float speed = 0.030f*accel;
						accel += 0.1f;
						if(accel > 1)accel = 1;
						if(DangerZone.player.getGameMode() == GameModes.GHOST)speed *= 2.5f;
						float effectspeed;
						effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
						if(effectspeed > 1){
							speed *= effectspeed;
						}
						effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
						if(effectspeed > 1){
							speed /= effectspeed;
						}
						DangerZone.player.motionx += speed*Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head-180))*DangerZone.deltaT;
						DangerZone.player.motionz += speed*Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head-180))*DangerZone.deltaT;
					}
					if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_D)){
						float speed = 0.030f*accel;
						accel += 0.1f;
						if(accel > 1)accel = 1;
						if(DangerZone.player.getGameMode() == GameModes.GHOST)speed *= 2.5f;
						float effectspeed;
						effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
						if(effectspeed > 1){
							speed *= effectspeed;
						}
						effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
						if(effectspeed > 1){
							speed /= effectspeed;
						}
						DangerZone.player.motionx -= speed*Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head-180))*DangerZone.deltaT;
						DangerZone.player.motionz -= speed*Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head-180))*DangerZone.deltaT;
					}
				}

				//emergency exit!
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_ESCAPE, true);
					ImAllDone();
					return;
				}

				//adjust where looking with mouse...
				//makes player look around... kinda funny! :)
				float dx, dy;		
				while(DangerZone.M_next()){
					//System.out.printf("Mouse!\n");
					dx = DangerZone.M_getEventDX();
					dx *= 0.1f + (0.01f * (float)DangerZone.mouseSensitivity);
					dy = DangerZone.M_getEventDY();
					dy *= 0.1f + (0.01f * (float)DangerZone.mouseSensitivity);

					DangerZone.player.rotation_yaw_head += dx; //normal
					if(DangerZone.player.rotation_yaw_head < 0)DangerZone.player.rotation_yaw_head += 360;
					DangerZone.player.rotation_yaw_head = DangerZone.player.rotation_yaw_head%360;		
					DangerZone.player.rotation_pitch_head -= dy;
					DangerZone.player.rotation_pitch_head = DangerZone.player.rotation_pitch_head%360;

					if(DangerZone.player.rotation_pitch_head > 180){
						if(DangerZone.player.rotation_pitch_head < 270)DangerZone.player.rotation_pitch_head = 270;
					}else{
						if(DangerZone.player.rotation_pitch_head > 90)DangerZone.player.rotation_pitch_head = 90;
					}

					if(dronecontrol){
						//send button clicks to entity!
						if(DangerZone.M_getEventButtonState()){	
							//System.out.printf("DOWN: %d\n", Mouse.getEventButton());
							if(DangerZone.M_getEventButton() >= 0)DangerZone.player.server_connection.sendMouseEventToEntity(droneentity.entityID, DangerZone.M_getEventButton(), true);
						}else{
							//Mouse button released!
							if(DangerZone.M_getEventButton() >= 0)DangerZone.player.server_connection.sendMouseEventToEntity(droneentity.entityID, DangerZone.M_getEventButton(), false);
						}	
					}

				}
			}
		}

		if(mode == 1){
			//------------------------------------------------------------------------------------------------------------------------------------
			//------------------------------------------------------------------------------------------------------------------------------------
			//------------------------------------------------------------------------------------------------------------------------------------
			
			while (DangerZone.K_next()) {	
				//emergency exit!
				if (DangerZone.K_isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_ESCAPE, true);
					ImAllDone();
					return;
				}
			}
			
			
			std_clicker(mode, high_button);
			if(droneentity == null)return; //exit maybe clicked!
			
			VRControllerState motion_state;
			VRControllerState non_motion_state;
			
			VRSystem_GetControllerState(DangerZone.left_hand_index, DangerZone.left_state);
			VRSystem_GetControllerState(DangerZone.right_hand_index, DangerZone.right_state);
			
			motion_state = DangerZone.left_state;
			non_motion_state = DangerZone.right_state;
			
			if(DangerZone.motion_controller == DangerZone.right_controller) {
				motion_state = DangerZone.right_state;
				non_motion_state = DangerZone.left_state;
			}
			
			
			if(droneview || dronecontrol){

				//drone is controlled through the player, so get inputs and set them (without actually moving the player!)
				

				//Keys processed: up, down (for claw up/down), left, right (for claw open/close), escape = die
				if(Math.abs(non_motion_state.rAxis(DangerZone.trackpad_index).y())>0.25f){
					if(non_motion_state.rAxis(DangerZone.trackpad_index).y()>0.25f){	
						DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_UP, true);						
					}
					if(non_motion_state.rAxis(DangerZone.trackpad_index).y()<-0.25f){	
						DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_DOWN, true);
					}	
				}else {
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_DOWN, false);
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_UP, false);			
				}
				
				if(Math.abs(non_motion_state.rAxis(DangerZone.trackpad_index).x())>0.25f){
					if(non_motion_state.rAxis(DangerZone.trackpad_index).x()>0.25f){					
						DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_LEFT, true);						
					}
					if(non_motion_state.rAxis(DangerZone.trackpad_index).x()<-0.25f){						
						DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_RIGHT, true);						
					}
				}else {
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_LEFT, false);
					DangerZone.player.server_connection.sendKeyEventToEntity(droneentity.entityID, GLFW.GLFW_KEY_RIGHT, false);		
				}

				DangerZone.motion_controller.calc_50();
				float move_y = (float) Math.cos(Math.toRadians(DangerZone.motion_controller.pitch_50-90));
				if(move_y > 0.25f) {
					DangerZone.player.setDown(true);
				}else{
					DangerZone.player.setDown(false);
				}					
				if(move_y < -0.25f) {
					DangerZone.player.setUp(true);
				}else{
					DangerZone.player.setUp(false);
				}
							
				if(motion_state.rAxis(DangerZone.trackpad_index).y()>0.25f){	
					DangerZone.player.setForward(true);
				}else{
					DangerZone.player.setForward(false);
				}
				if(motion_state.rAxis(DangerZone.trackpad_index).y()<-0.25f){	
					DangerZone.player.setBackward(true);
				}else{
					DangerZone.player.setBackward(false);
				}
				if(motion_state.rAxis(DangerZone.trackpad_index).x()<-0.25f){	
					DangerZone.player.setLeft(true);
				}else{
					DangerZone.player.setLeft(false);
				}
				if(motion_state.rAxis(DangerZone.trackpad_index).x()>0.25f){	
					DangerZone.player.setRight(true);
				}else{
					DangerZone.player.setRight(false);
				}

	/*
				BUTTON EVENTS? BUTTONS FOR MOUSE BUTTONS?

					//send button clicks to entity!
					if(DangerZone.M_getEventButtonState()){	
						//System.out.printf("DOWN: %d\n", Mouse.getEventButton());
						if(DangerZone.M_getEventButton() >= 0)DangerZone.player.server_connection.sendMouseEventToEntity(droneentity.entityID, DangerZone.M_getEventButton(), true);
					}else{
						//Mouse button released!
						if(DangerZone.M_getEventButton() >= 0)DangerZone.player.server_connection.sendMouseEventToEntity(droneentity.entityID, DangerZone.M_getEventButton(), false);
					}
*/
				
			}else{

				//minimal player functionality while flying drone.
				//not sure I like the way I did this though...
				//
		
	
				float move_x, move_z, move_y;
				
				move_x = motion_state.rAxis(DangerZone.trackpad_index).x();
				move_z = motion_state.rAxis(DangerZone.trackpad_index).y();				
								
				DangerZone.motion_controller.calc_50();
				move_y = (float) Math.cos(Math.toRadians(DangerZone.motion_controller.pitch_50-90));
				

				if (move_z > 0){			
					float speed = 0.042f*accel*Math.abs(move_z*2);
					if(DangerZone.player.getGameMode() != GameModes.GHOST && DangerZone.player.getGameMode() != GameModes.LIMBO && 
							(DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy+2, (int)DangerZone.player.posz) != 0
							|| DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy+3, (int)DangerZone.player.posz) != 0 ))speed *= 0.70f;
					accel += 0.2f;
					if(accel > 1)accel = 1;
					if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.getGameMode() == GameModes.LIMBO || DangerZone.player.isFlying()){
						speed *= 4.0f;
					}else{
						if(gofast != 0)speed *= 2.5f;
					}
					float effectspeed;
					effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
					if(effectspeed > 1){
						speed *= effectspeed;
					}
					effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
					if(effectspeed > 1){
						speed /= effectspeed;
					}
					//System.out.printf("Headset.yaw = %f, sin %f, cos, %f\n",  headset.yaw, (float)Math.sin(Math.toRadians(headset.yaw)), (float)Math.cos(Math.toRadians(headset.yaw)));
					DangerZone.player.motionx += speed*Math.sin(Math.toRadians(DangerZone.headset.yaw));
					DangerZone.player.motionz -= speed*Math.cos(Math.toRadians(DangerZone.headset.yaw));

					//DangerZone.player.setForward(true);
				}else{
					gofast = 0;
					//DangerZone.player.setForward(false);
				}
				if (move_z < 0){
					float speed = 0.030f*accel*Math.abs(move_z*2);
					accel += 0.1f;
					if(accel > 1)accel = 1;
					if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.getGameMode() == GameModes.LIMBO)speed *= 2.5f;
					float effectspeed;
					effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
					if(effectspeed > 1){
						speed *= effectspeed;
					}
					effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
					if(effectspeed > 1){
						speed /= effectspeed;
					}
					DangerZone.player.motionx -= speed*Math.sin(Math.toRadians(DangerZone.headset.yaw));
					DangerZone.player.motionz += speed*Math.cos(Math.toRadians(DangerZone.headset.yaw));

					//DangerZone.player.setBackward(true);
				}else{
					//DangerZone.player.setBackward(false);
				}

				if (move_x < 0){
					float speed = 0.030f*accel*Math.abs(move_x*2);
					accel += 0.1f;
					if(accel > 1)accel = 1;
					if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.getGameMode() == GameModes.LIMBO)speed *= 2.5f;
					float effectspeed;
					effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
					if(effectspeed > 1){
						speed *= effectspeed;
					}
					effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
					if(effectspeed > 1){
						speed /= effectspeed;
					}
					DangerZone.player.motionx -= speed*Math.cos(Math.toRadians(DangerZone.headset.yaw));
					DangerZone.player.motionz -= speed*Math.sin(Math.toRadians(DangerZone.headset.yaw));
					//DangerZone.player.setLeft(true);
				}else{
					//DangerZone.player.setLeft(false);
				}
				if (move_x > 0){
					float speed = 0.030f*accel*Math.abs(move_x*2);
					accel += 0.1f;
					if(accel > 1)accel = 1;
					if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.getGameMode() == GameModes.LIMBO)speed *= 2.5f;
					float effectspeed;
					effectspeed = DangerZone.player.getTotalEffect(Effects.SPEED);
					if(effectspeed > 1){
						speed *= effectspeed;
					}
					effectspeed = DangerZone.player.getTotalEffect(Effects.SLOWNESS);
					if(effectspeed > 1){
						speed /= effectspeed;
					}
					DangerZone.player.motionx += speed*Math.cos(Math.toRadians(DangerZone.headset.yaw));
					DangerZone.player.motionz += speed*Math.sin(Math.toRadians(DangerZone.headset.yaw));
					//DangerZone.player.setRight(true);
				}else{
					//DangerZone.player.setRight(false);
				}
				
				if(move_y < 0) {
					if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.getGameMode() == GameModes.LIMBO || DangerZone.player.isFlying() || DangerZone.player.isLadder()){
						DangerZone.player.motiony += (0.055f-(0.005*DangerZone.character_feel))*accel*Math.abs(move_y);
						accel += 0.1f;
						if(accel > 1)accel = 1;
					}
					//DangerZone.player.setUp(true);
				}else{
					//DangerZone.player.setUp(false);
				}
				
				if (move_y > 0){
					if(DangerZone.player.getGameMode() == GameModes.GHOST || DangerZone.player.getGameMode() == GameModes.LIMBO || DangerZone.player.isFlying() || DangerZone.player.isLadder()){
						DangerZone.player.motiony -= (0.055f-(0.005*DangerZone.character_feel))*accel*Math.abs(move_y);
						accel += 0.1f;
						if(accel > 1)accel = 1;
					}
					//DangerZone.player.setDown(true);
				}else{
					//DangerZone.player.setDown(false);
				}
					

			}	
			

		}

	}
	
	public void ImAllDone(){

		DangerZone.wr.ViewFromEntity = DangerZone.player;
		droneentity = null; //we will look for another one!
		super.ImAllDone();
	}


}
