package dangerzone.gui;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.ArrayList;
import java.util.List;

import org.lwjgl.opengl.GL11;

import slick.Texture;
import dangerzone.DangerZone;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.Dimension;
import dangerzone.world.Dimensions;



public class PlayerDimensionGUI extends GuiInterface {


	private volatile int startat = 0;
	private  List<String> dims = null; 	
	private int num_dim = 0;
	

	
	private class MyButtonHandler extends ButtonHandler {
		
		
		
		MyButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int i){
			super(xpos, ypos, bxsize, bysize, tx, ot, i);
		}
		
		public void leftclickhandler(){
			DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
			DangerZone.click_pulse(100);
			if(buttonid == 0){
				ImAllDone();
			}
			if(buttonid == 7){
				startat += 10;
				if(startat >= num_dim)startat = 0;
			}
			if(buttonid == 8){
				startat -= 10;
				if(startat < 0)startat = 0;
			}
			
			/* dimension 0 is invalid! */
			//display starts at 0, dimensions start at 1
			
			if(buttonid == 10) {
				if(((startat + 0)<num_dim) && Dimensions.DimensionArray[startat + 1] != null) {
					Dimensions.DimensionArray[startat + 1].teleportToDimension(DangerZone.player, DangerZone.world, startat + 1, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 11) {
				if(((startat + 1)<num_dim) && Dimensions.DimensionArray[startat + 2] != null) {
					Dimensions.DimensionArray[startat + 2].teleportToDimension(DangerZone.player, DangerZone.world, startat + 2, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 12) {
				if(((startat + 2)<num_dim) && Dimensions.DimensionArray[startat + 3] != null) {
					Dimensions.DimensionArray[startat + 3].teleportToDimension(DangerZone.player, DangerZone.world, startat + 3, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 13) {
				if(((startat + 3)<num_dim) && Dimensions.DimensionArray[startat + 4] != null) {
					Dimensions.DimensionArray[startat + 4].teleportToDimension(DangerZone.player, DangerZone.world, startat + 4, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 14) {
				if(((startat + 4)<num_dim) && Dimensions.DimensionArray[startat + 5] != null) {
					Dimensions.DimensionArray[startat + 5].teleportToDimension(DangerZone.player, DangerZone.world, startat + 5, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 15) {
				if(((startat + 5)<num_dim) && Dimensions.DimensionArray[startat + 6] != null) {
					Dimensions.DimensionArray[startat + 6].teleportToDimension(DangerZone.player, DangerZone.world, startat + 6, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 16) {
				if(((startat + 6)<num_dim) && Dimensions.DimensionArray[startat + 7] != null) {
					Dimensions.DimensionArray[startat + 7].teleportToDimension(DangerZone.player, DangerZone.world, startat + 7, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 17) {
				if(((startat + 7)<num_dim) && Dimensions.DimensionArray[startat + 8] != null) {
					Dimensions.DimensionArray[startat + 8].teleportToDimension(DangerZone.player, DangerZone.world, startat + 8, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 18) {
				if(((startat + 8)<num_dim) && Dimensions.DimensionArray[startat + 9] != null) {
					Dimensions.DimensionArray[startat + 9].teleportToDimension(DangerZone.player, DangerZone.world, startat + 9, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
			if(buttonid == 19) {
				if(((startat + 9)<num_dim) && Dimensions.DimensionArray[startat + 10] != null) {
					Dimensions.DimensionArray[startat + 10].teleportToDimension(DangerZone.player, DangerZone.world, startat + 10, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz);
				}
			}
		}
		
		public void rightclickhandler(){
			leftclickhandler();
		}
	}
	
	public PlayerDimensionGUI(){
		super();
		dims = new ArrayList<String>();
		num_dim = 0;
	}
	
	/*
	 * Nice reasonably simple button event processing....
	 */
	public void process(int mode){
		Texture backtexture = null;
		Texture buttontexture = null;

		//initialize the dimension array
		if(num_dim == 0) {
			for(int i=0;i<Dimensions.dimensionsMAX;i++) {
				Dimension d = Dimensions.DimensionArray[i];
				if(d != null) {
					dims.add(d.getDisplayName());
					num_dim++;
				}
			}
		}
		
		std_setup(mode);
		GL11.glColor3f(1,1,1); //because text messes this up!
		
		backtexture = TextureMapper.getTexture("res/menus/"+"back.png");
		buttontexture = TextureMapper.getTexture("res/menus/"+"button.png");

		starty -= 100;
		//Build the button list... 
		buttons = new ArrayList<ButtonHandler>();
		buttons.add(new MyButtonHandler(middle - 250, starty - 100, 100, 100, backtexture, null, 0));

		buttons.add(new MyButtonHandler(middle - 50, starty - 100, 75, 25, buttontexture, "Next", 7));
		buttons.add(new MyButtonHandler(middle - 50, starty - 125, 75, 25, buttontexture, "Prev", 8)); 
			


		
		starty -= 100;
		startx += 200;
			
		if(startat + 0 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-200, 475, 25, buttontexture, dims.get(startat + 0), 10));
		if(startat + 1 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-240, 475, 25, buttontexture, dims.get(startat + 1), 11));
		if(startat + 2 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-280, 475, 25, buttontexture, dims.get(startat + 2), 12));
		if(startat + 3 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-320, 475, 25, buttontexture, dims.get(startat + 3), 13));
		if(startat + 4 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-360, 475, 25, buttontexture, dims.get(startat + 4), 14));
		if(startat + 5 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-400, 475, 25, buttontexture, dims.get(startat + 5), 15));
		if(startat + 6 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-440, 475, 25, buttontexture, dims.get(startat + 6), 16));
		if(startat + 7 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-480, 475, 25, buttontexture, dims.get(startat + 7), 17));
		if(startat + 8 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-520, 475, 25, buttontexture, dims.get(startat + 8), 18));
		if(startat + 9 < num_dim)buttons.add(new MyButtonHandler(startx + 250, starty-560, 475, 25, buttontexture, dims.get(startat + 9), 19));

		
		int high_button = std_draw(mode);
		std_clicker(mode, high_button);


	}
	

}