package dangerzone.gui;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */



import java.util.Iterator;
import java.util.List;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import slick.ColorSlick;
import slick.Texture;


import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;

/*
 * Only two routines you need to mess with when inheriting from this interface.
 * Call super() in your constructor,
 * and then override the process() routine.
 * That's it!
 * Call ImAllDone() when you don't want your GUI up any more.
 */
public class GuiInterface {
	
	public boolean escaped = false;
	public boolean entered = false;
	public boolean arrow_up = false;
	public boolean arrow_down = false;
	public boolean caps = false;
	public InventoryContainer mousebite = null;
	public boolean grab_mouse = false;
	public List<ButtonHandler> buttons = null; //more like inventory squares, really, but they do nicely as buttons
	public int clickx, clicky;
	public int diffx = 0;
	public int diffy = 0;
	public int startx, starty, middle, bottom_of_display, top_of_display, left_of_display;
	public float scalex = DangerZone.screen_width/1920f;
	public float scaley = DangerZone.screen_height/1080f;
	public boolean leftdown = false;
	public boolean rightdown = false;
	public boolean middledown = false;
	public String guimessagestring = null;
	public int guimessagetimer = 0;


	//convenience... use it or not...
	public class ButtonHandler {
		public Texture t;
		public int x;
		public int y;
		public int xsize;
		public int ysize;
		public String s;
		public InventoryContainer ic;
		public int buttonid = 0;
		

		
		public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int bid){
			x = xpos;
			y = ypos;
			xsize = bxsize;
			ysize = bysize;
			t = tx;
			s = ot;
			ic = null;
			buttonid = bid;
		}
		
		public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, InventoryContainer iic, int bid){
			x = xpos;
			y = ypos;
			xsize = bxsize;
			ysize = bysize;
			t = null;
			s = null;
			ic = iic;
			buttonid = bid;
		}
		
		public void leftclickhandler(){			
		}
		public void rightclickhandler(){			
		}
		public void middleclickhandler(){			
		}
		
		public void draw(){
			if(ic != null){
				t = ic.getTexture();
				s = null;
				if(ic.count > 1){
					s = String.format("%d", ic.count);
				}
				if(t != null){
					GL11.glColor3f(1,1,1);
					drawRectangleWithTexture(t, x, y, xsize, ysize);
				}
				if(s != null && !s.equals("")){
					textAt( x+6, y, s);
					GL11.glColor3f(1,1,1); //because text messes this up!
				}
				//FIXME TODO - damage indicator! (if ic.count == 1 && ic.damage != 0 && ic.maxdamage != 0)
				if(ic.count == 1){
					if(ic.currentuses > 0){
						if(ic.getMaxStack() == 1){
							Item it = ic.getItem();
							if(it != null){
								int md = it.maxuses;
								if(md > 0){
									float pu = (float)ic.currentuses/(float)md;
									drawUsed(pu, x, y, xsize, 2);
								}
							}
						}
					}
				}
			}else{
				if(t != null){
					GL11.glColor3f(1,1,1);
					drawRectangleWithTexture(t, x, y, xsize, ysize);
				}
				if(s != null && !s.equals("")){
					textAt(x+6, y, s);
					GL11.glColor3f(1,1,1); //because text messes this up!
				}
			}
		}
	
	
	public void draw(float tcolor){
		if(ic != null){
			t = ic.getTexture();
			s = null;
			if(ic.count > 1){
				s = String.format("%d", ic.count);
			}
			if(t != null){
				GL11.glColor3f(tcolor,tcolor,tcolor);
				drawRectangleWithTexture(t, x, y, xsize, ysize);
			}
			if(s != null && !s.equals("")){
				textAt( x+6, y, s);
				GL11.glColor3f(1,1,1); //because text messes this up!
			}
			//FIXME TODO - damage indicator! (if ic.count == 1 && ic.damage != 0 && ic.maxdamage != 0)
			if(ic.count == 1){
				if(ic.currentuses > 0){
					if(ic.getMaxStack() == 1){
						Item it = ic.getItem();
						if(it != null){
							int md = it.maxuses;
							if(md > 0){
								float pu = (float)ic.currentuses/(float)md;
								drawUsed(pu, x, y, xsize, 2);
							}
						}
					}
				}
			}
		}else{
			if(t != null){
				GL11.glColor3f(tcolor,tcolor,tcolor);
				drawRectangleWithTexture(t, x, y, xsize, ysize);
			}
			if(s != null && !s.equals("")){
				textAt(x+6, y, s);
				GL11.glColor3f(1,1,1); //because text messes this up!
			}
		}
	}
	
}

	
	public GuiInterface(){
		//nothing to do...
	}
	
	/*
	 * Do your thing here! Draw, and then process inputs, all in one go.
	 * You will get called approximately 60 times a second, same as the frame rate.
	 * Try not to slow things down too much!
	 * You are in menu-mode for drawing, with 0,0 in the lower left.
	 * DangerZone.screen_width and DangerZone.screen_height is the size.
	 * Completely over-ride this routine! 
	 * Don't call super() unless you want the keyboard and mouse queues cleared.
	 * OK, maybe last, before you return... lol!
	 * MODE != 0 == VR
	 */
	public void process(int mode){		
		//while(K_next()){}; //clear out the keyboard queue
		//while(M_next()){}; //clear out the mouse queue
		K_clear(); //clear out the keyboard queue
		M_clear(); //clear out the mouse queue
	}
	
	/*
	 * Clean exit from your gui, when you are all done.
	 */
	public void ImAllDone(){
		
		G_clear(); //flush inputs to buffers?
		try {
			Thread.sleep(10);
		} catch (InterruptedException e2) {
			e2.printStackTrace();
		} 
		K_clear(); //clear out the keyboard queue
		M_clear(); //clear out the mouse queue

		//and do it again, just because.
		
		G_clear(); //flush inputs to buffers?
		try {
			Thread.sleep(10);
		} catch (InterruptedException e2) {
			e2.printStackTrace();
		} 
		K_clear(); //clear out the keyboard queue
		M_clear(); //clear out the mouse queue
		
		DangerZone.clearActiveGui();
		DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);
	}
	
	//convenience text routine! 
	//Remember to reset the brightness after drawing text!
	
	public void textAt( float xpos, float ypos, String text){
		DangerZone.wr.loadtexture(Blocks.stone.getTexture(0)); //it just wants a texture loaded, or it gets mad....
		GL11.glPushMatrix(); //save position
		GL11.glScalef(scalex, scaley, 1);
		GL11.glTranslatef(xpos, ypos+DangerZone.font.getHeight(), 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		DangerZone.font.drawString(0, 0, text, ColorSlick.white);	
		GL11.glPopMatrix();  //restore position
	}
	
	public void smallTextAt( float xpos, float ypos, String text){
		DangerZone.wr.loadtexture(Blocks.stone.getTexture(0)); //it just wants a texture loaded, or it gets mad....
		GL11.glPushMatrix(); //save position
		GL11.glScalef(scalex, scaley, 1);
		GL11.glTranslatef(xpos, ypos+DangerZone.font16.getHeight(), 0f); 
		GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!
		DangerZone.font16.drawString(0, 0, text, ColorSlick.white);	
		GL11.glPopMatrix();  //restore position
	}
	
	
	//convenience box...
	public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize){
		DangerZone.wr.forceloadtexture(t);
		float w = t.getWidth();
		float h = t.getHeight();
		GL11.glPushMatrix(); //save position
		GL11.glScalef(scalex, scaley, 1);
		GL11.glTranslatef(xpos, ypos, 0f); 
		GL11.glScalef(xsize/t.getWidth(), ysize/t.getHeight(), 1f);
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(w,0);
		GL11.glVertex3f(1, 1, 0); // Top Right
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(0, 1, 0); // Top Left
		GL11.glTexCoord2f(0,h);
		GL11.glVertex3f(0, 0, 0); // Bottom left
		GL11.glTexCoord2f(w,h);
		GL11.glVertex3f(1, 0, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glPopMatrix();
	}
	
	
	//convenience box, with rotation...
	public void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize, float zrot){
		DangerZone.wr.forceloadtexture(t);
		float w = t.getWidth();
		float h = t.getHeight();
		GL11.glPushMatrix(); //save position
		GL11.glScalef(scalex, scaley, 1);
		GL11.glTranslatef(xpos, ypos, 0f); 
		//GL11.glPushMatrix(); //save position
		GL11.glRotatef(zrot, 0, 0, 1.0f);
		GL11.glScalef(xsize/t.getWidth(), ysize/t.getHeight(), 1f);
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(w,0);
		GL11.glVertex3f(1, 1, 0); // Top Right
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(-1, 1, 0); // Top Left
		GL11.glTexCoord2f(0,h);
		GL11.glVertex3f(-1, -1, 0); // Bottom left
		GL11.glTexCoord2f(w,h);
		GL11.glVertex3f(1, -1, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		//GL11.glPopMatrix();
		GL11.glPopMatrix();
	}
	
	//convenience box, with rotation...
	public void drawRectangleWithTextureTwo(Texture t, float xpos, float ypos, float xsize, float ysize, float zrot, float extrascale){
		DangerZone.wr.forceloadtexture(t);
		float w = t.getWidth();
		float h = t.getHeight();
		GL11.glPushMatrix(); //save position
		GL11.glScalef(scalex, scaley, 1);
		GL11.glTranslatef(xpos, ypos, 0f); 	
		GL11.glScalef(extrascale*xsize/t.getWidth(), extrascale*ysize/t.getHeight(), 1f);
		GL11.glRotatef(zrot, 0, 0, 1.0f);
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glTexCoord2f(w,0);
		GL11.glVertex3f(1, 1, 0); // Top Right
		GL11.glTexCoord2f(0,0);
		GL11.glVertex3f(-1, 1, 0); // Top Left
		GL11.glTexCoord2f(0,h);
		GL11.glVertex3f(-1, -1, 0); // Bottom left
		GL11.glTexCoord2f(w,h);
		GL11.glVertex3f(1, -1, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glPopMatrix();
	}
	
	//messes up colors! make sure you reset back to what you want
	public void drawUsed(float used, float xpos, float ypos, float xsize, float ysize){
		float xs;
		if(used > 1)used = 1;
		if(used < 0)used = 0;
		xs = xsize * (1f - used);
		if(xs < 1)xs = 1;
		GL11.glPushMatrix(); //save position
		GL11.glScalef(scalex, scaley, 1);
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		GL11.glTranslatef(xpos, ypos, 0f); 
		GL11.glScalef(1f, 1f, 1f);
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glColor3f(used, 1f-used, 0);
		GL11.glVertex3f(xs, ysize, 0); // Top Right
		GL11.glColor3f(used, 1f-used, 0);
		GL11.glVertex3f(0, ysize, 0); // Top Left
		GL11.glColor3f(used, 1f-used, 0);
		GL11.glVertex3f(0, 0, 0); // Bottom left
		GL11.glColor3f(used, 1f-used, 0);
		GL11.glVertex3f(xs, 0, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glPopMatrix();
	}
	
	//messes up colors! make sure you reset back to what you want
	public void drawcoloredsquare(int xpos, int ypos, int xsize, int ysize, float r, float g, float b, float a){
		GL11.glPushMatrix(); //save position
		GL11.glScalef(scalex, scaley, 1);
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL11.glTranslatef(xpos, ypos, 0f); 		
		GL11.glBegin(GL11.GL_QUADS);	
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(xsize, ysize, 0); // Top Right
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(0, ysize, 0); // Top Left
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(0, 0, 0); // Bottom left
		GL11.glColor4f(r, g, b, a);
		GL11.glVertex3f(xsize, 0, 0); // Bottom right		
		GL11.glEnd(); // Done Drawing The Quad
		GL11.glDisable(GL11.GL_BLEND);		
		GL11.glEnable(GL11.GL_TEXTURE_2D);	
		GL11.glPopMatrix();
	}
	
	/*
	 * You are in complete control of the keyboard and mouse inputs.
	 * Make sure you do the proper while() loops to clear the events.
	 * And yes, you have to go through these routines, because Mouse and Keyboard
	 * only have context in the main routine, nowhere else, and cannot be passed...
	 */
	
	public void G_clear() {
		DangerZone.glfw_clear();
	}
	
	public void K_clear() {
		DangerZone.K_clear();
	}
	
	public void M_clear() {
		DangerZone.M_clear();
	}
	
	public boolean K_next(){
		return DangerZone.K_next();
	}
	
	public int K_getEventKey(){
		return DangerZone.K_getEventKey();
	}
	
	public boolean K_isEventKeyDown(){
		return DangerZone.K_isEventKeyDown();
	}
	
	public boolean K_isKeyDown(int key){
		return DangerZone.K_isKeyDown(key);
	}
	
	public boolean M_next(){
		return DangerZone.M_next();
	}
	
	public int M_getEventButton(){
		return DangerZone.M_getEventButton();
	}
	
	public boolean M_getEventButtonState(){
		return DangerZone.M_getEventButtonState();
	}
	
	public int M_getEventX(){
		return DangerZone.M_getEventX();
	}
	
	public int M_getEventY(){
		return DangerZone.M_getEventY();
	}
	
	public int M_getEventDX(){
		return DangerZone.M_getEventDX();
	}
	
	public int M_geEventDY(){
		return DangerZone.M_getEventDY();
	}
	
	public int M_getCurX(){
		return DangerZone.M_getCurX();
	}
	
	public int M_getCurY(){
		return DangerZone.M_getCurY();
	}
	
	public int M_getCurDX(){
		return DangerZone.M_getCurDX();
	}
	
	public int M_getCurDY(){
		return DangerZone.M_getCurDY();
	}
	
	//gets one char at a time. returns null if none, "delete" if delete!
	//sets global "escaped" flag too...
	//and the "entered" flag...
	public String getTextChar(){
		int currk;
		escaped = false;
		entered = false;
		arrow_up = false;
		arrow_down = false;
		
		
		while (K_next()) {	
			
			
			currk = K_getEventKey();
			
			//System.out.printf("Key! 0x%x, %s\n", currk, K_isEventKeyDown()?"true":"false");
			
			if (currk == GLFW.GLFW_KEY_ESCAPE){
				if(K_isEventKeyDown()) {
					escaped = true;
				}else {
					escaped = false;
				}
			}
			if (currk == GLFW.GLFW_KEY_ENTER){
				if(K_isEventKeyDown()) {
					entered = true;
				}else {
					entered = false;
				}
			}
			if (currk == GLFW.GLFW_KEY_UP){
				if(K_isEventKeyDown()) {
					arrow_up = true;
				}else {
					arrow_up = false;
				}
			}
			if (currk == GLFW.GLFW_KEY_DOWN){
				if(K_isEventKeyDown()) {
					arrow_down = true;
				}else {
					arrow_down = false;
				}
			}
			
			if (currk == GLFW.GLFW_KEY_LEFT_SHIFT || currk == GLFW.GLFW_KEY_RIGHT_SHIFT){
				if(K_isEventKeyDown()) {
					caps = true;
				}else {
					caps = false;
				}
			}

			
			if(!K_isEventKeyDown())continue; //only care if down event for the rest.
			
			switch(currk){
			
			case GLFW.GLFW_KEY_DELETE:
				return "delete";
			case GLFW.GLFW_KEY_BACKSPACE:
				return "delete";
				
			case GLFW.GLFW_KEY_0:
				if(caps)return ")";
				return "0";
			case GLFW.GLFW_KEY_1:
				if(caps)return "!";
				return "1";
			case GLFW.GLFW_KEY_2:
				if(caps)return "@";
				return "2";
			case GLFW.GLFW_KEY_3:
				if(caps)return "#";
				return "3";
			case GLFW.GLFW_KEY_4:
				if(caps)return "$";
				return "4";
			case GLFW.GLFW_KEY_5:
				if(caps)return "%";
				return "5";
			case GLFW.GLFW_KEY_6:
				if(caps)return "^";
				return "6";
			case GLFW.GLFW_KEY_7:
				if(caps)return "&";
				return "7";
			case GLFW.GLFW_KEY_8:
				if(caps)return "*";
				return "8";
			case GLFW.GLFW_KEY_9:
				if(caps)return "(";
				return "9";
			case GLFW.GLFW_KEY_A:
				if(caps)return "A";
				return "a";
			case GLFW.GLFW_KEY_B:
				if(caps)return "B";
				return "b";
			case GLFW.GLFW_KEY_C:
				if(caps)return "C";
				return "c";
			case GLFW.GLFW_KEY_D:
				if(caps)return "D";
				return "d";
			case GLFW.GLFW_KEY_E:
				if(caps)return "E";
				return "e";
			case GLFW.GLFW_KEY_F:
				if(caps)return "F";
				return "f";
			case GLFW.GLFW_KEY_G:
				if(caps)return "G";
				return "g";
			case GLFW.GLFW_KEY_H:
				if(caps)return "H";
				return "h";
			case GLFW.GLFW_KEY_I:
				if(caps)return "I";
				return "i";
			case GLFW.GLFW_KEY_J:
				if(caps)return "J";
				return "j";
			case GLFW.GLFW_KEY_K:
				if(caps)return "K";
				return "k";
			case GLFW.GLFW_KEY_L:
				if(caps)return "L";
				return "l";
			case GLFW.GLFW_KEY_M:
				if(caps)return "M";
				return "m";
			case GLFW.GLFW_KEY_N:
				if(caps)return "N";
				return "n";
			case GLFW.GLFW_KEY_O:
				if(caps)return "O";
				return "o";
			case GLFW.GLFW_KEY_P:
				if(caps)return "P";
				return "p";
			case GLFW.GLFW_KEY_Q:
				if(caps)return "Q";
				return "q";
			case GLFW.GLFW_KEY_R:
				if(caps)return "R";
				return "r";
			case GLFW.GLFW_KEY_S:
				if(caps)return "S";
				return "s";
			case GLFW.GLFW_KEY_T:
				if(caps)return "T";
				return "t";
			case GLFW.GLFW_KEY_U:
				if(caps)return "U";
				return "u";
			case GLFW.GLFW_KEY_V:
				if(caps)return "V";
				return "v";
			case GLFW.GLFW_KEY_W:
				if(caps)return "W";
				return "w";
			case GLFW.GLFW_KEY_X:
				if(caps)return "X";
				return "x";
			case GLFW.GLFW_KEY_Y:
				if(caps)return "Y";
				return "y";
			case GLFW.GLFW_KEY_Z:
				if(caps)return "Z";
				return "z";				
				
			case GLFW.GLFW_KEY_PERIOD:
				if(caps)return ">";
				return ".";
			case GLFW.GLFW_KEY_COMMA:
				if(caps)return "<";
				return ",";
			case GLFW.GLFW_KEY_SLASH:
				if(caps)return "?";
				return "/";				
			case GLFW.GLFW_KEY_SEMICOLON:
				if(caps)return ":";
				return ";";
			case GLFW.GLFW_KEY_APOSTROPHE:
				if(caps)return "\"";
				return "'";				
			case GLFW.GLFW_KEY_SPACE:
			case GLFW.GLFW_KEY_TAB:				
				return " ";				
			case GLFW.GLFW_KEY_BACKSLASH:
				if(caps)return "|";
				return "\\";
			case GLFW.GLFW_KEY_LEFT_BRACKET:
				if(caps)return "{";
				return "[";
			case GLFW.GLFW_KEY_RIGHT_BRACKET:
				if(caps)return "}";
				return "]";				
			case GLFW.GLFW_KEY_MINUS:
				if(caps)return "_";
				return "-";
			case GLFW.GLFW_KEY_EQUAL:
				if(caps)return "+";
				return "=";
				
			default:
				
			}
		}
		return null;
	}
	

	
	public void showArmorValue(int which, int x, int y){
		InventoryContainer ic = DangerZone.player.getArmor(which);
		if(ic != null){
			if(ic.count == 1){
				Item it = ic.getItem();
				if(it instanceof ItemArmor){
					ItemArmor ia = (ItemArmor)it;
					String s = String.format("%3.1f", ia.protection);
					textAt( (x), (y), s);
					GL11.glColor3f(1,1,1); //because text messes this up!
				}
			}
		}
	}
	
	/*
	 * ALL inventory handling is done on the server to prevent rampant cheating.
	 */
	public void ClickedHotBar(int which, int leftrightmid, boolean shifted){	
		DangerZone.server_connection.handleInventory(0, which, leftrightmid, shifted?1:0, 0);
	}
	public void ClickedInventory(int which, int leftrightmid, boolean shifted){
		DangerZone.server_connection.handleInventory(1, which, leftrightmid, shifted?1:0, 0);
	}
	public void ClickedEntityInventory(int eid, int which, int leftrightmid, boolean shifted){	
		DangerZone.server_connection.handleInventory(2, eid, which, leftrightmid, shifted?1:0);
	}
	public void ClickedCreativeInventory(int iid, int bid, boolean shifted){
		DangerZone.server_connection.handleInventory(3, iid, bid, shifted?1:0, 0);
	}
	public void ClickedCrafted(int leftrightmid, boolean shifted){
		DangerZone.server_connection.handleInventory(4, leftrightmid, shifted?1:0, 0, 0);
	}
	public void ClickedCrafting(int which, int leftrightmid, boolean shifted){
		DangerZone.server_connection.handleInventory(5, which, leftrightmid, shifted?1:0, 0);
	}
	public void SpreadListAdd(int which, int iid, int bid){	
		DangerZone.server_connection.handleInventory(6, which, iid, bid, 0);
	}
	public void SpreadListClear(){
		DangerZone.server_connection.handleInventory(7, 0, 0, 0, 0);
	}
	public void ClearTable(){
		DangerZone.server_connection.handleInventory(8, 0, 0, 0, 0);
	}
	public void ClickedArmor(int which, int leftrightmid, boolean shifted){
		DangerZone.server_connection.handleInventory(9, which, leftrightmid, shifted?1:0, 0);
	}
	public void DeleteMouseBite(){
		DangerZone.server_connection.handleInventory(10, 0, 0, 0, 0);
	}
	public void SpitMouseBite(){
		DangerZone.server_connection.handleInventory(11, 0, 0, 0, 0);
	}
	public void ClickedInventoryWithEntity(int which, int leftrightmid, boolean shifted, int eid){ //only for entities with full 50 inventory!
		DangerZone.server_connection.handleInventory(12, which, leftrightmid, shifted?1:0, eid);
	}
	public void SpitOneHotbar(){
		DangerZone.server_connection.handleInventory(13, 0, 0, 0, 0);
	}
	public void SellToEntity(int eid){ 
		DangerZone.server_connection.handleInventory(14, eid, 0, 0, 0);
	}
	public void BuyFromEntity(int which, int eid){ 
		DangerZone.server_connection.handleInventory(15, which, eid, 0, 0);
	}
	public void UnStayEntity(int eid){ 
		DangerZone.server_connection.handleInventory(16, eid, 0, 0, 0);
	}
	public void MouseBiteToEntity(int eid){ 
		DangerZone.server_connection.handleInventory(17, eid, 0, 0, 0);
	}
	public void ClickedDeskCrafted(int leftrightmid, boolean shifted){
		DangerZone.server_connection.handleInventory(18, leftrightmid, shifted?1:0, 0, 0);
	}
	public void ClickedDeskCrafting(int which, int leftrightmid, boolean shifted){
		DangerZone.server_connection.handleInventory(19, which, leftrightmid, shifted?1:0, 0);
	}	


	public void std_setup(int mode) {
		
		scalex = (float)DangerZone.screen_width/1920.0f;
		scaley = (float)DangerZone.screen_height/1080.0f;
		starty = 1080;
		middle = 1920/2;
		startx = 0;
		bottom_of_display = 0;

		
		if(mode != 0) {
			startx = DangerZone.get_left(mode);
			starty = DangerZone.get_top(mode);
			middle = DangerZone.get_middle(mode);			
			bottom_of_display = DangerZone.get_bottom(mode);
				
			scaley = (float)(DangerZone.use_height)/1080.0f;
			scalex = (float)(DangerZone.use_width)/1920.0f;			
			
			//System.out.printf("last, curr == %f, %f\n",  DangerZone.player.rotation_yaw_head, DangerZone.player_last_yaw);
			
			float usexhead = DangerZone.player.rotation_yaw_head;
			//if(usexhead > 180)usexhead -= 360;
			
			float usexlast = DangerZone.player_last_yaw;
			//if(usexlast > 180)usexlast -= 360;
			
			float hdiff = usexhead - usexlast;
			if(hdiff > 180)hdiff -= 360;
			if(hdiff < -180)hdiff += 360;
			
			//System.out.printf("        hdiff == %f\n",  hdiff);
			
			startx -= (hdiff)*10;
			middle -= (hdiff)*10;
			diffx = (int) ((hdiff)*10);
			
			float useyhead = DangerZone.player.rotation_pitch_head;
			if(useyhead > 180)useyhead -= 360;
			
			//float useylast = DangerZone.player_last_pitch;
			float useylast = -15;
			if(useylast > 180)useylast -= 360;
			
			hdiff = useyhead - useylast;
			starty += hdiff*10;
			bottom_of_display += hdiff*10;
			diffy = (int) ((hdiff)*10);
		}
		
		
		startx += 100;	
		top_of_display = starty;
		left_of_display = startx;
		
	}
	
	public int std_draw(int mode){
		Texture sighttexture = null;
		Texture tx = null;
		String s = null;
		//Draw buttons!
		clickx = 0; //these are set in findHighlightedButton();
		clicky = 0;
		
		int high_button = findHighlightedButton(mode);
		
		//Draw buttons!
		if(buttons != null) {
			Iterator<ButtonHandler> bb = buttons.iterator();
			ButtonHandler thisbutton = null;
			float diff = 0.55f;
			if(mode == 0)diff = 0.75f;
			while(bb.hasNext()){
				thisbutton = bb.next();
				thisbutton.draw(thisbutton.buttonid==high_button?1.0f:diff);
			}
		}
		
		std_text(high_button);
		
		if(guimessagetimer > 0) {
			guimessagetimer--;
			
			if(guimessagestring != null) {
				
				if(mode == 0) {
					//fixed pos at bottom
					drawRectangleWithTexture(DangerZone.textinputtexture, middle - (5 * guimessagestring.length()) - 50, bottom_of_display + 95, 
								(13 * guimessagestring.length())+20, 30);
					textAt( middle - (5 * guimessagestring.length()) - 30, bottom_of_display + 95, guimessagestring);
				}else {
					//below the cursor because in VR you can't read it at the bottom without looking!
					drawRectangleWithTexture(DangerZone.textinputtexture, clickx - (5 * guimessagestring.length()) - 50, clicky - 65, 
							(13 * guimessagestring.length())+20, 30);
					textAt( clickx - (5 * guimessagestring.length()) - 30, clicky - 65, guimessagestring);
				}
			}
			
			if(guimessagetimer <= 0)guimessagestring = null;
		}


		//Draw the things under the mouse
		mousebite = DangerZone.player.getMouseBite();
		
		if(mode == 0) {
			if(mousebite != null){
				float x = M_getCurX();
				float y = M_getCurY();
				x /= scalex;
				y /= scaley;
				
				tx = mousebite.getTexture();
				s = null;
				if(mousebite.count > 1){
					s = String.format("%d", mousebite.count);
				}
				if(tx != null){
					GL11.glColor3f(1,1,1);
					drawRectangleWithTexture(tx, x-24, y-24, 48, 48);
				}
				if(s != null && !s.equals("")){
					textAt( x-18, y-24, s);
					GL11.glColor3f(1,1,1); //because text messes this up!
				}
			}
		}else {
			if(mousebite != null){			
				tx = mousebite.getTexture();
				s = null;
				if(mousebite.count > 1){
					s = String.format("%d", mousebite.count);
				}
				if(tx != null){
					GL11.glColor3f(1,1,1);
					drawRectangleWithTexture(tx, clickx-16, clicky-16, 32, 32);
				}
				if(s != null && !s.equals("")){
					textAt( clickx-10, clicky-16, s);
					GL11.glColor3f(1,1,1); //because text messes this up!
				}
			}else {
				//draw the clicky sight
				if(mode != 0) {
					GL11.glColor3f(1,1,1);
					sighttexture = TextureMapper.getTexture("res/menus/"+"sight.png");
					drawRectangleWithTexture(sighttexture, clickx-16, clicky-16, 32, 32);
				}
			}
		}
		
		return high_button;
	}
	
	public int findHighlightedButton(int mode) {
		if(buttons == null)return -1;
		
		if(mode == 0) {		
			//Highlight only when cursor on top of button
			float x = M_getCurX();
			float y = M_getCurY();
			x /= scalex;
			y /= scaley;
			int lclickx = (int)x;
			int lclicky = (int)y;
			
			Iterator<ButtonHandler> bb = buttons.iterator();
			ButtonHandler thisbutton = null;

			while(bb.hasNext()){
				thisbutton = bb.next();
				if(lclickx >= thisbutton.x && lclickx <= (thisbutton.x+thisbutton.xsize)){
					if(lclicky >= thisbutton.y && lclicky <= (thisbutton.y+thisbutton.ysize)){
						return thisbutton.buttonid;
					}
				}
			}
		}else {
			
			
			clickx = DangerZone.get_middle(mode); //middle
			clicky = DangerZone.screen_height/2;
			
			DangerZone.pointer_controller.calc_50();
					
			float usexhead = DangerZone.pointer_controller.yaw_50;

			float usexlast = DangerZone.player_last_yaw;
			
			float hdiff = usexhead - usexlast;
			if(hdiff > 180)hdiff -= 360;
			if(hdiff < -180)hdiff += 360;
			
			clickx += (hdiff)*20;	
			clickx -= diffx; //take out head offset
			
			float useyhead = DangerZone.pointer_controller.pitch_50;
			if(useyhead > 180)useyhead -= 360;
			
			float useylast = 0;
			if(useylast > 180)useylast -= 360;
			
			clicky -= (useyhead - useylast)*20;
			clicky += diffy; //take out head offset
			
			//System.out.printf("head, last == %f, %f\n", DangerZone.player.rotation_pitch_head, DangerZone.player_last_pitch );
			//System.out.printf("head, last == %f, %f\n", useyhead, useylast );
			
			Iterator<ButtonHandler> bb = buttons.iterator();
			ButtonHandler thisbutton = null;
			ButtonHandler closer = null;
			float dist;
			float closest = 1000000;

			while(bb.hasNext()){
				thisbutton = bb.next();
				dist = (float)Math.sqrt((((thisbutton.x+(thisbutton.xsize/2))-clickx)*((thisbutton.x+(thisbutton.xsize/2))-clickx))
						+(((thisbutton.y+(thisbutton.ysize/2))-clicky)*((thisbutton.y+(thisbutton.ysize/2))-clicky)));
				if(dist < closest) {
					closest = dist;
					closer = thisbutton;
				}
			}
			//System.out.printf("mode, clickx = %d, %d\n", mode, clickx);
			//if(closer != null)System.out.printf("buttonid = %d\n", closer.buttonid);
						
			if(closer != null)return closer.buttonid;

		}

		return -1;
	}
	
	public void std_clicker(int mode, int high_button) {
		ButtonHandler fb = null;
		ButtonHandler mb = null;
		
		//Check for exit via keypad
		while(K_next()){
			if (K_getEventKey() == GLFW.GLFW_KEY_E && K_isKeyDown(GLFW.GLFW_KEY_E)){
				ImAllDone();
				return;
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_ESCAPE && K_isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
				ImAllDone();
				return;
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F2 && K_isEventKeyDown()){
				Utils.screenshot(DangerZone.screen_width, DangerZone.screen_height);
				guimessagestring = "Screenshot!";
				guimessagetimer = 60;
			}
		}
		
		if(buttons == null)return;

		Iterator<ButtonHandler> bb = buttons.iterator();
		
		if(mode == 0) {

			//Check for mouse events!
			while(M_next()){
				float x = M_getEventX();
				float y = M_getEventY();
				x /= scalex;
				y /= scaley;
				int lclickx = (int)x;
				int lclicky = (int)y;

				if(M_getEventButtonState()){
					if(M_getEventButton() >= 0){ //clicked!

						//Find which "button" they clicked on
						bb = buttons.iterator();
						fb = null;
						while(bb.hasNext()){
							mb = bb.next();
							if(lclickx >= mb.x && lclickx <= (mb.x+mb.xsize)){
								if(lclicky >= mb.y && lclicky <= (mb.y+mb.ysize)){
									fb = mb;
									break;
								}
							}
						}
						// 0 = left, 1 = right, 2 = middle
						if(M_getEventButton() == 0){
							if(fb != null)fb.leftclickhandler();
							leftdown = true;
						}
						if(M_getEventButton() == 1){
							if(fb != null)fb.rightclickhandler();
							rightdown = true;
						}
						if(M_getEventButton() == 2){
							if(fb != null)fb.middleclickhandler();
							middledown = true;
						}				
					}
				}else{
					if(M_getEventButton() == 0){
						leftdown = false;
					}
					if(M_getEventButton() == 1){
						rightdown = false;
					}
					if(M_getEventButton() == 2){
						middledown = false;
					}
				}

			}

		}else if(mode == 1) {
			
			TargetInfo ti = DangerZone.vr_is_clicked();
			if(ti != null) {
				//Find which "button" they clicked on
				bb = buttons.iterator();
				fb = null;
				while(bb.hasNext()){
					mb = bb.next();
					if(high_button ==  mb.buttonid ){
							fb = mb;
							break;
					}
				}
				
				if(ti == DangerZone.pointer_controller){
					if(fb != null)fb.leftclickhandler();
				}else{
					if(fb != null)fb.rightclickhandler();
				}
				
			}

		}
	
	}
	
	public void std_text(int high_button) {
		ButtonHandler fb = null;
		ButtonHandler mb = null;

		if(buttons == null)return;

		Iterator<ButtonHandler> bb = buttons.iterator();
		InventoryContainer ic = null;

		bb = buttons.iterator();
		fb = null;
		while(bb.hasNext()){
			mb = bb.next();
			if(high_button ==  mb.buttonid ){
				fb = mb;
				break;
			}
		}

		if(fb != null) {
			ic = fb.ic;
			if(ic != null){
				String hotstring = null;
				String[] hss = null;
				if(ic.bid != 0){
					hotstring = Blocks.getUniqueName(ic.bid);
				}
				if(ic.iid != 0){
					hotstring = Items.getUniqueName(ic.iid);
					int attackstrength = Items.getAttackStrength(ic.iid);
					if(attackstrength > 1){
						hotstring += String.format(" +%d", attackstrength);
					}		
				}
				if(hotstring != null){
					hss = hotstring.split(":");
					if(hss.length >= 2){
						guimessagestring = hss[1];
						guimessagetimer = 10;
					}
				}
			}
		}

	}
	
	public void std_keypad_add(int mode) {
		
		if(mode == 0)return; //has real keyboard!
		
		Texture buttontexture = null;
		
		String s = null;
		String special = "!@#$%^&*()_+-= {}[]\\|;':\",./<>?`~";
		String numeric = "0123456789";
		String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
		char c = 0;
		
		buttontexture = TextureMapper.getTexture("res/menus/"+"button.png");
		
		starty -= 100; //go down a bit more
				
		for(int i=0;i<alpha.length();i++) {
			c = alpha.charAt(i);
			s = String.format("%c", c);
			//textAt( startx+(15*(i%13)), starty-(20*(i/13)), s);
			buttons.add(new ButtonHandler((int)((startx+(30*(i%26)))), (int)((starty-(40*(i/26)))), 
					(int)(30), (int)(30), buttontexture, s, 26000+c));
		}
		for(int i=0;i<numeric.length();i++) {
			c = numeric.charAt(i);
			s = String.format("%c", c);
			//textAt( startx+(15*(i%13)), starty-(20*(i/13)), s);
			buttons.add(new ButtonHandler((int)((startx+(30*(i%26)))), (int)((starty+40-(40*(i/26)))), 
					(int)(30), (int)(30), buttontexture, s, 26000+c));
		}
		for(int i=0;i<special.length();i++) {
			c = special.charAt(i);
			s = String.format("%c", c);
			//textAt( startx+(15*(i%13)), starty-(20*(i/13)), s);
			buttons.add(new ButtonHandler((int)((startx+(30*(i%26)))), (int)((starty+120-(40*(i/26)))), 
					(int)(30), (int)(30), buttontexture, s, 26000+c));
		}
		c = ' ';
		s = "<space>";
		buttons.add(new ButtonHandler((int)((startx)), (int)((starty-80)), 
				(int)(20*7), (int)(30), buttontexture, s, 26000+c));
		c = 8;
		s = "<delete>";
		buttons.add(new ButtonHandler((int)((startx+(20*9))), (int)((starty-80)), 
				(int)(20*7), (int)(30), buttontexture, s, 26000+c));
		c = 27;
		s = "<escape>";
		buttons.add(new ButtonHandler((int)((startx+(20*9*2))), (int)((starty-80)), 
				(int)(20*7), (int)(30), buttontexture, s, 26000+c));
		
		s = "<up>";
		buttons.add(new ButtonHandler((int)((startx)), (int)((starty-120)), 
				(int)(20*7), (int)(30), buttontexture, s, 26000+264));
		s = "<down>";
		buttons.add(new ButtonHandler((int)((startx+(20*9))), (int)((starty-120)), 
				(int)(20*7), (int)(30), buttontexture, s, 26000+265));
		
		c = '\n';
		s = "<enter>";
		buttons.add(new ButtonHandler((int)((startx+(20*9*2))), (int)((starty-120)), 
				(int)(20*7), (int)(30), buttontexture, s, 26000+c));
		
	}
	
	public String std_keypad_get(int mode, int high_button) {
		
		entered = false;
		escaped = false;
		arrow_up = false;
		arrow_down = false;
		
		if(mode == 0) {
			return getTextChar(); //check real keyboard
		}
		
		if(high_button < 26000 || high_button > 26999)return null;
		
		TargetInfo ti = DangerZone.vr_is_clicked();
		if(ti == null) {
			return null;
		}
		if(ti != DangerZone.pointer_controller) {
			return null;
		}
				
		ButtonHandler mb = null;		
		Iterator<ButtonHandler> bb = buttons.iterator();
		bb = buttons.iterator();
		while(bb.hasNext()){
			mb = bb.next();
			if(high_button ==  mb.buttonid && high_button >= 26000 && high_button < 27000 ){
				if(high_button == 26008)return "delete";
				if(high_button == 26010) {
					DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
					entered = true;
					return null;
				}
				if(high_button == 26027) {
					DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
					escaped = true;
					return null;
				}
				if(high_button == 26264) {
					DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
					arrow_down = true;
					return null;
				}
				if(high_button == 26265) {
					DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
					arrow_up = true;
					return null;
				}
				DangerZone.world.playSound("DangerZone:pop", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.25f, 1.0f);		
				return String.format("%c", (char) (high_button - 26000));
			}
		}
		return null;
	}

}
