package dangerzone.entities;


import dangerzone.DamageTypes;
import dangerzone.Explosion;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.threads.ExplosionThread;
import dangerzone.world.World;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

public class ThrownInstability extends ThrownBlockItem {
	
	public float explosive_power = 1.0f; //tested up to 10,000.

	public ThrownInstability(World w) {
		super(w);
		uniquename = "DangerZone:ThrownInstability";
		setAttackDamage(2.0f);
	}
	
	public void doSpecialEffects(double x, double y, double z){
		int pfreq = 40;
		if(explosive_power >= 10)pfreq = 20;
		if(explosive_power >= 100)pfreq = 10;
		if(explosive_power >= 1000)pfreq = 5;
		if(world.rand.nextInt(pfreq) == 0)Utils.spawnParticlesFromServer(world, "DangerZone:ParticleFire", world.rand.nextInt(3)+2, dimension, x, y, z);
		if(world.rand.nextInt(pfreq) == 0)Utils.spawnParticlesFromServer(world, "DangerZone:ParticleSmoke", world.rand.nextInt(3)+2, dimension, x, y, z);
	}

	public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent){
		if(explosive_power < 0.01f)return;
		if(he && ent != null){
			ent.doAttackFromCustom(thrower, DamageTypes.EXPLOSIVE, 2*getAttackDamage()*explosive_power, false);
			Utils.spawnParticlesFromServerScaled(world, "DangerZone:ParticleHurt", 25, this.dimension, x, y, z, 0, 0.25f*(ent.getWidth()+ent.getHeight())/4f);

			//add a little more knockback!
			float dir = (float) Math.atan2(ent.posz - z, ent.posx - x);
			float hdist = (float) Math.sqrt((ent.posx - x)*(ent.posx - x) + (ent.posz - z)*(ent.posz - z));
			float ydir = (float) Math.atan2((ent.posy+ent.getHeight()/2) - y, hdist);
			float knockback = explosive_power/2;
			knockback /= (ent.getWidth()*ent.getHeight());
			if(knockback > 10)knockback = 10;
			//System.out.printf("ydir is %f from %f and %f\n", ydir, (ent.posy+ent.getHeight()/2)-y, hdist );
			//System.out.printf("sin = %f\n", Math.sin(ydir));
			//System.out.printf("cos = %f\n", Math.cos(ydir));
			//System.out.printf("knockback 1 added %f\n", knockback);
			ent.motionx += Math.cos(dir)*knockback*Math.cos(ydir);
			ent.motionz += Math.sin(dir)*knockback*Math.cos(ydir);
			ent.motiony += knockback*Math.sin(ydir);
			if(ent instanceof Player){
				Player pl = (Player)ent;
				pl.server_thread.sendVelocityUpdateToPlayer(ent.motionx, ent.motiony, ent.motionz);
			}
		}
		
		if((int)(getAttackDamage()*explosive_power) <= 99) {
			Explosion.boom(this, world, dimension, x, y, z, (int)(getAttackDamage()*explosive_power), true);
		}else {
			//kick it off into a thread so it doesn't hold things up!!!
			ExplosionThread rt = new ExplosionThread(this, world, dimension, x, y, z, (int)(getAttackDamage()*explosive_power), true);
			Thread it = new Thread(rt);
			it.setPriority(Thread.NORM_PRIORITY); 
			it.start();		
		}
	}
	


}
