package dangerzone.entities;


import slick.Texture;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;


public class MonarchCrysalis extends EntityLiving {
	
	Texture texture2 = null;
	
	public	MonarchCrysalis(World w){
		super(w);
		maxrenderdist = 32; //in blocks
		this.height = 0.25f;
		this.width = 0.15f;
		uniquename = "DangerZone:Monarch Crysalis";
		moveSpeed = 0.0f;
		setMaxHealth(1.0f);
		setHealth(1.0f);
		setDefense(0.5f);
		setAttackDamage(0);
		movefrequency = 4000;
		//takesFallDamage = false;
		setExperience(1);
		canSwim = false;
		daytimespawn = false;
		nighttimespawn = false;
		daytimedespawn = false;
		nighttimedespawn = false;

	}
	
	public void init(){
		super.init();
	}
	
	public void update(float deltaT){

		if(world.isServer){
			rotation_yaw_motion = 1;
		}
		super.update(deltaT);
	}
	
	public void doEntityAction(float deltaT){
		if(world.rand.nextInt(500) == 1){
			doHatch();
		}
		super.doEntityAction(deltaT);
	}
	
	private void doHatch(){
	
		setVarInt(31, getVarInt(31)+1);
		
		if(getVarInt(31) > 20 && world.isDaytime()) {
			Monarch sc = (Monarch)world.createEntityByName("DangerZone:Monarch", dimension, posx, posy, posz);
			if(sc != null){
				sc.init();
				world.spawnEntityInWorld(sc);
			}
			DangerZone.world.playSound("DangerZone:pop", dimension, posx, posy, posz, 0.15f, 1.0f);		
			deadflag = true;
		}

	}
	
	public boolean rightClickedByPlayer(Player p, InventoryContainer ic){	
		if(ic != null){
			if(ic.count != 0)return false; //must have empty hand!
		}
		if(world.isServer && p != null){			
			DangerZone.world.playSound("DangerZone:pop", dimension, posx, posy, posz, 0.15f, 1.0f);	
			if(getVarInt(31) > 16) {
				Utils.doDropRand(world, 0, Items.eggmonarchcrysalis2.itemID, 1f, dimension, posx, posy, posz);
			}else {
				Utils.doDropRand(world, 0, Items.eggmonarchcrysalis.itemID, 1f, dimension, posx, posy, posz);
			}
			deadflag = true;
		}
		return false;
	}
				
	
	public String getDeathSound(){
		return "DangerZone:little_splat";
	}
		
	//Model calls back out to see what texture to use.
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/skins/"+ "MonarchCrysalistexture.png");	
			texture2 = TextureMapper.getTexture("res/skins/"+ "MonarchCrysalistexture2.png");	
		}
		if(getVarInt(31) > 16)return texture2;
		return texture;
	}
	

}