package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import slick.Texture;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;


public class MonarchCaterpillar extends EntityLiving {
	
	public	MonarchCaterpillar(World w){
		super(w);
		maxrenderdist = 32; //in blocks
		this.height = 0.15f;
		this.width = 0.15f;
		uniquename = "DangerZone:Monarch Caterpillar";
		moveSpeed = 0.01f;
		setMaxHealth(1.0f);
		setHealth(1.0f);
		setDefense(1.0f);
		setAttackDamage(0.01f);
		searchDistance = 8f;
		attackRange = 0.25f;
		movefrequency = 35;
		setExperience(0);

		daytimespawn = true;
		daytimedespawn = false;
		nighttimespawn = false;
		nighttimedespawn = false;
		
		enable_findfoodblock = true;
		foodblockfreq = 11;
		foodblockdistxz = 7;
		foodblockdisty = 3;
		foodblockheal = 1;
		foodblockdisteat = 2;
		fooddaytimeonly = false;

	}
	
	public void doEntityAction(float deltaT){
		moveSpeed = 0.01f*(getVarInt(31)+1);
		setVarInt(30, getVarInt(30)+1);
		
		//10 minutes!
		if(getVarInt(30)> 6000)deadflag = true;
		
		super.doEntityAction(deltaT);
		
		if(getVarInt(31) >= 5 && world.rand.nextInt(20) == 1) {
			spawnCrysalis(world, dimension, posx, posy, posz);			
			deadflag = true; //bye bye!
		}
	}
	
	public void spawnCrysalis(World world, int d, double x, double y, double z){
		MonarchCrysalis sc = (MonarchCrysalis)world.createEntityByName("DangerZone:Monarch Crysalis", d, x, y, z);
		if(sc != null){
			sc.init();
			world.spawnEntityInWorld(sc);
		}
	}
	
	public boolean rightClickedByPlayer(Player p, InventoryContainer ic){	
		if(ic != null){
			if(ic.count != 0)return false; //must have empty hand!
		}
		if(world.isServer && p != null){			
			DangerZone.world.playSound("DangerZone:pop", dimension, posx, posy, posz, 0.15f, 1.0f);				
			Utils.doDropRand(world, 0, Items.eggmonarchcaterpillar.itemID, 1f, dimension, posx, posy, posz);
			deadflag = true;
		}
		return false;
	}
	
	
	 public void doEatFoodAction(int d, int x, int y, int z){
			if(world.rand.nextInt(4) == 1)playburp(0.01f*getVarInt(31));
			//world.setblockandmetaWithPerm(this, d, x,  y,  z,  0, 0); //don't kill the plant!
			if(world.rand.nextInt(50) == 1) {
				if(getVarInt(31) < 5)setVarInt(31, getVarInt(31)+1);	
			}
			setVarInt(30, 0); //I have eaten!
			if(getVarInt(31) >= 5 && world.rand.nextInt(150) == 1) {
				//Oopsies!
				world.setblockandmetaWithPerm(this, d, x,  y,  z,  0, 0);
			}
	 }
	 
	 public boolean isFoodBlock(int bid){
		 if(bid == Blocks.milkweed_plant.blockID)return true;
		 if(bid == Blocks.milkweed_plant1.blockID)return true;
		 if(bid == Blocks.milkweed_plant2.blockID)return true;
		 if(bid == Blocks.milkweed_plant3.blockID)return true;
		 return false;
	 }
		
	
	public float getScale(){
		if(getVarInt(31) == 0)return 0.01f;
		if(getVarInt(31) == 1)return 0.02f;
		if(getVarInt(31) == 2)return 0.03f;
		if(getVarInt(31) == 3)return 0.04f;
		if(getVarInt(31) == 4)return 0.05f;
		return 0.06f;
	}
	
	public String getLivingSound(){
		return null;
	}
	
	public String getHurtSound(){
		return null;
	}
	
	public String getDeathSound(){
		return "DangerZone:big_splat";
	}
	
	public void doDeathDrops(){
		if(world.rand.nextInt(20)==1)Utils.doDropRand(world, 0, Items.trophymonarchcaterpillar.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.deadbug.itemID, 1f, dimension, posx, posy, posz);
	}
	
	//Model calls back out to see what texture to use.
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/skins/"+ "MonarchCaterpillartexture.png");	//this is not fast, so we keep our own pointer!
		}
		return texture;
	}
	

}
