package dangerzone.entities;

import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.ModelRenderer;

public class ModelMonarchCrysalis extends ModelBase
{

	ModelRenderer foot;
	ModelRenderer body;

	public ModelMonarchCrysalis()
	{
		foot = new ModelRenderer(this, 0, 0);
		foot.addBox(-0.5F, 0F, -0.5F, 1, 2, 1);
		foot.setRotationPoint(0F, -8F, 0F);
		foot.setTextureSize(64, 64);
		foot.mirror = true;
		setRotation(foot, 0F, 0F, 0F);
		body = new ModelRenderer(this, 9, 0);
		body.addBox(-5F, 0F, 0F, 10, 24, 10);
		body.setRotationPoint(0F, -6F, -5F);
		body.setTextureSize(64, 64);
		body.mirror = true;
		setRotation(body, 0F, 0F, 0F);
	}

	public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
	{
		body.render(deathfactor);
		foot.render(deathfactor);
	}

	public void doScale(Entity ent){
		super.doScale(ent);
		MatrixStack.scale(0.18f, 0.18f, 0.18f); 
	}

}
