package dangerzone.entities;


import dangerzone.rendering.ModelBase;
import dangerzone.rendering.ModelRenderer;

public class ModelMonarchCaterpillar extends ModelBase
{

  //fields
    ModelRenderer Head;
    ModelRenderer falsehead;
    ModelRenderer seg1;
    ModelRenderer ltusk1;
    ModelRenderer ltusk2;
    ModelRenderer rtusk1;
    ModelRenderer rtusk2;
    ModelRenderer ljaw;
    ModelRenderer rjaw;
    ModelRenderer seg1lleg;
    ModelRenderer seg1rleg;
    ModelRenderer seg2;
    ModelRenderer seg2lfoot;
    ModelRenderer seg2rfoot;
    ModelRenderer seg3;
    ModelRenderer seg3lfoot;
    ModelRenderer seg3rfoot;
    ModelRenderer seg3lbackspike;
    ModelRenderer seg3rbackspike;


  
  public ModelMonarchCaterpillar()
  {
      

	    
	      Head = new ModelRenderer(this, 0, 50);
	      Head.addBox(-8F, -8F, -8F, 16, 13, 8);
	      Head.setRotationPoint(0F, 7F, -12F);
	      Head.setTextureSize(256, 512);
	      Head.mirror = true;
	      setRotation(Head, 0F, 0F, 0F);
	      falsehead = new ModelRenderer(this, 0, 100);
	      falsehead.addBox(-10F, -27F, -11F, 20, 17, 10);
	      falsehead.setRotationPoint(0F, 11F, -12F);
	      falsehead.setTextureSize(256, 512);
	      falsehead.mirror = true;
	      setRotation(falsehead, -0.1570796F, 0F, 0F);
	      seg1 = new ModelRenderer(this, 0, 200);
	      seg1.addBox(-14F, -31F, 0F, 28, 32, 14);
	      seg1.setRotationPoint(0F, 12F, -12F);
	      seg1.setTextureSize(256, 512);
	      seg1.mirror = true;
	      setRotation(seg1, 0F, 0F, 0F);
	      ltusk1 = new ModelRenderer(this, 0, 140);
	      ltusk1.addBox(-1F, -1F, -1F, 33, 3, 3);
	      ltusk1.setRotationPoint(9F, -16F, -19F);
	      ltusk1.setTextureSize(256, 512);
	      ltusk1.mirror = true;
	      setRotation(ltusk1, 0F, 0.5585054F, 0F);
	      ltusk2 = new ModelRenderer(this, 0, 160);
	      ltusk2.addBox(0F, 0F, 0F, 20, 1, 1);
	      ltusk2.setRotationPoint(36F, -16F, -36F);
	      ltusk2.setTextureSize(256, 512);
	      ltusk2.mirror = true;
	      setRotation(ltusk2, 0F, 0.8028515F, 0F);
	      rtusk1 = new ModelRenderer(this, 0, 150);
	      rtusk1.addBox(-33F, 0F, 0F, 33, 3, 3);
	      rtusk1.setRotationPoint(-8F, -16F, -17F);
	      rtusk1.setTextureSize(256, 512);
	      rtusk1.mirror = true;
	      setRotation(rtusk1, 0F, -0.5585054F, 0F);
	      rtusk2 = new ModelRenderer(this, 0, 170);
	      rtusk2.addBox(-20F, 0F, 0F, 20, 1, 1);
	      rtusk2.setRotationPoint(-36F, -15F, -34F);
	      rtusk2.setTextureSize(256, 512);
	      rtusk2.mirror = true;
	      setRotation(rtusk2, 0F, -0.8028515F, 0F);
	      ljaw = new ModelRenderer(this, 100, 50);
	      ljaw.addBox(0F, 0F, 0F, 1, 7, 4);
	      ljaw.setRotationPoint(4F, 11F, -18F);
	      ljaw.setTextureSize(256, 512);
	      ljaw.mirror = true;
	      setRotation(ljaw, 0F, 0F, 0.1396263F);
	      rjaw = new ModelRenderer(this, 125, 50);
	      rjaw.addBox(0F, 0F, 0F, 1, 7, 4);
	      rjaw.setRotationPoint(-5F, 11F, -18F);
	      rjaw.setTextureSize(256, 512);
	      rjaw.mirror = true;
	      setRotation(rjaw, 0F, 0F, -0.1396263F);
	      seg1lleg = new ModelRenderer(this, 125, 200);
	      seg1lleg.addBox(-1F, 0F, -1F, 2, 16, 2);
	      seg1lleg.setRotationPoint(8F, 8F, -5F);
	      seg1lleg.setTextureSize(256, 512);
	      seg1lleg.mirror = true;
	      setRotation(seg1lleg, 0F, 0F, 0.1570796F);
	      seg1rleg = new ModelRenderer(this, 150, 200);
	      seg1rleg.addBox(0F, 0F, 0F, 2, 16, 2);
	      seg1rleg.setRotationPoint(-9F, 8F, -5F);
	      seg1rleg.setTextureSize(256, 512);
	      seg1rleg.mirror = true;
	      setRotation(seg1rleg, 0F, 0F, -0.1570796F);
	      seg2 = new ModelRenderer(this, 0, 300);
	      seg2.addBox(-20F, -17F, -9F, 40, 34, 18);
	      seg2.setRotationPoint(0F, -2F, 32F);
	      seg2.setTextureSize(256, 512);
	      seg2.mirror = true;
	      setRotation(seg2, 0F, 0F, 0F);
	      seg2lfoot = new ModelRenderer(this, 125, 300);
	      seg2lfoot.addBox(-5F, 0F, -5F, 10, 10, 10);
	      seg2lfoot.setRotationPoint(13F, 14F, 32F);
	      seg2lfoot.setTextureSize(256, 512);
	      seg2lfoot.mirror = true;
	      setRotation(seg2lfoot, 0F, 0F, 0F);
	      seg2rfoot = new ModelRenderer(this, 175, 300);
	      seg2rfoot.addBox(-5F, 0F, -5F, 10, 10, 10);
	      seg2rfoot.setRotationPoint(-13F, 14F, 32F);
	      seg2rfoot.setTextureSize(256, 512);
	      seg2rfoot.mirror = true;
	      setRotation(seg2rfoot, 0F, 0F, 0F);
	      seg3 = new ModelRenderer(this, 0, 400);
	      seg3.addBox(-15F, -14F, -7F, 30, 28, 14);
	      seg3.setRotationPoint(0F, 3F, 48F);
	      seg3.setTextureSize(256, 512);
	      seg3.mirror = true;
	      setRotation(seg3, 0F, 0F, 0F);
	      seg3lfoot = new ModelRenderer(this, 100, 400);
	      seg3lfoot.addBox(-4F, 0F, -6F, 8, 8, 12);
	      seg3lfoot.setRotationPoint(10F, 16F, 48F);
	      seg3lfoot.setTextureSize(256, 512);
	      seg3lfoot.mirror = true;
	      setRotation(seg3lfoot, 0F, 0F, 0F);
	      seg3rfoot = new ModelRenderer(this, 150, 400);
	      seg3rfoot.addBox(-4F, 0F, -6F, 8, 8, 12);
	      seg3rfoot.setRotationPoint(-10F, 16F, 48F);
	      seg3rfoot.setTextureSize(256, 512);
	      seg3rfoot.mirror = true;
	      setRotation(seg3rfoot, 0F, 0F, 0F);
	      seg3lbackspike = new ModelRenderer(this, 50, 450);
	      seg3lbackspike.addBox(-2F, -20F, -2F, 4, 20, 4);
	      seg3lbackspike.setRotationPoint(13F, -8F, 53F);
	      seg3lbackspike.setTextureSize(256, 512);
	      seg3lbackspike.mirror = true;
	      setRotation(seg3lbackspike, -0.9773844F, 0.2792527F, 0.1396263F);
	      seg3rbackspike = new ModelRenderer(this, 75, 450);
	      seg3rbackspike.addBox(-2F, -20F, -2F, 4, 20, 4);
	      seg3rbackspike.setRotationPoint(-13F, -8F, 53F);
	      seg3rbackspike.setTextureSize(256, 512);
	      seg3rbackspike.mirror = true;
	      setRotation(seg3rbackspike, -0.9773844F, -0.3490659F, 0.1396263F);
	    

  }
  
  // f = lifetime ticker. Doing Math.toRadians() on it provides a nice smooth wave cycle.
  // f1 = entity velocity
  public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
  {
	    float newangle = 0;
	    float headoff = 0;
	    float zpi = 0;
	    float zdist = 0;
	    int i;
	    //System.out.printf("floats: %f,  %f, %f, %f, %f, %f\n", f, f1, f2, f3, f4, deathfactor);
	    //if(f1 > 0.01){
	    //	newangle = (float) (Math.cos(Math.toRadians(f*5.6f)) * (float)Math.PI * 0.25F * f1);
	    //}else{
	    //	newangle = 0.0F;
	    //}
	    
	    if(entity.getAttacking()){
	    	newangle = (float)Math.cos(Math.toRadians(f*17.6f) ) * (float)Math.PI * 0.07F;
	    }else{
	    	newangle = (float)Math.cos(Math.toRadians(f*3.6f) ) * (float)Math.PI * 0.025F;
	    }
	    ljaw.rotateAngleZ = 0.139f + newangle;
	    rjaw.rotateAngleZ = -0.139f - newangle;


	    if(entity.getAttacking()){
	    	headoff = (float)Math.cos(Math.toRadians(f*17.6f) ) * 8f;
	    }else{
	    	headoff = (float)Math.cos(Math.toRadians(f*3.6f) ) * 2f;
	    }
	    Head.rotationPointY = -8 + headoff;
	    falsehead.rotationPointY = -4 + headoff;   
	    ltusk1.rotationPointY = -25 + headoff;
	    ltusk2.rotationPointY = -25 + headoff;
	    rtusk1.rotationPointY = -25 + headoff;
	    rtusk2.rotationPointY = -25 + headoff;
	    ljaw.rotationPointY = -1 + headoff;
	    rjaw.rotationPointY = -1 + headoff;
	    
	    //newangle = (float)Math.cos(f2 * 0.81F ) * (float)Math.PI * 0.08F;
	    //ltusk2.rotateAngleZ = newangle;
	    //newangle = (float)Math.cos(f2 * 0.87F ) * (float)Math.PI * 0.08F;
	    //rtusk2.rotateAngleZ = newangle;
	    
	    newangle = (float)Math.cos(Math.toRadians(f*14.6f) ) * (float)Math.PI * 0.08F;
	    ltusk2.rotateAngleY = 0.802f + newangle;
	    newangle = (float)Math.cos(Math.toRadians(f*15.6f) ) * (float)Math.PI * 0.08F;
	    rtusk2.rotateAngleY = -0.802f + newangle;
	    
	    
	    Head.render(deathfactor);
	    falsehead.render(deathfactor);   
	    ltusk1.render(deathfactor);
	    ltusk2.render(deathfactor);
	    rtusk1.render(deathfactor);
	    rtusk2.render(deathfactor);
	    ljaw.render(deathfactor);
	    rjaw.render(deathfactor);
	    
	    for(i=0;i<3;i++){
	    	seg1.rotationPointY = -8 + (headoff/(i+1))+(8*i) ;

	    	seg1lleg.rotationPointY = -8 + (headoff/(i+1))+(8*i);
	    	seg1rleg.rotationPointY = -8 + (headoff/(i+1))+(8*i);
	    	
	    	seg1.rotationPointZ = -12 + (14*i);

	    	seg1lleg.rotationPointZ = -5 + (14*i);
	    	seg1rleg.rotationPointZ = -5 + (14*i);
	    	
	    	   
	    	   if(entity.getAttacking()){
	    		   newangle = (float)Math.cos((float)((Math.toRadians(f*21.6f)) + ((Math.PI/8.0)*i))) * (float)Math.PI * 0.15F;
	    	    }else{
	    	    	newangle = (float)Math.cos((float)((Math.toRadians(f*6.6f)) + ((Math.PI/8.0)*i))) * (float)Math.PI * 0.04F;
	    	    }
	    	   
	    	   seg1lleg.rotateAngleX = newangle;
	    	   seg1rleg.rotateAngleX = -newangle;
	    	
	    	seg1.render(deathfactor);

	    	seg1lleg.render(deathfactor);
	    	seg1rleg.render(deathfactor);
	    }
	    
	    for(i=0;i<6;i++){
	    	
	    	zdist = (float)Math.cos((Math.toRadians(f*18.6f)) + zpi) * 5.5f * f1;
	    	
	    	seg2.rotationPointZ = 39.0f + ((16f+zdist)*i);
	    	seg2lfoot.rotationPointZ = 39.0f + ((16f+zdist)*i);
	    	seg2rfoot.rotationPointZ = 39.0f + ((16f+zdist)*i);
  
	    	seg2.render(deathfactor);
	    	seg2lfoot.render(deathfactor);
	    	seg2rfoot.render(deathfactor);
	    	
	    	zpi += (float)Math.PI/4;
	    }
	    
	    seg3.rotationPointZ = seg2rfoot.rotationPointZ + 16;
	    seg3lfoot.rotationPointZ = seg3.rotationPointZ;
	    seg3rfoot.rotationPointZ = seg3.rotationPointZ;

	    seg3lbackspike.rotationPointZ = seg3.rotationPointZ + 6;
	    seg3rbackspike.rotationPointZ = seg3.rotationPointZ + 6;
	    
	    i = 6;
	    
	    newangle = (float)Math.cos(Math.toRadians(f*7.6f) ) * (float)Math.PI * 0.04F;
	    seg3lbackspike.rotateAngleX = -0.977f + newangle;
	    newangle = (float)Math.cos(Math.toRadians(f*7.75f) ) * (float)Math.PI * 0.04F;
	    seg3rbackspike.rotateAngleX = -0.977f + newangle;
	    
	    newangle = (float)Math.cos(Math.toRadians(f*9.1f) ) * (float)Math.PI * 0.04F;
	    seg3lbackspike.rotateAngleY = 0.280f + newangle;
	    newangle = (float)Math.cos(Math.toRadians(f*11.6f) ) * (float)Math.PI * 0.04F;
	    seg3rbackspike.rotateAngleY = -0.280f + newangle;
	    
	    seg3.render(deathfactor);
	    seg3lfoot.render(deathfactor);
	    seg3rfoot.render(deathfactor);

	    seg3lbackspike.render(deathfactor);
	    seg3rbackspike.render(deathfactor);
    
  }
  
//  public void doScale(Entity ent){
	  //MonarchCaterpillar mc = (MonarchCaterpillar)ent;
//	  super.doScale(ent);
	  //System.out.printf("scale = %f\n", mc.getScaleCat() );
	  //MatrixStack.scale(mc.getScaleCat(), mc.getScaleCat(), mc.getScaleCat());
//  }
  

}
