package dangerzone.entities;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.ModelRenderer;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */
public class ModelFuzzButt extends ModelBase
{

  //fields
    ModelRenderer head;
    ModelRenderer abd;
    ModelRenderer butt;
    ModelRenderer eye1;
    ModelRenderer eye2;
    ModelRenderer eye3;
    ModelRenderer eye4;
    ModelRenderer eye5;
    ModelRenderer eye6;
    ModelRenderer fuzz1;
    ModelRenderer fuzz2;
    ModelRenderer fuzz3;
    ModelRenderer fuzz4;
    ModelRenderer fuzz5;
    ModelRenderer leg1a;
    ModelRenderer leg2a;
    ModelRenderer leg3a;
    ModelRenderer leg4a;
    ModelRenderer leg1b;
    ModelRenderer leg2b;
    ModelRenderer leg3b;
    ModelRenderer leg4b;
    ModelRenderer leg5a;
    ModelRenderer leg6a;
    ModelRenderer leg7a;
    ModelRenderer leg8a;
    ModelRenderer leg5b;
    ModelRenderer leg6b;
    ModelRenderer leg7b;
    ModelRenderer leg8b;

  
  public ModelFuzzButt()
  {
    
      head = new ModelRenderer(this, 0, 79);
      head.addBox(-4F, 0F, 0F, 10, 6, 10);
      head.setRotationPoint(-1F, 16F, -11F);
      head.setTextureSize(64, 128);
      head.mirror = true;
      setRotation(head, 0F, 0F, 0F);
      abd = new ModelRenderer(this, 0, 96);
      abd.addBox(0F, 0F, 0F, 4, 2, 6);
      abd.setRotationPoint(-2F, 19F, -1F);
      abd.setTextureSize(64, 128);
      abd.mirror = true;
      setRotation(abd, 0F, 0F, 0F);
      butt = new ModelRenderer(this, 0, 105);
      butt.addBox(-6F, -3F, -1F, 12, 3, 18);
      butt.setRotationPoint(0F, 21F, 4F);
      butt.setTextureSize(64, 128);
      butt.mirror = true;
      setRotation(butt, 0F, 0F, 0F);
      eye1 = new ModelRenderer(this, 31, 0);
      eye1.addBox(0F, 0F, 0F, 2, 2, 1);
      eye1.setRotationPoint(1F, 17F, -12F);
      eye1.setTextureSize(64, 128);
      eye1.mirror = true;
      setRotation(eye1, 0F, 0F, 0F);
      eye2 = new ModelRenderer(this, 31, 4);
      eye2.addBox(0F, 0F, -1F, 2, 2, 1);
      eye2.setRotationPoint(-3F, 17F, -11F);
      eye2.setTextureSize(64, 128);
      eye2.mirror = true;
      setRotation(eye2, 0F, 0F, 0F);
      eye3 = new ModelRenderer(this, 31, 8);
      eye3.addBox(0F, 0F, 0F, 1, 2, 1);
      eye3.setRotationPoint(5F, 17F, -10F);
      eye3.setTextureSize(64, 128);
      eye3.mirror = true;
      setRotation(eye3, 0F, 0F, 0F);
      eye4 = new ModelRenderer(this, 31, 12);
      eye4.addBox(0F, 0F, 0F, 1, 1, 1);
      eye4.setRotationPoint(5F, 17F, -7F);
      eye4.setTextureSize(64, 128);
      eye4.mirror = true;
      setRotation(eye4, 0F, 0F, 0F);
      eye5 = new ModelRenderer(this, 31, 15);
      eye5.addBox(0F, 0F, 0F, 1, 2, 1);
      eye5.setRotationPoint(-6F, 17F, -10F);
      eye5.setTextureSize(64, 128);
      eye5.mirror = true;
      setRotation(eye5, 0F, 0F, 0F);
      eye6 = new ModelRenderer(this, 31, 19);
      eye6.addBox(0F, 0F, 0F, 1, 1, 1);
      eye6.setRotationPoint(-6F, 17F, -7F);
      eye6.setTextureSize(64, 128);
      eye6.mirror = true;
      setRotation(eye6, 0F, 0F, 0F);
      fuzz1 = new ModelRenderer(this, 0, 69);
      fuzz1.addBox(0F, 0F, 0F, 1, 1, 8);
      fuzz1.setRotationPoint(0F, 19F, 21F);
      fuzz1.setTextureSize(64, 128);
      fuzz1.mirror = true;
      setRotation(fuzz1, 0F, 0F, 0F);
      fuzz2 = new ModelRenderer(this, 0, 59);
      fuzz2.addBox(0F, 0F, 0F, 1, 1, 8);
      fuzz2.setRotationPoint(0F, 19F, 21F);
      fuzz2.setTextureSize(64, 128);
      fuzz2.mirror = true;
      setRotation(fuzz2, -0.5759587F, 0F, 0F);
      fuzz3 = new ModelRenderer(this, 0, 49);
      fuzz3.addBox(0F, 0F, 0F, 1, 1, 8);
      fuzz3.setRotationPoint(0F, 19F, 21F);
      fuzz3.setTextureSize(64, 128);
      fuzz3.mirror = true;
      setRotation(fuzz3, 0.5585054F, 0F, 0F);
      fuzz4 = new ModelRenderer(this, 0, 39);
      fuzz4.addBox(0F, 0F, 0F, 1, 1, 8);
      fuzz4.setRotationPoint(0F, 19F, 21F);
      fuzz4.setTextureSize(64, 128);
      fuzz4.mirror = true;
      setRotation(fuzz4, 0F, -0.6806784F, 0F);
      fuzz5 = new ModelRenderer(this, 0, 29);
      fuzz5.addBox(0F, 0F, 0F, 1, 1, 8);
      fuzz5.setRotationPoint(0F, 19F, 21F);
      fuzz5.setTextureSize(64, 128);
      fuzz5.mirror = true;
      setRotation(fuzz5, 0F, 0.6457718F, 0F);
      leg1a = new ModelRenderer(this, 8, 0);
      leg1a.addBox(0F, -12F, 0F, 1, 12, 1);
      leg1a.setRotationPoint(4F, 21F, -8F);
      leg1a.setTextureSize(64, 128);
      leg1a.mirror = true;
      setRotation(leg1a, 0F, 0F, 0.8726646F);
      leg2a = new ModelRenderer(this, 8, 0);
      leg2a.addBox(0F, -12F, 0F, 1, 12, 1);
      leg2a.setRotationPoint(4F, 21F, -6F);
      leg2a.setTextureSize(64, 128);
      leg2a.mirror = true;
      setRotation(leg2a, 0F, 0F, 0.8726646F);
      leg3a = new ModelRenderer(this, 8, 0);
      leg3a.addBox(0F, -12F, 0F, 1, 12, 1);
      leg3a.setRotationPoint(4F, 21F, -4F);
      leg3a.setTextureSize(64, 128);
      leg3a.mirror = true;
      setRotation(leg3a, 0F, 0F, 0.8726646F);
      leg4a = new ModelRenderer(this, 8, 0);
      leg4a.addBox(0F, -12F, 0F, 1, 12, 1);
      leg4a.setRotationPoint(4F, 21F, -2F);
      leg4a.setTextureSize(64, 128);
      leg4a.mirror = true;
      setRotation(leg4a, 0F, 0F, 0.8726646F);
      leg1b = new ModelRenderer(this, 14, 0);
      leg1b.addBox(0F, 0F, 0F, 1, 12, 1);
      leg1b.setRotationPoint(13F, 14F, -8F);
      leg1b.setTextureSize(64, 128);
      leg1b.mirror = true;
      setRotation(leg1b, 0F, 0F, -0.5235988F);
      leg2b = new ModelRenderer(this, 14, 0);
      leg2b.addBox(0F, 0F, 0F, 1, 12, 1);
      leg2b.setRotationPoint(13F, 14F, -6F);
      leg2b.setTextureSize(64, 128);
      leg2b.mirror = true;
      setRotation(leg2b, 0F, 0F, -0.5235988F);
      leg3b = new ModelRenderer(this, 14, 0);
      leg3b.addBox(0F, 0F, 0F, 1, 12, 1);
      leg3b.setRotationPoint(13F, 14F, -4F);
      leg3b.setTextureSize(64, 128);
      leg3b.mirror = true;
      setRotation(leg3b, 0F, 0F, -0.5235988F);
      leg4b = new ModelRenderer(this, 14, 0);
      leg4b.addBox(0F, 0F, 0F, 1, 12, 1);
      leg4b.setRotationPoint(13F, 14F, -2F);
      leg4b.setTextureSize(64, 128);
      leg4b.mirror = true;
      setRotation(leg4b, 0F, 0F, -0.5235988F);
      leg5a = new ModelRenderer(this, 0, 14);
      leg5a.addBox(0F, 0F, 0F, 1, 12, 1);
      leg5a.setRotationPoint(-4F, 21F, -8F);
      leg5a.setTextureSize(64, 128);
      leg5a.mirror = true;
      setRotation(leg5a, 0F, 0F, 2.268928F);
      leg6a = new ModelRenderer(this, 0, 14);
      leg6a.addBox(0F, 0F, 0F, 1, 12, 1);
      leg6a.setRotationPoint(-4F, 21F, -6F);
      leg6a.setTextureSize(64, 128);
      leg6a.mirror = true;
      setRotation(leg6a, 0F, 0F, 2.268928F);
      leg7a = new ModelRenderer(this, 0, 14);
      leg7a.addBox(0F, 0F, 0F, 1, 12, 1);
      leg7a.setRotationPoint(-4F, 21F, -4F);
      leg7a.setTextureSize(64, 128);
      leg7a.mirror = true;
      setRotation(leg7a, 0F, 0F, 2.268928F);
      leg8a = new ModelRenderer(this, 0, 14);
      leg8a.addBox(0F, 0F, 0F, 1, 12, 1);
      leg8a.setRotationPoint(-4F, 21F, -2F);
      leg8a.setTextureSize(64, 128);
      leg8a.mirror = true;
      setRotation(leg8a, 0F, 0F, 2.268928F);
      leg5b = new ModelRenderer(this, 0, 0);
      leg5b.addBox(-1F, 0F, 0F, 1, 12, 1);
      leg5b.setRotationPoint(-13F, 14F, -8F);
      leg5b.setTextureSize(64, 128);
      leg5b.mirror = true;
      setRotation(leg5b, 0F, 0F, 0.5235988F);
      leg6b = new ModelRenderer(this, 0, 0);
      leg6b.addBox(-1F, 0F, 0F, 1, 12, 1);
      leg6b.setRotationPoint(-13F, 14F, -6F);
      leg6b.setTextureSize(64, 128);
      leg6b.mirror = true;
      setRotation(leg6b, 0F, 0F, 0.5235988F);
      leg7b = new ModelRenderer(this, 0, 0);
      leg7b.addBox(-1F, 0F, 0F, 1, 12, 1);
      leg7b.setRotationPoint(-13F, 14F, -4F);
      leg7b.setTextureSize(64, 128);
      leg7b.mirror = true;
      setRotation(leg7b, 0F, 0F, 0.5235988F);
      leg8b = new ModelRenderer(this, 0, 0);
      leg8b.addBox(-1F, 0F, 0F, 1, 12, 1);
      leg8b.setRotationPoint(-13F, 14F, -2F);
      leg8b.setTextureSize(64, 128);
      leg8b.mirror = true;
      setRotation(leg8b, 0F, 0F, 0.5235988F);
  }
  
  // f = lifetime ticker. Doing Math.toRadians() on it provides a nice smooth wave cycle.
  // f1 = entity velocity
  public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
  {
	 
	    float newangle = 0;
	    //System.out.printf("floats: %f,  %f, %f, %f, %f, %f\n", f, f1, f2, f3, f4, f5);
	    if(f1 > 0.01){
	    	if(f1>1)f1 = 1;
	    	newangle = (float) (Math.cos(Math.toRadians(f*17.6f)) * (float)Math.PI * 0.15F * f1);
	    }else{
	    	newangle = 0.0F;
	    }
	    
	    leg1a.rotateAngleX = 0.524f + newangle;
	    leg2a.rotateAngleX = 0.175f - newangle;
	    leg3a.rotateAngleX = -0.175f + newangle;
	    leg4a.rotateAngleX = -0.524f - newangle;
	    
	    leg5a.rotateAngleX = -0.524f + newangle;
	    leg6a.rotateAngleX = -0.175f - newangle;
	    leg7a.rotateAngleX = 0.175f + newangle;
	    leg8a.rotateAngleX = 0.524f - newangle;
	    
	    //close enough...
	    float distx;
	    distx = (float) (Math.cos(leg1a.rotateAngleZ)*leg1a.sizeY*1.55f);
	    leg1b.rotationPointZ = (float) (leg1a.rotationPointZ - distx*Math.sin(leg1a.rotateAngleX));
	    leg1b.rotationPointX = (float) (leg1a.rotationPointX + distx*Math.cos(leg1a.rotateAngleX)*0.75f);
	    distx = (float) (Math.cos(leg2a.rotateAngleZ)*leg2a.sizeY*1.55f);
	    leg2b.rotationPointZ = (float) (leg2a.rotationPointZ - distx*Math.sin(leg2a.rotateAngleX));
	    leg2b.rotationPointX = (float) (leg2a.rotationPointX + distx*Math.cos(leg2a.rotateAngleX)*0.75f);
	    distx = (float) (Math.cos(leg3a.rotateAngleZ)*leg3a.sizeY*1.55f);
	    leg3b.rotationPointZ = (float) (leg3a.rotationPointZ - distx*Math.sin(leg3a.rotateAngleX));
	    leg3b.rotationPointX = (float) (leg3a.rotationPointX + distx*Math.cos(leg3a.rotateAngleX)*0.75f);
	    distx = (float) (Math.cos(leg4a.rotateAngleZ)*leg4a.sizeY*1.55f);
	    leg4b.rotationPointZ = (float) (leg4a.rotationPointZ - distx*Math.sin(leg4a.rotateAngleX));
	    leg4b.rotationPointX = (float) (leg4a.rotationPointX + distx*Math.cos(leg4a.rotateAngleX)*0.75f);
	    
	    distx = (float) (Math.cos(leg5a.rotateAngleZ)*leg5a.sizeY*1.55f);
	    leg5b.rotationPointZ = (float) (leg5a.rotationPointZ - distx*Math.sin(leg5a.rotateAngleX));
	    leg5b.rotationPointX = (float) (leg5a.rotationPointX + distx*Math.cos(leg5a.rotateAngleX)*0.75f);
	    distx = (float) (Math.cos(leg6a.rotateAngleZ)*leg6a.sizeY*1.55f);
	    leg6b.rotationPointZ = (float) (leg6a.rotationPointZ - distx*Math.sin(leg6a.rotateAngleX));
	    leg6b.rotationPointX = (float) (leg6a.rotationPointX + distx*Math.cos(leg6a.rotateAngleX)*0.75f);
	    distx = (float) (Math.cos(leg7a.rotateAngleZ)*leg7a.sizeY*1.55f);
	    leg7b.rotationPointZ = (float) (leg7a.rotationPointZ - distx*Math.sin(leg7a.rotateAngleX));
	    leg7b.rotationPointX = (float) (leg7a.rotationPointX + distx*Math.cos(leg7a.rotateAngleX)*0.75f);
	    distx = (float) (Math.cos(leg8a.rotateAngleZ)*leg8a.sizeY*1.55f);
	    leg8b.rotationPointZ = (float) (leg8a.rotationPointZ - distx*Math.sin(leg8a.rotateAngleX));
	    leg8b.rotationPointX = (float) (leg8a.rotationPointX + distx*Math.cos(leg8a.rotateAngleX)*0.75f);
	    
	    
	    if(entity.getAttacking()){
	    	leg3b.rotateAngleZ = -2.268f;
	    	leg7b.rotateAngleZ = 2.268f;
	    	butt.rotateAngleX = 0.942f;	    	
	    	fuzz3.rotateAngleX = 0.558f + butt.rotateAngleX + (float) (Math.cos(Math.toRadians(f*12.6f)) * (float)Math.PI * 0.18F);
	    	fuzz2.rotateAngleX = -0.558f + butt.rotateAngleX - (float) (Math.cos(Math.toRadians(f*12.6f)) * (float)Math.PI * 0.18F);
	    	fuzz5.rotateAngleX = butt.rotateAngleX;
	    	fuzz4.rotateAngleX = butt.rotateAngleX;
	    	fuzz5.rotateAngleY = 0.558f + (float) (Math.cos(Math.toRadians(f*21.6f)) * (float)Math.PI * 0.18F);
	    	fuzz4.rotateAngleY = -0.558f - (float) (Math.cos(Math.toRadians(f*21.6f)) * (float)Math.PI * 0.18F);
	    	fuzz1.rotateAngleX = butt.rotateAngleX;
	    	fuzz1.rotateAngleZ = (float) (Math.cos(Math.toRadians(f*5.6f)));
	    }else{
	    	fuzz1.rotateAngleX = 0f;
	    	fuzz2.rotateAngleX = 0.558f;
	    	fuzz3.rotateAngleX = -0.558f;
	    	fuzz4.rotateAngleX = 0f;
	    	fuzz5.rotateAngleX = -0f;
	    	fuzz4.rotateAngleY = 0.558f;
	    	fuzz5.rotateAngleY = -0.558f;
	    	butt.rotateAngleX = 0;
	    	leg3b.rotateAngleZ = -0.524f;
	    	leg7b.rotateAngleZ = 0.524f;
	    	fuzz1.rotateAngleZ = 0;
	    }
	    
	    fuzz1.rotationPointY = (float) (butt.rotationPointY - Math.sin(butt.rotateAngleX)*17) - 2;
	    fuzz2.rotationPointY = fuzz3.rotationPointY = fuzz4.rotationPointY = fuzz5.rotationPointY = fuzz1.rotationPointY;
	    fuzz1.rotationPointZ = (float) (butt.rotationPointZ + Math.cos(butt.rotateAngleX)*17) - 2;
	    fuzz2.rotationPointZ = fuzz3.rotationPointZ = fuzz4.rotationPointZ = fuzz5.rotationPointZ = fuzz1.rotationPointZ;
	    
	    head.render(deathfactor);
	    abd.render(deathfactor);
	    butt.render(deathfactor);
	    eye1.render(deathfactor);
	    eye2.render(deathfactor);
	    eye3.render(deathfactor);
	    eye4.render(deathfactor);
	    eye5.render(deathfactor);
	    eye6.render(deathfactor);
	    fuzz1.render(deathfactor);
	    fuzz2.render(deathfactor);
	    fuzz3.render(deathfactor);
	    fuzz4.render(deathfactor);
	    fuzz5.render(deathfactor);
	    leg1a.render(deathfactor);
	    leg2a.render(deathfactor);
	    leg3a.render(deathfactor);
	    leg4a.render(deathfactor);
	    leg1b.render(deathfactor);
	    leg2b.render(deathfactor);
	    leg3b.render(deathfactor);
	    leg4b.render(deathfactor);
	    leg5a.render(deathfactor);
	    leg6a.render(deathfactor);
	    leg7a.render(deathfactor);
	    leg8a.render(deathfactor);
	    leg5b.render(deathfactor);
	    leg6b.render(deathfactor);
	    leg7b.render(deathfactor);
	    leg8b.render(deathfactor);
    
  }
  

}
