package dangerzone.entities;

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;

public class ModelFireball extends ModelBase {

	private boolean compiled = false;
	private int side1[] = new int[8];
	
	public ModelFireball()
	{
		super();		  
	}	  

	/*
	 * rendering for Item/Block when floating around as an entity.
	 */
	public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor)
	{
		
		float spinz = entity.getSpinz();
		
		MatrixStack.pushMatrix();
		MatrixStack.rotate(spinz, 0, 0, 1); //we push the matrix and let opengl do z rotation for us! otherwise... massive matrix math...
		MatrixStack.sendCurrentStack();
		
		MatrixStack.sendFinalStack();
		
		if(!compiled){
			doCompile();
		}

		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "alpha_adjust"), 0.75f);			
		DangerZone.wr.setBrightness(0.95f);
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);


		int which = DangerZone.rand.nextInt(8);
		GL30.glBindVertexArray(side1[which]);				
		GL11.glDrawArrays(GL11.GL_QUADS, 0, 4);						
		GL30.glBindVertexArray(0);
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);	

		DangerZone.wr.setBrightness();
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "alpha_adjust"), 1f);	
		GL11.glDisable(GL11.GL_BLEND);
		
		MatrixStack.popMatrix();
	}

	public void doScale(Entity ent){	
		MatrixStack.scale( 1.55f, 1.55f, 1.55f);		
	}

	private void doCompile(){

		float offinc = 0;

		int stride = 3*4; //xyz coord size (floats!)
		int textureoff = stride;
		stride += 2*4; //texture coord size
		int coloroff = stride;
		stride += 3*4; //rgb (brightness bytes!)	
		
		for(int i=0;i<8;i++){
			
			side1[i] = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(side1[i]);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);	
			
	    	ByteBuffer vbodata = BufferUtils.createByteBuffer(4*stride); // size   	    	
	    	addVertexInfoToBuffer(vbodata, 9, 9, 0, 1,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, 9, 0, 0,offinc, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -9, -9, 0, 0,offinc + 0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 9, -9, 0, 1,offinc + 0.125f, 1f, 1f, 1f);
	    			    		    	
	    	vbodata.flip();
	    	int vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
										
			offinc += 0.125f;
		}
		
		compiled = true;
	}

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }
    
}