package dangerzone.entities;


import slick.Texture;

import java.util.List;
import java.util.ListIterator;

import dangerzone.DamageTypes;
import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;


public class Libtard extends EntityLiving {
	
	public	Libtard(World w){
		super(w);
		maxrenderdist = 120; //in blocks
		this.height = 1.90f;
		this.width = 0.85f;
		uniquename = "DangerZone:Libtard";
		moveSpeed = 0.15f;
		setMaxHealth(3.0f);
		setHealth(3.0f);
		setDefense(0.75f);
		setAttackDamage(0.3f);
		searchDistance = 16f;
		attackRange = 2.5f;
		movefrequency = 55;
		setExperience(20);
		canSwim = true;
		has_inventory = true;
		temperament = Temperament.HOSTILE;
		enable_hostile = true;
		tower_defense_enable = true;
		enable_buddy = true;
		findbuddydistance = 25;
		findbuddyfrequency = 25;
	}
	
	
	public String getLivingSound(){
		int which = world.rand.nextInt(8);
		if(which == 1)return "DangerZone:vaxxed_living1";
		if(which == 2)return "DangerZone:vaxxed_living2";
		if(which == 3)return "DangerZone:vaxxed_living3";
		if(which == 4)return "DangerZone:vaxxed_living4";
		if(which == 5)return "DangerZone:vaxxed_living5";
		return null;
	}
	
	public void update(float deltaT){
		if(getAttacking()){
			setArmsUp(true);
		}else{
			setArmsUp(false);
		}
		super.update(deltaT);
	}
	
	public float getLivingSoundVolume(){
		return 0.5f;
	}
	
	public String getHurtSound(){
		int which = world.rand.nextInt(5);
		if(which == 1)return "DangerZone:vaxxed_hit1";
		if(which == 2)return "DangerZone:vaxxed_hit2";
		if(which == 3)return "DangerZone:vaxxed_hit3";
		if(which == 4)return "DangerZone:vaxxed_hit4";
		if(which == 0)return "DangerZone:vaxxed_hit5";
		return null;
	}
	
	public String getDeathSound(){
		return "DangerZone:vaxxed_death";
	}
	
	public String getAttackSound(){
		int which = world.rand.nextInt(5);
		if(which == 1)return "DangerZone:vaxxed_attack1";
		if(which == 2)return "DangerZone:vaxxed_attack2";
		if(which == 3)return "DangerZone:vaxxed_attack3";
		return null;
	}
	
	 public boolean isBuddy(Entity e){
			if(e instanceof Vaxxed)return true;
			if(e instanceof Libtard)return true;
			if(e instanceof Teacher)return true;
			if(e instanceof Professor)return true;
			if(e instanceof Dean)return true;
			if(e instanceof Doctor)return true;
			if(e instanceof BigPharma)return true;
		 return false;
	 }
	
	
	public void doFindBuddy(){
		if(world.rand.nextInt(findbuddyfrequency) == 1){			
			List<Integer> nearby_list = null;
			int nbuddy = 0;
			double totalx, totalz;
			totalx = totalz = 0;
			//Get a list of entities within range
			nearby_list = DangerZone.server.entityManager.findEntitiesInRangei(findbuddydistance, dimension, posx, posy, posz);
			if(nearby_list != null){
				if(!nearby_list.isEmpty()){
					Entity e = null;
					ListIterator<Integer> li = nearby_list.listIterator();
					while(li.hasNext()){
						e = DangerZone.server.entityManager.entities[li.next()];												
						if(e != null && e != this && isBuddy(e)){

							int mult = 1;
							if(e instanceof Vaxxed)mult = 1;
							if(e instanceof Libtard)mult = 2;
							if(e instanceof Teacher)mult = 4;
							if(e instanceof Professor)mult = 8;
							if(e instanceof Dean)mult = 16;
							if(e instanceof Doctor)mult = 16;
							if(e instanceof BigPharma)mult = 32;

							totalx += e.posx*mult;
							totalz += e.posz*mult;
							nbuddy += mult;

						}		
					}
					if(nbuddy > 0){
						//head towards middle of group
						totalx /= nbuddy;
						totalz /= nbuddy;
						float rundir = (float) Math.atan2(totalx - posx, totalz - posz);
						rundir = (float) Math.toDegrees(rundir);
						findNewTarget(rundir, 45f);
					}
				}								
			}			
		}
	}
	
	
	
	public void doAttackFrom(/*entity that hit me*/Entity e, /*DamageTypes*/int dt, float pain){	
		if(dt == DamageTypes.POISON)return; //already poisoned!
		doAttackFromCustom(e, dt, pain, true);
	}
	
	public void doAttack(Entity victim){
		Effects ef = new Effects(Effects.POISON, 0.02f, 50);
		victim.addEffectFromServer(ef);
		super.doAttack(victim);
	}	
	
	public void doEntityAction(float deltaT){
		if(world.isServer) {
			if(effect_list == null || effect_list.size() == 0) {
				Effects ef = new Effects(Effects.POISON, 0.01f, 1000);
				addEffect(ef);
			}
		}
		super.doEntityAction(deltaT);
	}
	
	public void doDeathDrops(){	
		if(world.rand.nextInt(5)==1)Utils.doDropRand(world, 0, Items.trophylibtard.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.stick.itemID, 1f, dimension, posx, posy, posz);
		Utils.doDropRand(world, 0, Items.sign.itemID, 1f, dimension, posx, posy, posz);
		super.doDeathDrops();
	}

	//Override, because we attack hostiles that are NOT moose!
	public boolean isSuitableTarget(Entity e){
		if(isIgnorable(e))return false;
		if(e instanceof Vaxxed)return false;
		if(e instanceof Libtard)return false;
		if(e instanceof Teacher)return false;
		if(e instanceof Professor)return false;
		if(e instanceof Dean)return false;
		if(e instanceof Doctor)return false;
		if(e instanceof BigPharma)return false;
		if(e.temperament == Temperament.HOSTILE && CanProbablySeeEntity(e) )return true;
		if(e instanceof Player && CanProbablySeeEntity(e) )return true;
		return false;
	}
	
	//Model calls back out to see what texture to use.
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/skins/"+ "Libtardtexture.png");	//this is not fast, so we keep our own pointer!
		}
		return texture;
	}
	

}