package dangerzone.entities;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.util.List;
import java.util.ListIterator;
import slick.Texture;


import dangerzone.DangerZone;
import dangerzone.GameModes;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;


public class EntityNoob extends EntityExp {
	
	public int deathtimer = 10 * 60; // = one minute on the server
	public int pickup_delay = 0; //so you can toss things straight down
	public int points = 0;
	int nexttext = 0;
	int nexttextcount = 0;
	int countdir = 1;
	boolean tried = false;
	
	public EntityNoob(World w){
		super(w);
		maxrenderdist = 32; //in blocks
		this.height = 0.25f;
		this.width = 0.25f;
		uniquename = "DangerZone:Noob";
		pickup_delay = 10; // = 1 second on server
		points = 0;
		if(w != null){
			nexttext = w.rand.nextInt(8);
			nexttextcount = w.rand.nextInt(10);
		}
		canthitme = true; //Ignore me!
		setFlying(true);
	}
	

	public void update( float deltaT){
		float rate = (float)((float)DangerZone.entityupdaterate/DangerZone.serverentityupdaterate);
				
		if(this.world.isServer){
			int bbid;
			boolean inliquid = false;
			
			bbid = this.world.getblock(dimension, (int)this.posx, (int)(this.posy-(this.getHeight()+0.25f)), (int)this.posz);
			if(Blocks.isSolid(bbid)){				
				motiony += 0.007f * deltaT;
			}else{
				if(Blocks.isLiquid(bbid)){
					Blocks.entityInLiquid(bbid, this);
					inliquid = true;
				}		
				motiony -= 0.005f * deltaT;
			}
			setInLiquid(inliquid);
			
			motiony *= (1.0f-(0.05f*deltaT));
			motionx *= (1.0f-(0.05f*deltaT));
			motionz *= (1.0f-(0.05f*deltaT));

			if(getOnFire() != 0){
				deathtimer -= 5;
			}
			
			deathtimer--;
			if(deathtimer <= 0){
				this.deadflag = true;
				return;
			}
			
			if(pickup_delay > 0)pickup_delay--;
			
			this.rotation_yaw_motion = 0;
			this.rotation_pitch_motion = 0;
			this.rotation_roll_motion = 0;
			this.rotation_pitch = 0;
			this.rotation_yaw = 0;
			this.rotation_roll = 0;
			
			if(!this.deadflag && pickup_delay <= 0){
				Player p = DangerZone.server.findNearestPlayer(this);
				if(p != null){
					double maxdist = p.getWidth()+8f;
					if(this.getDistanceFromEntityCenter(p) < maxdist && !p.deadflag && p.getGameMode() != GameModes.LIMBO){
						if(this.getDistanceFromEntityCenter(p) < p.getWidth()+1.0f){
							p.setExperience(p.getExperience()-this.getExperience()); //SUBTRACT!
							this.deadflag = true;
							if(getBID() == 0) {
								DangerZone.ground_pulse();
								world.playSound("DangerZone:pop", dimension, posx, posy, posz, 0.25f, 1.0f+(world.rand.nextFloat()-world.rand.nextFloat())*0.3f);
							}
						}

					   	float tdir = (float) Math.atan2(p.posx - posx, p.posz - posz);
					   	double dist;
					   	double factor;
				    	dist = this.getDistanceFromEntityCenter(p);
				    	factor = (maxdist - dist)/maxdist;
				    	if(factor > 1)factor = 1; 
				    	if(factor < 0)factor = 0;
				    	factor *= 2;
				    	motionx += 0.04f*factor*Math.sin(tdir) * deltaT;
				    	motionz += 0.04f*factor*Math.cos(tdir) * deltaT;
				    	if(posy>p.posy+p.getHeight()/2)motiony -= 0.02f * deltaT * factor;
				    	if(posy<p.posy+p.getHeight()/2)motiony += 0.06f * deltaT * factor;
					}
				}
			}
			
			//if getting to be a lot of entities, try combining once...
			if(!tried && !deadflag && DangerZone.server.entityManager.active_entities > DangerZone.max_entities/8){
				List<Entity> nearby_list = null;
				ListIterator<Entity> li;
				Entity e = null;
				//						
				nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(8.0f, dimension, posx, posy, posz);
				if(nearby_list != null){
					if(!nearby_list.isEmpty()){
						li = nearby_list.listIterator();
						while(li.hasNext()){
							e = (Entity)li.next();
							if(e != this && e instanceof EntityNoob && !e.deadflag){	
								EntityNoob ex = (EntityNoob)e;
								ex.setExperience(ex.getExperience()+this.getExperience());
								ex.deathtimer = 10 * 120; //give it double!
								this.deadflag = true;
								break;																		
							}
						}
					}
				}
				tried = true;				
			}
			
			if(getInLiquid()){
				doInLiquid(1.0f);
				motionx *= 0.90f;
				motiony *= 0.90f;
				motionz *= 0.90f;
				doSolidsPushback(0, deltaT);
			}
			
		}else{
			motiony *= (1.0f-(0.05f*deltaT*rate));
			motionx *= (1.0f-(0.05f*deltaT*rate));
			motionz *= (1.0f-(0.05f*deltaT*rate));
		}
		super.update( deltaT );
	}
	
	
	public Texture getTexture(){
		if(texture == null){
			//ENTITIES MUST USE TEXTUREMAPPER.GETTEXTURE()!!!!
			texture = TextureMapper.getTexture("res/misc/"+ "noob.png");
		}
		return texture;
	}
	
	
}

