package dangerzone.entities;


import dangerzone.Explosion;
import dangerzone.threads.ExplosionThread;
import dangerzone.world.World;

public class EntityExplosion extends Entity {
		
	public Entity thrower = null;
	
	public EntityExplosion(World w){
		super(w);
		maxrenderdist = 1; //in blocks
		this.height = 0.0f;
		this.width = 0.0f;
		uniquename = "DangerZone:Explosion";
		canthitme = true; //Ignore me!
		setBID(0); //default true, do entity damage and fire
	}	

	public void update( float deltaT){
				
		if(this.world.isServer){
			if(thrower == null)thrower = this;
			if(getAttackDamage() <= 99) {
				Explosion.boom(thrower, world, dimension, (int)posx, (int)posy, (int)posz, (int)getAttackDamage(), getBID()==0?true:false);
			}else {
				//kick it off into a thread so it doesn't hold things up!!!
				ExplosionThread rt = new ExplosionThread(thrower, world, dimension, posx, posy, posz, getAttackDamage(), getBID()==0?true:false);
				Thread it = new Thread(rt);
				it.setPriority(Thread.NORM_PRIORITY); 
				it.start();		
			}
			this.deadflag = true;
		}
		super.update( deltaT );
	}
	
}
