package dangerzone.blocks;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.items.Items;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;


public class Door extends Block {
	private boolean compiled = false; //graphics outputs compiled. Or not.
	private int squareid3D = 0;
	private float blockrenderwidth = 16;
		
	public Door(String n, String txt){
		super(n, txt);
		breaksound = "DangerZone:woodbreak"; 
		placesound = "DangerZone:woodplace"; 
		hitsound =   "DangerZone:woodhit";
		isSolidForRendering = false;
		isSolid = true;
		hasOwnRenderer = true;	
		maxdamage = 100;
		burntime = 65;
		hasFront = true;
		showInInventory = false;
	}
	
	public String getStepSound(){
		int i = DangerZone.rand.nextInt(4);
		if(i == 0)return "DangerZone:wood1";
		if(i == 1)return "DangerZone:wood2";
		if(i == 2)return "DangerZone:wood3";
		return "DangerZone:wood4";
	}
	
	public void notifyNeighborChanged(World w, int d, int x, int y, int z){
		int bid = 0;
		
		if(!w.isServer)return;
		bid = w.getblock(d, x, y, z);
		if(bid != Blocks.doortop.blockID && bid != Blocks.doorbottom.blockID)return;
		
		if(!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0))return;
		if(blockID == Blocks.doorbottom.blockID){
			bid = w.getblock(d, x, y+1, z);
			if(bid != Blocks.doortop.blockID){
				w.setblock(d, x, y, z, 0);
			}
		}else{
			bid = w.getblock(d, x, y-1, z);
			if(bid != Blocks.doorbottom.blockID){
				w.setblock(d, x, y, z, 0);
			}
		}
	}
	
	public boolean getIsSolid(World w, int d, int x, int y, int z){
		int meta = w.getblockmeta(d, x, y, z);
		if((meta&0x01)==0x01){
			return false;
		}
		return true;
	}
	
	//client-side only
	public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z){		
		//Player can be NULL! Make sure you check!
		return 0; //standard default return
	}
	
	//client-side only
	public int getItemDrop(Player p, World w, int dimension, int x, int y, int z){
		return Items.door.itemID;
	}
	
	//Player right-clicked on this block
	//client-side only
	public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int s){
		if(p != null){
			if(p.world.isServer){
				int meta = p.world.getblockmeta(p.dimension, x, y, z);
				if((meta&0x01)==0x01){
					meta &= 0xfffe; //mask it off! //close door
					if(p.world.rand.nextBoolean()){
						p.world.playSound("DangerZone:door_close1", dimension, x, y, z, 0.75f, 1.0f);
					}else{
						p.world.playSound("DangerZone:door_close2", dimension, x, y, z, 0.75f, 1.0f);
					}
				}else{
					meta |= 0x01; //open door
					if(p.world.rand.nextBoolean()){
						p.world.playSound("DangerZone:door_open1", dimension, x, y, z, 0.75f, 1.0f);
					}else{
						p.world.playSound("DangerZone:door_open2", dimension, x, y, z, 0.75f, 1.0f);
					}
				}
				if(!BreakChecks.canChangeBlock(p, dimension, x, y, z, blockID, meta))return false;
				p.world.setblockandmeta(p.dimension, x, y, z, blockID, meta);
				
				//adjust our other half
				if(blockID == Blocks.doortop.blockID){
					p.world.setblockandmeta(p.dimension, x, y-1, z, Blocks.doorbottom.blockID, meta);
				}else{
					p.world.setblockandmeta(p.dimension, x, y+1, z, Blocks.doortop.blockID, meta);
				}
			}
		}
		return false; //NO block placement here!
	}
	
	public void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int inmeta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder){

		VBOBuffer v = null;
		StitchedTexture st = null;
		float brw = blockrenderwidth/2;
		float xoff = 0;
		int meta = inmeta;
			
		st = builder.findVBOtextureforblockside(0, bid); //loads us into the stitching if we are not already!
		if(st == null)return;
		v = builder.findOrMakeVBOForTexture(chunkvbos, st, isTranslucent);
		if(v == null)return;
		
		if((inmeta&0x01)==0x01){
			xoff = 7; //door is open!
			//now fix open rotation to match door open
			if((inmeta&BlockRotation.Y_MASK) == BlockRotation.Y_ROT_0){
				meta = BlockRotation.Y_ROT_90;
			}else if((inmeta&BlockRotation.Y_MASK) == BlockRotation.Y_ROT_90){
				meta = BlockRotation.Y_ROT_180;
			}else if((inmeta&BlockRotation.Y_MASK) == BlockRotation.Y_ROT_180){
				meta = BlockRotation.Y_ROT_270;
			}else{
				meta = BlockRotation.Y_ROT_0;
			}			
		}
		
		//if((sides & 0x20) != 0){
			addVertextWithRotation(v, 1 + xoff, brw, -brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin + ((st.yoffsetmax-st.yoffsetmin)/8), meta, builder);		
			addVertextWithRotation(v, -1 + xoff, brw, -brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder);		
			addVertextWithRotation(v, -1 + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder);
			addVertextWithRotation(v, 1 + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin + ((st.yoffsetmax-st.yoffsetmin)/8), meta, builder);
		//}
		
		//if((sides & 0x10) != 0){
			addVertextWithRotation(v, 1 + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin + ((st.yoffsetmax-st.yoffsetmin)/8), meta, builder); 			
			addVertextWithRotation(v, -1 + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder); 			
			addVertextWithRotation(v, -1 + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder); 			
			addVertextWithRotation(v, 1 + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin + ((st.yoffsetmax-st.yoffsetmin)/8), meta, builder);
		//}
		
		//if((sides & 0x08) != 0){
			addVertextWithRotation(v, 1 + xoff, brw, brw, xo, yo, zo, st.xoffsetmin + ((st.xoffsetmax-st.xoffsetmin)/8), st.yoffsetmin, meta, builder); 	
			addVertextWithRotation(v, -1 + xoff, brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder); 		
			addVertextWithRotation(v, -1 + xoff, -brw, brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder); 		
			addVertextWithRotation(v, 1 + xoff, -brw, brw, xo, yo, zo, st.xoffsetmin + ((st.xoffsetmax-st.xoffsetmin)/8), st.yoffsetmax, meta, builder);
		//}
			
		//if((sides & 0x04) != 0){
			addVertextWithRotation(v, -1 + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin + ((st.xoffsetmax-st.xoffsetmin)/8), st.yoffsetmin, meta, builder); 
			addVertextWithRotation(v, 1 + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder); 
			addVertextWithRotation(v, 1 + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder); 
			addVertextWithRotation(v, -1 + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin + ((st.xoffsetmax-st.xoffsetmin)/8), st.yoffsetmax, meta, builder); 
		//}
		
		//front
		//if((sides & 0x01) != 0){
			addVertextWithRotation(v, -1 + xoff, brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder);
			addVertextWithRotation(v, -1 + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder); 
			addVertextWithRotation(v, -1 + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder); 
			addVertextWithRotation(v, -1 + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmax, meta, builder);
		//}
		//back
		//if((sides & 0x02) != 0){
			addVertextWithRotation(v, 1 + xoff, brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmin, meta, builder); 
			addVertextWithRotation(v, 1 + xoff, brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmin, meta, builder); 
			addVertextWithRotation(v, 1 + xoff, -brw, brw, xo, yo, zo, st.xoffsetmax, st.yoffsetmax, meta, builder); 
			addVertextWithRotation(v, 1 + xoff, -brw, -brw, xo, yo, zo, st.xoffsetmin, st.yoffsetmax, meta, builder); 
		//}

	}
	
	public void addVertextWithRotation(VBOBuffer v, float x, float y, float z, float xo, float yo, float zo, float xtx, float ytx, int meta, VBODataBuilderThread builder){
		if((meta & BlockRotation.Y_MASK) == 0){			
			v.addVertexInfoToVBO(z + xo, y + yo, -x + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb); 
		}else if((meta & BlockRotation.Y_MASK) == BlockRotation.Y_ROT_90){
			v.addVertexInfoToVBO(-x + xo, y + yo, -z + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb); 
		}else if((meta & BlockRotation.Y_MASK) == BlockRotation.Y_ROT_180){
			v.addVertexInfoToVBO(-z + xo, y + yo, x + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb); 
		}else{							
			v.addVertexInfoToVBO(x + xo, y + yo, z + zo, xtx, ytx, builder.cbr, builder.cbg, builder.cbb);
		}
	}
	
	public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus){
		

		if(!compiled){
			int stride = 3*4; //xyz coord size (floats!)
			int textureoff = stride;
			stride += 2*4; //texture coord size
			int coloroff = stride;
			stride += 3*4; //rgb (brightness bytes!)	
			
			squareid3D = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(squareid3D);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);	

	    	ByteBuffer vbodata = BufferUtils.createByteBuffer(24*stride); // size  
	    	
			
	    	addVertexInfoToBuffer(vbodata, 1, blockrenderwidth/2, -blockrenderwidth/2, 1,0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, blockrenderwidth/2, -blockrenderwidth/2, 1,0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, blockrenderwidth/2, blockrenderwidth/2, 0,0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, blockrenderwidth/2, blockrenderwidth/2, 0,0.125f, 1f, 1f, 1f);
			
	    	addVertexInfoToBuffer(vbodata, 1, -blockrenderwidth/2, blockrenderwidth/2, 1,0.125f, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, -blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, -blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, -blockrenderwidth/2, -blockrenderwidth/2, 0,0.125f, 1f, 1f, 1f);
	    	
	    	addVertexInfoToBuffer(vbodata, 1, blockrenderwidth/2, blockrenderwidth/2, 0.125f,0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, blockrenderwidth/2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, -blockrenderwidth/2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, -blockrenderwidth/2, blockrenderwidth/2, 0.125f,1, 1f, 1f, 1f);
	    		    	
	    	addVertexInfoToBuffer(vbodata, -1, blockrenderwidth/2, -blockrenderwidth/2, 0.125f,0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, -blockrenderwidth/2, -blockrenderwidth/2, 0.125f,1, 1f, 1f, 1f);
	    		    	
	    	addVertexInfoToBuffer(vbodata, -1, blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -1, -blockrenderwidth/2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    		    	
	    	addVertexInfoToBuffer(vbodata, 1, blockrenderwidth/2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, blockrenderwidth/2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, -blockrenderwidth/2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, 1, -blockrenderwidth/2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    		    	
	    	vbodata.flip();
	    	int vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
	    	
			compiled = true;
		}

		wr.loadtextureforblockside(0, bid, false); //We only have one side. Tell world renderer to load our texture.
		
		float rot = 0;
		float xoff = 0;
		float zoff = 0;
		
		if((meta&0x01)==0x00){
			if((meta & BlockRotation.Y_MASK) == 0){		
				//System.out.printf("0 = ymask 0\n");
				rot = 270f;
			}else if((meta & BlockRotation.Y_MASK) == BlockRotation.Y_ROT_90){
				//System.out.printf("0 = ymask 90\n");
				rot = 180f;
			}else if((meta & BlockRotation.Y_MASK) == BlockRotation.Y_ROT_180){
				//System.out.printf("0 = ymask 180\n");
				rot = 90f;
			}else{	
				//System.out.printf("0 = ymask 270\n");
				rot = 0;
			}
		}else{
			if((meta & BlockRotation.Y_MASK) == 0){	
				//System.out.printf("1 = ymask 0\n");
				rot = 180;
				xoff = -6.93f;
			}else if((meta & BlockRotation.Y_MASK) == BlockRotation.Y_ROT_90){
				//System.out.printf("1 = ymask 90\n");
				rot = 90;
				zoff = 6.93f;
			}else if((meta & BlockRotation.Y_MASK) == BlockRotation.Y_ROT_180){
				//System.out.printf("1 = ymask 180\n");
				rot = 0f;
				xoff = 6.93f;
			}else{	
				//System.out.printf("1 = ymask 270\n");
				rot = 270f;
				zoff = -6.93f;
			}
		}
		
		//MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();
		
		MatrixStack.rotate(rot, 0, 1, 0);
		if((meta&0x01)==0x01) {
			if(xoff != 0)MatrixStack.translate(xoff,  0,  0);
			if(zoff != 0)MatrixStack.translate(0,  0,  zoff);
		}
		MatrixStack.sendCurrentStack();
		
		MatrixStack.sendFinalStack();
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);
		
		GL30.glBindVertexArray(squareid3D);
		
		GL11.glDrawArrays(GL11.GL_QUADS, 0, 24);
				
		GL30.glBindVertexArray(0);
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);

		MatrixStack.popMatrix();
		
	}
	
    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }


}
