package dangerzone.blocks;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import java.nio.ByteBuffer;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;


public class ButterflyPlant extends Block {
	private boolean compiled = false; //graphics outputs compiled. Or not.
	private int squareid3D = 0;
	private float blockrenderwidth = 12;
		
	public ButterflyPlant(String n, String txt){
		super(n, txt);
		breaksound = "DangerZone:leavesbreak";
		placesound = "DangerZone:leavesplace";
		hitsound =   "DangerZone:leaves_hit";
		isSolidForRendering = false;
		isSolid = false;
		hasOwnRenderer = true;
		randomtick = true;	
		isLeaves = true;
		maxdamage = 1;
		burntime = 10;
		showInInventory = true;
		if(!n.equals("DangerZone:Butterfly Plant")){
			showInInventory = false;
		}
	}
	
	public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z){
		return Blocks.butterfly_plant.blockID;
	}
	
	public void notifyNeighborChanged(World w, int d, int x, int y, int z){
		int bid = w.getblock(d, x, y-1, z);
		if(bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID){
			//Don't know what I'm on, but it's not for growing!
			w.setblock(d, x, y, z, 0); 
			//sometimes drop a block
			if(w.rand.nextInt(4) == 1){
				EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x+0.5f, (double)y+0.5f, (double)z+0.5f);
				if(e != null){
					e.fill(Blocks.butterfly_plant, 1); //I am a block!		
					w.spawnEntityInWorld(e);
				}
			}
		}
	}
	
	public void tickMe(World w, int d, int x, int y, int z){
		if(!w.isServer)return;
		if(w.getblock(d, x, y+1, z) != 0){
			w.setblock(d, x, y, z, 0); //Can't grow with anything on top of me!
			//System.out.printf("Grass died\n");
			return;
		}
		int bid = w.getblock(d, x, y-1, z);
		if(bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID){
			w.setblock(d, x, y, z, 0); 
			//System.out.printf("Grass died\n");
			return;
		}
		
		if(w.isDaytime() && w.rand.nextInt(15) == 1){
			int howmany = 1 + w.rand.nextInt(3);
			if(this.blockID == Blocks.butterfly_plant1.blockID)howmany += 1;
			if(this.blockID == Blocks.butterfly_plant2.blockID)howmany += 2;
			if(this.blockID == Blocks.butterfly_plant3.blockID)howmany += 3;
			for(int i=0;i<howmany;i++){
				Entity eb = w.createEntityByName("DangerZone:Butterfly", d, ((double)x)+0.5f, ((double)y)+1.05f, ((double)z)+0.5f);
				if(eb != null){
					eb.init();
					w.spawnEntityInWorld(eb);
				}
			}
			
			if(w.rand.nextInt(5) == 1){
				int growto = 0;
				if(this.blockID == Blocks.butterfly_plant.blockID)growto = Blocks.butterfly_plant1.blockID;
				if(this.blockID == Blocks.butterfly_plant1.blockID)growto = Blocks.butterfly_plant2.blockID;
				if(this.blockID == Blocks.butterfly_plant2.blockID)growto = Blocks.butterfly_plant3.blockID;
				if(growto != 0){
					if(!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0))return;
					w.setblock(d, x, y, z, growto);
				}
			}
		}
	}
	
	
	
	public void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder){

		VBOBuffer v = null;
		StitchedTexture st = null;
		float brw = blockrenderwidth/2;
		
		st = builder.findVBOtextureforblockside(0, bid); //loads us into the stitching if we are not already!
		v = builder.findOrMakeVBOForTexture(chunkvbos, st, isTranslucent);
		
		if(v != null){
			
			v.addVertexInfoToVBO(brw + xo, brw + yo - 2, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 	
			v.addVertexInfoToVBO(-brw + xo, brw + yo - 2, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 		
			v.addVertexInfoToVBO(-brw + xo, -brw + yo - 2, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 		
			v.addVertexInfoToVBO(brw + xo, -brw + yo - 2, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
	
			v.addVertexInfoToVBO(-brw + xo, brw + yo - 2, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(brw + xo, brw + yo - 2, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(brw + xo, -brw + yo - 2, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(-brw + xo, -brw + yo - 2, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 

			v.addVertexInfoToVBO(-brw + xo, brw + yo - 2, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
			v.addVertexInfoToVBO(-brw + xo, brw + yo - 2, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(-brw + xo, -brw + yo - 2, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(-brw + xo, -brw + yo - 2, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);

			v.addVertexInfoToVBO(brw + xo, brw + yo - 2, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(brw + xo, brw + yo - 2, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(brw + xo, -brw + yo - 2, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 
			v.addVertexInfoToVBO(brw + xo, -brw + yo - 2, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb); 
		
		}

	}
	

	
	public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus){
		
		if(!compiled){
			int stride = 3*4; //xyz coord size (floats!)
			int textureoff = stride;
			stride += 2*4; //texture coord size
			int coloroff = stride;
			stride += 3*4; //rgb (brightness bytes!)	
			
			squareid3D = GL30.glGenVertexArrays();
			GL30.glBindVertexArray(squareid3D);
			GL20.glEnableVertexAttribArray(0);
			GL20.glEnableVertexAttribArray(1);
			GL20.glEnableVertexAttribArray(2);	

	    	ByteBuffer vbodata = BufferUtils.createByteBuffer(16*stride); // size   	
	    	
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2 - 2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2 - 2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2 - 2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2 - 2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    	
	    	addVertexInfoToBuffer(vbodata,-blockrenderwidth/2, blockrenderwidth/2 - 2, -blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2 - 2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2 - 2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2 - 2, -blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	 
			
	    	addVertexInfoToBuffer(vbodata,-blockrenderwidth/2, blockrenderwidth/2 - 2, blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, blockrenderwidth/2 - 2, -blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2 - 2, -blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, -blockrenderwidth/2, -blockrenderwidth/2 - 2, blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    	
	    	addVertexInfoToBuffer(vbodata,blockrenderwidth/2, blockrenderwidth/2 - 2, -blockrenderwidth/2, 1, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, blockrenderwidth/2 - 2, blockrenderwidth/2, 0, 0, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2 - 2, blockrenderwidth/2, 0, 1, 1f, 1f, 1f);
	    	addVertexInfoToBuffer(vbodata, blockrenderwidth/2, -blockrenderwidth/2 - 2, -blockrenderwidth/2, 1, 1, 1f, 1f, 1f);
	    		    	
	    	vbodata.flip();
	    	int vbo_buffer = GL15.glGenBuffers();
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, vbo_buffer);
	    	GL15.glBufferData(GL15.GL_ARRAY_BUFFER, vbodata, GL15.GL_STATIC_DRAW);
	    	GL20.glVertexAttribPointer(0, 3, GL11.GL_FLOAT, false, stride, 0);
	    	GL20.glVertexAttribPointer(1, 2, GL11.GL_FLOAT, false, stride, textureoff);
	    	GL20.glVertexAttribPointer(2, 3, GL11.GL_FLOAT, false, stride, coloroff);
	    	GL15.glBindBuffer(GL15.GL_ARRAY_BUFFER, 0);
	    	GL30.glBindVertexArray(0);
			GL20.glDisableVertexAttribArray(2);
			GL20.glDisableVertexAttribArray(1);
			GL20.glDisableVertexAttribArray(0);		
	    	
			compiled = true;
		}
		
		wr.loadtextureforblockside(0, bid, false); //We only have one side. Tell world renderer to load our texture.
		
		MatrixStack.sendFinalStack();
		
		GL20.glEnableVertexAttribArray(0);
		GL20.glEnableVertexAttribArray(1);
		GL20.glEnableVertexAttribArray(2);
		
		GL30.glBindVertexArray(squareid3D);
		
		GL11.glDrawArrays(GL11.GL_QUADS, 0, 16);
				
		GL30.glBindVertexArray(0);
		
		GL20.glDisableVertexAttribArray(2);
		GL20.glDisableVertexAttribArray(1);
		GL20.glDisableVertexAttribArray(0);
		

	}
	
    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz,
    		float tx, float ty,
    		float br, float bg, float bb){

    	vbodata.putFloat( vx);
    	vbodata.putFloat( vy);
    	vbodata.putFloat( vz);

    	vbodata.putFloat(tx);
    	vbodata.putFloat(ty);

    	vbodata.putFloat(br);
    	vbodata.putFloat(bg);
    	vbodata.putFloat(bb);
   	
    }


}
