package dangerzone.blocks;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */



import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;

import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.MonarchCaterpillar;
import dangerzone.items.Items;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;


public class BlockMilkweed extends BlockCorn { //uses BlockCorn graphics rendering!
	
		
	public BlockMilkweed(String n, String txt){
		super(n, txt);
		isSolidForRendering = false;
		isSolid = false;
		breaksound = "DangerZone:leavesbreak";
		placesound = "DangerZone:leavesplace";
		hitsound =   "DangerZone:leaves_hit";
		isLeaves = true;
		randomtick = true;
		maxdamage = 5;
		showInInventory = false;
		hasOwnRenderer = true;
		burntime = 15;
	}
	
	public void notifyNeighborChanged(World w, int d, int x, int y, int z){
		//System.out.printf("notified %d\n", this.blockID);
		int bid = w.getblock(d, x, y-1, z);
		if(bid != Blocks.dirt.blockID && bid != Blocks.grassblock.blockID
				&& bid != Blocks.milkweed_plant.blockID && bid != Blocks.milkweed_plant1.blockID
				&& bid != Blocks.milkweed_plant2.blockID && bid != Blocks.milkweed_plant3.blockID){
			//Don't know what I'm on, but it's not for growing!
			w.setblock(d, x, y, z, 0);
			if(this.blockID == Blocks.milkweed_plant3.blockID){
				int i = w.rand.nextInt(3) + 1;				
				for(int j=0;j<i;j++){
					EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x+0.5f, (double)y+0.5f, (double)z+0.5f);
					if(e != null){
						e.fill(Items.milkweed_seed, 1);		
						w.spawnEntityInWorld(e);
					}
					Utils.spawnExperience(1, w, d, (double)x+0.5f, (double)y+0.5f, (double)z+0.5f);
				}
			}
		}
	}
	
	//client-side only
	public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z){
		//Player can be NULL! Make sure you check!
		return 0;
	}
	
	//client-side only
	public int getItemDrop(Player p, World w, int d, int x, int y, int z){
		//System.out.printf("getItemDrop %d\n", this.blockID);
		//Player can be NULL! Make sure you check!
		if(this.blockID == Blocks.milkweed_plant3.blockID){
			Utils.spawnExperience(1, w, d, (double)x+0.5f, (double)y+0.5f, (double)z+0.5f);
			return Items.milkweed_seed.itemID; //override this if you want to drop an item instead of a block.
		}
		return 0;
	}
	
	public int getDropCount(Player p, World w, int d, int x, int y, int z){
		//System.out.printf("getDropCount %d\n", this.blockID);
		if(this.blockID == Blocks.milkweed_plant3.blockID){
			int i = w.rand.nextInt(7) + 3;	
			return i;
		}
		return 0;
	}
	
	
	public void tickMe(World w, int d, int x, int y, int z){

		if(this.blockID != Blocks.milkweed_plant.blockID && this.blockID != Blocks.milkweed_plant1.blockID) return; 

		int i;    	
		int bid;
		int var6;
		int Height = 1;
		int dontGrow = 0;
		int myMaxHeight;
		
		if(w.rand.nextInt(10) != 1)return; //SLOW DOWN!
		if(!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0))return;

		myMaxHeight = w.getblockmeta(d, x, y, z);
		myMaxHeight &= 0xf;
		//System.out.printf("Corn counter = %d\n", var7); 
		if(myMaxHeight == 0)myMaxHeight = 3 + w.rand.nextInt(4); //Add some variation...
		
		bid = w.getblock(d, x, y + 1, z);
		if(bid == 0){
			for (var6 = 1; var6 < 10; var6++){
				bid = w.getblock(d, x, y - var6, z);
				if(bid != Blocks.milkweed_plant.blockID && bid != Blocks.milkweed_plant1.blockID && bid != Blocks.milkweed_plant2.blockID && bid != Blocks.milkweed_plant3.blockID ){
					break;
				}
				Height++;
				if(bid == Blocks.milkweed_plant2.blockID || bid == Blocks.milkweed_plant3.blockID){
					dontGrow = 1;
				}
			}

			if(dontGrow != 0){
				myMaxHeight = Height; //Something is hosed. Try to fix it.          
			}

			if(Height < myMaxHeight){
				//System.out.printf("Growing\n");
				w.setblockandmeta(d, x, y+1, z, Blocks.milkweed_plant.blockID, myMaxHeight); //Move top of plant up one block.          		
				w.setblockandmeta(d, x, y, z, Blocks.milkweed_plant1.blockID, myMaxHeight); //Now have a longer stem          		
			}else{
				//We grew up as much as we wanted to. Now mature the milkweed.            		
				for(i=1;i<(myMaxHeight-1);i++){
					bid = w.getblock(d, x, y - i, z);
					if(bid == Blocks.milkweed_plant1.blockID && w.rand.nextInt(2) == 0){            			
						w.setblockandmeta(d, x, y - i, z, Blocks.milkweed_plant2.blockID, myMaxHeight);            				

					}else if(bid == Blocks.milkweed_plant2.blockID && w.rand.nextInt(2) == 0){          			
						w.setblockandmeta(d, x, y - i, z, Blocks.milkweed_plant3.blockID, myMaxHeight);                     			
					}
				}
			}
			for (var6 = 1; var6 < 10; var6++){
				bid = w.getblock(d, x, y - var6, z);
				if(bid == Blocks.milkweed_plant.blockID || bid == Blocks.milkweed_plant1.blockID || bid == Blocks.milkweed_plant2.blockID || bid == Blocks.milkweed_plant3.blockID ){					
					if(w.rand.nextBoolean())spawnCaterpillar(w,  d, x, y - var6, z);
				}
			}
			
		}
	}
	
	public void spawnCaterpillar(World world, int d, int x, int y, int z){
		double px = x;
		double py = y;
		double pz = z;
		int bid;
		
		if(world.rand.nextInt(5) != 1)return;
		
		px += (world.rand.nextInt(4)-world.rand.nextInt(4));
		pz += (world.rand.nextInt(4)-world.rand.nextInt(4));
		
		for(int i=-5; i<=5;i++){
			bid = world.getblock(d, (int)px, (int)py+i, (int)pz);
			if(bid == 0){
				bid = world.getblock(d, (int)px, (int)py+i-1, (int)pz);
				if(bid != 0){
					MonarchCaterpillar sc = (MonarchCaterpillar)world.createEntityByName("DangerZone:Monarch Caterpillar", d, px, py+i, pz);
					if(sc != null){
						sc.init();
						world.spawnEntityInWorld(sc);
						break;
					}
				}
			}
		}		
	}
	

}
