package dangerzone.blocks;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 *
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import slick.Texture;
import dangerzone.DangerZone;
import dangerzone.entities.Entity;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.World;


public class BetterTorch extends LightStick {

	private static ModelBetterTorch mbt = null;
	private String fulltexturestring = null;
	private Texture fulltexture = null;
		
	public BetterTorch(String n, String flattxt, String txt){
		super(n, flattxt);
		isSolidForRendering = false;
		isSolid = false;
		hasOwnRenderer = true;
		brightness = 0.75f;
		maxdamage = 1;
		randomtick = true;
		burntime = 30;
		fulltexturestring = txt;
		if(mbt == null)mbt = new ModelBetterTorch();
	}
	
	public Texture getTexture(int side){
		if(texture == null || fulltexture == null){
			texture = initBlockTexture(texturepath);
			fulltexture = initBlockTexture(fulltexturestring);
		}
		if(side == 5)return fulltexture;
		return texture;
	}
	
	public String getStitchedTextureName(int side){
		return fulltexturestring;
	}
	
	public void renderMeToVBO(long chunkvbos[], WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder){
		
		VBOBuffer v = null;
		StitchedTexture st = null;

		st = builder.findVBOtextureforblockside(5, bid);
		if(st == null)return;
		v = builder.findOrMakeVBOForTexture(chunkvbos, st, isTranslucent);
		if(v == null)return;
		
		switch((meta>>8)){
		case 0:
			mbt.t1base.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
			mbt.t1flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
			break;
		case 1:
			mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
			mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
			mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
			mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);	
			break;
		case 2:
			mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);
			mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);
			mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);
			mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 270);	
			break;
		case 3:
			mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
			mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
			mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
			mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);	
			break;
		case 4:
			mbt.t2base1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
			mbt.t2base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
			mbt.t2base3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
			mbt.t2flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);	
			break;
		case 5:
			mbt.t3base.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo,  0);
			mbt.t3base2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
			mbt.t3flame.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
			break;
		default:
				
		}		
		
	}
	
	public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay){
		if(e == null)return;
		//MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();
		if(!DangerZone.isVR) {
			if(isdisplay) {
				MatrixStack.translate(4,  -1,  -4);
			}else {
				MatrixStack.translate(0,  -1,  -4);
			}
			MatrixStack.scale(3,3,3);
		}else {
			MatrixStack.rotate(90f,  1, 0, 0);
		}
		MatrixStack.sendCurrentStack();
		renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 0, 0, false);
		MatrixStack.popMatrix();
	}
	
	
	public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus){

		wr.loadtextureforblockside(5, bid, false); //We only have one side. Tell world renderer to load our texture.
		
		//MatrixStack.sendCurrentStack();
		MatrixStack.pushMatrix();
		
		switch((meta>>8)){
		case 0:
			MatrixStack.translate(0,  -8,  0);
			MatrixStack.sendCurrentStack();
			mbt.t1base.render(1);
			mbt.t1flame.render(1);
			break;
		case 1:
			MatrixStack.translate(0,  -8,  0);
			MatrixStack.rotate(90f, 0, 1, 0);
			MatrixStack.sendCurrentStack();
			mbt.t2base1.render(1);
			mbt.t2base2.render(1);
			mbt.t2base3.render(1);
			mbt.t2flame.render(1);			
			break;
		case 2:
			
			MatrixStack.translate(0,  -8,  0);	
			MatrixStack.rotate(270f, 0, 1, 0);
			MatrixStack.sendCurrentStack();
			mbt.t2base1.render(1);
			mbt.t2base2.render(1);
			mbt.t2base3.render(1);
			mbt.t2flame.render(1);			
			
			break;
		case 3:
			MatrixStack.translate(0,  -8,  0);
			MatrixStack.rotate(180f, 0, 1, 0);
			MatrixStack.sendCurrentStack();
			mbt.t2base1.render(1);
			mbt.t2base2.render(1);
			mbt.t2base3.render(1);
			mbt.t2flame.render(1);			
			
			break;
		case 4:			
			MatrixStack.translate(0,  -8,  0);
			MatrixStack.sendCurrentStack();
			mbt.t2base1.render(1);
			mbt.t2base2.render(1);
			mbt.t2base3.render(1);
			mbt.t2flame.render(1);			
			break;
		case 5:
			MatrixStack.translate(0,  -8,  0);
			MatrixStack.sendCurrentStack();
			mbt.t3base.render(1);
			mbt.t3base2.render(1);
			mbt.t3flame.render(1);
			break;
		default:
				
		}		

		MatrixStack.popMatrix();
		
	}
	


}
