package dangerzone;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdQuaternion;
import org.lwjgl.openvr.HmdVector3;

import dangerzone.rendering.Matrix4f;

public class UglyMath {
	
    public Matrix4f convertSteamVRMatrix4ToMatrix4f(org.lwjgl.openvr.HmdMatrix44 hmdMatrix, Matrix4f mat){
        mat.set(hmdMatrix.m(0), hmdMatrix.m(1), hmdMatrix.m(2), hmdMatrix.m(3), 
                hmdMatrix.m(4), hmdMatrix.m(5), hmdMatrix.m(6), hmdMatrix.m(7),
                hmdMatrix.m(8), hmdMatrix.m(9), hmdMatrix.m(10), hmdMatrix.m(11), 
                hmdMatrix.m(12), hmdMatrix.m(13), hmdMatrix.m(14), hmdMatrix.m(15));
        return mat;
    }
    
	// Get the x,y,z vector representing the position
	public void GetPosition(HmdMatrix34 matrix, HmdVector3 vector) {
		//Don't ask why. This is just where they put them.
		vector.v().put(0,matrix.m(3));//x
		vector.v().put(1,matrix.m(7));//y
		vector.v().put(2,matrix.m(11));//z
	}
	
	public float fmax(float f1, float f2) {
		if(f1>f2)return f1;
		return f2;
	}
	
	// Returns the Quaternion rotation parameters, w, x, y, z.
	// Sort of like Euler p, y, r, but not quite.
	public void GetRotation(HmdMatrix34 matrix, HmdQuaternion q) {
		//Again with the stuffing numbers in hardcoded locations. Sheesh.
		q.w(Math.sqrt(fmax(0, 1 + matrix.m(0) + matrix.m(5) + matrix.m(10))) / 2);
		q.x(Math.sqrt(fmax(0, 1 + matrix.m(0) - matrix.m(5) - matrix.m(10))) / 2);
		q.y(Math.sqrt(fmax(0, 1 - matrix.m(0) + matrix.m(5) - matrix.m(10))) / 2);
		q.z(Math.sqrt(fmax(0, 1 - matrix.m(0) - matrix.m(5) + matrix.m(10))) / 2);
		q.x(Math.copySign(q.x(), matrix.m(9) - matrix.m(6)));
		q.y(Math.copySign(q.y(), matrix.m(2) - matrix.m(8)));
		q.z(Math.copySign(q.z(), matrix.m(4) - matrix.m(1)));
	}
	
	// Turn Quaternion rotation into normal Euler Rotation so we can use it.
	// (w,x,y,z to p,y,r)
	/* Mostly works?
	static void Quaternion_to_Euler(HmdQuaternion q1, HmdVector3 vector) {
		double sqx = q1.x()*q1.x();
		double sqy = q1.y()*q1.y();
		double sqz = q1.z()*q1.z();
		double pitch = -Math.atan2(2.0 * (q1.w()*q1.x() + q1.y()*q1.z()),1 - 2.0 * (sqx + sqy));		
		double yaw = -Math.asin(2.0 * (q1.w()*q1.y() - q1.z()*q1.x()));
		double roll = -Math.atan2(2.0 * (q1.w()*q1.z() + q1.x()*q1.y()), 1 - 2.0 * (sqy + sqz));
		vector.v().put(0,(float)pitch);
		vector.v().put(1,(float)yaw);
		vector.v().put(2,(float)roll);
	}
	*/
	
	/*
	 * 
//Source: http://docs.ros.org/latest-lts/api/dji_sdk_lib/html/DJI__Flight_8cpp_source.html#l00152
EulerianAngle Flight::toEulerianAngle(QuaternionData data)
{
    EulerianAngle ans;

    double q2sqr = data.q2 * data.q2;
    double t0 = -2.0 * (q2sqr + data.q3 * data.q3) + 1.0;
    double t1 = +2.0 * (data.q1 * data.q2 + data.q0 * data.q3);
    double t2 = -2.0 * (data.q1 * data.q3 - data.q0 * data.q2);
    double t3 = +2.0 * (data.q2 * data.q3 + data.q0 * data.q1);
    double t4 = -2.0 * (data.q1 * data.q1 + q2sqr) + 1.0;

    t2 = t2 > 1.0 ? 1.0 : t2;
    t2 = t2 < -1.0 ? -1.0 : t2;

    ans.pitch = asin(t2); //yaw???
    ans.roll = atan2(t3, t4); //pitch???
    ans.yaw = atan2(t1, t0);  //roll???

    return ans;
}
	 
	 */
	
	//This DEFINTELY does not work well. ROLL is all horked up.
	//We can use these values for DISPLAY as long as they are all three used together.
	//They are completely useless and just plain wrong if taken singly.
	public void Quaternion_to_Euler(HmdQuaternion q1, HmdVector3 vector) {

	    double q2sqr = q1.y() * q1.y();
	    double t0 = -2.0 * (q2sqr + q1.z() * q1.z()) + 1.0;
	    double t1 = +2.0 * (q1.x() * q1.y() + q1.w() * q1.z());
	    double t2 = -2.0 * (q1.x() * q1.z() - q1.w() * q1.y());
	    double t3 = +2.0 * (q1.y() * q1.z() + q1.w() * q1.x());
	    double t4 = -2.0 * (q1.x() * q1.x() + q2sqr) + 1.0;

	    t2 = t2 > 1.0 ? 1.0 : t2;
	    t2 = t2 < -1.0 ? -1.0 : t2;

	    vector.v().put(1,(float)-Math.asin(t2));      //yaw
	    vector.v().put(0,(float)-Math.atan2(t3, t4)); //pitch
	    vector.v().put(2,(float)-Math.atan2(t1, t0)); //roll
	    
	}
	
	public boolean closeEnough(float a, float b) {
	    return (0.0001f > Math.abs(a - b));
	}
	
	
	//This works pretty well, but we will use it only to get a reasonable ROLL calculation.
	//Quaternions don't separate out roll very nicely. This does.
	public void rot34_to_euler(HmdMatrix34 matrix, HmdVector3 vector) {
			
		
		//0 pitch
		//1 yaw
		//2 roll
	    
		//works for little angles
		//vector.v().put(0,(float)Math.atan2(matrix.m(6), matrix.m(10)));
	    //vector.v().put(1,-(float)Math.asin(matrix.m(2)));
	    //vector.v().put(2,(float)Math.atan2(matrix.m(1), matrix.m(0)));	   
		
		//much more consistent. Little blivots at certain degrees.
		
	    if (closeEnough(matrix.m(8), -1.0f)) {
	        float x = 0; //gimbal lock, value of x doesn't matter
	        float y = (float) (Math.PI / 2);
	        float z = (float) (x + Math.atan2(matrix.m(1), matrix.m(2)));
		    vector.v().put(1,-x);
		    vector.v().put(0,-y);
		    vector.v().put(2,-z);
	        
	    } else if (closeEnough(matrix.m(8), 1.0f)) {
	        float x = 0;
	        float y = (float) (-Math.PI / 2);
	        float z = (float) (-x + Math.atan2(-matrix.m(1), -matrix.m(2)));
		    vector.v().put(1,-x);
		    vector.v().put(0,-y);
		    vector.v().put(2,-z);
	        
	    } else { //two solutions exist
	        float x1 = (float) -Math.asin(matrix.m(8));
	        float x2 = (float) (Math.PI - x1);

	        float y1 = (float) Math.atan2(matrix.m(9) / Math.cos(x1), matrix.m(10) / Math.cos(x1));
	        float y2 = (float) Math.atan2(matrix.m(9) / Math.cos(x2), matrix.m(10) / Math.cos(x2));

	        float z1 = (float) Math.atan2(matrix.m(4) / Math.cos(x1), matrix.m(0) / Math.cos(x1));
	        float z2 = (float) Math.atan2(matrix.m(4) / Math.cos(x2), matrix.m(0) / Math.cos(x2));

	        //choose one solution to return
	        //for example the "shortest" rotation
	        if ((Math.abs(x1) + Math.abs(y1) + Math.abs(z1)) <= (Math.abs(x2) + Math.abs(y2) + Math.abs(z2))) {
			    vector.v().put(1,-x1);
			    vector.v().put(0,-y1);
			    vector.v().put(2,-z1);
	            
	        } else {
			    vector.v().put(1,-x2);
			    vector.v().put(0,-y2);
			    vector.v().put(2,-z2);
	            
	        }
	    }		
	}

	
	// Turn Quaternion rotation into normal xyz vector so we can use it.
	// forward vector! (dx, dy, dz)
	public void Quaternion_to_Vector(HmdQuaternion q1, HmdVector3 vector) {
		vector.v().put(0,-(float)(2*(q1.x()*q1.z()+q1.w()*q1.y())));
		vector.v().put(1,-(float)(2*(q1.y()*q1.z()-q1.w()*q1.x())));
		vector.v().put(2,-(float)(1-(2*(q1.x()*q1.x()+q1.y()*q1.y()))));
	}
	
	
	/*
forward vector:
x = 2 * (x*z + w*y)
y = 2 * (y*z - w*x)
z = 1 - 2 * (x*x + y*y)

up vector
x = 2 * (x*y - w*z)
y = 1 - 2 * (x*x + z*z)
z = 2 * (y*z + w*x)

left vector
x = 1 - 2 * (y*y + z*z)
y = 2 * (x*y + w*z)
z = 2 * (x*z - w*y)
	 */
	


}
