package dangerzone;

/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */

import org.lwjgl.openvr.HmdQuaternion;
import org.lwjgl.openvr.HmdVector3;

public class TargetInfo {
	
	
	public TargetInfo() {
		angular_velocity = HmdVector3.create();
		velocity = HmdVector3.create();	
		quat = HmdQuaternion.create();
		rotq_50 = ToQuaternion(0, 0, Math.toRadians(-45)); //pitch
		quat_50 = HmdQuaternion.create();
		vec_50 = HmdVector3.create();
		calc_50_done = false;
	}
	
	public double rel_posx, rel_posy, rel_posz;
	public double real_posx, real_posy, real_posz;	
	public float display_pitch, display_yaw, display_roll;
	public float pitch, yaw;
	public float dx, dy, dz;
	public float ev_pitch, ev_yaw, ev_roll;
	public HmdVector3 angular_velocity;
	public HmdVector3 velocity;
	public HmdVector3 vec_50;
	public HmdQuaternion quat;
	public HmdQuaternion rotq_50;
	public HmdQuaternion quat_50;
	
	public float pitch_50, yaw_50;
	public float dx_50, dy_50, dz_50;
	public boolean calc_50_done = false;
	
	
	//Use this to make a rotation, then rotate onto freaking controller so we don't get bent wrists!
	//Someone doesn't know what pitch, yaw, and roll are though...
	public HmdQuaternion ToQuaternion(double yaw, double pitch, double roll) // yaw (Z), pitch (Y), roll (X)
	{
	    // Abbreviations for the various angular functions
	    double cy = Math.cos(yaw * 0.5);
	    double sy = Math.sin(yaw * 0.5);
	    double cp = Math.cos(pitch * 0.5);
	    double sp = Math.sin(pitch * 0.5);
	    double cr = Math.cos(roll * 0.5);
	    double sr = Math.sin(roll * 0.5);

	    HmdQuaternion q = HmdQuaternion.create();
	    q.w(cr * cp * cy + sr * sp * sy);
	    q.x(sr * cp * cy - cr * sp * sy);
	    q.y(cr * sp * cy + sr * cp * sy);
	    q.z(cr * cp * sy - sr * sp * cy);

	    return q;
	}
	
	/*
	
    // return a new Quaternion whose value is (this * b)
    static  HmdQuaternion times(HmdQuaternion a, HmdQuaternion b) {
        double y0 = a.x0*b.x0 - a.x1*b.x1 - a.x2*b.x2 - a.x3*b.x3;
        double y1 = a.x0*b.x1 + a.x1*b.x0 + a.x2*b.x3 - a.x3*b.x2;
        double y2 = a.x0*b.x2 - a.x1*b.x3 + a.x2*b.x0 + a.x3*b.x1;
        double y3 = a.x0*b.x3 + a.x1*b.x2 - a.x2*b.x1 + a.x3*b.x0;
        return new HmdQuaternion(y0, y1, y2, y3);
    }
    */
    public void mult(HmdQuaternion a, HmdQuaternion b, HmdQuaternion res) {
        
        double qw = b.w(), qx = b.x(), qy = b.y(), qz = b.z();
        double iw = a.w(), ix = a.x(), iy = a.y(), iz = a.z();
        
        res.x( ix * qw + iy * qz - iz * qy + iw * qx);
        res.y( -ix * qz + iy * qw + iz * qx + iw * qy);
        res.z( ix * qy - iy * qx + iz * qw + iw * qz);
        res.w( -ix * qx - iy * qy - iz * qz + iw * qw);
        
    }
    
    public void copy(HmdQuaternion from, HmdQuaternion to) {
    	to.x(from.x());
    	to.y(from.y());
    	to.z(from.z());
    	to.w(from.w());
    }
    
    public void calc_50() {
    	
    	if(calc_50_done)return; //only do this ONCE per cycle!!!
    	
    	mult(quat, rotq_50, quat_50);
		DangerZone.um.Quaternion_to_Vector(quat_50, vec_50); //convert to dx, dy, dz
		//System.out.printf("        xyz vec: %f, %f, %f\n",euler_vec.v().get(0), euler_vec.v().get(1), euler_vec.v().get(2));

		dx_50 = vec_50.v().get(0);
		dy_50 = vec_50.v().get(1);
		dz_50 = vec_50.v().get(2);

		//Finally... having proper dx, dy, dz, we can calculate useful pitch and yaw with roll=0, which we need for shooting and throwing!						
		float tdir = (float) Math.atan2(vec_50.v().get(0), vec_50.v().get(2));
		float ddx, ddz;
		ddx = (float) Math.sqrt(vec_50.v().get(0)*vec_50.v().get(0) + vec_50.v().get(2)*vec_50.v().get(2));
		ddz = (float) Math.atan2(-vec_50.v().get(1), ddx);

		pitch_50 = DangerZone.smooth_degrees(pitch_50, (float) Math.toDegrees(ddz), 0);
		while(pitch_50 < 0)pitch_50 += 360f;
		pitch_50 %= 360f;

		yaw_50 = DangerZone.smooth_degrees(yaw_50, 180f - (float) Math.toDegrees(tdir), 0);
		while(yaw_50 < 0)yaw_50 += 360f;
		yaw_50 %= 360f;
		calc_50_done = true;
    }

}
