package dangerzone;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.rendering.Fastmath;
import dangerzone.world.World;

public class Focus_Finder {
	
	public int focus_x, focus_y, focus_z, focus_side;
	public int focus_bid, focus_meta;
	public float focus_damage = 0;
	public float focus_maxdamage = 0;
	public float focus_dist = 0;
	public Entity focus_entity = null;
	public double poi_x, poi_y, poi_z; //point of impact!!! Client side only.
	private int xlast = 0;
	private int ylast = 0;
	private int zlast = 0;
	private int sidelast = 0;
	private Entity entitylast = null;
	
	/*
	 * Find the block we are pointing at, and the side too...
	 */
	public boolean find_focus(World w){
		double dir, dx, dz, dy;
		double sx, sz, sy;
		double delta = 0.0d;
		double xzscale;
		double delta2;
		double dist, lastdist;
		int x,y,z;
		double fx,fy,fz;
		int lx, ly, lz;
		int bid;
		int eyebid;
		int lfx, lfy, lfz;
		boolean has_changed = false;
		
		Entity tempe = null;
		List<Entity> nearby_list = null;
		List<Entity> check_list = new ArrayList<Entity>();
		ListIterator<Entity> li;
		int riddenid = 0;
		Entity ridden = DangerZone.player.getRiddenEntity();
		if(ridden != null )riddenid = ridden.entityID;
		
		
		fx =  DangerZone.pointer_posx;
		fy = DangerZone.pointer_posy;
		fz =  DangerZone.pointer_posz;
		x = (int) fx;
		y = (int) fy;
		z = (int) fz;
		eyebid = w.getblock(DangerZone.player.dimension, x, y, z); //where our eyes are!
		
		dir = Math.toRadians((DangerZone.pointer_yaw-90)%360f); 
		dx = Math.cos(dir);
		dz = Math.sin(dir);
		dy = Math.sin(Math.toRadians((DangerZone.pointer_pitch)%360f));
		xzscale = Math.abs(Math.cos(Math.toRadians((DangerZone.pointer_pitch)%360f)));
		dx *= xzscale;
		dz *= xzscale;
		dy = -dy;
		
		float reach = 2 + (DangerZone.player.getHeight() * 2.5f);
		if(reach < 2)reach = 2;
		float itemreach = reach - 1;
		float blockreach = reach;
		float itemwidth = 0.125f;
		InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
		if(ic != null){
			itemreach += 0.5f * (float)ic.getAttribute(ItemAttribute.REACH);
			blockreach += 0.25f * (float)ic.getAttribute(ItemAttribute.REACH);
			itemwidth += 0.25f * (float)ic.getAttribute(ItemAttribute.ACCURACY);
		}
		if(itemreach > reach)reach = itemreach;
		if(blockreach > reach)reach = blockreach;
		
		//pre-filter to take out things we cannot possibly or shouldn't hit!
		nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(20.0f+reach, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz);
		if(nearby_list != null){
			if(!nearby_list.isEmpty()){
				li = nearby_list.listIterator();
				while(li.hasNext()){
					tempe = (Entity)li.next();
					dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fy-tempe.posy)*(fy-tempe.posy)+(fz-tempe.posz)*(fz-tempe.posz));
					dist -= 0.125f; //width of sword or whatever
					dist -= (tempe.getWidth()/2); //general hitbox of entity
					if(tempe != DangerZone.player && !tempe.canthitme && dist < 14){					
						//don't hit mount unless looking almost straight down!
						if(tempe.entityID != riddenid){
							//System.out.printf("added %d\n", tempe.entityID);
							check_list.add(tempe);
						}
					}
				}
			}
		}
		
		if(ridden != null && dy < -0.75f)check_list.add(ridden); //add whatever we are riding on! (if looking down!)

		//focus_x = focus_y = focus_z = focus_side = 0;
		lx = ly = lz = 0;
		lfx = focus_x; lfy = focus_y; lfz = focus_z;


		//increment along the axis looking for a block
		while(delta < reach){
			fx =  (DangerZone.pointer_posx + dx*delta);
			fy =  ((DangerZone.pointer_posy) + dy*delta);
			fz =  (DangerZone.pointer_posz + dz*delta);
			
			if(DangerZone.config_isVR && DangerZone.use_pointer) {
				if(Fastmath.nextInt(50) == 1)Utils.spawnParticlesScaled(w, "DangerZone:ParticleSparkle", 1, DangerZone.player.dimension, fx, fy, fz, 0, 0.05f, false);
				if(Fastmath.nextInt(50) == 1)Utils.spawnParticlesScaled(w, "DangerZone:ParticleSmoke", 1, DangerZone.player.dimension, fx, fy, fz, 0, 0.05f, false);
			}
			
			
			x = (int) fx;
			y = (int) fy;
			z = (int) fz;
			//Hit an entity or a block... whichever...
			if(delta < itemreach && check_list != null){
				if(!check_list.isEmpty()){
					li = check_list.listIterator();
					while(li.hasNext()){
						tempe = (Entity)li.next();
						if(fy > tempe.posy-itemwidth && fy < tempe.posy+tempe.getHeight()+itemwidth){
							dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fz-tempe.posz)*(fz-tempe.posz));
							dist -= itemwidth; //width of sword or whatever
							dist -= (tempe.getWidth()/2); //general hitbox of entity
							//System.out.printf("entity dist %d, d = %f\n", tempe.entityID, dist);
							if(dist < 0){
								//System.out.printf("entity hit %d, dy = %f\n", tempe.entityID, dy);
								focus_x = focus_y = focus_z = focus_bid = focus_meta = focus_side = 0;
								focus_damage = 0;
								focus_dist = (float) dist;
								focus_entity = tempe;
								poi_x = fx; poi_y = fy; poi_z = fz;
								
								if(focus_x != xlast || focus_y != ylast || focus_z != zlast || focus_side != sidelast) {
									has_changed = true;
								}
								if(focus_entity != entitylast)has_changed = true;
								xlast = focus_x;
								ylast = focus_y;
								zlast = focus_z;
								sidelast = focus_side;
								entitylast = focus_entity;
								
								return has_changed;
							}
						}
					}
				}
			}
			
			//wait until block actually changes
			if(delta < blockreach && x != lx || y != ly || z != lz){
				lx = x; ly = y; lz = z;
				bid = w.getblock(DangerZone.player.dimension, x, y, z);
				if(eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid))bid = 0; //we are in water. ignore water.
				if(bid != 0){ //Hit a block!!!	
					
					//but wait! If it is NOT a solid block, then we need to check for a hit-able entity inside!
					//hit the entity if possible, else continue with hitting the block...
					if(!Blocks.isSolid(bid) && check_list != null){
						int tbid;
						int tx, ty, tz;
						int tlx = lx;
						int tlz = lz;
						int tly = ly;
						double tdelta = delta;
						while(tdelta < itemreach){
							fx =  (DangerZone.pointer_posx + dx*tdelta);
							fy =  ((DangerZone.pointer_posy) + dy*tdelta);
							fz =  (DangerZone.pointer_posz + dz*tdelta);
							tx = (int) fx;
							ty = (int) fy;
							tz = (int) fz;
							if(tx != tlx || ty != tly || tz != tlz){
								tbid = w.getblock(DangerZone.player.dimension, tx, ty, tz);
								if(Blocks.isSolid(tbid)){
									break; //hit something solid. break out and process original non-solid block.
								}
								tlx = tx; tly = ty; tlz = tz;
							}
							if(!check_list.isEmpty()){
								li = check_list.listIterator();
								while(li.hasNext()){
									tempe = (Entity)li.next();
									if(fy > tempe.posy-itemwidth && fy < tempe.posy+tempe.getHeight()+itemwidth){
										dist = Math.sqrt((fx-tempe.posx)*(fx-tempe.posx)+(fz-tempe.posz)*(fz-tempe.posz));
										dist -= itemwidth; //width of sword or whatever
										dist -= (tempe.getWidth()/2); //general hitbox of entity
										//System.out.printf("entity dist %d, d = %f\n", tempe.entityID, dist);
										if(dist < 0){
											//System.out.printf("entity hit %d, dy = %f\n", tempe.entityID, dy);
											focus_x = focus_y = focus_z = focus_bid = focus_meta = focus_side = 0;
											focus_damage = 0;
											focus_dist = (float) dist;
											focus_entity = tempe;
											poi_x = fx; poi_y = fy; poi_z = fz;
											
											if(focus_x != xlast || focus_y != ylast || focus_z != zlast || focus_side != sidelast) {
												has_changed = true;
											}
											if(focus_entity != entitylast)has_changed = true;
											xlast = focus_x;
											ylast = focus_y;
											zlast = focus_z;
											sidelast = focus_side;
											entitylast = focus_entity;
											
											return has_changed;
										}
									}
								}
							}
							tdelta += 0.1d;
						}
					}
					
					//hit something! Now back it up one step and loop for 0.01;
					delta2 = delta;
					delta = delta - 0.1f;
					x = (int) (DangerZone.pointer_posx + dx*delta);
					y = (int) ((DangerZone.pointer_posy) + dy*delta );
					z = (int) (DangerZone.pointer_posz + dz*delta);
					lx = x; ly = y; lz = z;

					//loop to get really really close to intersection
					while(delta < delta2+0.01f){
						fx =  (DangerZone.pointer_posx + dx*delta);
						fy =  ((DangerZone.pointer_posy) + dy*delta);
						fz =  (DangerZone.pointer_posz + dz*delta);
						x = (int) fx;
						y = (int) fy;
						z = (int) fz;
						if(x != lx || y != ly || z != lz){
							lx = x; ly = y; lz = z;
							bid = w.getblock(DangerZone.player.dimension, x, y, z);
							if(eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid))bid = 0; //we are in water. ignore water.
							if(bid != 0){ //Hit a block!!! (again)
								
								//Now we are within 1/100th of the side. 
								//See which side center is closest to this ray-plane intersection point.

								dx =  (DangerZone.pointer_posx + dx*delta);
								dy =  ((DangerZone.pointer_posy) + dy*delta );
								dz =  (DangerZone.pointer_posz + dz*delta);
								dist = 2.0d;
								lastdist = 2.0d;
								focus_side = 0;
								poi_x = fx; poi_y = fy; poi_z = fz;

								//top
								sx = ((double)x + 0.5f);
								sy = ((double)y + 1.0f);
								sz = ((double)z + 0.5f);
								dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
								if(dist < lastdist){
									lastdist = dist;
									focus_side = 0;
								}						

								//back
								sx = ((double)x + 0.5f);
								sy = ((double)y + 0.5f);
								sz = ((double)z + 0.0f);
								dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
								if(dist < lastdist){
									lastdist = dist;
									focus_side = 2;
								}

								//front
								sx = ((double)x + 0.5f);
								sy = ((double)y + 0.5f);
								sz = ((double)z + 1.0f);
								dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
								if(dist < lastdist){
									lastdist = dist;
									focus_side = 1;
								}

								//left
								sx = ((double)x + 0.0f);
								sy = ((double)y + 0.5f);
								sz = ((double)z + 0.5f);
								dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
								if(dist < lastdist){
									lastdist = dist;
									focus_side = 3;
								}

								//right
								sx = ((double)x + 1.0f);
								sy = ((double)y + 0.5f);
								sz = ((double)z + 0.5f);
								dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
								if(dist < lastdist){
									lastdist = dist;
									focus_side = 4;
								}

								//bottom
								sx = ((double)x + 0.5f);
								sy = ((double)y + 0.0f);
								sz = ((double)z + 0.5f);
								dist = Math.sqrt((sx-dx)*(sx-dx)+(sy-dy)*(sy-dy)+(sz-dz)*(sz-dz));
								if(dist < lastdist){
									lastdist = dist;
									focus_side = 5;
								}

								//Done! Fast and efficient, with no complex vector math involved! :)
								focus_x = lx;
								focus_y = ly;
								focus_z = lz;
								focus_bid = bid;
								focus_meta = w.getblockmeta(DangerZone.player.dimension, x, y, z);
								focus_dist = (float) delta;
								focus_entity = null;
								if(lfx != focus_x || lfy != focus_y || lfz != focus_z){
									focus_damage = 0;
									focus_maxdamage = Blocks.getMaxDamage(bid);
									if(focus_maxdamage < 1)focus_maxdamage = 1;
								}
								//System.out.printf("Side = %d\n", focus_side);
								
								if(focus_x != xlast || focus_y != ylast || focus_z != zlast || focus_side != sidelast) {
									has_changed = true;
								}
								if(focus_entity != entitylast)has_changed = true;
								xlast = focus_x;
								ylast = focus_y;
								zlast = focus_z;
								sidelast = focus_side;
								entitylast = focus_entity;
								
								return has_changed;
							}
						}
						delta += 0.01f;
					}
				}
			}
			delta += 0.1d;
		}
		focus_x = focus_y = focus_z = focus_bid = focus_meta = focus_side = 0;
		poi_x = poi_y = poi_z = 0;
		focus_damage = 0;
		focus_dist = 0;
		focus_entity = null;
		
		if(focus_x != xlast || focus_y != ylast || focus_z != zlast || focus_side != sidelast) {
			has_changed = true;
		}
		if(focus_entity != entitylast)has_changed = true;
		xlast = focus_x;
		ylast = focus_y;
		zlast = focus_z;
		sidelast = focus_side;
		entitylast = focus_entity;
		
		return has_changed;
	}

}
