package dangerzone;
/*
 * This code is copyright Richard H. Clark, TheyCallMeDanger, OreSpawn, 2015-2021.
 * You may use this code for reference for modding the DangerZone game program,
 * and are perfectly welcome to cut'n'paste portions for your mod as well.
 * DO NOT USE THIS CODE FOR ANY PURPOSE OTHER THAN MODDING FOR THE DANGERZONE GAME.
 * DO NOT REDISTRIBUTE THIS CODE. 
 * 
 * WARNING: There are bugs. Big bugs. Little bugs. Every size in-between bugs.
 * This code is NOT suitable for use in anything other than this particular game. 
 * NO GUARANTEES of any sort are given, either express or implied, and Richard H. Clark, 
 * TheyCallMeDanger, OreSpawn are not responsible for any damages, direct, indirect, or otherwise. 
 * You should have made backups. It's your own fault for not making them.
 * 
 * NO ATTEMPT AT SECURITY IS MADE. This code is USE AT YOUR OWN RISK.
 * Regardless of what you may think, the reality is, that the moment you 
 * connected your computer to the Internet, Uncle Sam, among many others, hacked it.
 * DO NOT KEEP VALUABLE INFORMATION ON INTERNET-CONNECTED COMPUTERS.
 * Or your phone...
 * 
 */


import org.lwjgl.glfw.GLFW;
import static org.lwjgl.glfw.GLFW.*;
import static org.lwjgl.opengl.GL11.glClearColor;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import slick.Inputs;
import slick.Inputs.ScrollEvent;
import slick.ColorSlick;

import slick.TrueTypeFont;
import slick.SoundStore;
import slick.Texture;
import slick.TextureLoader;
import slick.ResourceLoader;

import org.lwjgl.openvr.*;
import org.lwjgl.openvr.TrackedDevicePose.Buffer;

import static org.lwjgl.openvr.VR.*;
import static org.lwjgl.openvr.VRSystem.*;


import dangerzone.blocks.BlockRotation;
import dangerzone.blocks.Blocks;
import dangerzone.crafting.Cooking;
import dangerzone.crafting.Crafting;
import dangerzone.crafting.DeskCrafting;
import dangerzone.crafting.Shredding;
import dangerzone.entities.Entities;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityExp;
import dangerzone.entities.EntityNoob;
import dangerzone.entities.ModelEntityBlockItem;
import dangerzone.entities.ModelExp;
import dangerzone.entities.ModelHumanoid;
import dangerzone.gui.GuiInterface;
import dangerzone.gui.KeyHandlers;
import dangerzone.gui.OverlayGUI;
import dangerzone.gui.PlayerChatGUI;
import dangerzone.gui.PlayerChestGUI;
import dangerzone.gui.PlayerColoringGUI;
import dangerzone.gui.PlayerCommandGUI;
import dangerzone.gui.PlayerCraftingGUI;
import dangerzone.gui.PlayerDeathGUI;
import dangerzone.gui.PlayerDeskGUI;
import dangerzone.gui.PlayerDimensionGUI;
import dangerzone.gui.PlayerDroneGUI;
import dangerzone.gui.PlayerEntityGUI;
import dangerzone.gui.PlayerEscapeGUI;
import dangerzone.gui.PlayerFurnaceGUI;
import dangerzone.gui.PlayerHelpGUI;
import dangerzone.gui.PlayerInventoryGUI;
import dangerzone.gui.PlayerPetNameGUI;
import dangerzone.gui.PlayerShredderGUI;
import dangerzone.gui.PlayerSignGUI;
import dangerzone.gui.PlayerStatsGUI;
import dangerzone.gui.PlayerToDoGUI;
import dangerzone.gui.PlayerTradeGUI;
import dangerzone.gui.PlayerVRGUI;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.network.CustomPackets;
import dangerzone.particles.Particles;
import dangerzone.rendering.Fastmath;
import dangerzone.rendering.FramebufferDesc;
import dangerzone.rendering.Matrix4f;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ShaderStuff;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;
import dangerzone.rendering.WorldRendererUtils;
import dangerzone.threads.ChunkWriterThread;
import dangerzone.threads.CleanerThread;
import dangerzone.threads.DisplaySorterThread;
import dangerzone.threads.EntityUpdateLoop;
import dangerzone.threads.LightingThread;
import dangerzone.threads.ParticleUpdateLoop;
import dangerzone.threads.RumbleThread;
import dangerzone.threads.Server;
import dangerzone.threads.ServerConnection;
import dangerzone.threads.SoundPollingThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.Chunk;
import dangerzone.world.ChunkCache;
import dangerzone.world.Dimensions;
import dangerzone.world.Ores;
import dangerzone.world.ServerChunkCache;
import dangerzone.world.Spawnlist;
import dangerzone.world.World;
import dangerzone.world.WorldDecorators;



public class DangerZone {
	

	public static String versionstring = "2.7-VR";
	
	public static volatile int gameover = 0;
	static String windowTitle = "Welcome to the Danger Zone...";
	public static float deltaT = 0;
	public static String server_address = null;
	public static int server_port = 0;
	public static String nsserver_address = null;
	public static int nsserver_port = 0;
	public static ChunkCache client_chunk_cache = null;
	public static ServerChunkCache server_chunk_cache = null;
	public static ChunkWriterThread chunkwriter = null;
	public static SoundPollingThread soundpollingthread = null;
	public static DisplaySorterThread displaysorterthread = null;
	public static int screen_width = 1000;
	public static int screen_height = 600;
	public static int vr_screen_width = 1000;
	public static int vr_screen_height = 600;
	public static int screen_screen_width = 1000;
	public static int screen_screen_height = 600;
	public static Player player = null;
	public static World world = null;
	public static World server_world = null;
	public static String worldname = null; 
	public static String origworldname = null; 
	public static WorldRenderer wr = null;
	public static ServerConnection server_connection = null;
	public static Server server = null;
	public static WorldDecorators wds = null;
	public static BreakChecks breakchecker = null;
	public static Blocks all_the_blocks;
	public static Items all_the_items;
	public static Dimensions all_the_dimensions;
	public static Crafting all_the_recipies;
	public static DeskCrafting all_the_deskrecipies;
	public static Cooking all_the_cooking;
	public static Entities all_the_entities;
	public static Particles all_the_particles;
	public static Ores all_the_ores;
	public static Spawnlist all_the_spawns;
	public static CustomPackets all_the_custompackets;
	public static CommandHandlers all_the_handlers;
	public static Shredding all_the_shreds;
	public static Texture logotexture = null;
	public static Texture textinputtexture = null;
	public static int messagetimer = 0;
	public static String messagestring = null;
	public static int hotmessagetimer = 0;
	public static String hotmessagestring = null;
	public static String ghost_string = "Game Mode Ghost";
	public static String creative_string = "Game Mode Creative";
	public static String survival_string = "Game Mode Survival";
	public static String limbo_string = "Game Mode Limbo";
	public static int renderdistance = 24; //chunks
	public static int savedrenderdistance = 0;
	public static EntityUpdateLoop clientEntityManager;
	public static ParticleUpdateLoop clientParticleManager;
	public static int entityupdatedist = 16*24; //blocks!
	public static int max_entities = 6000;		//max entities allowed alive at any one time.
	public static DangerZoneBase base;
	public static int entityupdaterate = 17; //ms
	public static int serverentityupdaterate = 100; //ms
	public static boolean f3_on = false; //useful info overlay
	public static volatile boolean f12_on = false;//PAUSE and SHOWCASE!
	public static volatile boolean f5_front = false;
	public static volatile boolean f5_back = false;
	public static volatile boolean f5_side = false;
	public static boolean view_ores = false;
	public static String blockitemname = "DangerZone:BlockItem"; //Builtin
	public static boolean escape_options_menu = false;
	public static boolean mouse_grabbed = false;
	public static volatile GuiInterface current_gui = null;
	
	//these can now all be overridden by the modder
	//completely replace any DZ gui
	//some take no input, some take an input being set by the caller, and some take a call to init()
	//find an example usage and do the same... I'm tired. I don't want to make them all the same... grrrr....
	//all external routines that start a DZ GUI should use these references and NOT declare a new instance.
	public static PlayerEscapeGUI escapegui = null;
	public static PlayerHelpGUI helpgui = null;
	public static PlayerDimensionGUI dimensiongui = null;
	public static PlayerChatGUI chatgui = null;
	public static PlayerCommandGUI commandgui = null;
	public static PlayerInventoryGUI inventorygui = null;
	public static PlayerDeathGUI deathgui = null;	
	public static PlayerChestGUI chestgui = null;
	public static PlayerColoringGUI coloringgui = null;
	public static PlayerCraftingGUI craftinggui = null;
	public static PlayerDeskGUI deskgui = null;
	public static PlayerDroneGUI dronegui = null;
	public static PlayerFurnaceGUI furnacegui = null;
	public static PlayerPetNameGUI petnamegui = null;
	public static PlayerShredderGUI shreddergui = null;
	public static PlayerSignGUI signgui = null;
	public static PlayerEntityGUI entitygui = null;
	public static PlayerTradeGUI tradegui = null;
	public static PlayerStatsGUI statsgui = null;
	public static PlayerToDoGUI todogui = null;
	public static PlayerVRGUI vrgui = null;
	
	public static DZCommandHandler commandhandler = null;
	public static EntityBlockItem blockitem = null;
	public static int packets_per_second = 0;
	public static int chunks_per_second = 0;
	public static int gofasttimer = 0;
	public static int gofast = 0;
	public static int flytimer = 0;
	public static int gofly = 0;
	public static volatile int do_hit_cycle = 0;
	public static volatile int do_food_cycle = 0;
	private static int volume_temp = 0;
	private static int music_volume_temp = 0;
	public static SoundManager soundmangler = null;
	public static boolean start_server = false;
	public static boolean start_client = false;
	public static boolean showcase = false;
	private static int showcase_change_counter = 0;
	private static long nowtime = 0;
	private static long thentime = 0;
	private static int pps = 0;
	public static Font awtfont = null;
	public static TrueTypeFont font = null;
	public static Font awtfont16 = null;
	public static TrueTypeFont font16 = null;
	public static LightingThread lto0 = null;
	public static LightingThread lto1 = null;
	public static LightingThread lto2 = null;
	public static LightingThread lto3 = null;
	public static CleanerThread tidyup = null;
	public static String playername = "Player";
	public static Random rand = null;
	public static TextureMapper texmap = new TextureMapper();
	public static int fieldOfView;
	public static int fieldOfViewLast;
	public static int mouseSensitivity;
	public static float accel = 0.0f;
	static FloatBuffer listenerPos = BufferUtils.createFloatBuffer(3);
	static FloatBuffer listenerOri = BufferUtils.createFloatBuffer(6);
	
	//public static UUIDReader uuidrdr = new UUIDReader();


	public static boolean keepitsqueakyclean = false;
	public static boolean generatecaves = true;
/*
sad: -1:  no lighting, 30fps
show_rain - false
show_clouds - false
light_speed - false
hog_mode - 0
move_part - false
all_sides - false

lame: 0: --showcase mode, 30fps, low lighting
show_rain - true
show_clouds - true
light_speed - false
hog_mode - 0
move_part - false
all_sides - false


good: 1:
show_rain - true
show_clouds - true
light_speed - false
hog_mode - 0
move_part - false
all_sides - true


great: 2:
show_rain - true
show_clouds - true
light_speed - true
hog_mode - 0
move_part - true
all_sides - true



ultra:3:
show_rain - true
show_clouds - true
light_speed - true
hog_mode - 1
move_part - true
all_sides - true
*/
	public static int graphics_mode = 0;
	public static int graphics_mode_was = 0;
	//public static int mindrawlevel = 0;
	public static ModLoader modloader = null;
	public static List<String> alt_texture_paths = new ArrayList<String>();
	public static List<ModListEntry> all_the_mods = new ArrayList<ModListEntry>();
	public static List<ModListEntry> all_the_server_mods = new ArrayList<ModListEntry>();
	//public static boolean all_sides = true;
	//public static boolean light_speed = true;
	public volatile static int new_dimension = 0;
	public volatile static double new_posx = 0;
	public volatile static double new_posy = 0;
	public volatile static double new_posz = 0;
	private static Chunk currchunk = null;
	
	public static boolean leftbuttondown = false;
	public static boolean rightbuttondown = false;
	public static boolean leftbuttonclicked = false;
	public static boolean rightbuttonclicked = false;
	public static boolean leftbuttonreleased = false;
	public static boolean rightbuttonreleased = false;
	public static boolean prevrightbuttondown = false;
	public static boolean prevbothbuttondown = false;
	public static boolean dorightclickup = false;
	public volatile static int rightbuttondowncounter = 0;
	public static int rapidfire_delay = 0;
	private static int repeatdelay = 0;
	public static volatile boolean singleshot = false;
	public static volatile boolean singleshot_needleftup = false;
	public static volatile boolean singleshot_needrightup = false;
	public static volatile boolean semiauto = false;
	public static volatile boolean semiauto_needleftup = false;
	public static volatile boolean fullauto = false;
	public static volatile boolean doleftclick = false;
	public static volatile boolean dorightclick = false;

	
	public static boolean vrleftbuttondown = false;
	public static boolean vrrightbuttondown = false;
	public static boolean vrleftbuttonclicked = false;
	public static boolean vrrightbuttonclicked = false;
	public static boolean vrleftbuttonreleased = false;
	public static boolean vrrightbuttonreleased = false;
	public static boolean vrprevrightbuttondown = false;
	public static boolean vrprevbothbuttondown = false;
	public static boolean vrdorightclickup = false;
	public volatile static int vrrightbuttondowncounter = 0;
	public static int vrrapidfire_delay = 0;
	private static int vrrepeatdelay = 0;
	public static volatile boolean vrsingleshot = false;
	public static volatile boolean vrsingleshot_needleftup = false;
	public static volatile boolean vrsingleshot_needrightup = false;
	public static volatile boolean vrsemiauto = false;
	public static volatile boolean vrsemiauto_needleftup = false;
	public static volatile boolean vrfullauto = false;
	public static volatile boolean vrdoleftclick = false;
	public static volatile boolean vrdorightclick = false;
	//public static volatile boolean swing_did_hit = false;
	


	private static int chunkwaitdelay = 0;
	private static boolean nogui = false;
	public static volatile boolean dimension_change_in_progress = false; //because the chunk cleaner can sometimes clean entities while teleporting!
	public static OverlayGUI overlayguis = new OverlayGUI();
	public static KeyHandlers keyhandlers = new KeyHandlers();
	public static boolean playnicely = false;
	public static boolean keep_inventory_on_death = false;
	//public static boolean show_clouds = true;
	//public static boolean show_rain = true;
	public volatile static int thundercount = 0;
	public static String crypted_password = null;
	public static boolean require_valid_passwords = false;
	public static boolean allow_anonymous = false;
	public static int default_privs = 0xffffffff;
	private static Properties configprop = new Properties();
	public static int max_players_on_server = 10;
	public static boolean private_server = false;
	public static volatile String connection_msg = null;
	public volatile static int connection_error = 0;
	public static float testx, testy, testz, testp, testw, testr;
	public static boolean show_server_stats = false;
	//public static boolean bits64mode = true;
	public static boolean fullscreen = true;
	//public static boolean fog_enable = true;
	public static boolean showhitbox = true;
	//public static boolean movepart = true;
	public static boolean crafting_animation = true;
//	private static FloatBuffer fogColor = null;
	public static boolean doDeathGUI = false;
	public static boolean freeze_world = false;
	public static boolean firedamage = true;
	public static boolean petprotection = false;
	public static ServerHooker server_hooks = null;
	public static volatile float magic_power = 0;
	public static volatile int magic_type = 0;
	//public static boolean printit = false;	
	public static Map<Integer, Integer> keymap_real_to_new = null;
	public static Map<Integer, Integer> keymap_new_to_real = null;
	public static ToDoList achievements = new ToDoList();
	public static boolean overlays_on = true;
	public static int character_feel = 0;
	//public static float lastvol = 0;
	   /**
     * The handle of the window.
     */
	public static long window;
    public static Inputs input;
    public static long monitor = 0;
    
    public static int lastkey = 0;
    public static boolean lastdown = false;
    
    ///////////////////////////////////////////////////VRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVRVR
    public static boolean isVR = false;
    public static boolean config_isVR = false;
    
    public static int left_hand_index = -1;
    public static int right_hand_index = -1;
    public static int hmd_index = -1;
    public static Buffer trackerbuf;
    public static int trackpad_index = -1;
    public static int trigger_index = -1;
    public static int hmd_dev = 0;
    
    public static HmdVector3 posvec;		
    public static HmdQuaternion rotv;
    public static HmdVector3 euler_rotv;
	public static HmdVector3 euler_vec;
	public static HmdVector3 euler_vec_new;

	public static double lastx, lastz, lasty;
	public static double eyeheight_adjust = 0;
	
	public static TargetInfo right_controller = new TargetInfo();
	public static TargetInfo left_controller = new TargetInfo();
	public static TargetInfo headset = new TargetInfo();
	//public static TargetInfo mouse = new TargetInfo();
	
	public static TargetInfo pointer_controller = null;
	public static TargetInfo non_pointer_controller = null;
	
	public static TargetInfo weapon_controller = null;
	public static TargetInfo non_weapon_controller = null;
	
	public static TargetInfo motion_controller = null;
	public static TargetInfo non_motion_controller = null;
	
	public static VREvent vr_event;
	public static VRControllerState left_state;
	public static VRControllerState right_state;
	public static Buffer rpa;
	public static Buffer gpa;
	

	public static FramebufferDesc leftEyeDesc[];
	public static FramebufferDesc RightEyeDesc[];
	public static int whichframe = 0;
	public static VRCompositor vrc = null;
	public static VRTextureBounds leftTextureBounds;
	public static VRTextureBounds RightTextureBounds;
	public static org.lwjgl.openvr.Texture leftTextureType;
	public static org.lwjgl.openvr.Texture RightTextureType;
	public static float ipd = 1.0f;
	public static float vrha = 0.0f;
	//public static float cleardummy[];
	

	
	//public static int default_shader; //has projection and view_*
	public static int model_shader; //has projection and MatrixStack
	//public static int current_shader = -1; 
	
	
	public static Matrix4f projection = new Matrix4f();
	//public static Matrix4f view_trans = new Matrix4f();
	//public static Matrix4f view_rot = new Matrix4f();
    public static Matrix4f hmdProjectionLeftEye = null;
    public static Matrix4f hmdProjectionRightEye = null;

	
	public static int logoVAO = 0;
	public static int logoVVO = 0;
	public static int logoVTO = 0;
	
	public static FloatBuffer logoV_fb;
	public static FloatBuffer logoT_fb;
	
	public static int refresh_rate = 60; //experimental
	public static int frame_scaler = 0;
	
	public static VRHitHandler vrhit = new VRHitHandler();
	public static boolean swinging = false;
	
	
	public static float player_last_pitch;
	public static float player_last_yaw;
	public static float player_last_roll;
	
	//to make them single-shot!
	public static boolean left_is_down = false;
	public static boolean right_is_down = false;
	public static boolean joy_is_left = false;
	public static boolean joy_is_right = false;
	public static int gui_exit = 0;
	
	
	public static boolean motion_swap = false;
	public static boolean weapon_swap = false;
	public static boolean pointer_swap = false;
	public static boolean use_pointer = false;
	public static boolean monitor_enable = true;
	public static boolean no_dark = false;
	
	public static double pointer_posx = 0;
	public static double pointer_posy = 0;
	public static double pointer_posz = 0;
	public static double pointer_pitch = 0;
	public static double pointer_yaw = 0;
	
	public static ShaderStuff shader_stuff = new ShaderStuff();
	public static UglyMath um = new UglyMath();
	public static int headset_type = 0; // 0 - unknown, 1 = Valve index, 2 = HTC Vive, 3 = Oculus Quest 2
	
	public static int lr_eye_skew = 0;
	public static int use_height = 1080;
	public static int use_width = 1920;
	public static int height_adjust = 0;
	
	
	public static int vr_max_particle = 1500;
	public static int vr_max_entity = 25;
	
	private static float into_future = 0.030f; //30 ms into future
	private static float n_avg = 3;
	
	public static volatile long most_current_time = System.currentTimeMillis();
		
	public static void PreRender(FramebufferDesc framebufferDesc) {		
		GL30.glBindFramebuffer( GL30.GL_FRAMEBUFFER, framebufferDesc.m_nFramebufferId );		
	}

	public static void PostRender(FramebufferDesc framebufferDesc) {
		GL30.glBindFramebuffer( GL30.GL_FRAMEBUFFER, 0 );		
	}

	public static void SetupStereoRenderTargets() {
		SetupTarget(leftEyeDesc[0], vr_screen_width, vr_screen_height);
		SetupTarget(RightEyeDesc[0], vr_screen_width, vr_screen_height);
		SetupTarget(leftEyeDesc[1], vr_screen_width, vr_screen_height);
		SetupTarget(RightEyeDesc[1], vr_screen_width, vr_screen_height);
	}
	
	
	
	private static boolean GLok(String message) {
		int errorCheckValue = GL11.glGetError();
		if (errorCheckValue != GL11.GL_NO_ERROR) {
			System.out.println("GL Error " + errorCheckValue + " " + message);
			Thread.dumpStack();
			return false;
		}
		return true;
	}

	
	public static int SetupTarget(FramebufferDesc frame, int a_width, int a_height) {
		
		//frame buffer
		frame.m_nFramebufferId = GL30.glGenFramebuffers();
		GL30.glBindFramebuffer(GL30.GL_FRAMEBUFFER, frame.m_nFramebufferId);
		if (!GLok("Bind Framebuffer"))
			return 0;
		
		//attach a texture buffer to it
		frame.m_nTextureId = GL11.glGenTextures();
		if (!GLok("glGenTextures"))
			return 0;
		GL11.glBindTexture(GL11.GL_TEXTURE_2D, frame.m_nTextureId);
		if (!GLok("glBindTexture"))
			return 0;
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_LINEAR);
		if (!GLok("GL_TEXTURE_MIN_FILTER"))
			return 0;
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_LINEAR);
		if (!GLok("GL_TEXTURE_MAG_FILTER"))
			return 0;		
		GL11.glTexImage2D(GL11.GL_TEXTURE_2D, 0, GL11.GL_RGBA, a_width, a_height, 0, GL11.GL_RGBA, GL11.GL_UNSIGNED_BYTE, (java.nio.ByteBuffer)null);
		if (!GLok("glTexImage2D"))
			return 0;		
		GL30.glFramebufferTexture2D(GL30.GL_FRAMEBUFFER, GL30.GL_COLOR_ATTACHMENT0, GL11.GL_TEXTURE_2D, frame.m_nTextureId, 0);
		if (!GLok("glFramebufferTexture2D"))
			return 0;
		
		//attach a depth buffer to it
		frame.m_nDepthBufferId = GL30.glGenRenderbuffers();
		if (!GLok("glGenRenderbuffers"))
			return 0;
		GL30.glBindRenderbuffer(GL30.GL_RENDERBUFFER, frame.m_nDepthBufferId);
		if (!GLok("l_depthbuffer"))
			return 0;
		
		GL30.glRenderbufferStorage(GL30.GL_RENDERBUFFER, GL11.GL_DEPTH_COMPONENT, a_width, a_height);
		if (!GLok("glRenderbufferStorage"))
			return 0;

		GL30.glFramebufferRenderbuffer(GL30.GL_FRAMEBUFFER, GL30.GL_DEPTH_ATTACHMENT, GL30.GL_RENDERBUFFER, frame.m_nDepthBufferId);
		if (!GLok("glFramebufferRenderbuffer"))
			return 0;

		int l_err = GL30.glCheckFramebufferStatus(GL30.GL_FRAMEBUFFER);
		if(l_err != GL30.GL_FRAMEBUFFER_COMPLETE)
		{
			System.out.println("Failed to create FBO: "+l_err);
			return -1;
		}
		
		//un-attach (back to default screen)
		GL30.glBindFramebuffer(GL30.GL_FRAMEBUFFER, 0);

		return 0;
	}

	
	public static void SendToHeadset(boolean getposes) {
		
		if(isVR) {	
			
			//int submit_flags = VR.EVRSubmitFlags_Submit_GlRenderBuffer;	//doesn't work	
			int submit_flags = VR.EVRSubmitFlags_Submit_Default;		
			int colorspace = VR.EColorSpace_ColorSpace_Linear;
			
	        if(getposes)VRCompositor.VRCompositor_WaitGetPoses(rpa, gpa);
			            
			leftTextureBounds.set(0f, 0f, 1f, 1f);           
            leftTextureType.set(leftEyeDesc[whichframe].m_nTextureId, VR.ETextureType_TextureType_OpenGL, colorspace);           
            VRCompositor.VRCompositor_Submit(VR.EVREye_Eye_Left, leftTextureType, leftTextureBounds, submit_flags);
            
            RightTextureBounds.set(0f, 0f, 1f, 1f);
            RightTextureType.set(RightEyeDesc[whichframe].m_nTextureId, VR.ETextureType_TextureType_OpenGL, colorspace);
            VRCompositor.VRCompositor_Submit(VR.EVREye_Eye_Right, RightTextureType, RightTextureBounds, submit_flags);
            						
			//Go baby, go!
            VRCompositor.VRCompositor_PostPresentHandoff(); //tell it to start drawing!
            
            //toggle to the other ones! Not really necessary, but we do this anyway....
            if(whichframe == 0) {
            	whichframe = 1;
            }else {
            	whichframe = 0;
            }
		}
	}
	

    
	public static void startGUI(){
			

			input = new Inputs(screen_screen_width, screen_screen_height);
		       
		   //Initialize GLFW.
	        GLFW.glfwInit();      
	        	        
	        glfwDefaultWindowHints();

	        //Get the primary monitor.
	        monitor = glfwGetPrimaryMonitor();
	        //monitors = GLFW.glfwGetMonitors();
	        
	        //for(int i=0;i<monitors.limit();i++) {
	        //	System.out.printf("Found a monitor! %d\n",  i);
	        //	System.out.printf("Monitor name is: %s\n", GLFW.glfwGetMonitorName(monitors.get(i)));	 
	        //	GLFWVidMode vidMode = glfwGetVideoMode(monitors.get(i));
	        //	System.out.printf("width, height == %d, %d\n", vidMode.width(), vidMode.height() );
	        //}
	        //monitor = monitors.get(2);
	        
	        //Retrieve the desktop resolution
	        GLFWVidMode vidMode = glfwGetVideoMode(monitor);
	        if (fullscreen) {
	            input.setScreenWidthHeight(vidMode.width(), vidMode.height());
	            screen_screen_width = screen_width = input.getScreenWidth();
	            screen_screen_height = screen_height = input.getScreenHeight();
	            window = glfwCreateWindow(screen_width, screen_height, "DangerZone LWJGL3/OpenVR", glfwGetPrimaryMonitor(), 0);  
	        }else {
	        
	        //Create the window with the specified title.
	        	window = glfwCreateWindow(screen_width, screen_height, "DangerZone LWJGL3/OpenVR", 0, 0);  
	        }
	       
	        //GLWF.setWindowTitle(window, "Stupid Title");
	        if(window == 0) {
	            throw new RuntimeException("Failed to create window");
	        }
	                
	        GLFW.glfwSetKeyCallback(window, input.getKeyboardCallback());
	        GLFW.glfwSetCursorPosCallback(window, input.getMouseMoveCallback());
	        GLFW.glfwSetMouseButtonCallback(window, input.getMouseButtonsCallback());
	        GLFW.glfwSetFramebufferSizeCallback(window, input.getFrameSizeCallback());
	        GLFW.glfwSetScrollCallback(window, input.getScrollCallback());
	        
	        if(!fullscreen)glfwSetWindowPos(window, (vidMode.width()-screen_width)/2, (vidMode.height()-screen_height)/2);

	        glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_DISABLED);
	        mouse_grabbed = true;
	        
	        glfwMakeContextCurrent(window);
	        //glfwSwapInterval(1); //uses vsync in a good way. Much smoother.
	        glfwSwapInterval(0); 
	        	        
	        GLFW.glfwSetWindowSize(window, screen_width, screen_height);
	        
	        glfwShowWindow(window);
	        
	        GL.createCapabilities();
	        glClearColor(0.97f, 0.97f, 0.97f, 1.0f);
	        glfwWindowHint(GLFW_VISIBLE, GLFW_TRUE);
	        
	        if(!isVR)GLFW.glfwFocusWindow(window);	        
	        if(isVR)glfwWindowHint(GLFW.GLFW_FOCUSED, GLFW_FALSE);               

			try {
				SoundStore.get().init();
				//initGL();
			} catch (Exception e1) {
				System.out.printf("Something went horribly wrong with initialization!\n");
				e1.printStackTrace();
				System.exit(1);
			}

			//System.out.printf("Finished init\n");
			
		}
	

	
	public static void initVR() {
		
		System.out.printf("initVR start!\n");
		
		if(pointer_swap) {
			pointer_controller = left_controller;
			non_pointer_controller = right_controller;
		}else {
			pointer_controller = right_controller;
			non_pointer_controller = left_controller;
		}
		
		if(weapon_swap) {
			weapon_controller = left_controller;
			non_weapon_controller = left_controller;
		}else {
			weapon_controller = right_controller;
			non_weapon_controller = left_controller;
		}

		if(motion_swap) {
			motion_controller = left_controller;
			non_motion_controller = right_controller;
		}else {
			motion_controller = right_controller;
			non_motion_controller = left_controller;
		}
				
		

		if(VR.VR_IsHmdPresent()) {
			System.out.printf("Hardware detected\n");
			if(VR.VR_IsRuntimeInstalled()) {
				//System.out.printf("Runtime installed\n");

				IntBuffer peError = BufferUtils.createIntBuffer(4);
				IntBuffer w = BufferUtils.createIntBuffer(2);
				IntBuffer h = BufferUtils.createIntBuffer(2);

				for(int init_retries = 0; init_retries < 5 ; init_retries++) {
					hmd_dev = VR.VR_InitInternal(peError, VR.EVRApplicationType_VRApplication_Scene);
					System.out.printf("hmd_dev = %d\n", hmd_dev);
					//String where = VR.VR_RuntimePath();
					//System.out.printf("runtimepath = %s\n", where);

					OpenVR.create(hmd_dev);		

					System.out.println("Model Number : " + VRSystem_GetStringTrackedDeviceProperty( k_unTrackedDeviceIndex_Hmd, ETrackedDeviceProperty_Prop_ModelNumber_String, peError ));

					headset_type = 0; //Don't know!
					String tstring = VRSystem_GetStringTrackedDeviceProperty( k_unTrackedDeviceIndex_Hmd, ETrackedDeviceProperty_Prop_ModelNumber_String, peError);
					if(tstring.toLowerCase().contains("vive")) headset_type = 2;
					if(tstring.toLowerCase().contains("index")) headset_type = 1;
					if(tstring.toLowerCase().contains("miramar")) headset_type = 3;
					
					if(headset_type == 3 && lr_eye_skew == 0) {
						//first time!
						//Oculus Quest II
						lr_eye_skew = 325;	
					}
					if(headset_type == 1 && lr_eye_skew == 0) {
						//first time!
						//Valve Index
						lr_eye_skew = 500;
					}
					if(headset_type == 2 && lr_eye_skew == 0) {
						//first time!
						//HTC vive
						lr_eye_skew = 182;	
					}
					
					if(headset_type == 0 && lr_eye_skew == 0) {
						//default numbers... guess
						lr_eye_skew = 300;
					}
					
					
					for(int retries = 3; retries > 0; retries--) {
						hmd_index = left_hand_index = right_hand_index = -1;

						for(int i=0;i<k_unMaxTrackedDeviceCount;i++) {
							boolean iscon = VRSystem_IsTrackedDeviceConnected(i);
							if(iscon) {
								int tdc = VRSystem_GetTrackedDeviceClass(i);			
								if(tdc == VR.ETrackedDeviceClass_TrackedDeviceClass_HMD) {
									System.out.printf("Found HMD at index %d\n", i);
									hmd_index = i;
								}
								if(tdc == VR.ETrackedDeviceClass_TrackedDeviceClass_Controller) {
									int role = VRSystem_GetControllerRoleForTrackedDeviceIndex(i);
									if(role == ETrackedControllerRole_TrackedControllerRole_LeftHand) {
										System.out.printf("Found left controller at index %d\n", i);
										left_hand_index = i;
									}
									if(role == ETrackedControllerRole_TrackedControllerRole_RightHand) {
										System.out.printf("Found right controller at index %d\n", i);
										right_hand_index = i;
									}
								}
								//ignore other types!
							}
						}
						if(hmd_index < 0) {
							System.out.printf("Waiting for HMD\n");							
						}
						if(left_hand_index < 0) {
							System.out.printf("Waiting for Left controller\n");							
						}
						if(right_hand_index < 0) {
							System.out.printf("Waiting for Right controller\n");							
						}
						if(hmd_index < 0 || left_hand_index < 0 || right_hand_index < 0) {
							System.out.printf("   ...%d\n",  retries);
							try {
								Thread.sleep(1000);
							} catch (InterruptedException e) {

							}
							continue;
						}
						break;
					}
					





					if(hmd_index < 0 || left_hand_index < 0 || right_hand_index < 0) {
						System.out.printf("Can't find headset and controllers. Retrying...\n");
						OpenVR.destroy();
						VR.VR_ShutdownInternal();
						try {
							Thread.sleep(1000);
						} catch (InterruptedException e) {

						}
						hmd_index = left_hand_index = right_hand_index = -1;
						continue;
					}

					break;
				}

				if(hmd_index < 0 || left_hand_index < 0 || right_hand_index < 0) {
					System.out.printf("Giving up. Bye!\n");
					OpenVR.destroy();
					VR.VR_ShutdownInternal();
					System.exit(1);
				}


				VRSystem.VRSystem_SetDisplayVisibility(true); //extend hmd to desktop so glfw can see this thing!
				VRCompositor.VRCompositor_SetTrackingSpace(ETrackingUniverseOrigin_TrackingUniverseStanding);
				VRCompositor.VRCompositor_ShowMirrorWindow();							

				VRSystem.VRSystem_GetRecommendedRenderTargetSize(w, h);
				System.out.println("Recommended width : " + w.get(0));
				System.out.println("Recommended height: " + h.get(0));

				vr_screen_width = w.get(0);	
				//vr_screen_width += vr_screen_width/4;
				vr_screen_height = h.get(0);


				/* These don't actually work... sigh...
					scratch.put(0, 0);
					VRSystem_GetInt32TrackedDeviceProperty(left_hand_index, EVRControllerAxisType_k_eControllerAxis_Trigger, scratch);
					trigger_index = scratch.get(0);					
					scratch.put(0, 0);
					VRSystem_GetInt32TrackedDeviceProperty(left_hand_index, EVRControllerAxisType_k_eControllerAxis_TrackPad, scratch);
					trackpad_index = scratch.get(0);
				 */
				trackpad_index = 0;
				trigger_index = 1;					

				/*
				if(trigger_index < 0 || trackpad_index < 0) {
					System.out.printf("Can't find trigger or trackpad indexes. Oops.\n");
					OpenVR.destroy();
					VR.VR_ShutdownInternal();
					System.out.printf("Shutdown. Bye!\n");
					System.exit(1);
				}
				*/

				//Found headset and controllers. Seems ok!

				//Make a trackerpose buffer to GET ALL the devices at the same time.
				//Call all the .create routines here, ONCE so we don't leak memory.
				//trackerbuf = TrackedDevicePose.create(k_unMaxTrackedDeviceCount);
				trackerbuf = TrackedDevicePose.create(k_unMaxTrackedDeviceCount);
				posvec = HmdVector3.create();		
				rotv = HmdQuaternion.create();
				euler_rotv = HmdVector3.create();
				euler_vec = HmdVector3.create();
				euler_vec_new = HmdVector3.create();
				vr_event = VREvent.create();
				left_state = VRControllerState.create();
				right_state= VRControllerState.create();
				lastx = lastz = lasty = 0;
				leftTextureBounds = VRTextureBounds.create();
				RightTextureBounds = VRTextureBounds.create();
				leftTextureType = org.lwjgl.openvr.Texture.create();
				RightTextureType = org.lwjgl.openvr.Texture.create();
				leftEyeDesc = new FramebufferDesc [2];
				RightEyeDesc = new FramebufferDesc [2];
				leftEyeDesc[0] = new FramebufferDesc();
				RightEyeDesc[0] = new FramebufferDesc();
				leftEyeDesc[1] = new FramebufferDesc();
				RightEyeDesc[1] = new FramebufferDesc();


				leftTextureBounds.set(0f, 0f, 1f, 1f);
				RightTextureBounds.set(0f, 0f, 1f, 1f);
				leftTextureType.set(-1, VR.ETextureType_TextureType_OpenGL, VR.EColorSpace_ColorSpace_Linear);
				RightTextureType.set(-1, VR.ETextureType_TextureType_OpenGL, VR.EColorSpace_ColorSpace_Linear);

				rpa = TrackedDevicePose.create(k_unMaxTrackedDeviceCount);
				gpa = TrackedDevicePose.create(k_unMaxTrackedDeviceCount);
				

				HmdMatrix44 mat = HmdMatrix44.create();
				mat = VRSystem.VRSystem_GetProjectionMatrix(VR.EVREye_Eye_Left, 1.0f, 256.0f*renderdistance, mat);
				hmdProjectionLeftEye = new Matrix4f();
				um.convertSteamVRMatrix4ToMatrix4f(mat, hmdProjectionLeftEye);

				mat = VRSystem.VRSystem_GetProjectionMatrix(VR.EVREye_Eye_Right, 1.0f, 256.0f*renderdistance, mat);
				hmdProjectionRightEye = new Matrix4f();
				um.convertSteamVRMatrix4ToMatrix4f(mat, hmdProjectionRightEye);

				return; //SUCCESS!
			}

		}

		OpenVR.destroy();
		VR.VR_ShutdownInternal();
		System.out.printf("VR is Broken. Bye!\n");
		System.exit(1);
	}
	
	
	public static float smooth_degrees(float oldval, float newval, int printit) {
		float ov, nv;
		ov = oldval;
		nv = newval;
		
		while(ov < 0)ov += 360f;
		while(ov > 360f)ov -= 360f;

		while(nv < 0)nv += 360f;
		while(nv > 360f)nv -= 360f;

		if(Math.abs(ov-nv)>180f) { //crosses 0/360 line?
			if(ov < nv) {
				ov += 360f;
			}else {
				nv += 360f;
			}
		}
		float diff = Math.abs(oldval - newval);
		if(diff > 180)diff = 360f - diff;
		diff = Math.abs(diff);
		
		n_avg = 2;               //BIG diffs go straight through
		if(diff < 4)n_avg = 3;   //medium diffs a little
		if(diff < 0.75f)n_avg = 4;   //small diffs more!
		
		if(printit != 0)System.out.printf("diff = %f, %f, %f\n", diff, ov, nv);
		
		nv = ((ov*(n_avg-1)) + (nv))/(n_avg); //tweak this algorithm here!
				
		while(nv < 0)nv += 360f;
		while(nv > 360f)nv -= 360f;
		
		return nv;
	}
	
/*	public static double smooth_double(double oldval, double newval, int printit) {
		double ov, nv;
		ov = oldval;
		nv = newval;
		
		double diff = Math.abs(oldval - newval);
		
		n_avg = 2;               //BIG diffs go straight through
		if(diff < 0.15)n_avg = 3;   //medium diffs a little
		if(diff < 0.02f)n_avg = 4;   //small diffs more!
		
		if(printit != 0)System.out.printf("ddiff = %f, %f, %f\n", diff, ov, nv);
		
		nv = ((ov*(n_avg-1)) + (nv))/(n_avg); //tweak this algorithm here!
		
		return nv;
	}
	*/
	
	
	public static void update_poses() {
		
		if(!isVR)return;

		into_future = 0.030f; //30 ms into future for occulus (max seems to be about 40 fps).
		if(wr.fps > 50)into_future = 0.021f; //21ms for normal 60 fps framerate!
		
		trackerbuf.rewind();
		VRSystem_GetDeviceToAbsoluteTrackingPose(ETrackingUniverseOrigin_TrackingUniverseStanding, into_future, trackerbuf);
		trackerbuf.rewind(); //rewind. Headset is always 0!
		TrackedDevicePose trk = trackerbuf.get().eTrackingResult(0);	
		if(trk.bPoseIsValid()) {
			//fetch the position&rotation matrix	
			HmdMatrix34 pos = trk.mDeviceToAbsoluteTracking();											
			um.GetPosition(pos, posvec); //fetch position into posvec
			//System.out.printf("        xyz pos: %f, %f, %f\n",posvec.v(0), posvec.v(1), posvec.v(2));	
			player.posx += (posvec.v(0)-lastx);
			lastx = posvec.v(0);
			eyeheight_adjust = posvec.v(1) + vrha - (player.getHeight()*0.943f); //DELTA from expected HUMAN height!!!
			lasty = posvec.v(1)+vrha-player.getHeight();
			player.posz += (posvec.v(2)-lastz);
			lastz = posvec.v(2);

			headset.rel_posx = posvec.v(0);
			headset.rel_posy = posvec.v(1) + vrha - 1.65f; //DELTA from expected HUMAN height!!!
			headset.rel_posz = posvec.v(2);

			headset.real_posx = player.posx;
			headset.real_posy = player.posy+eyeheight_adjust+player.getEyeHeight(); //eyeheight is auto adjusted in player.
			headset.real_posz = player.posz;

			um.GetRotation(pos, rotv); //fetch quaternion rotation into rotv
			headset.copy(rotv, headset.quat);
			
			//System.out.printf("        quat rot: %f, %f, %f, %f\n",rotv.w(), rotv.x(), rotv.y(), rotv.z());
			um.Quaternion_to_Euler(rotv, euler_rotv); //convert to normal pitch/yaw/roll
			//System.out.printf("        pyr rot: %f, %f, %f\n",euler_rotv.v().get(0), euler_rotv.v().get(1), euler_rotv.v().get(2));
			
			//This does not work because quats confuse rot with yaw and pitch
			//MatrixStack.quaternion_to_rotation(rotv, hmd_matrix);
			
			um.rot34_to_euler(pos, euler_vec_new);
			headset.ev_pitch = (float) Math.toDegrees((euler_vec_new.v().get(0)));
			headset.ev_yaw = (float) Math.toDegrees((euler_vec_new.v().get(1)));										
			headset.ev_roll = (float) Math.toDegrees((euler_vec_new.v().get(2))); //this is correct. other two are broken.
		
			//Use these for the Display only!!! There are no ROLL calculations in the game!
			headset.display_pitch = smooth_degrees(headset.display_pitch, (float) Math.toDegrees((euler_rotv.v().get(0))), 0);
			headset.display_yaw = smooth_degrees(headset.display_yaw, (float) Math.toDegrees((euler_rotv.v().get(1))), 0);										
			headset.display_roll = smooth_degrees(headset.display_roll, (float) Math.toDegrees((euler_rotv.v().get(2))), 0);

			//Convert the quat to a pointing/arrow type vector.
			//With that, we can calculate real pitch and yaw.
			//Roll must come from elsewhere.
			um.Quaternion_to_Vector(rotv, euler_vec); //convert to dx, dy, dz
			//System.out.printf("        xyz vec: %f, %f, %f\n",euler_vec.v().get(0), euler_vec.v().get(1), euler_vec.v().get(2));

			headset.dx = euler_vec.v().get(0);
			headset.dy = euler_vec.v().get(1);
			headset.dz = euler_vec.v().get(2);

			//Finally... having proper dx, dy, dz, we can calculate useful pitch and yaw with roll=0, which we need for shooting and throwing!						
			float tdir = (float) Math.atan2(euler_vec.v().get(0), euler_vec.v().get(2));
			float dx, dz;
			dx = (float) Math.sqrt(euler_vec.v().get(0)*euler_vec.v().get(0) + euler_vec.v().get(2)*euler_vec.v().get(2));
			dz = (float) Math.atan2(-euler_vec.v().get(1), dx);

			player.rotation_pitch_head = smooth_degrees(player.rotation_pitch_head, (float) Math.toDegrees(dz), 0);
			while(player.rotation_pitch_head < 0)player.rotation_pitch_head += 360f;
			player.rotation_pitch_head %= 360f;

			headset.pitch = player.rotation_pitch_head;

			player.rotation_yaw_head = smooth_degrees(player.rotation_yaw_head, 180f - (float) Math.toDegrees(tdir), 0);
			while(player.rotation_yaw_head < 0)player.rotation_yaw_head += 360f;
			player.rotation_yaw_head %= 360f;

			headset.yaw = player.rotation_yaw_head;

			//player.rotation_roll_head = wr.display_roll; //This only works for very small YAW angles, then it goes bonkers.
			//How can we get a non-fucked-up roll out of quaternion? I don't know.
			player.rotation_roll_head = smooth_degrees(player.rotation_roll_head, (float) Math.toDegrees((euler_vec_new.v().get(2))), 0);

			//System.out.printf("        player rot: %f, %f, %f\n",player.rotation_pitch_head, player.rotation_yaw_head, player.rotation_roll_head);

		}

		trk = null;
		if(right_hand_index > 0)trk = trackerbuf.get(right_hand_index).eTrackingResult(0);	
		if(trk != null && trk.bPoseIsValid()) {
			//fetch the position&rotation matrix	
			HmdMatrix34 pos = trk.mDeviceToAbsoluteTracking();											
			um.GetPosition(pos, posvec); //fetch position into posvec
			//System.out.printf("        xyz pos: %f, %f, %f\n",posvec.v(0), posvec.v(1), posvec.v(2));	
			right_controller.rel_posx = posvec.v(0);
			right_controller.rel_posy = posvec.v(1)+vrha-(player.getHeight()*0.943f);
			right_controller.rel_posz = posvec.v(2);

			right_controller.real_posx = (player.posx - lastx) + right_controller.rel_posx;
			right_controller.real_posy = player.posy + right_controller.rel_posy; //MUST STILL ADD EYEHEIGHT!!!
			right_controller.real_posz = (player.posz - lastz) + right_controller.rel_posz;

			um.GetRotation(pos, rotv); //fetch quaternion rotation into rotv
			right_controller.copy(rotv, right_controller.quat);
			
			//System.out.printf("        quat rot: %f, %f, %f, %f\n",rotv.w(), rotv.x(), rotv.y(), rotv.z());
			um.Quaternion_to_Euler(rotv, euler_rotv); //convert to normal pitch/yaw/roll
			//System.out.printf("        right pyr rot: %f, %f, %f\n",euler_rotv.v().get(0), euler_rotv.v().get(1), euler_rotv.v().get(2));
			//Use these for the Display only!!! There are no ROLL calculations in the game!
			right_controller.display_pitch = smooth_degrees(right_controller.display_pitch, (float) Math.toDegrees((euler_rotv.v().get(0))), 0);
			right_controller.display_yaw = smooth_degrees(right_controller.display_yaw, (float) Math.toDegrees((euler_rotv.v().get(1))), 0);										
			right_controller.display_roll = smooth_degrees(right_controller.display_roll, (float) Math.toDegrees((euler_rotv.v().get(2))), 0);
			
			um.rot34_to_euler(pos, euler_vec_new);
			right_controller.ev_pitch = (float) Math.toDegrees((euler_vec_new.v().get(0)));
			right_controller.ev_yaw = (float) Math.toDegrees((euler_vec_new.v().get(1)));										
			right_controller.ev_roll = (float) Math.toDegrees((euler_vec_new.v().get(2))); //this is correct. other two are broken.
			while(right_controller.ev_pitch<0)right_controller.ev_pitch+=360f;
			while(right_controller.ev_yaw<0)right_controller.ev_yaw+=360f;
			while(right_controller.ev_roll<0)right_controller.ev_roll+=360f;

			um.Quaternion_to_Vector(rotv, euler_vec); //convert to dx, dy, dz
			//System.out.printf("        xyz vec: %f, %f, %f\n",euler_vec.v().get(0), euler_vec.v().get(1), euler_vec.v().get(2));
			right_controller.dx = euler_vec.v().get(0);
			right_controller.dy = euler_vec.v().get(1);
			right_controller.dz = euler_vec.v().get(2);

			//Finally... having proper dx, dy, dz, we can calculate useful pitch and yaw with roll=0, which we need for shooting and throwing!						
			float tdir = (float) Math.atan2(euler_vec.v().get(0), euler_vec.v().get(2));
			float dx, dz;
			dx = (float) Math.sqrt(euler_vec.v().get(0)*euler_vec.v().get(0) + euler_vec.v().get(2)*euler_vec.v().get(2));
			dz = (float) Math.atan2(-euler_vec.v().get(1), dx);

			right_controller.pitch = smooth_degrees(right_controller.pitch, (float) Math.toDegrees(dz), 0);
			while(right_controller.pitch < 0)right_controller.pitch += 360f;
			right_controller.pitch %= 360f;

			right_controller.yaw = smooth_degrees(right_controller.yaw, (float) Math.toDegrees(tdir), 0);
			while(right_controller.yaw < 0)right_controller.yaw += 360f;
			right_controller.yaw %= 360f;
			
			right_controller.angular_velocity = trk.vAngularVelocity(); //fetch this?
			right_controller.velocity = trk.vVelocity(); //fetch this?
			
			//System.out.printf("right vel: %f, %f, %f\n",right_controller.velocity.v(0), right_controller.velocity.v(1), right_controller.velocity.v(2));
			//System.out.printf("right angvel: %f, %f, %f\n",right_controller.angular_velocity.v(0), right_controller.angular_velocity.v(1), right_controller.angular_velocity.v(2));
			right_controller.calc_50_done = false; //reset because we have NOT done this yet!
		}

		trk = null;
		if(left_hand_index > 0)trk = trackerbuf.get(left_hand_index).eTrackingResult(0);	
		if(trk != null && trk.bPoseIsValid()) {
			//fetch the position&rotation matrix	
			HmdMatrix34 pos = trk.mDeviceToAbsoluteTracking();											
			um.GetPosition(pos, posvec); //fetch position into posvec
			//System.out.printf("        xyz pos: %f, %f, %f\n",posvec.v(0), posvec.v(1), posvec.v(2));	
			left_controller.rel_posx = posvec.v(0);
			left_controller.rel_posy = posvec.v(1)+vrha-(player.getHeight()*0.943f); //(1.65f/1.75f)
			left_controller.rel_posz = posvec.v(2);

			left_controller.real_posx = (player.posx - lastx) + left_controller.rel_posx;
			left_controller.real_posy = (player.posy - lasty) + left_controller.rel_posy; //MUST STILL ADD EYEHEIGHT!!!
			left_controller.real_posz = (player.posz - lastz) + left_controller.rel_posz;

			um.GetRotation(pos, rotv); //fetch quaternion rotation into rotv
			left_controller.copy(rotv, left_controller.quat);
			
			//System.out.printf("        quat rot: %f, %f, %f, %f\n",rotv.w(), rotv.x(), rotv.y(), rotv.z());
			um.Quaternion_to_Euler(rotv, euler_rotv); //convert to normal pitch/yaw/roll
			//System.out.printf("        left pyr rot: %f, %f, %f\n",euler_rotv.v().get(0), euler_rotv.v().get(1), euler_rotv.v().get(2));
			//Use these for the Display only!!! There are no ROLL calculations in the game!
			left_controller.display_pitch = smooth_degrees(left_controller.display_pitch, (float) Math.toDegrees((euler_rotv.v().get(0))), 0);
			left_controller.display_yaw = smooth_degrees(left_controller.display_yaw, (float) Math.toDegrees((euler_rotv.v().get(1))), 0);										
			left_controller.display_roll = smooth_degrees(left_controller.display_roll, (float) Math.toDegrees((euler_rotv.v().get(2))), 0);

			um.Quaternion_to_Vector(rotv, euler_vec); //convert to dx, dy, dz
			//System.out.printf("        xyz vec: %f, %f, %f\n",euler_vec.v().get(0), euler_vec.v().get(1), euler_vec.v().get(2));
			left_controller.dx = euler_vec.v().get(0);
			left_controller.dy = euler_vec.v().get(1);
			left_controller.dz = euler_vec.v().get(2);
			
			um.rot34_to_euler(pos, euler_vec_new);
			left_controller.ev_pitch = (float) Math.toDegrees((euler_vec_new.v().get(0)));
			left_controller.ev_yaw = (float) Math.toDegrees((euler_vec_new.v().get(1)));										
			left_controller.ev_roll = (float) Math.toDegrees((euler_vec_new.v().get(2))); //this is correct. other two are broken.
			while(left_controller.ev_pitch<0)left_controller.ev_pitch+=360f;
			while(left_controller.ev_yaw<0)left_controller.ev_yaw+=360f;
			while(left_controller.ev_roll<0)left_controller.ev_roll+=360f;

			//Finally... having proper dx, dy, dz, we can calculate useful pitch and yaw with roll=0, which we need for shooting and throwing!						
			float tdir = (float) Math.atan2(euler_vec.v().get(0), euler_vec.v().get(2));
			float dx, dz;
			dx = (float) Math.sqrt(euler_vec.v().get(0)*euler_vec.v().get(0) + euler_vec.v().get(2)*euler_vec.v().get(2));
			dz = (float) Math.atan2(-euler_vec.v().get(1), dx);

			left_controller.pitch = smooth_degrees(left_controller.pitch, (float) Math.toDegrees(dz), 0);
			while(left_controller.pitch < 0)left_controller.pitch += 360f;
			left_controller.pitch %= 360f;
			
			left_controller.angular_velocity = trk.vAngularVelocity(); //fetch this?
			left_controller.velocity = trk.vVelocity(); //fetch this?
			
			left_controller.yaw = smooth_degrees(left_controller.yaw, (float) Math.toDegrees(tdir), 0);
			while(left_controller.yaw < 0)left_controller.yaw += 360f;
			left_controller.yaw %= 360f;
			
			left_controller.calc_50_done = false; //reset because we have NOT done this yet!
		}

	}
	
	public static void set_shader_projection(int mode, int which, int width, int height) {
		GL11.glLoadIdentity();
		
		if(mode == 0)Matrix4f.projection(projection, (float)fieldOfView, ((float) width / (float) height), 1.0f, 256.0f*renderdistance);	
		
		if(mode == 0)GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "projection"), true, projection.elements);			
		if(mode == 1)GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "projection"), true, hmdProjectionLeftEye.elements);			
		if(mode == 2)GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "projection"), true, hmdProjectionRightEye.elements);	
									
		//if(which == model_shader) {
			MatrixStack.identity();	
			GL20.glUniform1f(GL20.glGetUniformLocation(which, "colorfixr"), 1.0f);	
			GL20.glUniform1f(GL20.glGetUniformLocation(which, "colorfixg"), 1.0f);	
			GL20.glUniform1f(GL20.glGetUniformLocation(which, "colorfixb"), 1.0f);	
			GL20.glUniform1f(GL20.glGetUniformLocation(which, "alpha_adjust"), 1.0f);	
		//}else {
		//	Matrix4f.identity(view_trans);
		//	Matrix4f.identity(view_rot);
		//	GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "view_trans"), true, view_trans.elements);
		//	GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "view_rot"), true, view_rot.elements);
		//}
		
		//current_shader = which;
		
	}
	
	//puts 0, 0 at lower left of screen. 
	public static void set_shader_ortho(int which) {
		GL11.glLoadIdentity();
		
		Matrix4f.ortho(projection, 0, screen_width, screen_height, 0, -300, 300f);				
		GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "projection"), true, projection.elements);		
		
				
		//if(which == model_shader) {
			MatrixStack.identity();
			GL20.glUniform1f(GL20.glGetUniformLocation(which, "colorfixr"), 1.0f);	
			GL20.glUniform1f(GL20.glGetUniformLocation(which, "colorfixg"), 1.0f);	
			GL20.glUniform1f(GL20.glGetUniformLocation(which, "colorfixb"), 1.0f);	
		//}else {
		//	Matrix4f.identity(view_trans);
		//	Matrix4f.identity(view_rot);
		//	GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "view_trans"), true, view_trans.elements);
		//	GL20.glUniformMatrix4fv(GL20.glGetUniformLocation(which, "view_rot"), true, view_rot.elements);
		//}
		
		//current_shader = which;
	}
	
	public static void initGL(int width, int height, int mode) 
	{
				
		GL11.glViewport(0, 0, width, height); // Reset The Current Viewport

		GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f); // Black Background
		
		GL11.glDisable(GL11.GL_CULL_FACE); //NO!!! Not unless you want to fix all the renderToVBO rotations...
		GL11.glEnable(GL11.GL_DEPTH_TEST); // Enables Depth Testing
		GL11.glClearDepth(1.0f); // Depth Buffer Setup
		GL11.glDepthFunc(GL11.GL_LEQUAL); // The Type Of Depth Test To Do
		
		GL11.glHint(GL11.GL_PERSPECTIVE_CORRECTION_HINT, GL11.GL_FASTEST); // Fast Perspective Calculations
		GL11.glEnable(GL11.GL_TEXTURE_2D); 
		GL11.glAlphaFunc ( GL11.GL_GREATER, 0.1f ) ;
		GL11.glEnable ( GL11.GL_ALPHA_TEST ) ;	
		GL11.glEnable(GL14.GL_COLOR_SUM);
		
		GL20.glUseProgram( model_shader );
		//current_shader = default_shader;
		
		if(mode == 0)MatrixStack.reset(projection.elements);			
		if(mode == 1)MatrixStack.reset(hmdProjectionLeftEye.elements);			
		if(mode == 2)MatrixStack.reset(hmdProjectionRightEye.elements);	
		//MatrixStack.reset();
		
		set_shader_projection(mode, model_shader, width, height);
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixr"), 1f);	
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixg"), 1f);	
		GL20.glUniform1f(GL20.glGetUniformLocation(DangerZone.model_shader, "colorfixb"), 1f);	
		
	}
	
	public static void do_fog() {
		//Have to write fog as part of shader now, I think...
/*		
		if(fog_enable){
			if(fogColor == null)fogColor = BufferUtils.createFloatBuffer(4);
			fogColor.put(0.75f);
			fogColor.put(0.75f);
			fogColor.put(0.75f);
			fogColor.put(1.0f);
			fogColor.position(0);
			
			GL11.glEnable (GL11.GL_FOG); //enable the fog
			GL11.glFogi (GL11.GL_FOG_MODE, GL11.GL_LINEAR); //set the fog mode to GL_LINEAR
			GL11.glFogf (GL11.GL_FOG_START, 148.0f*renderdistance);
			GL11.glFogf (GL11.GL_FOG_END, 248.0f*renderdistance);			
			GL11.glFogfv (GL11.GL_FOG_COLOR, fogColor); //set the fog color to our color chosen above
			GL11.glFogf (GL11.GL_FOG_DENSITY, 0.0010f); //set the density
			GL11.glHint (GL11.GL_FOG_HINT, GL11.GL_FASTEST); // set the fog to look the fastest, may slow down on older cards
			
		}else{
			GL11.glDisable(GL11.GL_FOG);
		}
		*/					
	}
	
	
	/**
	 * @param args
	 */
	public static void main(String[] args) throws InterruptedException {
		long lasttime = System.currentTimeMillis();
		long currtime, delta;

		
		//because some places use commas in numbers, and of course java hoses them up!
		if(Locale.getDefault() != Locale.US) {
		    Locale.setDefault(Locale.US);
		}

		String curdir = System.getProperty("user.dir");	
		File libfile = new File(curdir + "/DangerZone_lib/native");
		File stopfile = new File(curdir + "/stop.txt");
		if(libfile.exists())System.setProperty("org.lwjgl.librarypath", curdir + "/DangerZone_lib/native");
		
		CodeSource codeSource = DangerZone.class.getProtectionDomain().getCodeSource();
		try {
			File myfile = new File(codeSource.getLocation().toURI().getPath());
			//System.out.printf("Adding self as: %s\n",  myfile.getAbsolutePath());
			ModLoader.addFile(myfile); //add self to path so it will search here for resources!
		} catch (URISyntaxException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		//bits64mode = (System.getProperty("os.arch").indexOf("64") != -1);
		//bits64mode = false;
		
		System.out.printf("Starting DZVR version: %s\n",  versionstring);
		
		if(args.length > 1){
			int arglen = args.length;
			int i;
			for(i=0;i<arglen;i++){
				//System.out.printf("arg %d = :%s\n", i, args[i]);
				if(args[i].contains("client")){
					start_client = true;
				}
				if(args[i].contains("server")){
					start_server = true;					
				}
				if(args[i].contains("nogui")){
					nogui = true;
					start_client = false;
					start_server = true;
				}
				if(args[i].contains("stats")){
					show_server_stats = true;
					start_client = false;
					start_server = true;
					nogui = false;
				}
				if(args[i].contains("showcase")){
					start_client = true;
					start_server = true;
					showcase = true;
				}
			}
			if(!start_client && !start_server){
				System.out.printf("Bad args?\n");
				System.exit(1);			
			}
		}else{
			//default singleplayer
			start_client = true;
			start_server = true;
		}
		
		//for remapping keys.
		keymap_real_to_new = new HashMap<Integer, Integer>();
		keymap_new_to_real = new HashMap<Integer, Integer>();
		
		
		rand = new Random(lasttime);
		server_hooks = new ServerHooker(); //common to all
		
		Fastmath.inittable(); //prep the sin table.
		Fastmath.initrand(); //prep the rand function too.
		
		readConfig();
		
		character_feel = 0;
		
		//if(!bits64mode){
		//	if(renderdistance > 16)renderdistance = 16;
		//	all_sides = false; //icky graphics
		//	entityupdatedist = 16*16; //smaller active area!!!
		//	light_speed = false; //slow lighting!
		//	System.out.printf("Aw man... 32-bit Java detected!\n");
		//}
		
		if(!start_server){ //CLIENT ONLY
			if(renderdistance > 16)renderdistance = 16;
		}
		
		if(!start_client){ //SERVER ONLY
			renderdistance = 20;
			entityupdatedist = 16*24;
			isVR = false;
		}
		
		if(start_server && !start_client){ //SERVER ONLY
			screen_screen_width = screen_width = 800;
			screen_screen_height = screen_height = 400;
			fullscreen = false;
			isVR = false;
		}
		
		if(!nogui){
			//System.out.printf("I am here!\n");
			try {	
				
				if(isVR)initVR();
				startGUI();	
				shader_stuff.initShaders();
				initGL(screen_screen_width, screen_screen_height, 0);
				if(isVR)SetupStereoRenderTargets();
				
				
				AL10.alDistanceModel(AL10.AL_NONE); //we do our own volume scaling
				
			} catch (Exception e1) {
				System.out.printf("Something went horribly wrong with initialization!\n");
				e1.printStackTrace();
				System.exit(1);
			}
			
			
			showLogoandpush(false);
			
			
			if(font == null){
				awtfont = new Font("Times New Roman", Font.PLAIN, 24);
				font = new TrueTypeFont(awtfont, false);
				awtfont16 = new Font("Times New Roman", Font.PLAIN, 16);
				font16 = new TrueTypeFont(awtfont16, false);
			}
		}
		
		
		if(start_server){
			if(start_client){
				doStartSinglePlayer(); //fire it ALL up!
			}else{
				doStartServer(); //just the server stuff
				if(!nogui){
					glfwShowWindow(window);
					glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_NORMAL);
					mouse_grabbed = false;			
				}
			}
		}else{
			if(start_client){
				doStartClient(); //just the client stuff
				glfwShowWindow(window);
			}else{
				System.out.printf("Hunh?\n");
				System.exit(1);		
			}
		}
		

		long next_time = System.currentTimeMillis();
		currtime = most_current_time = next_time;
		/*
		long time_one, time_two, time_three;
		int sleeper, mysleep;
		time_one = 	time_two = time_three = currtime = time_one = most_current_time = System.currentTimeMillis();
		mysleep = 20;
		*/

		//FIXME TODO - tag to help find main loop!
		/*
		 * And finally, the main server/client loop...
		 */
		while(DangerZone.gameover == 0){
			
			
			if(stopfile.exists()){
				stopfile.delete();
				DangerZone.gameover = 1;
			}
			
			if(thundercount > 0){
				thundercount--;
			}
			
			frame_scaler++;
			if(frame_scaler > 1000000)frame_scaler = 0;
		
			
			if(start_client){
				
				int sleepframe = 17;
				if(refresh_rate == 90)sleepframe = 11;
				if(refresh_rate == 120)sleepframe = 8;
				if(showcase || graphics_mode <= 0)sleepframe = 32;
/*				
				time_one = 	System.currentTimeMillis();	
				//see how long the last cycle took, sleep if less than 16ms
				time_three = time_one - time_two;
				sleeper = (int) time_three;				
				sleeper = sleepframe - sleeper;
				if(sleeper < 0)sleeper = 0;
				if(sleeper > sleepframe)sleeper = sleepframe;	
				if(mysleep < sleeper)mysleep++;
				if(mysleep > sleeper && mysleep > 0)mysleep--;
								
				if(mysleep > 0)Thread.sleep(mysleep);			
				
				time_two = currtime = most_current_time = System.currentTimeMillis();
				*/
				
				//A bunch of little sleeps instead of one big one.
				//This way seems to help the java jitter a little.
				//Not much, but a little.
				while(true) {
					currtime = most_current_time = System.currentTimeMillis();
					if(currtime >= next_time)break;
					if(next_time - currtime >= 2) {
						Thread.sleep(2);
					}else {
						Thread.sleep(1);
					}
				}				
				next_time = currtime + sleepframe;
				
				
				delta = currtime - lasttime;
				lasttime = currtime;
				
				deltaT = delta;
				deltaT = deltaT / 16.6f; //motion is relative to 60hz default				
				if(deltaT < 0.75f)deltaT = 0.75f;
				if(deltaT > 3)deltaT = 3; //2 is ok because of showcase mode

				
				/*
				 * Keep safe from teleports by making sure we have the current chunk!
				 */
				if(new_dimension != 0){
					
					player.posx = new_posx;
					player.posy = new_posy;
					player.posz = new_posz;
					player.dimension = new_dimension;
					//new_dimension = 0;
					player.server_connection.sendPlayerEntityUpdate(player);
				
					chunkwaitdelay = 0;
					currchunk = world.chunkcache.getDecoratedChunk(player.dimension, (int)player.posx, 100, (int)player.posz); 			
					while(chunkwaitdelay < 200 && currchunk == null){
						DangerZone.server_connection.flushit();
						chunkwaitdelay++; //just in case it gets confused. timeout.
						Thread.sleep(100);
						player.server_connection.sendPlayerEntityUpdate(player);
						currchunk = world.chunkcache.getDecoratedChunk(player.dimension, (int)player.posx, 100, (int)player.posz); 
					}
					currchunk = null;
					new_dimension = 0;
				}
							
				//Have to do player updates here. Seems to cause screen glitches if not...
				if(!f12_on){
					
					if(refresh_rate == 120 && (frame_scaler&0x01)==0) {
						player.update(deltaT);
					}else if(refresh_rate == 90 && (frame_scaler%3)!=0) {
						player.update(deltaT);
					}else { //60
						player.update(deltaT);
					}
					
				}else{
					player.server_connection.idle();
				}
				if(gofasttimer > 0)gofasttimer--;
				if(flytimer > 0)flytimer--;
			
				//Draw the world!!!	
				screen_width = input.getScreenWidth();
				screen_height = input.getScreenHeight();			
				initGL(screen_width, screen_height, 0);
				
				//render everything!!!
				wr.renderWorld(world, 0); //f12 gui is drawn in here!!!		
				
				renderGUIThings(0);
				
				GL11.glFlush();
				
				if(isVR) {
					screen_width = vr_screen_width;
					screen_height = vr_screen_height;
					
					PreRender( leftEyeDesc[whichframe] );
					initGL(vr_screen_width, vr_screen_height, 1);
					wr.renderWorld(world, 1); //f12 gui is drawn in here!!!
					renderGUIThings(1);
					//do_fog();
					GL11.glFlush();
					PostRender( leftEyeDesc[whichframe] );
					
					
					PreRender( RightEyeDesc[whichframe] );
					initGL(vr_screen_width, vr_screen_height, 2);
					wr.renderWorld(world, 2); //f12 gui is drawn in here!!!
					renderGUIThings(2);
					//do_fog();
					GL11.glFlush();
					PostRender( RightEyeDesc[whichframe] );
				}
				
					
				if(isVR) {
					//fetch latest VR inputs positions (poses)
					update_poses();
					//yes, it goes to the headset
					SendToHeadset(true);
				}
				glfwSwapBuffers(window);

				//Close clicked?
				if(GLFW.glfwWindowShouldClose(window))DangerZone.gameover = 1;
				
				//Someone resized the window!
				if(input.wasResized() || fieldOfView != fieldOfViewLast){
					screen_screen_width = input.getScreenWidth();
					screen_screen_height = input.getScreenHeight();
					fieldOfViewLast = fieldOfView;
					//System.out.printf("New Screen size = %d, %d\n", screen_screen_width, screen_screen_height );
				}
				
				if(player.deadflag){
					break; //will stop things slowly, later
				}
				
				//kick the sound effects into gear...
				//DangerZone.soundmangler.playMusic();	
				
				//And generic sound processing as well.
				//DangerZone.do_sound_stuff();
				
			}else{
				//is a server!
				Thread.sleep(100);
				most_current_time = nowtime = System.currentTimeMillis();
				if(nowtime - thentime > 1000){				
					thentime = nowtime;
					pps = DangerZone.packets_per_second;
					DangerZone.packets_per_second = 0;
				}
				
				if(!nogui){
					
					initGL(screen_width, screen_height, 0);	

					screen_width = screen_screen_width;
					screen_height = screen_screen_height;
					showLogo(false, 0);

					// Get into menu mode...
					GL20.glUseProgram( 0 ); //stop with the shaders already...	
					//current_shader = 0;
					GL11.glLoadIdentity(); // Reset The View
					
					//puts 0,0 (x,y) at lower left of screen!
					GL11.glOrtho(0,DangerZone.screen_width,0,DangerZone.screen_height,-320,320);
					
					GL11.glDisable(GL11.GL_DEPTH_TEST);			
					GL11.glEnable(GL11.GL_TEXTURE_2D);
					GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!
					GL11.glAlphaFunc ( GL11.GL_GREATER, 0.1f ) ;
					GL11.glEnable ( GL11.GL_ALPHA_TEST ) ;	
					GL11.glEnable(GL14.GL_COLOR_SUM);


					GL11.glPushMatrix();
					GL11.glTranslatef(10, screen_height-10, 0f); 
					GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!		
					font.drawString(0, 0, String.format("Players: %d", server.server_thread_list.size()), ColorSlick.gray);		
					GL11.glPopMatrix();

					GL11.glPushMatrix();
					GL11.glTranslatef(10, screen_height-60, 0f); 
					GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!		
					font.drawString(0, 0, String.format("Packets per Second: %d", pps), ColorSlick.gray);		
					GL11.glPopMatrix();

					GL11.glPushMatrix();
					GL11.glTranslatef(10, screen_height-110, 0f); 
					GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!		
					font.drawString(0, 0, String.format("Entities: %d", DangerZone.server.entityManager.entity_list.size()), ColorSlick.gray);		
					GL11.glPopMatrix();

					GL11.glPushMatrix();
					GL11.glTranslatef(10, screen_height-160, 0f); 
					GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!		
					font.drawString(0, 0, String.format("Active Entities: %d", DangerZone.server.entityManager.active_entities), ColorSlick.gray);		
					GL11.glPopMatrix();

					//back out of menu mode
					GL11.glDisable(GL11.GL_BLEND);
					GL11.glMatrixMode(GL11.GL_PROJECTION);
					GL11.glPopMatrix();
					GL11.glMatrixMode(GL11.GL_MODELVIEW);
					GL11.glPopMatrix();
					GL11.glEnable(GL11.GL_DEPTH_TEST);

					justPush();

					//Close clicked?
					if(GLFW.glfwWindowShouldClose(window))DangerZone.gameover = 1;
					
					//Someone resized the window!
					if(input.wasResized()){
						initGL(screen_screen_width, screen_screen_height, 0);
					}	

					while (K_next()) {	
						//System.out.printf("Key!\n");
						if (K_getEventKey() == GLFW.GLFW_KEY_ESCAPE && K_isKeyDown(GLFW.GLFW_KEY_ESCAPE)){
							if(K_isEventKeyDown()){
								DangerZone.gameover = 1;
							}
						}
					}
				}
			}
			
			//Process key and mouse input events		
			glfwPollEvents();
			
		}
		
		DangerZone.gameover = 1; //just to make sure!

		/*
		 * Game is over... shut down gracefully and save things properly...
		 */
		if(start_client){
			//Tell the server!
			player.server_connection.sendDisconnect();			
			connection_msg = "Shutting down Client side.";
			showLogoandpush(false);
			writeConfig(false);
			Thread.sleep(500);
			showLogoandpush(false);
			Thread.sleep(500);
			showLogoandpush(false);
		}
		
		//Say bye bye!		
		Thread.sleep(500);	//Pretend we're busy doing real work.
		showLogoandpush(false);
		
		if(start_server){
			connection_msg = "Shutting down Server side.";
			showLogoandpush(false);			
			Thread.sleep(100);
			
			connection_msg = "Saving world properties.";
			showLogoandpush(false);
			Thread.sleep(100);
			saveWorld(server_world);

			connection_msg = "Saving world chunks.";
			showLogoandpush(false);
			Thread.sleep(100);
			while(chunkwriter.getSize() > 0){				
				showLogoandpush(false);
				Thread.sleep(100);
			}
			
			connection_msg = "Shutdown chunk cache.";
			showLogoandpush(false);
			Thread.sleep(100);
			server_world.serverchunkcache.shutdown();
			
			//Close and save all the players!	
			connection_msg = "Saving players.";
			showLogoandpush(false);
			Thread.sleep(100);
			server.savePlayers();
			
		}
		
		connection_msg = "Bye!";
		showLogoandpush(false);
		Thread.sleep(500);	//Pretend we're busy doing real work.

		if(!nogui){
			if(isVR)VR.VR_ShutdownInternal();
			stopGUI();
			shader_stuff.removeShaders();
		}

		//System.out.printf("I am NOT here!\n");
		System.exit(0);
	}
	
	public static void do_sound_stuff() {
		//tell the sound player where we are and our orientation.
		//mostly all it needs is orientation so the sound hits the correct ear,
		//but it seems to overdo this and its mostly one ear or the other...
		//or maybe my speakers are just too far apart!
		
		listenerPos.rewind();
		listenerOri.rewind();
		
		listenerPos.put((float)player.posx);
		listenerPos.put((float)player.posy);
		listenerPos.put((float)player.posz);
		listenerPos.flip();
		
		listenerOri.put(-(float)Math.cos(Math.toRadians(player.rotation_yaw_head+90)));
		listenerOri.put(0);
		listenerOri.put(-(float)Math.sin(Math.toRadians(player.rotation_yaw_head+90)));
		listenerOri.put((float)0);
		listenerOri.put((float)1);
		listenerOri.put((float)0);
		listenerOri.flip();
		

		AL10.alListenerfv(AL10.AL_POSITION, listenerPos);
		AL10.alListenerfv(AL10.AL_ORIENTATION, listenerOri);
		
	
		SoundStore.get().poll(0);
	}
	
	public static void renderGUIThings(int mode) {
		
		if(doDeathGUI){
			f12_on = false;
			if(current_gui != null){
				if(current_gui != deathgui){
					current_gui.ImAllDone();
					current_gui = deathgui;
				}
			}else{
				current_gui = deathgui;
			}
		}

		if(current_gui != null && !f12_on){
			
			if(mouse_grabbed && !current_gui.grab_mouse){
				//Mouse.setGrabbed(false); //We be un-cat-like
				glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_NORMAL);
				mouse_grabbed = false;
			}
			
			messagestring = null;
			messagetimer = 0;

			/*
			 * Get into menu mode...
			 */
			if(mode == 0) {
				if(monitor_enable) {
					GL11.glDisable(GL11.GL_DEPTH_TEST);
					GL11.glMatrixMode(GL11.GL_PROJECTION);
					GL11.glPushMatrix();
					GL11.glLoadIdentity();
					//puts 0,0 (x,y) at lower left of screen!
					GL11.glOrtho(0,DangerZone.screen_width,0,DangerZone.screen_height,-320,320);


					GL11.glMatrixMode(GL11.GL_MODELVIEW);
					GL11.glPushMatrix();
					GL11.glLoadIdentity();
					GL11.glEnable(GL11.GL_TEXTURE_2D);
					GL11.glEnable(GL11.GL_BLEND);
					GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
					GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!
				}
			}else {
				wr.setup_vr_menu();
			}

			if(mode != 0 || (mode == 0 && monitor_enable))current_gui.process(mode);

			if(mode == 0) {
				//back out of menu mode
				if(monitor_enable) {
					GL11.glDisable(GL11.GL_BLEND);
					GL11.glMatrixMode(GL11.GL_PROJECTION);
					GL11.glPopMatrix();
					GL11.glMatrixMode(GL11.GL_MODELVIEW);
					GL11.glPopMatrix();
					GL11.glEnable(GL11.GL_DEPTH_TEST);
				}
			}else {
				wr.teardown_vr_menu();
			}

		}else{
			if(!isVR)player.rotation_roll_head = 0;
			player_last_pitch = player.rotation_pitch_head;
			player_last_yaw = player.rotation_yaw_head;
			player_last_roll = player.rotation_roll_head;
			
			if(OverlayGUI.guiarray[1] != null && overlays_on && !f12_on){
				
				if(mode != 0 || (mode == 0 && monitor_enable)) {

					/*
					 * Get into menu mode...
					 */
					GL11.glDisable(GL11.GL_DEPTH_TEST);
					GL11.glMatrixMode(GL11.GL_PROJECTION);
					GL11.glPushMatrix();
					GL11.glLoadIdentity();
					//puts 0,0 (x,y) at lower left of screen!
					GL11.glOrtho(0,DangerZone.screen_width,0,DangerZone.screen_height,-320,320);

					GL11.glMatrixMode(GL11.GL_MODELVIEW);
					GL11.glPushMatrix();
					GL11.glLoadIdentity();
					GL11.glEnable(GL11.GL_TEXTURE_2D);
					GL11.glEnable(GL11.GL_BLEND);
					GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
					GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!

					int ig;
					for(ig = 1;ig<OverlayGUI.guiMAX;ig++){
						if(OverlayGUI.guiarray[ig] != null){
							OverlayGUI.guiarray[ig].process(mode);
						}
					}

					//back out of menu mode
					GL11.glDisable(GL11.GL_BLEND);
					GL11.glMatrixMode(GL11.GL_PROJECTION);
					GL11.glPopMatrix();
					GL11.glMatrixMode(GL11.GL_MODELVIEW);
					GL11.glPopMatrix();
					GL11.glEnable(GL11.GL_DEPTH_TEST);

				}
			}
			if(!mouse_grabbed && !f12_on && !showcase){
				//Mouse.setGrabbed(true); //We be cat-like
				glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_DISABLED);
				mouse_grabbed = true;
			}

			
			if(refresh_rate == 120 && (frame_scaler&0x01)==0) {
				if(isVR && mode == 1) {
					doVRInput();
				}
				if(mode == 0) {
					doNormalInput();
					if(gui_exit > 0)gui_exit--;
				}
			}else if(refresh_rate == 90 && (frame_scaler%3)!=0) {
				if(isVR && mode == 1) {
					doVRInput();
				}
				if(mode == 0) {
					doNormalInput();
					if(gui_exit > 0)gui_exit--;
				}
			}else { //60
				if(isVR && mode == 1) {
					doVRInput();
				}
				if(mode == 0) {
					doNormalInput();
					if(gui_exit > 0)gui_exit--;
				}
			}
			

			
			//they can use the pointer instead of headset
			if(isVR && use_pointer && pointer_controller != null) {
				pointer_posx = pointer_controller.real_posx;
				pointer_posy = pointer_controller.real_posy + player.getEyeHeight();
				pointer_posz = pointer_controller.real_posz;
				//pointer_controller.calc_50();
				pointer_pitch = pointer_controller.pitch;
				pointer_yaw = (360f - pointer_controller.yaw) + 180f;
				while(pointer_yaw < 0)pointer_yaw += 360f;
				while(pointer_yaw >= 360)pointer_yaw -= 360;
			}else {
				//defaults for mouse/headset focus-finder
				pointer_posx = player.posx;
				pointer_posy = player.posy+player.getEyeHeight()+eyeheight_adjust;
				pointer_posz = player.posz;
				pointer_pitch = player.rotation_pitch_head;
				pointer_yaw = player.rotation_yaw_head;
			}
			
			
		}
		//GL11.glFlush();
	}
	
	public static TargetInfo vr_is_clicked() {
		VRSystem_GetControllerState(left_hand_index, left_state);
		VRSystem_GetControllerState(right_hand_index, right_state);
		
		if(left_state.rAxis(trigger_index).x() > 0.1f) {
			if(left_is_down)return null; //already reported
			left_is_down = true;
			return left_controller;
		}else {
			left_is_down = false;
		}
		if(right_state.rAxis(trigger_index).x() > 0.1f) {
			if(right_is_down)return null; //already reported
			right_is_down = true;
			return right_controller;
		}else {
			right_is_down = false;
		}

		return null;
	}
	
	public static TargetInfo vr_is_down() {
		VRSystem_GetControllerState(left_hand_index, left_state);
		VRSystem_GetControllerState(right_hand_index, right_state);
		
		if(left_state.rAxis(trigger_index).x() > 0.1f) {
			return left_controller;
		}
		if(right_state.rAxis(trigger_index).x() > 0.1f) {
			return right_controller;
		}
		return null;
	}
	
	
	public static void doVRInput() {
		int bfoo;
		boolean hit_something = false;
		boolean swing_stopped = false;
		//We do not get events for trigger values. Just have to read them and check each time.
		//trigger will go to exactly 1.0000 when clicked.
		if(gameover != 0)return;

		VRSystem_GetControllerState(left_hand_index, left_state);
		VRSystem_GetControllerState(right_hand_index, right_state);
		float swing_speed = 0;
		float angular_swing_speed = 0;

		if(gui_exit == 0) {

			left_controller.calc_50();
			right_controller.calc_50();

			if(weapon_controller == right_controller) {

				vrrightbuttonclicked = vrrightbuttonreleased = false;
				if(right_state.rAxis(trigger_index).x() > 0.1f) {
					if(!vrrightbuttondown)vrrightbuttonclicked=true;
					vrrightbuttondown = true;
				}else {
					if(vrrightbuttondown)vrrightbuttonreleased=true;
					vrrightbuttondown = false;
				}

				vrleftbuttonclicked = vrleftbuttonreleased = false;
				if(left_state.rAxis(trigger_index).x() > 0.1f) {
					if(!vrleftbuttondown)vrleftbuttonclicked=true;
					vrleftbuttondown = true;
				}else {
					if(vrleftbuttondown)vrleftbuttonreleased=true;
					vrleftbuttondown = false;
				}

				//Hotbar control
				int idir = 0;
				if(right_state.rAxis(trackpad_index).x()<-0.25f){
					if(!joy_is_left)idir=-1;
					joy_is_left = true;
				}else {
					joy_is_left = false;
				}

				if(right_state.rAxis(trackpad_index).x()>0.25f){
					if(!joy_is_right)idir=1;
					joy_is_right = true;
				}else {
					joy_is_right = false;
				}			
				if(idir != 0) {
					int i = player.gethotbarindex();
					i+=idir;
					i %= 10;
					while(i<0)i+=10;
					player.sethotbarindex(i);
					show_selection(i);
				}



				swing_speed = (float) Math.sqrt(right_controller.velocity.v(0)*right_controller.velocity.v(0)
						+right_controller.velocity.v(1)*right_controller.velocity.v(1)
						+right_controller.velocity.v(2)*right_controller.velocity.v(2));
				angular_swing_speed = (float) Math.sqrt(right_controller.angular_velocity.v(0)*right_controller.angular_velocity.v(0)
						+right_controller.angular_velocity.v(1)*right_controller.angular_velocity.v(1)
						+right_controller.angular_velocity.v(2)*right_controller.angular_velocity.v(2));

				if(swing_speed > 2 || angular_swing_speed > 20) {			
					hit_something = vrhit.check_for_contact(world, right_controller, swing_speed, angular_swing_speed, !swinging, wr.fps);
					if(!swinging) {					
						int which = DangerZone.player.world.rand.nextInt(6);
						if(which == 0)DangerZone.player.world.playSound("DangerZone:swish3", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 1)DangerZone.player.world.playSound("DangerZone:swish4", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 2)DangerZone.player.world.playSound("DangerZone:swish5", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 3)DangerZone.player.world.playSound("DangerZone:swish6", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 4)DangerZone.player.world.playSound("DangerZone:swish7", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 5)DangerZone.player.world.playSound("DangerZone:swish8", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						swinging = true;
					}
					//if(hit_something)swing_did_hit = true;
				}else {
					if(swinging == true) {
						swing_stopped = true;
						//if(!swing_did_hit) {
						//	vrhit.focus_damage = 0;
						//	wr.show_focus_damage = 0;
						//}
						//swing_did_hit = false;						
					}
					swinging = false;
					vrhit.focus_bid = vrhit.focus_meta = 0;
					vrhit.focus_entity = null;
					vrhit.focus_x = vrhit.focus_y = vrhit.focus_z = 0;
				}
			}else {

				vrrightbuttonclicked = vrrightbuttonreleased = false;
				if(left_state.rAxis(trigger_index).x() > 0.1f) {
					if(!vrrightbuttondown)vrrightbuttonclicked=true;
					vrrightbuttondown = true;
				}else {
					if(vrrightbuttondown)vrrightbuttonreleased=true;
					vrrightbuttondown = false;
				}

				vrleftbuttonclicked = vrleftbuttonreleased = false;
				if(right_state.rAxis(trigger_index).x() > 0.1f) {
					if(!vrleftbuttondown)vrleftbuttonclicked=true;
					vrleftbuttondown = true;
				}else {
					if(vrleftbuttondown)vrleftbuttonreleased=true;
					vrleftbuttondown = false;
				}

				//Hotbar control
				int idir = 0;
				if(left_state.rAxis(trackpad_index).x()<-0.25f){
					if(!joy_is_left)idir=-1;
					joy_is_left = true;
				}else {
					joy_is_left = false;
				}

				if(left_state.rAxis(trackpad_index).x()>0.25f){
					if(!joy_is_right)idir=1;
					joy_is_right = true;
				}else {
					joy_is_right = false;
				}			
				if(idir != 0) {
					int i = player.gethotbarindex();
					i+=idir;
					i %= 10;
					while(i<0)i+=10;
					player.sethotbarindex(i);
					show_selection(i);
				}

				swing_speed = (float) Math.sqrt(left_controller.velocity.v(0)*left_controller.velocity.v(0)
						+left_controller.velocity.v(1)*left_controller.velocity.v(1)
						+left_controller.velocity.v(2)*left_controller.velocity.v(2));
				angular_swing_speed = (float) Math.sqrt(left_controller.angular_velocity.v(0)*left_controller.angular_velocity.v(0)
						+left_controller.angular_velocity.v(1)*left_controller.angular_velocity.v(1)
						+left_controller.angular_velocity.v(2)*left_controller.angular_velocity.v(2));

				if(swing_speed > 2 || angular_swing_speed > 20) {			
					hit_something = vrhit.check_for_contact(world, left_controller, swing_speed, angular_swing_speed, !swinging, wr.fps);
					if(!swinging) {					
						int which = DangerZone.player.world.rand.nextInt(6);
						if(which == 0)DangerZone.player.world.playSound("DangerZone:swish3", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 1)DangerZone.player.world.playSound("DangerZone:swish4", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 2)DangerZone.player.world.playSound("DangerZone:swish5", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 3)DangerZone.player.world.playSound("DangerZone:swish6", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 4)DangerZone.player.world.playSound("DangerZone:swish7", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						if(which == 5)DangerZone.player.world.playSound("DangerZone:swish8", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy+1.25d, DangerZone.player.posz, 0.25f, 1);
						swinging = true;
					}
					//if(hit_something)swing_did_hit = true;
				}else {
					if(swinging == true) {
						swing_stopped = true;
						//if(!swing_did_hit) {
						//	vrhit.focus_damage = 0;
						//	wr.show_focus_damage = 0;
						//}
						//swing_did_hit = false;		
					}
					swinging = false;
					vrhit.focus_bid = vrhit.focus_meta = 0;
					vrhit.focus_entity = null;
					vrhit.focus_x = vrhit.focus_y = vrhit.focus_z = 0;
					
				}
			}


			if(hit_something) {
				wr.show_focus_bid = vrhit.focus_bid;
				wr.show_focus_meta = vrhit.focus_meta;
				wr.show_focus_side = vrhit.focus_side;
				wr.show_focus_x = vrhit.focus_x;
				wr.show_focus_y = vrhit.focus_y;
				wr.show_focus_z = vrhit.focus_z;
				wr.show_focus_damage = vrhit.focus_damage;
				wr.show_focus_maxdamage = vrhit.focus_maxdamage;
				wr.show_focus_dist = vrhit.focus_dist;
				wr.show_focus_entity = vrhit.focus_entity;
				wr.show_poi_x = vrhit.poi_x;
				wr.show_poi_y = vrhit.poi_y;
				wr.show_poi_z = vrhit.poi_z; 
				
				InventoryContainer ic = player.getHotbar(player.gethotbarindex());
				if(ic != null) {
					Item it = ic.getItem();
					if(it != null) {
						it.vr_hit_something(vrhit.focus_entity, vrhit.focus_bid);
					}
				}

				
				if((weapon_controller == right_controller && vrrightbuttondown == true)
						|| (weapon_controller == left_controller && vrleftbuttondown == true)){
					DangerZone.player.rightclick(world, vrhit.focus_x, vrhit.focus_y, vrhit.focus_z, vrhit.focus_side, vrhit.focus_entity==null?0:vrhit.focus_entity.entityID, 
							vrhit.poi_x, vrhit.poi_y, vrhit.poi_z);
					DangerZone.dorightclick = false;
					DangerZone.vrdorightclick = false;
				}else {
					DangerZone.player.leftclick(world, vrhit.focus_x, vrhit.focus_y, vrhit.focus_z, vrhit.focus_side, vrhit.focus_entity==null?0:vrhit.focus_entity.entityID, 
							DangerZone.magic_power, DangerZone.magic_type, vrhit.poi_x, vrhit.poi_y, vrhit.poi_z);
					DangerZone.doleftclick = false;
					DangerZone.vrdoleftclick = false;
					DangerZone.magic_power = 0;	
				}

			}

			if(swing_stopped) {

				DangerZone.player.swingstop(world, vrhit.focus_x, vrhit.focus_y, vrhit.focus_z, vrhit.focus_side, vrhit.focus_entity==null?0:vrhit.focus_entity.entityID, 
						vrhit.poi_x, vrhit.poi_y, vrhit.poi_z);

			}

		}

		float move_x, move_z, move_y;
		if(motion_controller != right_controller) {
			move_x = left_state.rAxis(trackpad_index).x();
			move_z = left_state.rAxis(trackpad_index).y();
			move_y = (float) Math.cos(Math.toRadians(left_controller.pitch_50-90));
		}else {
			move_x = right_state.rAxis(trackpad_index).x();
			move_z = right_state.rAxis(trackpad_index).y();
			move_y = (float) Math.cos(Math.toRadians(right_controller.pitch_50-90));
		}

		if (move_z > 0){			
			float speed = 0.042f*accel*Math.abs(move_z*2);
			if(player.getGameMode() != GameModes.GHOST && player.getGameMode() != GameModes.LIMBO && 
					(world.getblock(player.dimension, (int)player.posx, (int)player.posy+2, (int)player.posz) != 0
					|| world.getblock(player.dimension, (int)player.posx, (int)player.posy+3, (int)player.posz) != 0 ))speed *= 0.70f;
			accel += 0.2f;
			if(accel > 1)accel = 1;
			if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO || player.isFlying()){
				speed *= 4.0f;
			}else{
				if(gofast != 0)speed *= 2.5f;
			}
			float effectspeed;
			effectspeed = player.getTotalEffect(Effects.SPEED);
			if(effectspeed > 1){
				speed *= effectspeed;
			}
			effectspeed = player.getTotalEffect(Effects.SLOWNESS);
			if(effectspeed > 1){
				speed /= effectspeed;
			}
			//System.out.printf("Headset.yaw = %f, sin %f, cos, %f\n",  headset.yaw, (float)Math.sin(Math.toRadians(headset.yaw)), (float)Math.cos(Math.toRadians(headset.yaw)));
			float fact = player.getMotionFactor();
			player.motionx += speed*Math.sin(Math.toRadians(headset.yaw))*deltaT*fact;
			player.motionz -= speed*Math.cos(Math.toRadians(headset.yaw))*deltaT*fact;

			player.setForward(true);
		}else{
			gofast = 0;
			player.setForward(false);
		}
		if (move_z < 0){
			float speed = 0.030f*accel*Math.abs(move_z*2);
			accel += 0.1f;
			if(accel > 1)accel = 1;
			if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO)speed *= 2.5f;
			float effectspeed;
			effectspeed = player.getTotalEffect(Effects.SPEED);
			if(effectspeed > 1){
				speed *= effectspeed;
			}
			effectspeed = player.getTotalEffect(Effects.SLOWNESS);
			if(effectspeed > 1){
				speed /= effectspeed;
			}
			float fact = player.getMotionFactor();
			player.motionx -= speed*Math.sin(Math.toRadians(headset.yaw))*deltaT*fact;
			player.motionz += speed*Math.cos(Math.toRadians(headset.yaw))*deltaT*fact;

			player.setBackward(true);
		}else{
			player.setBackward(false);
		}

		if (move_x < 0){
			float speed = 0.030f*accel*Math.abs(move_x*2);
			accel += 0.1f;
			if(accel > 1)accel = 1;
			if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO)speed *= 2.5f;
			float effectspeed;
			effectspeed = player.getTotalEffect(Effects.SPEED);
			if(effectspeed > 1){
				speed *= effectspeed;
			}
			effectspeed = player.getTotalEffect(Effects.SLOWNESS);
			if(effectspeed > 1){
				speed /= effectspeed;
			}
			float fact = player.getMotionFactor();
			player.motionx -= speed*Math.cos(Math.toRadians(headset.yaw))*deltaT*fact;
			player.motionz -= speed*Math.sin(Math.toRadians(headset.yaw))*deltaT*fact;
			player.setLeft(true);
		}else{
			player.setLeft(false);
		}
		if (move_x > 0){
			float speed = 0.030f*accel*Math.abs(move_x*2);
			accel += 0.1f;
			if(accel > 1)accel = 1;
			if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO)speed *= 2.5f;
			float effectspeed;
			effectspeed = player.getTotalEffect(Effects.SPEED);
			if(effectspeed > 1){
				speed *= effectspeed;
			}
			effectspeed = player.getTotalEffect(Effects.SLOWNESS);
			if(effectspeed > 1){
				speed /= effectspeed;
			}
			float fact = player.getMotionFactor();
			player.motionx += speed*Math.cos(Math.toRadians(headset.yaw))*deltaT*fact;
			player.motionz += speed*Math.sin(Math.toRadians(headset.yaw))*deltaT*fact;
			player.setRight(true);
		}else{
			player.setRight(false);
		}

		if(move_y < 0) {
			if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO || player.isFlying() || player.isLadder()){
				float fact = player.getAirFactor();
				player.motiony += (0.055f-(0.005*character_feel))*deltaT*accel*Math.abs(move_y)*fact;
				accel += 0.1f;
				if(accel > 1)accel = 1;
			}
			player.setUp(true);
		}else{
			player.setUp(false);
		}

		if (move_y > 0){
			if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO || player.isFlying() || player.isLadder()){
				float fact = player.getAirFactor();
				player.motiony -= (0.055f-(0.005*character_feel))*deltaT*accel*Math.abs(move_y)*fact;
				accel += 0.1f;
				if(accel > 1)accel = 1;
			}
			player.setDown(true);
		}else{
			player.setDown(false);
		}


		//System.out.printf("Right trigger, pad = %f, %f, %f\n", right_state.rAxis(trigger_index).x(),
		//		right_state.rAxis(trackpad_index).x(),right_state.rAxis(trackpad_index).y());
		//Trackpad left and up are positive. Ranges 1 to -1.

		while(VRSystem_PollNextEvent(vr_event)) {

			//System.out.printf("Left trigger, pad = %f, %f, %f\n", left_state.rAxis(trigger_index).x(),
			//		left_state.rAxis(trackpad_index).x(),left_state.rAxis(trackpad_index).y());
			//System.out.printf("Right trigger, pad = %f, %f, %f\n", right_state.rAxis(trigger_index).x(),
			//		right_state.rAxis(trackpad_index).x(),right_state.rAxis(trackpad_index).y());

			//System.out.printf("Right trigger vals = %f, %f, %f. %f, %f, %f, %f. %f\n", right_state.rAxis(0).x(),right_state.rAxis(0).y(),
			//		right_state.rAxis(1).x(),right_state.rAxis(1).y(),
			//		right_state.rAxis(2).x(),right_state.rAxis(2).y(),
			//		right_state.rAxis(3).x(),right_state.rAxis(3).y()
			//		);


			if(gui_exit != 0) continue; //just clear the events


			int foo = vr_event.eventType();
			switch(foo) {


			case EVREventType_VREvent_ButtonPress:
				bfoo = vr_event.data().controller().button();

				//System.out.printf("button press was %d on controller %d\n", bfoo, vr_event.trackedDeviceIndex());

				switch(bfoo) {
				case	EVRButtonId_k_EButton_A:
					//System.out.printf("button press was A\n");
					break;
				case	EVRButtonId_k_EButton_ApplicationMenu: //"B"
					//System.out.printf("button press was App\n");
					if(current_gui != null) {
						current_gui.ImAllDone();
						current_gui = null;
					}
					setActiveGui(vrgui);						
					break;
				case	EVRButtonId_k_EButton_Dashboard_Back: //"A"
					if(!player.isFlying()) {
						if(player.jump()) { //always mode == 1, so no problem
							jump_pulse();
						}
					}
					break;
				case	EVRButtonId_k_EButton_Axis0:
					//System.out.printf("button press was Axis0\n");
					break;
				case	EVRButtonId_k_EButton_Axis1:
					//System.out.printf("button press was A1\n");
					break;
				case	EVRButtonId_k_EButton_Axis2:
					//System.out.printf("button press was A2\n");
					break;
				case	EVRButtonId_k_EButton_Axis3:
					//System.out.printf("button press was A3\n");
					break;
				case	EVRButtonId_k_EButton_Axis4:
					//System.out.printf("button press was A4\n");
					break;
				default:
					//System.out.printf("button press was Something: %d\n", bfoo);
					break;
				}
				break;


			case EVREventType_VREvent_ButtonUnpress:
			{
				bfoo = vr_event.data().controller().button();
				switch(bfoo) {
				case	EVRButtonId_k_EButton_A:
					//System.out.printf("button unpress was A\n");
					break;
				case	EVRButtonId_k_EButton_ApplicationMenu:
					//System.out.printf("button unpress was App\n");
					break;
				case	EVRButtonId_k_EButton_Axis0:
					//System.out.printf("button unpress was Axis0\n");
					break;
				case	EVRButtonId_k_EButton_Axis1:
					//System.out.printf("button unpress was A1\n");
					break;
				case	EVRButtonId_k_EButton_Axis2:
					//System.out.printf("button unpress was A2\n");
					break;
				case	EVRButtonId_k_EButton_Axis3:
					//System.out.printf("button unpress was A3\n");
					break;
				case	EVRButtonId_k_EButton_Axis4:
					//System.out.printf("button unpress was A4\n");
					break;
				case	EVRButtonId_k_EButton_Dashboard_Back:
					//System.out.printf("button press/unpress was Dash\n");
					break;
				case	EVRButtonId_k_EButton_DPad_Down:
					//System.out.printf("button press/unpress was Down\n");
					break;
				case	EVRButtonId_k_EButton_DPad_Up:
					//System.out.printf("button press/unpress was Up\n");
					break;
				case	EVRButtonId_k_EButton_DPad_Left:
					//System.out.printf("button press/unpress was Left\n");
					break;
				case	EVRButtonId_k_EButton_DPad_Right:
					//System.out.printf("button press/unpress was Right\n");
					break;
					//case	EVRButtonId_k_EButton_Grip:
				case	EVRButtonId_k_EButton_Max:
					//System.out.printf("button press/unpress was Max\n");
					break;
				case	EVRButtonId_k_EButton_ProximitySensor:
					//System.out.printf("button press/unpress was Prox\n");
					break;
					//case	EVRButtonId_k_EButton_SteamVR_Touchpad:
					//case	EVRButtonId_k_EButton_SteamVR_Trigger:
				case	EVRButtonId_k_EButton_System:
					//System.out.printf("button press/unpress was System\n");
					break;
				default:
					//System.out.printf("button press/unpress was UNKNOWN %d\n", bfoo);
				}
			}
			case EVREventType_VREvent_ButtonTouch:
				//System.out.printf("Event Touch\n");
				break;
			case EVREventType_VREvent_ButtonUntouch:
				//System.out.printf("Event UnTouch\n");
				break;
			case EVREventType_VREvent_Quit:
			case EVREventType_VREvent_ProcessQuit:
			//case EVREventType_VREvent_QuitAborted_UserPrompt:
			case EVREventType_VREvent_QuitAcknowledged:
				//System.out.printf("Event Quit\n");
				DangerZone.gameover = 1;
				break;
			case EVREventType_VREvent_DashboardActivated:
				//System.out.printf("Event DashACT\n");
				break;
			case EVREventType_VREvent_DashboardDeactivated:
				//System.out.printf("Event DashDeAct\n");
				break;
			case EVREventType_VREvent_TouchPadMove:
				//System.out.printf("Event TouchPadMove\n");
				break;
			default:
				//System.out.printf("Event happened! %d\n", foo);
				//System.out.printf("Controller was %d\n", vr_event.trackedDeviceIndex());
				//System.out.printf("button was %d\n", vr_event.data().controller().button());
				break;
			}

		}



		if(gui_exit != 0)return;


		//what kind of clickiness are we doing? hit&eat or shoot?
		boolean clicky_shoot = false;
		InventoryContainer ic = player.getHotbar(player.gethotbarindex());
		if(ic != null){
			if(ic.iid > 0){
				Item it = ic.getItem();
				if(it != null){
					if(it.do_shoot_clicks){
						clicky_shoot = true;
					}
				}
			}
		}



		if(!clicky_shoot){
			//normal clicks
			if(vrleftbuttondown || vrrightbuttondown){			
				if(vrrepeatdelay == 0 || vrrepeatdelay > 30){
					if(vrleftbuttondown && !vrrightbuttondown){
						do_hit_cycle = 1;
						do_food_cycle = 0;
						vrdoleftclick = true;
						vrdorightclick = false;
					}	
					if(vrrightbuttondown && !vrleftbuttondown){
						if(wr.show_focus_entity != null){
							do_hit_cycle = 1;
							do_food_cycle = 0;
							vrdorightclick = true;
							vrdoleftclick = false;
						}else{
							if(ic != null && Items.isFood(ic.iid) && wr.show_focus_x == 0 && wr.show_focus_z == 0){
								do_food_cycle = 1;
								do_hit_cycle = 0;
								vrdoleftclick = false;
								vrdorightclick = false;
							}else{
								do_hit_cycle = 1;
								do_food_cycle = 0;
								vrdorightclick = true;
								vrdoleftclick = false;
							}
						}
					}				
				}
				vrrepeatdelay++;
			}else{
				vrrepeatdelay = 0;
			}

			if(vrrapidfire_delay > 0)vrrapidfire_delay--;
			if(vrprevrightbuttondown){
				if(!vrrightbuttondown){
					//right button is now up!
					vrdorightclickup = true;
				}else{
					vrrightbuttondowncounter++;
					vrrapidfire_delay = 10;
				}			
			}
			vrprevrightbuttondown = vrrightbuttondown;

		}else{ //else is probably a gun of some sort.

			do_hit_cycle = do_food_cycle = 0;

			if(vrrapidfire_delay > 0)vrrapidfire_delay--;

			if(weapon_controller == right_controller) {

				if(!vrrightbuttondown){
					vrsingleshot_needleftup = false;
					vrsemiauto_needleftup = false;
					vrrapidfire_delay = 0;
				}

				if(!vrleftbuttondown){
					vrsingleshot_needrightup = false;
					vrrapidfire_delay = 0;
					vrrightbuttondowncounter = 0;
				}else{

					vrrightbuttondowncounter++;

					if(vrrightbuttondown){

						if(vrrapidfire_delay == 0){
							vrfullauto=true;
							vrrapidfire_delay = 12; //5 shots per second. ish.
							if(wr.fps < 40)vrrapidfire_delay = 8;
							if(wr.fps < 20)vrrapidfire_delay = 4;
						}

						if(!vrsemiauto_needleftup){
							vrsemiauto = true;
							vrsemiauto_needleftup = true;
						}

						if(!vrsingleshot_needleftup && !vrsingleshot_needrightup){
							vrsingleshot = true;
							vrsingleshot_needleftup = true;
							vrsingleshot_needrightup = true;
						}

					}else{
						vrfullauto = false;
					}
				}

			}else {

				if(!vrleftbuttondown){
					vrsingleshot_needleftup = false;
					vrsemiauto_needleftup = false;
					vrrapidfire_delay = 0;
				}

				if(!vrrightbuttondown){
					vrsingleshot_needrightup = false;
					vrrapidfire_delay = 0;
					vrrightbuttondowncounter = 0;
				}else{

					vrrightbuttondowncounter++;

					if(vrleftbuttondown){

						if(vrrapidfire_delay == 0){
							vrfullauto=true;
							vrrapidfire_delay = 12; //5 shots per second. ish.
							if(wr.fps < 40)vrrapidfire_delay = 8;
							if(wr.fps < 20)vrrapidfire_delay = 4;
						}

						if(!vrsemiauto_needleftup){
							vrsemiauto = true;
							vrsemiauto_needleftup = true;
						}

						if(!vrsingleshot_needleftup && !vrsingleshot_needrightup){
							vrsingleshot = true;
							vrsingleshot_needleftup = true;
							vrsingleshot_needrightup = true;
						}

					}else{
						vrfullauto = false;
					}
				}
			}	
		}



	}

	public static void stopGUI(){
		GLFW.glfwDestroyWindow(window);
		GLFW.glfwTerminate();
		input.destroy();
	}
	
	//Because these calls can ONLY be made from here.
	//No, you CANNOT access Keyboard or Mouse calls directly.
	//Access must go through DangerZone.java where the Keyboard is defined.
	//Use these routines to access Mouse and Keyboard from outside this file!
	//
	
	public static void keymap_clear(){
		keymap_real_to_new.clear();
		keymap_new_to_real.clear();
	}
	
	//remaps the physical realkey to the logical newkey
	public static void keymap_remap(int realkey, int newkey){
		keymap_real_to_new.put(realkey, newkey);
		keymap_new_to_real.put(newkey, realkey);
	}
	
	public static boolean K_next(){
		return input.knext();
	}
	
	public static void K_clear(){
		input.kclear();
	}
	
	public static int K_getEventKey(){
		//return the logical key that was hit.
		int realkey = input.getEventKey();
		Integer mappedkey = keymap_real_to_new.get(realkey);
		if(mappedkey != null)return mappedkey.intValue();
		return realkey;
	}
	
	public static int K_getEventKeyUnMapped(){
		//return the key that was hit.
		return input.getEventKey();
	}
	
	public static boolean K_isEventKeyDown(){
		return input.getEventKeyState();
	}
	
	public static boolean K_isKeyDown(int key){
		//map logical back to real and see if it is down
		Integer realkey = keymap_new_to_real.get(key);
		if(realkey != null)return input.isKeyDown(realkey.intValue());
		return input.isKeyDown(key);
	}
	
	
	public static boolean K_isKeyDownUnMapped(int key){
		return input.isKeyDown(key);
	}
	
	public static boolean M_next(){
		return input.mnext();
	}
	
	public static void glfw_clear() {		
		glfwPollEvents(); //just get all the events into their queues
	}
	
	public static void M_clear(){
		input.mclear();
	}
	
	public static int M_getEventButton(){
		return input.getEventButton();
	}
	
	public static boolean M_getEventButtonState(){
		return input.getEventButtonState();
	}
	
	public static int M_getEventX(){
		return (int) input.getEventx();
	}
	
	public static int M_getEventY(){
		return (int) input.getEventy();
	}
	
	public static int M_getEventDX(){
		return (int) input.getEventdx();
	}
	
	public static int M_getEventDY(){
		return (int) input.getEventdy();
	}
	
	public static int M_getCurX(){
		return (int) input.getCurMousex();
	}
	
	public static int M_getCurY(){
		return (int) input.getCurMousey();
	}
	
	public static int M_getCurDX(){
		return (int) input.getCurMousedx();
	}
	
	public static int M_getCurDY(){
		return (int) input.getCurMousedy();
	}
	
	
	public static void setActiveGui(GuiInterface g){

		current_gui = g;
		
		do_hit_cycle = 0;
		do_food_cycle = 0;
		repeatdelay = 0;
		doleftclick = false;
		dorightclick = false;
		leftbuttondown = false;
		rightbuttondown = false;
		leftbuttonclicked = false;
		rightbuttonclicked = false;
		leftbuttonreleased = false;
		rightbuttonreleased = false;

		vrrepeatdelay = 0;
		vrdoleftclick = false;
		vrdorightclick = false;
		vrleftbuttondown = false;
		vrrightbuttondown = false;
		vrleftbuttonclicked = false;
		vrrightbuttonclicked = false;
		vrleftbuttonreleased = false;
		vrrightbuttonreleased = false;
		if(g == null){	
			gui_exit = 60; //set timer!
		}
	}
	
	public static void clearActiveGui(){
			setActiveGui(null);
	}
	
	public static void doNormalInput(){
		float dx, dy;
		int i;
		
		if(gameover != 0)return;
		
		accel -= 0.05f;
		if(accel < 0.1f)accel = 0.1f;
		
		if(showcase) {
			showcase_change_counter++;
			if(showcase_change_counter > 60*60*5) {
				showcase_change_counter = 0;
				for(i=0;i<Dimensions.dimensionsMAX;i++){
					int id = (player.dimension+i+1)%Dimensions.dimensionsMAX;
					if(Dimensions.DimensionArray[id] != null){
						if(!Dimensions.DimensionArray[id].special_hidden){
							//System.out.printf("requesting switch to %d:%s\n", id, Dimensions.DimensionArray[id].uniquename);
							Dimensions.DimensionArray[id].teleportToDimension(player, world, id, (int)player.posx, (int)player.posy, (int)player.posz);
							break;
						}
					}
				}
			}
			
			//player.setGameMode(GameModes.LIMBO);
			//player.setFlying(true);				
			float speed = 0.005f;
			float fact = player.getMotionFactor();
			//System.out.printf("getMotionFactor = %f\n", player.getMotionFactor() );
			player.rotation_yaw_head += (360f/(60f*60f*60f));
			player.rotation_pitch_head = 15f; //plus is down???
			player.motionx += speed*Math.cos(Math.toRadians(player.rotation_yaw_head-90))*deltaT*fact;
			player.motionz += speed*Math.sin(Math.toRadians(player.rotation_yaw_head-90))*deltaT*fact;	
			if(player.posx < 0)player.posx = 0;
			if(player.posz < 0)player.posz = 0;
			player.motiony = 0;
			int howhigh = Dimensions.DimensionArray[player.dimension].showcaseheight;
			if(player.posy < howhigh-5)player.motiony = 0.15f;
			if(player.posy > howhigh+5)player.motiony = -0.15f;			
			player.setForward(true);
			
		}
		
		//Keyboard input checks
		while (K_next()) {	
			
			//System.out.printf("key = 0x%x\n", K_getEventKey());
			
			if(f12_on && !(K_getEventKey() == GLFW.GLFW_KEY_F12)){
				f12_on = false;
				//setMusicVolume(lastvol);
				resumeMusic();
			}
			//System.out.printf("Key!\n");
			if (K_getEventKey() == GLFW.GLFW_KEY_ESCAPE){
				if(K_isEventKeyDown()){
					setActiveGui(escapegui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_H){
				if(K_isEventKeyDown()){
					setActiveGui(helpgui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_SEMICOLON){
				if(K_isEventKeyDown()){
					setActiveGui(dimensiongui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_E){
				if(K_isEventKeyDown()){
					setActiveGui(inventorygui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_T){
				if(K_isEventKeyDown()){
					setActiveGui(chatgui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_SLASH){
				if(K_isEventKeyDown()){
					setActiveGui(commandgui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_BACKSLASH){
				if(K_isEventKeyDown()){
					setActiveGui(entitygui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_G && K_isEventKeyDown()){
				//change gamemode
				if(player.getGameMode() == GameModes.SURVIVAL){
					player.server_connection.changeGameMode(GameModes.GHOST);
				}else if(player.getGameMode() == GameModes.GHOST){
					player.server_connection.changeGameMode(GameModes.CREATIVE);
				}else if(player.getGameMode() == GameModes.CREATIVE){
				//	player.server_connection.changeGameMode(GameModes.LIMBO);
				//}else if(player.getGameMode() == GameModes.LIMBO){
					player.server_connection.changeGameMode(GameModes.SURVIVAL);
				}else{
					player.server_connection.changeGameMode(GameModes.SURVIVAL);
				}
			}
			
			if (K_getEventKey() == GLFW.GLFW_KEY_M && K_isEventKeyDown()){
				//change difficulty
				if(player.getGameDifficulty() == 0){
					player.server_connection.changeGameDifficulty(-2); //girly
				}else if(player.getGameDifficulty() == -2){
					player.server_connection.changeGameDifficulty(-1);
				}else if(player.getGameDifficulty() == -1){
					player.server_connection.changeGameDifficulty(1);
				}else if(player.getGameDifficulty() == 1){
					player.server_connection.changeGameDifficulty(2);
				}else{
					player.server_connection.changeGameDifficulty(0);
				}
			}

			if (K_getEventKey() == GLFW.GLFW_KEY_X && K_isEventKeyDown() && player.getGameMode() != GameModes.LIMBO){
				if(wr.show_focus_x != 0 && wr.show_focus_y != 0 && wr.show_focus_z != 0){
					int bid = world.getblock(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z);
					int meta = world.getblockmeta(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z);
					if(!Blocks.isLiquid(bid)){
						if((meta&BlockRotation.X_MASK) == BlockRotation.X_ROT_0){//around
							meta = (meta & BlockRotation.NOT_X_MASK) | BlockRotation.X_ROT_90;
						}else if((meta&BlockRotation.X_MASK) == BlockRotation.X_ROT_90){//around
							meta = (meta & BlockRotation.NOT_X_MASK) | BlockRotation.X_ROT_180;
						}else if((meta&BlockRotation.X_MASK) == BlockRotation.X_ROT_180){//around
							meta = (meta & BlockRotation.NOT_X_MASK) | BlockRotation.X_ROT_270;
						}else if((meta&BlockRotation.X_MASK) == BlockRotation.X_ROT_270){//around
							meta = (meta & BlockRotation.NOT_X_MASK) | BlockRotation.X_ROT_0;
						}
						//System.out.printf("meta now %x\n", meta);
						world.setblockandmeta(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z, bid, meta);
					}
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_C && K_isEventKeyDown() && player.getGameMode() != GameModes.LIMBO){
				if(wr.show_focus_x != 0 && wr.show_focus_y != 0 && wr.show_focus_z != 0){
					int bid = world.getblock(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z);
					int meta = world.getblockmeta(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z);
					if(!Blocks.isLiquid(bid)){
						if((meta&BlockRotation.Y_MASK) == BlockRotation.Y_ROT_0){//around
							meta = (meta & BlockRotation.NOT_Y_MASK) | BlockRotation.Y_ROT_90;
						}else if((meta&BlockRotation.Y_MASK) == BlockRotation.Y_ROT_90){//around
							meta = (meta & BlockRotation.NOT_Y_MASK) | BlockRotation.Y_ROT_180;
						}else if((meta&BlockRotation.Y_MASK) == BlockRotation.Y_ROT_180){//around
							meta = (meta & BlockRotation.NOT_Y_MASK) | BlockRotation.Y_ROT_270;
						}else if((meta&BlockRotation.Y_MASK) == BlockRotation.Y_ROT_270){//around
							meta = (meta & BlockRotation.NOT_Y_MASK) | BlockRotation.Y_ROT_0;
						}
						//System.out.printf("meta now %x\n", meta);
						world.setblockandmeta(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z, bid, meta);
					}
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_V && K_isEventKeyDown() && player.getGameMode() != GameModes.LIMBO){
				if(wr.show_focus_x != 0 && wr.show_focus_y != 0 && wr.show_focus_z != 0){
					int bid = world.getblock(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z);
					int meta = world.getblockmeta(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z);
					if(!Blocks.isLiquid(bid)){
						if((meta&BlockRotation.Z_MASK) == BlockRotation.Z_ROT_0){//around
							meta = (meta & BlockRotation.NOT_Z_MASK) | BlockRotation.Z_ROT_90;
						}else if((meta&BlockRotation.Z_MASK) == BlockRotation.Z_ROT_90){//around
							meta = (meta & BlockRotation.NOT_Z_MASK) | BlockRotation.Z_ROT_180;
						}else if((meta&BlockRotation.Z_MASK) == BlockRotation.Z_ROT_180){//around
							meta = (meta & BlockRotation.NOT_Z_MASK) | BlockRotation.Z_ROT_270;
						}else if((meta&BlockRotation.Z_MASK) == BlockRotation.Z_ROT_270){//around
							meta = (meta & BlockRotation.NOT_Z_MASK) | BlockRotation.Z_ROT_0;
						}
						//System.out.printf("meta now %x\n", meta);
						world.setblockandmeta(player.dimension, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z, bid, meta);
					}
				}
			}
			

			if (K_getEventKey() == GLFW.GLFW_KEY_Y && K_isEventKeyDown()){
				//Find the next existing dimension!
				if(player.getGameMode() != GameModes.SURVIVAL && player.getGameMode() != GameModes.LIMBO){					
					if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_CONTROL)){
						Dimensions.DimensionArray[1].teleportToDimension(player, world, 1, (int)player.posx, (int)player.posy, (int)player.posz);
					}else{
						if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)){
							for(i=0;i<Dimensions.dimensionsMAX;i++){
								int id = (player.dimension-i-1)%Dimensions.dimensionsMAX;
								while(id<0)id += Dimensions.dimensionsMAX;
								if(Dimensions.DimensionArray[id] != null){
									if(!Dimensions.DimensionArray[id].special_hidden){
										//System.out.printf("requesting switch to %d:%s\n", id, Dimensions.DimensionArray[id].uniquename);
										Dimensions.DimensionArray[id].teleportToDimension(player, world, id, (int)player.posx, (int)player.posy, (int)player.posz);
										break;
									}
								}
							}
						}else{
							for(i=0;i<Dimensions.dimensionsMAX;i++){
								int id = (player.dimension+i+1)%Dimensions.dimensionsMAX;
								if(Dimensions.DimensionArray[id] != null){
									if(!Dimensions.DimensionArray[id].special_hidden){
										//System.out.printf("requesting switch to %d:%s\n", id, Dimensions.DimensionArray[id].uniquename);
										Dimensions.DimensionArray[id].teleportToDimension(player, world, id, (int)player.posx, (int)player.posy, (int)player.posz);
										break;
									}
								}
							}
						}
					}
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_Q && K_isEventKeyDown()){
				//Tell the server to spit out one item!
				DangerZone.server_connection.handleInventory(13, 0, 0, 0, 0);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F2 && K_isEventKeyDown()){
				Utils.screenshot(screen_width, screen_height);
				messagestring = "Screenshot!";
				messagetimer = 60;
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F3 && K_isEventKeyDown()){
				//show some stats
				if(f3_on){
					f3_on = false;
				}else{
					f3_on = true;
					f12_on = false;
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F12 && K_isEventKeyDown() && start_client && start_server){
				//show some stats
				if(f12_on){
					f12_on = false;
					//setMusicVolume(lastvol);
					resumeMusic();
				}else{
					//lastvol = getMusicVolume();
					//setMusicVolume(0);
					pauseMusic();
					//Mouse.setGrabbed(false); //We be cat-like
					glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_NORMAL);
					mouse_grabbed = false;
					f12_on = true;
					f3_on = false;
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F4 && K_isEventKeyDown()){
				if(K_isEventKeyDown()){
					setActiveGui(statsgui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F11 && K_isEventKeyDown()){
				if(K_isEventKeyDown()){
					setActiveGui(todogui);
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F10 && K_isEventKeyDown()){
				if(showcase){
					showcase = false;
					graphics_mode = graphics_mode_was;
					resumeMusic();
					player.server_connection.changeGameMode(GameModes.CREATIVE);
					player.setFlying(false);
					//allow chunks in memory to be written.
					server_chunk_cache.clear_dont_save_flags();
				}else{
					if(start_server) { //only if local server!
						//any chunks not already in memory will not be written out!
						pauseMusic();
						glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_NORMAL);
						mouse_grabbed = false;
						showcase = true;
						graphics_mode_was = graphics_mode;
						graphics_mode = 0;
						player.server_connection.changeGameMode(GameModes.LIMBO);
						player.setFlying(true);
					}
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F6 && K_isEventKeyDown()){
				if(player.getGameMode() != GameModes.SURVIVAL){
					if(view_ores){
						view_ores = false;
					}else{
						view_ores = true;
					}
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F7 && K_isEventKeyDown()){
					if(overlays_on){
						overlays_on = false;
					}else{
						overlays_on = true;
					}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_F5 && K_isEventKeyDown()){
				//show me!!!
				if(!isVR) {
					if(f5_front){
						f5_front = false;
						f5_back = true;
					}else{
						if(f5_back){
							f5_back = false;
							f5_side = true;
						}else{
							if(f5_side) {
								f5_front = false;
								f5_back = false;	
								f5_side = false;
							}else {
								f5_front = true;
								f5_back = false;
								f5_side = false;
							}
						}
					}
				}
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_1 && K_isEventKeyDown()){
				show_selection(0);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_2 && K_isEventKeyDown()){
				show_selection(1);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_3 && K_isEventKeyDown()){
				show_selection(2);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_4 && K_isEventKeyDown()){
				show_selection(3);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_5 && K_isEventKeyDown()){
				show_selection(4);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_6 && K_isEventKeyDown()){
				show_selection(5);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_7 && K_isEventKeyDown()){
				show_selection(6);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_8 && K_isEventKeyDown()){
				show_selection(7);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_9 && K_isEventKeyDown()){
				show_selection(8);
			}
			if (K_getEventKey() == GLFW.GLFW_KEY_0 && K_isEventKeyDown()){
				show_selection(9);
			}
			
			//Filter out REPEAT DOWN events for these two special keys that are trying to detect doubletaps!
			if (K_getEventKey() == GLFW.GLFW_KEY_W && K_isEventKeyDown()){
				if(lastkey != GLFW.GLFW_KEY_W || lastdown != K_isEventKeyDown()) {
					if(gofasttimer != 0)gofast = 1;
					gofasttimer = 20;
				}
			}
			
			if (K_getEventKey() == GLFW.GLFW_KEY_SPACE && K_isEventKeyDown()){
				if(lastkey != GLFW.GLFW_KEY_SPACE || lastdown != K_isEventKeyDown()) {
					if(flytimer != 0)gofly = 1;
					flytimer = 20;
				}
			}
			
			//filter out dups for W and SPACE to detect double-taps!
			lastkey = K_getEventKey();
			lastdown = K_isEventKeyDown();
			
			KeyHandlers.handleEvent();
		}
		

		if (K_isKeyDown(GLFW.GLFW_KEY_SPACE)){

				if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO || player.isFlying() || player.isLadder()){
					float fact = player.getAirFactor();
					player.motiony += (0.066f-(0.005*character_feel))*deltaT*accel*(fact/2);
					accel += 0.1f;
					if(accel > 1)accel = 1;
				}else{
					if(player.getOnGround() || player.getInLiquid()){
						player.jump();
					}
					if(gofly != 0)player.tryfly();
				}
			
			player.setUp(true);
		}else{
			player.setUp(false);
			gofly = 0;
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)){

				if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO || player.isFlying() || player.isLadder()){
					float fact = player.getAirFactor();
					player.motiony -= (0.066f-(0.005*character_feel))*deltaT*accel*(fact/2.5f);
					accel += 0.1f;
					if(accel > 1)accel = 1;
				}
			
			player.setDown(true);
		}else{
			player.setDown(false);
		}

		if (K_isKeyDown(GLFW.GLFW_KEY_W)){
			
				float speed = 0.045f*accel;
				if(player.getGameMode() != GameModes.GHOST && player.getGameMode() != GameModes.LIMBO && 
						(world.getblock(player.dimension, (int)player.posx, (int)player.posy+2, (int)player.posz) != 0
						|| world.getblock(player.dimension, (int)player.posx, (int)player.posy+3, (int)player.posz) != 0 ))speed *= 0.70f;
				accel += 0.1f;
				if(!player.isFlying())accel += 0.1f;
				if(accel > 1)accel = 1;
				if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO)speed *= 2.5f;
				if(gofast != 0)speed *= 1.85f;
				float effectspeed;
				effectspeed = player.getTotalEffect(Effects.SPEED);
				if(effectspeed > 1){
					speed *= effectspeed;
				}
				effectspeed = player.getTotalEffect(Effects.SLOWNESS);
				if(effectspeed > 1){
					speed /= effectspeed;
				}
				
				float fact = player.getMotionFactor();
				//System.out.printf("getMotionFactor = %f\n", player.getMotionFactor() );
				player.motionx += speed*Math.cos(Math.toRadians(player.rotation_yaw_head-90))*deltaT*fact;
				player.motionz += speed*Math.sin(Math.toRadians(player.rotation_yaw_head-90))*deltaT*fact;
			
			player.setForward(true);
		}else{
			gofast = 0;
			player.setForward(false);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_S)){
			
				float speed = 0.030f*accel;
				accel += 0.1f;
				if(accel > 1)accel = 1;
				if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO)speed *= 2.0f;
				float effectspeed;
				effectspeed = player.getTotalEffect(Effects.SPEED);
				if(effectspeed > 1){
					speed *= effectspeed;
				}
				effectspeed = player.getTotalEffect(Effects.SLOWNESS);
				if(effectspeed > 1){
					speed /= effectspeed;
				}
				float fact = player.getMotionFactor();
				player.motionx -= speed*Math.cos(Math.toRadians(player.rotation_yaw_head-90))*deltaT*fact;
				player.motionz -= speed*Math.sin(Math.toRadians(player.rotation_yaw_head-90))*deltaT*fact;
				
			
			player.setBackward(true);
		}else{
			player.setBackward(false);
		}
		
		if (K_isKeyDown(GLFW.GLFW_KEY_A)){
			
				float speed = 0.030f*accel;
				accel += 0.1f;
				if(accel > 1)accel = 1;
				if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO)speed *= 2.0f;
				float effectspeed;
				effectspeed = player.getTotalEffect(Effects.SPEED);
				if(effectspeed > 1){
					speed *= effectspeed;
				}
				effectspeed = player.getTotalEffect(Effects.SLOWNESS);
				if(effectspeed > 1){
					speed /= effectspeed;
				}
				float fact = player.getMotionFactor();
				player.motionx += speed*Math.cos(Math.toRadians(player.rotation_yaw_head-180))*deltaT*fact;
				player.motionz += speed*Math.sin(Math.toRadians(player.rotation_yaw_head-180))*deltaT*fact;
				
			
			player.setLeft(true);
		}else{
			player.setLeft(false);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_D)){
			
				float speed = 0.030f*accel;
				accel += 0.1f;
				if(accel > 1)accel = 1;
				if(player.getGameMode() == GameModes.GHOST || player.getGameMode() == GameModes.LIMBO)speed *= 2.0f;
				float effectspeed;
				effectspeed = player.getTotalEffect(Effects.SPEED);
				if(effectspeed > 1){
					speed *= effectspeed;
				}
				effectspeed = player.getTotalEffect(Effects.SLOWNESS);
				if(effectspeed > 1){
					speed /= effectspeed;
				}
				float fact = player.getMotionFactor();
				player.motionx -= speed*Math.cos(Math.toRadians(player.rotation_yaw_head-180))*deltaT*fact;
				player.motionz -= speed*Math.sin(Math.toRadians(player.rotation_yaw_head-180))*deltaT*fact;
				
				
			player.setRight(true);
		}else{
			player.setRight(false);
		}
		
		if ((K_isKeyDown(GLFW.GLFW_KEY_LEFT_CONTROL) || K_isKeyDown(GLFW.GLFW_KEY_LEFT_ALT)) && player.getHotbar(player.gethotbarindex())==null && player.getGameMode() != GameModes.LIMBO){ //MENU == ALT
			int nump = 1;
			if(magic_power < 1f)magic_power += 0.005f;
			nump = (int)(magic_power*5f);
			if(nump < 1)nump = 1;
			
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_CONTROL) && !K_isKeyDown(GLFW.GLFW_KEY_LEFT_ALT)){
				magic_type = 1; //heal
				if(rand.nextInt(3) == 1)Utils.spawnParticles(world, "DangerZone:ParticleHappy", nump, player.dimension, 
						player.posx+(float)Math.sin(Math.toRadians(180-player.rotation_yaw_head))*(player.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(player.rotation_pitch_head)),
						player.posy+(player.getHeight()*8/10) - (float)Math.sin(Math.toRadians(player.rotation_pitch_head))*(player.getWidth()+1.5f),
						player.posz+(float)Math.cos(Math.toRadians(180-player.rotation_yaw_head))*(player.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(player.rotation_pitch_head)),
						true);
			}
			if(!K_isKeyDown(GLFW.GLFW_KEY_LEFT_CONTROL) && K_isKeyDown(GLFW.GLFW_KEY_LEFT_ALT)){
				magic_type = 2; //harm
				if(rand.nextInt(3) == 1)Utils.spawnParticles(world, "DangerZone:ParticleDeath", nump, player.dimension, 
						player.posx+(float)Math.sin(Math.toRadians(180-player.rotation_yaw_head))*(player.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(player.rotation_pitch_head)),
						player.posy+(player.getHeight()*8/10) - (float)Math.sin(Math.toRadians(player.rotation_pitch_head))*(player.getWidth()+1.5f),
						player.posz+(float)Math.cos(Math.toRadians(180-player.rotation_yaw_head))*(player.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(player.rotation_pitch_head)),
						true);
			}
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_CONTROL) && K_isKeyDown(GLFW.GLFW_KEY_LEFT_ALT)){
				magic_type = 3; //destruct!
				if(rand.nextInt(3) == 1)Utils.spawnParticles(world, "DangerZone:ParticleSmoke", nump, player.dimension, 
						player.posx+(float)Math.sin(Math.toRadians(180-player.rotation_yaw_head))*(player.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(player.rotation_pitch_head)),
						player.posy+(player.getHeight()*8/10) - (float)Math.sin(Math.toRadians(player.rotation_pitch_head))*(player.getWidth()+1.5f),
						player.posz+(float)Math.cos(Math.toRadians(180-player.rotation_yaw_head))*(player.getWidth()+1.5f)*(float)Math.cos(Math.toRadians(player.rotation_pitch_head)),
						true);
			}
			
			int which = rand.nextInt(100);
			if(which == 0)player.world.playSound("DangerZone:swish3", player.dimension, player.posx, player.posy+1.25d, player.posz, 0.5f, 1);
			if(which == 1)player.world.playSound("DangerZone:swish4", player.dimension, player.posx, player.posy+1.25d, player.posz, 0.5f, 1);
			if(which == 2)player.world.playSound("DangerZone:swish5", player.dimension, player.posx, player.posy+1.25d, player.posz, 0.5f, 1);
			if(which == 3)player.world.playSound("DangerZone:swish6", player.dimension, player.posx, player.posy+1.25d, player.posz, 0.5f, 1);
			if(which == 4)player.world.playSound("DangerZone:swish7", player.dimension, player.posx, player.posy+1.25d, player.posz, 0.5f, 1);
			if(which == 5)player.world.playSound("DangerZone:swish8", player.dimension, player.posx, player.posy+1.25d, player.posz, 0.5f, 1);

		}else{
			magic_power = 0;
			magic_type = 0;
		}
		
		KeyHandlers.handleDown();
		
		/*
		if (K_isKeyDown(GLFW.GLFW_KEY_I)){
			into_future += 0.001f;
			System.out.printf("into_future = %f\n", into_future);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_O)){
			if(into_future > 0.001f)into_future -= 0.001f;
			System.out.printf("into_future = %f\n", into_future);
		}
		*/
				
		/* begin test block
		if (K_isKeyDown(GLFW.GLFW_KEY_I)){
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)||K_isKeyDown(GLFW.GLFW_KEY_RIGHT_SHIFT)){
				testx -= 0.1f;
			}else{
				testx += 0.1f;
			}
			System.out.printf("xyz, pwr = %f, %f, %f and %f, %f, %f\n", testx, testy, testz, testp, testw, testr);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_O)){
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)||K_isKeyDown(GLFW.GLFW_KEY_RIGHT_SHIFT)){
				testy -= 0.1f;
			}else{
				testy += 0.1f;
			}
			System.out.printf("xyz, pwr = %f, %f, %f and %f, %f, %f\n", testx, testy, testz, testp, testw, testr);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_P)){
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)||K_isKeyDown(GLFW.GLFW_KEY_RIGHT_SHIFT)){
				testz -= 0.1f;
			}else{
				testz += 0.1f;
			}
			System.out.printf("xyz, pwr = %f, %f, %f and %f, %f, %f\n", testx, testy, testz, testp, testw, testr);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_J)){
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)||K_isKeyDown(GLFW.GLFW_KEY_RIGHT_SHIFT)){
				testp -= 0.1f;
			}else{
				testp += 0.1f;
			}
			System.out.printf("xyz, pwr = %f, %f, %f and %f, %f, %f\n", testx, testy, testz, testp, testw, testr);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_K)){
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)||K_isKeyDown(GLFW.GLFW_KEY_RIGHT_SHIFT)){
				testw -= 0.1f;
			}else{
				testw += 0.1f;
			}
			System.out.printf("xyz, pwr = %f, %f, %f and %f, %f, %f\n", testx, testy, testz, testp, testw, testr);
		}
		if (K_isKeyDown(GLFW.GLFW_KEY_L)){
			if(K_isKeyDown(GLFW.GLFW_KEY_LEFT_SHIFT)||K_isKeyDown(GLFW.GLFW_KEY_RIGHT_SHIFT)){
				testr -= 0.1f;
			}else{
				testr += 0.1f;
			}
			System.out.printf("xyz, pwr = %f, %f, %f and %f, %f, %f\n", testx, testy, testz, testp, testw, testr);
		}
		 end test block */
		
		//if (K_isKeyDown(GLFW.GLFW_KEY_Z)){
		//	player.rotation_roll -= 1;
		//	player.rotation_roll = player.rotation_roll%360;
		//}
		//if (K_isKeyDown(GLFW.GLFW_KEY_C)){
		//	player.rotation_roll += 1;
		//	player.rotation_roll = player.rotation_roll%360;
		//}
		
		rightbuttonclicked = rightbuttonreleased = false;
		leftbuttonclicked = leftbuttonreleased = false;
		while(input.mnext()){
			//System.out.printf("Mouse!\n");
			
			if(!isVR && !showcase) {
				dx = input.getEventdx();
				dy = input.getEventdy();				
				
				//System.out.printf("dx, dy == %f, %f\n",  dx, dy);
				
				dx *= 0.1f + (0.01f * (float)mouseSensitivity);
				dy *= 0.1f + (0.01f * (float)mouseSensitivity);

				player.rotation_yaw_head += dx;
				//player.rotation_yaw_head = smooth_degrees(player.rotation_yaw_head, player.rotation_yaw_head+dx, 0);
				if(player.rotation_yaw_head < 0)player.rotation_yaw_head += 360;
				player.rotation_yaw_head = player.rotation_yaw_head%360;		
				player.rotation_pitch_head -= dy;
				//player.rotation_pitch_head = smooth_degrees(player.rotation_pitch_head, player.rotation_pitch_head-dy, 0);
				player.rotation_pitch_head = player.rotation_pitch_head%360;
				//System.out.printf("pitch = %f\n", player.rotation_pitch_head);
				if(player.rotation_pitch_head > 180){
					if(player.rotation_pitch_head < 270)player.rotation_pitch_head = 270;
				}else{
					if(player.rotation_pitch_head > 90)player.rotation_pitch_head = 90;
				}
			}
			
			
			if(input.getEventButtonState()){	
				//System.out.printf("DOWN: %d\n", Mouse.getEventButton());
				//clicking is hard work! :)
				if(player.getGameMode() == GameModes.SURVIVAL)player.setHunger(player.getHunger()-0.01f);
				
				if(input.getEventButton() == 0){
					//System.out.printf("left down\n");
					if(!leftbuttondown)leftbuttonclicked = true;
					else leftbuttonclicked = false;
					leftbuttondown = true;	
					//rightbuttondown = false;
				}	
				if(input.getEventButton() == 1){
					//System.out.printf("right down\n");
					if(!rightbuttondown)rightbuttonclicked = true;
					else rightbuttonclicked = false;
					rightbuttondown = true;
					//leftbuttondown = false;	
				}
				if(input.getEventButton() == 2)player.middleclick(world, wr.show_focus_x, wr.show_focus_y, wr.show_focus_z, 0);

			}else{
				//Mouse button released!
				if(input.getEventButton() >= 0){
					//System.out.printf("UP: %d\n", Mouse.getEventButton());
					do_hit_cycle = 0;
					do_food_cycle = 0;
					repeatdelay = 0;
				}
				if(input.getEventButton() == 0){
					//System.out.printf("left up\n");
					if(leftbuttondown)leftbuttonreleased = true;
					else leftbuttonreleased = false;
					leftbuttondown = false;
					leftbuttonclicked = false;
				}
				if(input.getEventButton() == 1){
					//System.out.printf("right up\n");
					if(rightbuttondown)rightbuttonreleased = true;
					else rightbuttonreleased = false;
					rightbuttondown = false;
					rightbuttonclicked = false;
				}
			}
		}
		
		
		i = player.gethotbarindex();
		ScrollEvent se = input.nextScroll();
		boolean showit = false;
		while(se != null) {
			//System.out.printf("Scroll = %d\n", se.dy);
			i -= se.dy;
			se = input.nextScroll();
			showit = true;
		}
		i %= 10;
		while(i<0)i+=10;
		player.sethotbarindex(i);
		if(showit)show_selection(i);
		
		//what kind of clickiness are we doing? hit&eat or shoot?
		boolean clicky_shoot = false;
		InventoryContainer ic = player.getHotbar(player.gethotbarindex());
		if(ic != null){
			if(ic.iid > 0){
				Item it = ic.getItem();
				if(it != null){
					if(it.do_shoot_clicks){
						clicky_shoot = true;
					}
				}
			}
		}
		
		if(!clicky_shoot){
			//normal clicks
			if(leftbuttondown || rightbuttondown){			
				if(repeatdelay == 0 || repeatdelay > 10){
					repeatdelay = 0;
					
					if(leftbuttondown && !rightbuttondown){
						do_hit_cycle = 1;
						do_food_cycle = 0;
						doleftclick = true;
						dorightclick = false;
					}	
					if(rightbuttondown && !leftbuttondown){
						if(wr.show_focus_entity != null){
							do_hit_cycle = 1;
							do_food_cycle = 0;
							dorightclick = true;
							doleftclick = false;
						}else{
							if(ic != null && Items.isFood(ic.iid) && wr.show_focus_x == 0 && wr.show_focus_z == 0){
								do_food_cycle = 1;
								do_hit_cycle = 0;
								doleftclick = false;
								dorightclick = false;
							}else{
								do_hit_cycle = 1;
								do_food_cycle = 0;
								dorightclick = true;
								doleftclick = false;
							}
						}
					}				
				}
				repeatdelay++;
			}else{
				repeatdelay = 0;
			}
			
			if(rapidfire_delay > 0)rapidfire_delay--;
			if(prevrightbuttondown){
				if(!rightbuttondown){
					//right button is now up!
					dorightclickup = true;
				}else{
					rightbuttondowncounter++;
					rapidfire_delay = 10;
				}			
			}
			prevrightbuttondown = rightbuttondown;

		}else{ //else is probably a gun of some sort.
			
			do_hit_cycle = do_food_cycle = 0;
			
			if(rapidfire_delay > 0)rapidfire_delay--;

			if(!leftbuttondown){
				singleshot_needleftup = false;
				semiauto_needleftup = false;
				rapidfire_delay = 0;
			}

			if(!rightbuttondown){
				singleshot_needrightup = false;
				rapidfire_delay = 0;
				rightbuttondowncounter = 0;
			}else{
				
				rightbuttondowncounter++;
				
				if(leftbuttondown){
					
					if(rapidfire_delay == 0){
						fullauto=true;
						rapidfire_delay = 12; //5 shots per second. ish.
						if(wr.fps < 40)rapidfire_delay = 8;
						if(wr.fps < 20)rapidfire_delay = 4;
					}
					
					if(!semiauto_needleftup){
						semiauto = true;
						semiauto_needleftup = true;
					}
					
					if(!singleshot_needleftup && !singleshot_needrightup){
						singleshot = true;
						singleshot_needleftup = true;
						singleshot_needrightup = true;
					}
					
				}else{
					fullauto = false;
				}
			}
		}
	}
	
	public static void justPush() {
		if(isVR) {
			SendToHeadset(true);
		}
		glfwSwapBuffers(window);
		
	}
	
	public static void showLogoandpush(boolean redcolor){
		
		screen_width = screen_screen_width;
		screen_height = screen_screen_height;
		initGL(screen_width, screen_height, 0);
		showLogo(redcolor, 0);
		glfwSwapBuffers(window);
		
		if(isVR) {
			screen_width = vr_screen_width;
			screen_height = vr_screen_height;
			initGL(screen_width, screen_height, 1);
			PreRender( leftEyeDesc[whichframe] );
			showLogo(redcolor, 1);
			PostRender( leftEyeDesc[whichframe] );
			
			initGL(screen_width, screen_height, 2);
			PreRender( RightEyeDesc[whichframe] );
			showLogo(redcolor, 2);
			PostRender( RightEyeDesc[whichframe] );
			
			SendToHeadset(true);
		}
	}
	

	public static void showLogo(boolean redcolor, int mode){

		
		set_shader_ortho(model_shader);
		MatrixStack.identity();
				
		
		if(logotexture == null){
			try {
				logotexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("res/menus/logo.png"));
				textinputtexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("res/menus/textinput.png"));
			} catch (IOException e) {
				e.printStackTrace();
			}
	
		}
				
		if(redcolor){
			GL11.glClearColor(1.0f, 0.0f, 0.0f, 0.0f);
		}else{
			GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		}
		
		GL11.glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_DEPTH_BUFFER_BIT); // Clear The Screen And The Depth Buffer
		
		
		if(redcolor){
			GL11.glColor3f(1.0f, 0.2f, 0.2f);
		}else{			
			GL11.glColor3f(1.0f, 1.0f, 1.0f);
		}
		
		logotexture.bind();
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_LINEAR);
		GL11.glTexParameteri(GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_LINEAR);
				
		//go to center of screen.
		MatrixStack.translate(get_middle(mode), screen_height/2f, 0);
		MatrixStack.sendCurrentStack();
		
		MatrixStack.pushMatrix();
		MatrixStack.scale(50, 50, 50);
		MatrixStack.sendCurrentStack();
		
		WorldRendererUtils.drawSquare3D();

		MatrixStack.popMatrix();
		
		if(connection_msg != null){
			
			GL20.glUseProgram( 0 ); //stop with the shaders already...	
			
			GL11.glDisable(GL11.GL_DEPTH_TEST);
			GL11.glMatrixMode(GL11.GL_PROJECTION);
			GL11.glPushMatrix();
			GL11.glLoadIdentity();
			//puts 0,0 (x,y) at lower left of screen!
			GL11.glOrtho(0,DangerZone.screen_width,0,DangerZone.screen_height,-320,320);
			GL11.glMatrixMode(GL11.GL_MODELVIEW);
			GL11.glPushMatrix();
			GL11.glLoadIdentity();
			GL11.glEnable(GL11.GL_TEXTURE_2D);
			GL11.glEnable(GL11.GL_BLEND);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
			GL11.glColor3f(1.0f, 1.0f, 1.0f); //brighten things up a bit!
			
						
			GL11.glTranslatef((get_middle(mode))-(connection_msg.length()*5), screen_height/2, 0f); 
			GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f); // Don't ask me why, but the text is upside down! Flip it!	
					
			font.drawString(0, 0, connection_msg, ColorSlick.white);			
			
		}
		GL11.glFlush();
		
	}
	

	
	private static void readConfig(){
		InputStream input = null;
		
		//defaults for when the file doesn't exist!
		server_address = "127.0.0.1";
		server_port = 18668;
		nsserver_address = "73.135.82.220";
		nsserver_port = 18669;
		screen_screen_width = 1024;
		screen_screen_height = 600;
		renderdistance = 24;
		volume_temp = 20;
		music_volume_temp = 20;
		worldname = "my_world";
		playername ="Player";
		fieldOfView = 45;
		mouseSensitivity = 0;
		//mindrawlevel = 0;
		//all_sides = true;
		//light_speed = true;
		keepitsqueakyclean = false;
		//show_clouds = true;
		//show_rain = true;
		crypted_password = "";
		fullscreen = true;
		//fog_enable = true;
		crafting_animation = true;
		showhitbox = true;
		//movepart = true;
		character_feel = 0;
		ipd = 0.2f;
		vrha = 0.0f;
		isVR = false;		
		motion_swap = false;
		weapon_swap = false;
		pointer_swap = false;
		use_pointer = false;
		lr_eye_skew = 0;
		use_height = 1080;
		use_width = 1920;
		height_adjust = 0;
		vr_max_entity = 25;
		vr_max_particle = 1500;
		monitor_enable = true;
		no_dark = false;
		graphics_mode = graphics_mode_was = 0;
		
		try {	 
			input = new FileInputStream("DangerZone.properties");
	 
			// load a properties file
			configprop.load(input);
	 
			screen_screen_width = Utils.getPropertyInt(configprop, "ScreenWidth", 500, 8192, 1024); //min, max, default
			screen_screen_height = Utils.getPropertyInt(configprop, "ScreenHeight", 300, 3000, 600); //min, max, default
			
			lr_eye_skew = Utils.getPropertyInt(configprop, "LR_eye_skew", -1000, 1000, 0); //min, max, default
			use_height = Utils.getPropertyInt(configprop, "Use_height", 500, 5000, 1080); //min, max, default
			use_width = Utils.getPropertyInt(configprop, "Use_width", 1000, 10000, 1920); //min, max, default
			height_adjust = Utils.getPropertyInt(configprop, "Height_adjust", -1000, 1000, 0); //min, max, default
			vr_max_entity = Utils.getPropertyInt(configprop, "VRMax_entity", 10, 1500, 25); //min, max, default
			vr_max_particle = Utils.getPropertyInt(configprop, "VRMax_particle", 500, 10000, 1500); //min, max, default
						
			renderdistance = Utils.getPropertyInt(configprop, "RenderDistance", 4, 24, 16); //min, max, default
			volume_temp = Utils.getPropertyInt(configprop, "Volume", 0, 100, 20); //min, max, default
			music_volume_temp = Utils.getPropertyInt(configprop, "MusicVolume", 0, 100, 20); //min, max, default
			server_address = Utils.getPropertyString(configprop, "ServerAddress", "127.0.0.1"); //
			server_port = Utils.getPropertyInt(configprop, "ServerPort", 0, Integer.MAX_VALUE, 18668); //min, max, default
			nsserver_address = Utils.getPropertyString(configprop, "NameServerAddress", "73.135.82.220"); //
			nsserver_port = Utils.getPropertyInt(configprop, "NameServerPort", 0, Integer.MAX_VALUE, 18669); //min, max, default
			worldname = Utils.getPropertyString(configprop, "WorldName", "my_world"); 
			origworldname = worldname;
			playername = Utils.getPropertyString(configprop, "Playername", "Player");
			fieldOfView = Utils.getPropertyInt(configprop, "FieldOfView", 30, 100, 45); //min, max, default
			mouseSensitivity = Utils.getPropertyInt(configprop, "MouseSensitivity", -9, 9, 0); //min, max, default
			keepitsqueakyclean = Utils.getPropertyBoolean(configprop, "RunFinalization", false);
			//mindrawlevel = Utils.getPropertyInt(configprop, "MinDrawLevel", 0, 40, 0); //min, max, default
			//all_sides = Utils.getPropertyBoolean(configprop, "MaxGraphics", true);
			//light_speed = Utils.getPropertyBoolean(configprop, "FastLighting", true);
			//show_clouds = Utils.getPropertyBoolean(configprop, "ShowClouds", true);
			//show_rain = Utils.getPropertyBoolean(configprop, "ShowRain", true);
			crypted_password = Utils.getPropertyString(configprop, "CryptedPassword", "");
			fullscreen = Utils.getPropertyBoolean(configprop, "FullScreen", true);
			//fog_enable = Utils.getPropertyBoolean(configprop, "FogEnable", true);
			crafting_animation = Utils.getPropertyBoolean(configprop, "CraftingAnimation", true);
			showhitbox = Utils.getPropertyBoolean(configprop, "ShowHitBox", true);
			//movepart = Utils.getPropertyBoolean(configprop, "MovePart", true);
			isVR = Utils.getPropertyBoolean(configprop, "isVR", false);
			character_feel = Utils.getPropertyInt(configprop, "CharacterFeel", 0, 2, 0); //min, max, default
			ipd = Utils.getPropertyFloat(configprop, "PupilDist", 0.0f, 2.0f, 0.2f); //min, max, default
			vrha = Utils.getPropertyFloat(configprop, "HeightAdjust", -1f, 1.0f, 0.0f); //min, max, default
			motion_swap = Utils.getPropertyBoolean(configprop, "motion_swap", true);
			weapon_swap = Utils.getPropertyBoolean(configprop, "weapon_swap", false);
			pointer_swap = Utils.getPropertyBoolean(configprop, "pointer_swap", true);
			use_pointer = Utils.getPropertyBoolean(configprop, "use_pointer", false);
			monitor_enable = Utils.getPropertyBoolean(configprop, "monitor_enable", true);
			no_dark = Utils.getPropertyBoolean(configprop, "no_dark", false);
			graphics_mode = Utils.getPropertyInt(configprop, "GraphicsMode", -1, 3, 2);
			graphics_mode_was = graphics_mode;
			
			if(!isVR)monitor_enable = true;

			screen_width = screen_screen_width;
			screen_height = screen_screen_height;
			
			
		} catch (IOException ex) {
			//ex.printStackTrace();
		}
		
		config_isVR = isVR;
		
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				//e.printStackTrace();
			}
		}	
		
		//Throttle for real server. Takes a huge load off the network.
		if(!start_server){
			if(renderdistance > 20){
				savedrenderdistance = renderdistance;
				renderdistance = 20;
			}
		}
		
	}
	
	private static void writeConfig(boolean pld){
		FileOutputStream output = null;
	 
		try {	 
			output = new FileOutputStream("DangerZone.properties");	 
			// set the properties value

			configprop.setProperty("ScreenWidth", String.format("%d", screen_screen_width));
			configprop.setProperty("ScreenHeight", String.format("%d", screen_screen_height));
			
			configprop.setProperty("LR_eye_skew", String.format("%d", lr_eye_skew));
			configprop.setProperty("Use_height", String.format("%d", use_height));
			configprop.setProperty("Use_width", String.format("%d", use_width));
			configprop.setProperty("Height_adjust", String.format("%d", height_adjust));
			
			configprop.setProperty("VRMax_entity", String.format("%d", vr_max_entity));
			configprop.setProperty("VRMax_particle", String.format("%d", vr_max_particle));
			
			if(savedrenderdistance > renderdistance)renderdistance = savedrenderdistance; //restore
			configprop.setProperty("RenderDistance", String.format("%d", renderdistance));
			if(soundmangler != null){
				configprop.setProperty("Volume", String.format("%d", soundmangler.master_volume));
				configprop.setProperty("MusicVolume", String.format("%d", soundmangler.music_master_volume));
			}
			configprop.setProperty("ServerAddress", server_address);
			configprop.setProperty("ServerPort", String.format("%d", server_port));
			configprop.setProperty("NameServerAddress", nsserver_address);
			configprop.setProperty("NameServerPort", String.format("%d", nsserver_port));
			String strippedname = worldname;
			if(!start_server)strippedname = origworldname; //restore. don't save server world name!
			if(strippedname.contains("/")){
				int is = strippedname.lastIndexOf("/");
				strippedname = strippedname.substring(is+1);
			}
			configprop.setProperty("WorldName", strippedname);
			configprop.setProperty("Playername", playername);
			configprop.setProperty("FieldOfView", String.format("%d", fieldOfView));
			configprop.setProperty("MouseSensitivity", String.format("%d", mouseSensitivity));
			configprop.setProperty("RunFinalization", String.format("%s", keepitsqueakyclean?"true":"false"));
			//configprop.setProperty("MinDrawLevel", String.format("%d", mindrawlevel));
			configprop.setProperty("GraphicsMode", String.format("%d", graphics_mode_was));
			//configprop.setProperty("MaxGraphics", String.format("%s", all_sides?"true":"false"));
			//configprop.setProperty("FastLighting", String.format("%s", light_speed?"true":"false"));
			//configprop.setProperty("ShowClouds", String.format("%s", show_clouds?"true":"false"));
			//configprop.setProperty("ShowRain", String.format("%s", show_rain?"true":"false"));
			configprop.setProperty("PlayerDied", String.format("%s", pld?"true":"false"));
			configprop.setProperty("CryptedPassword", crypted_password);
			configprop.setProperty("FullScreen", String.format("%s", fullscreen?"true":"false"));
			//configprop.setProperty("FogEnable", String.format("%s", fog_enable?"true":"false"));
			configprop.setProperty("CraftingAnimation", String.format("%s", crafting_animation?"true":"false"));
			configprop.setProperty("ShowHitBox", String.format("%s", showhitbox?"true":"false"));
			//configprop.setProperty("MovePart", String.format("%s", movepart?"true":"false"));
			configprop.setProperty("isVR", String.format("%s", config_isVR?"true":"false"));
			configprop.setProperty("CharacterFeel", String.format("%d", character_feel));
			configprop.setProperty("PupilDist", String.format("%f", ipd));
			configprop.setProperty("HeightAdjust", String.format("%f", vrha));
			configprop.setProperty("motion_swap", String.format("%s", motion_swap?"true":"false"));
			configprop.setProperty("weapon_swap", String.format("%s", weapon_swap?"true":"false"));
			configprop.setProperty("pointer_swap", String.format("%s", pointer_swap?"true":"false"));
			configprop.setProperty("use_pointer", String.format("%s", use_pointer?"true":"false"));
			configprop.setProperty("monitor_enable", String.format("%s", monitor_enable?"true":"false"));
			configprop.setProperty("no_dark", String.format("%s", no_dark?"true":"false"));
			
			
	 
			// save properties to project root folder
			configprop.store(output, null);
	 
		} catch (IOException io) {
			io.printStackTrace();
		}
		if (output != null) {
			try {
				output.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}		
	}
	
	

	
	public static void loadWorld(World w){
		InputStream input = null;
		Properties worldprop = new Properties();
		String filepath = new String();		
		filepath = String.format("worlds/%s/world.dat", DangerZone.worldname);	
		
		generatecaves = true;
		w.timetimer = 0;
		playnicely = false;
		keep_inventory_on_death = false;
		require_valid_passwords = false;
		allow_anonymous = false;
		default_privs = 0xffffffff;
		private_server = false;
		freeze_world = false;
		petprotection = false;
		firedamage = true;
		max_players_on_server = 10;
		w.worldseed = System.currentTimeMillis();
		 
		try {	 
			input = new FileInputStream(filepath);	 
			// load a properties file
			worldprop.load(input);
			
			w.timetimer = Utils.getPropertyInt(worldprop, "TimeOfDay", 0, Integer.MAX_VALUE, 0); //min, max, default
			generatecaves = Utils.getPropertyBoolean(worldprop, "CaveGeneration", true);
			playnicely = Utils.getPropertyBoolean(worldprop, "PlayNicely", false);
			keep_inventory_on_death = Utils.getPropertyBoolean(worldprop, "KeepInventory", false);
			private_server = Utils.getPropertyBoolean(worldprop, "PrivateServer", false);
			freeze_world = Utils.getPropertyBoolean(worldprop, "FreezeWorld", false);
			petprotection = Utils.getPropertyBoolean(worldprop, "PetProtection", false);
			firedamage = Utils.getPropertyBoolean(worldprop, "FireDamage", true);
			require_valid_passwords = Utils.getPropertyBoolean(worldprop, "RequireValidPassword", false);
			allow_anonymous = Utils.getPropertyBoolean(worldprop, "AllowAnonymous", false);
			default_privs = Utils.getPropertyInt(worldprop, "DefaultPrivs", Integer.MIN_VALUE, Integer.MAX_VALUE, 0xffffffff); //min, max, default
			max_players_on_server = Utils.getPropertyInt(worldprop, "MaxPlayers", 2, 255, 10); //min, max, default
			w.worldseed = Utils.getPropertyLong(worldprop, "WorldSeed", Long.MIN_VALUE, Long.MAX_VALUE, w.worldseed); //min, max, default

		} catch (IOException ex) {
			//ex.printStackTrace();
			input = null;
			//new world?

			FileOutputStream privoutput = null;
			filepath = String.format("worlds/%s/player_privs.dat", DangerZone.worldname);	
			File f = new File(filepath);		
			f.getParentFile().mkdirs();	
			Properties privprop = new Properties();
			privprop.setProperty(playername.toLowerCase(), String.format("%d", 0xffffffff)); //world creator gets all privs
			try {
				privoutput = new FileOutputStream(filepath);			 
				// save properties
				privprop.store(privoutput, null);	
				privoutput.close();
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}	

		}
		if (input != null) {
			try {
				input.close();
			} catch (IOException e) {
				//e.printStackTrace();
			}
		}
		
	}
	
	public static void saveWorld(World w){
		Properties worldprop = new Properties();
		FileOutputStream output = null;
		String filepath = new String();		
		filepath = String.format("worlds/%s/world.dat", DangerZone.worldname);	
		File f = new File(filepath);		
		f.getParentFile().mkdirs();	
		
		try {	
					
			worldprop.setProperty("TimeOfDay", String.format("%d", w.timetimer));
			worldprop.setProperty("CaveGeneration", String.format("%s", generatecaves?"true":"false"));
			worldprop.setProperty("PlayNicely", String.format("%s", playnicely?"true":"false"));
			worldprop.setProperty("KeepInventory", String.format("%s", keep_inventory_on_death?"true":"false"));
			worldprop.setProperty("PrivateServer", String.format("%s", private_server?"true":"false"));
			worldprop.setProperty("FreezeWorld", String.format("%s", freeze_world?"true":"false"));
			worldprop.setProperty("PetProtection", String.format("%s", petprotection?"true":"false"));
			worldprop.setProperty("FireDamage", String.format("%s", firedamage?"true":"false"));
			worldprop.setProperty("RequireValidPassword", String.format("%s", require_valid_passwords?"true":"false"));
			worldprop.setProperty("AllowAnonymous", String.format("%s", allow_anonymous?"true":"false"));
			worldprop.setProperty("DefaultPrivs", String.format("%d", default_privs));
			worldprop.setProperty("MaxPlayers", String.format("%d", max_players_on_server));
			worldprop.setProperty("WorldSeed", String.format("%d", w.worldseed));
			
			output = new FileOutputStream(filepath);	 
			// save properties
			worldprop.store(output, null);			
	 
		} catch (IOException io) {
			io.printStackTrace();
		}
		if (output != null) {
			try {
				output.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}		
	}
	
	public static String getWorldDirectoryPath()
	{
		return String.format("worlds/%s/", DangerZone.worldname);
	}

	private static void doStartSinglePlayer(){
		
		connection_msg = "Starting a few things...";
		showLogoandpush(false);
				
		//Boolean rdsuccess = uuidrdr.Read_UUID_File();
		//System.out.printf("UUID reader success = %s\n", rdsuccess?"true":"false");
		//if(rdsuccess) {
		//	rdsuccess = uuidrdr.checkUUID("000_000");
		//	System.out.printf("000_000 = %s\n", rdsuccess?"true":"false");
		//	rdsuccess = uuidrdr.checkUUID("111_111");
		//	System.out.printf("111_111 = %s\n", rdsuccess?"true":"false");
		//	rdsuccess = uuidrdr.checkUUID("222_222");
		//	System.out.printf("222_222 = %s\n", rdsuccess?"true":"false");
		//}
		
		
		//SOUNDS!!! Woohoo!
		soundmangler = new SoundManager();
		soundmangler.master_volume = volume_temp;
		soundmangler.music_master_volume = music_volume_temp;
	
		soundpollingthread = new SoundPollingThread();
		Thread swt = new Thread(soundpollingthread);
		swt.start();
		
		displaysorterthread = new DisplaySorterThread();
		Thread dst = new Thread(displaysorterthread);
		dst.start();

		//Make a place for chunks (client)		
		client_chunk_cache = new ChunkCache();  		//This caching mechanism is entirely different from...
		client_chunk_cache.passthru = true; //ONLY ONE ACTIVE CACHE!

		server_chunk_cache = new ServerChunkCache();	//this caching mechanism!
		chunkwriter = new ChunkWriterThread();
		Thread cwt = new Thread(chunkwriter);
		cwt.start();
		
		showLogoandpush(false);
		
		wds = new WorldDecorators();
		breakchecker = new BreakChecks();

		player = new Player(null);	

		player.model = new ModelHumanoid(); //Set renderer! (by hand)
		player.myname = playername;
		player.setPetName(playername);
		world = new World(client_chunk_cache, null);
		player.world = world; 


		//And a server world!
		server_world = new World(null, server_chunk_cache); //world for the server to use the server chunk cache!
		server_world.isServer = true; //yes we are!
		server_world.timetimer = 0;
		
		showLogoandpush(false);
		
		loadWorld(server_world);
		
		showLogoandpush(false);

		//Make a world renderer
		wr = new WorldRenderer();

		all_the_blocks = new Blocks();
		Blocks.load(); //Grab the known list from disk
		all_the_items = new Items();
		Items.load(); //Grab the known list from disk
		all_the_dimensions = new Dimensions();
		Dimensions.load(); //Grab the known list from disk

		showLogoandpush(false);
		
		//custom packets!
		all_the_custompackets = new CustomPackets();

		//make the crafting list
		all_the_recipies = new Crafting();
		all_the_deskrecipies = new DeskCrafting();

		//make the cooking list
		all_the_cooking = new Cooking();

		//make ore list holder
		all_the_ores = new Ores();

		//make spawn list holder
		all_the_spawns = new Spawnlist();
		
		//make command handler list
		all_the_handlers = new CommandHandlers();

		//particles!
		all_the_particles = new Particles();
		
		//make the shredding list
		all_the_shreds = new Shredding();
		
		showLogoandpush(false);

		//make a couple internal things we can't live without!
		all_the_entities = new Entities();
		blockitem = new EntityBlockItem(world);
		Entities.registerEntity(EntityBlockItem.class, blockitem.uniquename, new ModelEntityBlockItem());	//SPECIAL! Internal entity
		Entities.registerEntity(Player.class, "DangerZone:Player", new ModelHumanoid());					//SPECIAL! Internal entity
		Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());					//SPECIAL! Internal entity
		Entities.registerEntity(EntityNoob.class, "DangerZone:Noob", new ModelExp());					//SPECIAL! Internal entity

		//Load up the default dimensions, creatures, blocks, items, etc!
		base = new DangerZoneBase();
		base.registerThings();

		/*
		 * LOAD ALL OTHER MODS HERE!
		 */	
		connection_msg = "Loading mods...";
		showLogoandpush(false);
		
		modloader = new ModLoader();
		String badfile = modloader.loadmods();
		if(badfile != null){
			connection_msg = "Please remove incompatible mod:";
			showLogoandpush(false);
			
			try {
				Thread.sleep(2000);
			} catch (InterruptedException e2) {
				e2.printStackTrace();
			} 
			connection_msg = badfile;
			showLogoandpush(false);
			
			try {
				Thread.sleep(5000);
			} catch (InterruptedException e2) {
				e2.printStackTrace();
			} 
			System.exit(1);
		}

		base.postLoadProcessing();

		//FIXME TODO! If new world, copy mods to the created world directory.
		// If existing world, load mods from the world directory.
		//
		//FIXME TODO!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		// 


		//Save all the new blocks if any
		Blocks.save();
		//Save all the new items if any
		Items.save();
		//Save all the new Dimensions if any
		Dimensions.save();

		showLogoandpush(false);
		
		try {
			Thread.sleep(200);
		} catch (InterruptedException e2) {
			e2.printStackTrace();
		} //No reason, just make it seem like we're doing something...

		connection_msg = "Firing up some threads...";
		showLogoandpush(false);

		clientEntityManager = new EntityUpdateLoop();
		Thread it = new Thread(clientEntityManager);	//Use to do gc and run updates to the entities...
		//it.setPriority(Thread.MAX_PRIORITY);
		it.start();	
		showLogoandpush(false);

		clientParticleManager = new ParticleUpdateLoop();
		Thread pit = new Thread(clientParticleManager);	//Use to do gc and run updates to the entities...
		//it.setPriority(Thread.MAX_PRIORITY);
		pit.start();	
		showLogoandpush(false);

		commandhandler = new DZCommandHandler();

		server = new Server();
		Thread st = new Thread(server);	//Fire up the actual SERVER side
		st.start();	
		showLogoandpush(false);
		
		while(server.entityManager == null){
			Thread.yield();
			try {
				Thread.sleep(500);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			} //Let it all catch up a little...
			showLogoandpush(false);
		}

		player.getTexture(); //pre-load this here! It doesn't work in the server_connection thread!
		server_connection = new ServerConnection(player, false);
		Thread ct = new Thread(server_connection);	//Fire up server comms for the player
		ct.setPriority(Thread.MAX_PRIORITY); //Don't bog down the network!
		ct.start();	
		
		showLogoandpush(false);

		escapegui = new PlayerEscapeGUI();
		inventorygui = new PlayerInventoryGUI();
		chatgui = new PlayerChatGUI();
		helpgui = new PlayerHelpGUI();
		dimensiongui = new PlayerDimensionGUI();
		commandgui = new PlayerCommandGUI();
		deathgui = new PlayerDeathGUI();		
		chestgui = new PlayerChestGUI();
		coloringgui = new PlayerColoringGUI();
		craftinggui = new PlayerCraftingGUI();
		deskgui = new PlayerDeskGUI();
		dronegui = new PlayerDroneGUI();
		furnacegui = new PlayerFurnaceGUI();
		petnamegui = new PlayerPetNameGUI();
		shreddergui = new PlayerShredderGUI();
		signgui = new PlayerSignGUI();
		entitygui = new PlayerEntityGUI();
		tradegui = new PlayerTradeGUI();
		statsgui = new PlayerStatsGUI();
		todogui = new PlayerToDoGUI();
		vrgui = new PlayerVRGUI();


		int i = 0;
		while(server_connection.connected == 0 && i < 10){
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} //Wait for the two to connect!
			i++;
			showLogoandpush(false);
		}
		if(i >= 10){
			System.exit(1);
		}

		//Lighting!!!
		lto0 = new LightingThread(0);
		Thread lt0 = new Thread(lto0);
		lt0.start();
		lto1 = new LightingThread(1);
		Thread lt1 = new Thread(lto1);
		lt1.start();
		lto2 = new LightingThread(2);
		Thread lt2 = new Thread(lto2);
		lt2.start();
		lto3 = new LightingThread(3);
		Thread lt3 = new Thread(lto3);
		lt3.start();

		//What a MESS!!!
		tidyup = new CleanerThread();
		Thread clt = new Thread(tidyup);
		//clt.setPriority(Thread.MAX_PRIORITY); //YES! Needed!!! Especially for slower machines to keep from running out of memory...
		clt.start();
		
		connection_msg = "Loading textures...";
		showLogoandpush(false);
		
		//load ALL block textures
		wr.loadBlockTextures();
		
		connection_msg = "Waiting for first chunk...";
		showLogoandpush(false);
		
		//Wait for at least the chunk I am in before continuing!
		//tell it what dimension we are in, or it won't send us the chunk we are waiting for.		
		DangerZone.server_connection.sendPlayerEntityUpdate(player);
		Chunk c = null;
		while(c == null){
			c = player.world.chunkcache.getDecoratedChunk(player.dimension, (int)player.posx, 100, (int)player.posz);
			DangerZone.server_connection.flushit();
			if(c != null)break;
			try {
				Thread.sleep(200);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			showLogoandpush(false);
		}
		c = null;

		//set this so the wr knows what dimension we are in. it is a flag to clear all VBOs when changed!
		wr.lastplayerdimension = player.dimension;

		//And finally... grab the mouse pointer!
		//Mouse.setGrabbed(true); //We be cat-like
		glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_DISABLED);
		mouse_grabbed = true;

		//we have to do this to help smooth the mouse motion...
		Thread thisthread = Thread.currentThread();
		thisthread.setPriority(Thread.MAX_PRIORITY);

		connection_msg = null;
		showLogoandpush(false);
	}

	private static void doStartServer(){
		
		//SOUNDS!!! Woohoo! We don't play any in the server, just registration...
		soundmangler = new SoundManager();
		soundmangler.master_volume = volume_temp;
		soundmangler.music_master_volume = music_volume_temp;

		server_chunk_cache = new ServerChunkCache();
		chunkwriter = new ChunkWriterThread();
		Thread cwt = new Thread(chunkwriter);
		cwt.start();
		
		wds = new WorldDecorators();
		breakchecker = new BreakChecks();

		//player = new Player(null);	
		
		//And a server world!
		server_world = new World(null, server_chunk_cache); //world for the server to use the server chunk cache!
		server_world.isServer = true; //yes we are!
		server_world.timetimer = 0;
		//player.world = server_world; 
		
		loadWorld(server_world);

		all_the_blocks = new Blocks();
		Blocks.load(); //Grab the known list from disk
		all_the_items = new Items();
		Items.load(); //Grab the known list from disk
		all_the_dimensions = new Dimensions();
		Dimensions.load(); //Grab the known list from disk

		//custom packets!
		all_the_custompackets = new CustomPackets();

		//make the crafting list
		all_the_recipies = new Crafting();
		all_the_deskrecipies = new DeskCrafting();

		//make the cooking list
		all_the_cooking = new Cooking();

		//make ore list holder
		all_the_ores = new Ores();

		//make spawn list holder
		all_the_spawns = new Spawnlist();
		
		//make command handler list
		all_the_handlers = new CommandHandlers();

		//particles!
		all_the_particles = new Particles();
		
		//make the shredding list
		all_the_shreds = new Shredding();

		//make a couple internal things we can't live without!
		all_the_entities = new Entities();
		blockitem = new EntityBlockItem(world);
		Entities.registerEntity(EntityBlockItem.class, blockitem.uniquename, new ModelEntityBlockItem());	//SPECIAL! Internal entity
		Entities.registerEntity(Player.class, "DangerZone:Player", new ModelHumanoid());						//SPECIAL! Internal entity
		Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());					//SPECIAL! Internal entity
		Entities.registerEntity(EntityNoob.class, "DangerZone:Noob", new ModelExp());					//SPECIAL! Internal entity

		//Load up the default dimensions, creatures, blocks, items, etc!
		base = new DangerZoneBase();
		base.registerThings();

		/*
		 * LOAD ALL OTHER MODS HERE!
		 */	
		modloader = new ModLoader();
		String badfile = modloader.loadmods();
		if(badfile != null)System.exit(1);
		modloader.loadservermods();

		base.postLoadProcessing();
		

		//Save all the new blocks if any
		Blocks.save();
		//Save all the new items if any
		Items.save();
		//Save all the new Dimensions if any
		Dimensions.save();

		try {
			Thread.sleep(200);
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		} //No reason, just make it seem like we're doing something...

		commandhandler = new DZCommandHandler();

		server = new Server();
		Thread st = new Thread(server);	//Fire up the actual SERVER side
		st.start();	

		try {
			Thread.sleep(500);
		} catch (InterruptedException e) {
			e.printStackTrace();
		} //Let it all catch up a little...

		//What a MESS!!!
		tidyup = new CleanerThread();
		Thread clt = new Thread(tidyup);
		clt.setPriority(Thread.MAX_PRIORITY); //YES! Needed!!! Especially for slower machines to keep from running out of memory...
		clt.start();
		
	}

	private static void doStartClient(){
		
		connection_msg = "Starting a few things...";
		showLogoandpush(false);
			
		
		//SOUNDS!!! Woohoo!
		soundmangler = new SoundManager();
		soundmangler.master_volume = volume_temp;
		soundmangler.music_master_volume = music_volume_temp;
		soundpollingthread = new SoundPollingThread();
		Thread swt = new Thread(soundpollingthread);
		swt.start();
		
		displaysorterthread = new DisplaySorterThread();
		Thread dst = new Thread(displaysorterthread);
		dst.start();

		//Make a place for chunks (client)		
		client_chunk_cache = new ChunkCache();  		//This caching mechanism is entirely different from...

		player = new Player(null);	
		player.model = new ModelHumanoid(); //Set renderer! (by hand)
		player.myname = playername;
		player.setPetName(playername);

		//Make a world!
		world = new World(client_chunk_cache, null);
		player.world = world; 

		//Make a world renderer
		wr = new WorldRenderer();
		//blocks!
		all_the_blocks = new Blocks();
		//items!
		all_the_items = new Items();
		//dimensions!
		all_the_dimensions = new Dimensions();
		//custom packets!
		all_the_custompackets = new CustomPackets();
		//make the crafting list
		all_the_recipies = new Crafting();
		//make the desk crafting list
		all_the_deskrecipies = new DeskCrafting();
		//make the cooking list
		all_the_cooking = new Cooking();
		//make ore list holder
		all_the_ores = new Ores();
		//make spawn list holder
		all_the_spawns = new Spawnlist();
		//make command handler list
		all_the_handlers = new CommandHandlers();
		//particles!
		all_the_particles = new Particles();
		//make the shredding list
		all_the_shreds = new Shredding();

		//make a couple internal things we can't live without!
		all_the_entities = new Entities();
		blockitem = new EntityBlockItem(world);
		Entities.registerEntity(EntityBlockItem.class, blockitem.uniquename, new ModelEntityBlockItem());	//SPECIAL! Internal entity
		Entities.registerEntity(Player.class, "DangerZone:Player", new ModelHumanoid());						//SPECIAL! Internal entity
		Entities.registerEntity(EntityExp.class, "DangerZone:Experience", new ModelExp());					//SPECIAL! Internal entity
		Entities.registerEntity(EntityNoob.class, "DangerZone:Noob", new ModelExp());					//SPECIAL! Internal entity

		escapegui = new PlayerEscapeGUI();
		inventorygui = new PlayerInventoryGUI();
		chatgui = new PlayerChatGUI();
		helpgui = new PlayerHelpGUI();
		dimensiongui = new PlayerDimensionGUI();
		commandgui = new PlayerCommandGUI();
		deathgui = new PlayerDeathGUI();
		chestgui = new PlayerChestGUI();
		coloringgui = new PlayerColoringGUI();
		craftinggui = new PlayerCraftingGUI();
		deskgui = new PlayerDeskGUI();
		dronegui = new PlayerDroneGUI();
		furnacegui = new PlayerFurnaceGUI();
		petnamegui = new PlayerPetNameGUI();
		shreddergui = new PlayerShredderGUI();
		signgui = new PlayerSignGUI();
		entitygui = new PlayerEntityGUI();
		tradegui = new PlayerTradeGUI();
		statsgui = new PlayerStatsGUI();
		todogui = new PlayerToDoGUI();
		vrgui = new PlayerVRGUI();

		clientEntityManager = new EntityUpdateLoop();
		Thread it = new Thread(clientEntityManager);	//Use to do gc and run updates to the entities...
		//it.setPriority(Thread.MAX_PRIORITY);
		it.start();	

		clientParticleManager = new ParticleUpdateLoop();
		Thread pit = new Thread(clientParticleManager);	//Use to do gc and run updates to the entities...
		//it.setPriority(Thread.MAX_PRIORITY);
		pit.start();	


		try {
			Thread.sleep(500);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} //Let it all catch up a little...

		connection_msg = "Connecting to Server...";
		showLogoandpush(false);
		/*
		 * Connect to the server!
		 */
		player.getTexture(); //pre-load this here! It doesn't work in the server_connection thread!
		server_connection = new ServerConnection(player, true);
		Thread ct = new Thread(server_connection);	//Fire up server comms for the player
		ct.setPriority(Thread.MAX_PRIORITY); //Don't bog down the network!
		ct.start();	

		//we establish a partial connection with server to get world name and mods
		int i = 0;
		while(!server_connection.connectionInProgress && i < 30 && connection_error == 0){
			try {
				Thread.sleep(500);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} //Wait for the two to connect!
			i++;
		}
		if(i >= 30 || connection_error != 0){
			if(connection_error == 0)connection_msg = "Oops. Connection timed out.";
			showLogoandpush(false);
			try {
				Thread.sleep(4000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} 
			System.exit(1);
		}
		
		DangerZone.worldname = server_connection.worldname;
		
		if(DangerZone.worldname == null){
			connection_msg = "Invalid Playername/Password, or Null world!";
			showLogoandpush(false);
			try {
				Thread.sleep(4000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} 
			System.exit(1);
		}
						
		//Load up the default dimensions, creatures, blocks, items, etc!
		base = new DangerZoneBase();
		base.registerThings();
		
		connection_msg = "Loading Mods...";
		showLogoandpush(false);

		/*
		 * LOAD ALL OTHER MODS HERE!
		 */	
		modloader = new ModLoader();
		if(!modloader.loadmods(server_connection.modnames)){
			connection_msg = "Failed to load mods specified by server.";
			showLogoandpush(false);
			try {
				Thread.sleep(4000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} 
			//System.out.printf("Failed to load mods specified by server.\n");
			System.exit(1);
		}

		base.postLoadProcessing();
		
		//re-sync with server HERE!!!
		//the connection is waiting for this flag to receive the re-synced IDs, which we couldn't do because we need to load mods first.
		server_connection.waitformodstoload = false;
		
		//Now we wait for the resyncs to happen. Then we're done!
		i = 0;
		while(server_connection.connected == 0 && i < 30  && connection_error == 0){
			try {
				Thread.sleep(500);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} //Wait for the two to connect!
			i++;
		}
		if(i >= 30 || connection_error != 0){
			if(connection_error == 0)connection_msg = "Oops. Connection timed out while loading mods.";
			showLogoandpush(false);
			try {
				Thread.sleep(4000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} 
			System.exit(1);
		}

		connection_msg = "Loading textures...";
		showLogoandpush(false);
		
		//Now it's safe to load up ALL the block textures!	
		//We had to wait until server and client sync'ed up blockids!
		wr.loadBlockTextures();
		
		//Wait for at least the chunk I am in before continuing!
		//tell it what dimension we are in, or it won't send us the chunk we are waiting for.
		connection_msg = "Waiting for first chunk...";
		showLogoandpush(false);
		
		DangerZone.server_connection.sendPlayerEntityUpdate(player);
		
		Chunk c = null;
		i = 0;
		while(c == null){
			c = player.world.chunkcache.getDecoratedChunk(player.dimension, (int)player.posx, 100, (int)player.posz);
			DangerZone.server_connection.flushit(); //make sure any request gets sent!
			if(c != null)break;
			try {
				Thread.sleep(200);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			i++;
			if(i > 150)break;
		}
		if(c == null){
			connection_msg = "Oops. Couldn't get first chunk.";
			showLogoandpush(false);
			try {
				Thread.sleep(4000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} 
			System.exit(1);
		}
		c = null;
		
		connection_msg = "Almost ready...";
		showLogoandpush(false);
		
		//Lighting!!!
		//Lighting!!!
		lto0 = new LightingThread(0);
		Thread lt0 = new Thread(lto0);
		lt0.start();
		lto1 = new LightingThread(1);
		Thread lt1 = new Thread(lto1);
		lt1.start();
		lto2 = new LightingThread(2);
		Thread lt2 = new Thread(lto2);
		lt2.start();
		lto3 = new LightingThread(3);
		Thread lt3 = new Thread(lto3);
		lt3.start();
		//What a MESS!!!
		tidyup = new CleanerThread();
		Thread clt = new Thread(tidyup);
		clt.setPriority(Thread.MAX_PRIORITY); //YES! Needed!!! Especially for slower machines to keep from running out of memory...
		clt.start();

		//set this so the wr knows what dimension we are in. it is a flag to clear all VBOs when changed!
		wr.lastplayerdimension = player.dimension;

		//And finally... grab the mouse pointer!
		//Mouse.setGrabbed(true); //We be cat-like
		glfwSetInputMode(window, GLFW_CURSOR, GLFW.GLFW_CURSOR_DISABLED);
		mouse_grabbed = true;

		//we have to do this to help smooth the mouse motion...
		Thread thisthread = Thread.currentThread();
		thisthread.setPriority(Thread.MAX_PRIORITY);
		
		connection_msg = null;

	}
	
	public static void show_selection(int i){
		
		player.sethotbarindex(i);
		InventoryContainer ic = player.getHotbar(i);
		if(ic != null && ic.count > 0){
			String hotstring = null;
			String[] hss = null;
			
			if(ic.bid != 0){
				hotstring = Blocks.getUniqueName(ic.bid);
			}
			if(ic.iid != 0){
				hotstring = Items.getUniqueName(ic.iid);
				int attackstrength = Items.getAttackStrength(ic.iid);
				if(attackstrength > 1){
					hotstring += String.format(" +%d", attackstrength);
				}					
			}
			if(hotstring != null){
				hss = hotstring.split(":");
				if(hss.length >= 2){
					hotmessagestring = hss[1];
					hotmessagetimer = 60;
				}
			}
		}else{
			hotmessagestring = null;
			hotmessagetimer = 0;
		}
	}
	
	public static void setMusicVolume(float newvol){
		SoundStore.get().setMusicVolume(newvol);
	}
	
	public static float getMusicVolume(){
		return SoundStore.get().getCurrentMusicVolume();
	}
	
	public static void pauseMusic(){
		SoundStore.get().pauseLoop();
	}
	public static void resumeMusic(){
		SoundStore.get().restartLoop();
	}
	
	/*
	//shift whole screen left/right
	public static int get_startx(int inview) {
		int startx = 300;
		if(inview == 0)return 0;
		if(headset_type == 2)startx = 0;
		if(inview == 1)return startx + left_adjust+(lr_eye_skew/2);
		return startx + left_adjust-(lr_eye_skew/2);
	}
	
	public static int get_middle(int inview) {
		int middle = DangerZone.screen_width/2;
		if(inview == 0)return middle;
		middle += left_adjust;
		if(inview == 1)return middle+(lr_eye_skew/2);
		return middle-(lr_eye_skew/2);
	}
	
	public static int get_starty(int inview) {
		int starty = DangerZone.screen_height;
		if(inview == 0)return starty;
		return starty + top_adjust;
	}
	
	public static int get_bottom(int inview) {
		if(inview == 0)return 0;		
		return bottom_adjust;
	}
	*/
	
	public static int get_height(int inview) {
		if(inview == 0)return screen_height;		
		return use_height;
	}
	
	public static int get_width(int inview) {
		if(inview == 0)return screen_width;		
		return use_width;
	}
	
	public static int get_skew(int inview) {
		if(inview == 0)return 0;		
		return lr_eye_skew;
	}
	
	public static int get_top(int inview) {
		if(inview == 0)return screen_height;		
		int diff = (screen_height - use_height)/2;
		return use_height + diff + height_adjust;
	}
	
	public static int get_bottom(int inview) {
		if(inview == 0)return 0;			
		int diff = (screen_height - use_height)/2;	
		return diff + height_adjust;
	}
	
	public static int get_left(int inview) {
		if(inview == 0)return 0;			
		int diff = (screen_width - use_width)/2;
		if(inview == 1)return diff + (lr_eye_skew/2);
		return diff - (lr_eye_skew/2);
	}
	
	public static int get_middle(int inview) {
		if(inview == 0)return screen_width/2;			
		int diff = (screen_width - use_width)/2;
		if(inview == 1)return diff + (lr_eye_skew/2) + (use_width/2);
		return (diff - (lr_eye_skew/2)) + (use_width/2);
	}
	
	
	public static void jump_pulse() {
		//if(!isVR)return;
		//VRSystem_TriggerHapticPulse(right_hand_index, 0, (short)500); //controller index, haptic index, ms (or microsec?)
		//VRSystem_TriggerHapticPulse(left_hand_index, 0, (short)500); //controller index, haptic index, ms (or microsec?)
	}
	
	public static void ground_pulse() {
		if(!isVR)return;
		VRSystem_TriggerHapticPulse(right_hand_index, 0, (short)1000); //controller index, haptic index, ms (or microsec?)
		VRSystem_TriggerHapticPulse(left_hand_index, 0, (short)1000); //controller index, haptic index, ms (or microsec?)
	}
	
	public static void hit_pulse(int amp) {
		if(!isVR)return;
		if(amp <= 0)amp = 4;
		if(amp > 3999)amp = 3999;
		VRSystem_TriggerHapticPulse(weapon_controller == right_controller?right_hand_index:left_hand_index, 0, (short)amp); //controller index, haptic index, ms (or microsec?)
	}
	
	public static void click_pulse(int amp) {
		if(!isVR)return;
		if(amp <= 0)amp = 4;
		if(amp > 3999)amp = 3999;
		VRSystem_TriggerHapticPulse(pointer_controller == right_controller?right_hand_index:left_hand_index, 0, (short)amp); //controller index, haptic index, ms (or microsec?)
	}
	
	public static void long_rumble(int amp, int skip, int millis){
		if(!isVR)return;
		RumbleThread rt = new RumbleThread(amp, skip, millis);
		Thread it = new Thread(rt);
		it.start();			
	}	
	
	//VRSystem_TriggerHapticPulse(weapon_controller == right_controller?right_hand_index:left_hand_index, 0, (short)1000); //controller index, haptic index, ms (or microsec?)

	public static void addLightingRequest(int d, int x, int y, int z, float val){
		if(graphics_mode < 3) {
			if(graphics_mode < 2) {
				lto0.addRequest(d, x, y, z, val);
			}else {
				if((((x>>4)+(z>>4))&0x01) == 0) {
					if(lto0 != null)lto0.addRequest(d, x, y, z, val);
				}else{
					if(lto1 != null)lto1.addRequest(d, x, y, z, val);
				}
			}
		}else {
			if((((x>>4)+(z>>4))%4) == 0) {
				if(lto0 != null)lto0.addRequest(d, x, y, z, val);
			}else if((((x>>4)+(z>>4))%4) == 1) {
				if(lto1 != null)lto1.addRequest(d, x, y, z, val);
			}else if((((x>>4)+(z>>4))%4) == 2) {
				if(lto2 != null)lto2.addRequest(d, x, y, z, val);
			}else { 
				if(lto3 != null)lto3.addRequest(d, x, y, z, val);
			}
		}
	}
	
	
}
